/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.group.EntryHidingView;
import com.iplanet.idar.ui.configurator.group.SubtreeHidingView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class DataHidingView
extends ConfigurationView
implements SuiConstants {
    private NetworkGroupBean model;
    private JTabbedPane tabViews;
    private ConfigurationView viewSubtreeHiding;
    private ConfigurationView viewEntryHiding;

    public DataHidingView() {
        this.initComponents();
    }

    public DataHidingView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        if (this.viewSubtreeHiding != null && this.viewEntryHiding != null) {
            this.viewSubtreeHiding.setConsoleInfo(consoleInfo);
            this.viewEntryHiding.setConsoleInfo(consoleInfo);
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        Debug.println((String)("DataHidingView.setDataModel: model=" + iDARModelBean + " reset=" + bl));
        if (this.viewSubtreeHiding != null && this.viewEntryHiding != null) {
            this.viewSubtreeHiding.setDataModel(iDARModelBean, bl);
            this.viewEntryHiding.setDataModel(iDARModelBean, bl);
        }
        super.setDataModel(iDARModelBean, bl);
    }

    public void resetContent() throws ConfigurationViewException {
        Debug.println((String)("DataHidingView.resetContent: model=" + this.getDataModel()));
        this.viewSubtreeHiding.resetContent();
        this.viewEntryHiding.resetContent();
    }

    public void applyChanges() throws ConfigurationViewException {
        try {
            this.viewSubtreeHiding.applyChanges();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewSubtreeHiding.getPanel());
            throw configurationViewException;
        }
        try {
            this.viewEntryHiding.applyChanges();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewEntryHiding.getPanel());
            throw configurationViewException;
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupDataHidingGeneral", "TITLE");
    }

    public String getHelpTopic() {
        String string = "";
        Component component = this.tabViews.getSelectedComponent();
        if (component instanceof ConfigurationView) {
            ConfigurationView configurationView = (ConfigurationView)component;
            string = configurationView.getHelpTopic();
        }
        return string;
    }

    protected void initComponents() {
        this.tabViews = new JTabbedPane();
        this.viewSubtreeHiding = new SubtreeHidingView();
        this.viewEntryHiding = new EntryHidingView();
        IDARModelBean iDARModelBean = this.getDataModel();
        if (iDARModelBean != null) {
            this.viewSubtreeHiding.setDataModel(iDARModelBean);
            this.viewEntryHiding.setDataModel(iDARModelBean);
        }
        this.viewSubtreeHiding.addBlankPanelListener(this);
        this.viewEntryHiding.addBlankPanelListener(this);
        this.tabViews.addTab(this.viewSubtreeHiding.getTitleText(), null, this.viewSubtreeHiding.getPanel());
        this.tabViews.addTab(this.viewEntryHiding.getTitleText(), null, this.viewEntryHiding.getPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabViews, "Center");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new DataHidingView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

