/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.group.AttributeRenamingView;
import com.iplanet.idar.ui.configurator.group.AttributeResponseRestrictionView;
import com.iplanet.idar.ui.configurator.group.AttributeSearchRestrictionView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class AttributeView
extends ConfigurationView
implements SuiConstants {
    private JTabbedPane tabViews;
    private ConfigurationView viewAttributeSearchRestriction;
    private ConfigurationView viewAttributeRenaming;
    private ConfigurationView viewAttributeResponseRestriction;

    public AttributeView() {
        this.initComponents();
    }

    public AttributeView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        if (this.viewAttributeSearchRestriction != null) {
            this.viewAttributeSearchRestriction.setConsoleInfo(consoleInfo);
            this.viewAttributeRenaming.setConsoleInfo(consoleInfo);
            this.viewAttributeResponseRestriction.setConsoleInfo(consoleInfo);
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        Debug.println((String)("SearchView.setDataModel: model=" + iDARModelBean + " reset=" + bl));
        if (this.viewAttributeSearchRestriction != null) {
            this.viewAttributeSearchRestriction.setDataModel(iDARModelBean, bl);
            this.viewAttributeRenaming.setDataModel(iDARModelBean, bl);
            this.viewAttributeResponseRestriction.setDataModel(iDARModelBean, bl);
        }
        super.setDataModel(iDARModelBean, bl);
    }

    public void resetContent() throws ConfigurationViewException {
        Debug.println((String)("AttributeView.resetContent: model=" + this.getDataModel()));
        this.viewAttributeSearchRestriction.resetContent();
        this.viewAttributeRenaming.resetContent();
        this.viewAttributeResponseRestriction.resetContent();
    }

    public void applyChanges() throws ConfigurationViewException {
        try {
            this.viewAttributeSearchRestriction.applyChanges();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewAttributeSearchRestriction.getPanel());
            throw configurationViewException;
        }
        try {
            this.viewAttributeRenaming.applyChanges();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewAttributeRenaming.getPanel());
            throw configurationViewException;
        }
        try {
            this.viewAttributeResponseRestriction.applyChanges();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewAttributeResponseRestriction.getPanel());
            throw configurationViewException;
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupRequestsGeneral", "TITLE");
    }

    public String getHelpTopic() {
        String string = "";
        Component component = this.tabViews.getSelectedComponent();
        if (component instanceof ConfigurationView) {
            ConfigurationView configurationView = (ConfigurationView)component;
            string = configurationView.getHelpTopic();
        }
        return string;
    }

    protected void initComponents() {
        this.tabViews = new JTabbedPane();
        this.viewAttributeSearchRestriction = new AttributeSearchRestrictionView();
        this.viewAttributeRenaming = new AttributeRenamingView();
        this.viewAttributeResponseRestriction = new AttributeResponseRestrictionView();
        this.viewAttributeSearchRestriction.addBlankPanelListener(this);
        this.viewAttributeRenaming.addBlankPanelListener(this);
        this.viewAttributeResponseRestriction.addBlankPanelListener(this);
        this.tabViews.addTab(this.viewAttributeSearchRestriction.getTitleText(), null, this.viewAttributeSearchRestriction.getPanel());
        this.tabViews.addTab(this.viewAttributeRenaming.getTitleText(), null, this.viewAttributeRenaming.getPanel());
        this.tabViews.addTab(this.viewAttributeResponseRestriction.getTitleText(), null, this.viewAttributeResponseRestriction.getPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabViews, "Center");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new AttributeView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

