/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.AttributeDialog;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttributeResponseRestrictionView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-Attribute-Return";
    private JTextArea txtNote;
    private JTextArea txtSearchNote;
    private BlankPanel pnlAttribute;
    private JRadioButton radAllowAll;
    private JRadioButton radForbidThese;
    private JRadioButton radAllowThese;
    private JPanel pnlButtons;
    private JList lstAttributes;
    private JButton butAdd;
    private JButton butEdit;
    private JButton butRemove;
    private DefaultListModel listModel;

    public AttributeResponseRestrictionView() {
        this.initComponents();
    }

    public AttributeResponseRestrictionView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    protected void initComponents() {
        this.txtSearchNote = new JTextArea();
        this.txtSearchNote.setText(IDARResourceSet.getString("groupAttributeResponseRestrictions", "SEARCH_NOTE"));
        this.txtSearchNote.setEditable(false);
        this.txtSearchNote.setBackground(this.getBackground());
        this.txtSearchNote.setLineWrap(true);
        this.txtSearchNote.setWrapStyleWord(true);
        this.pnlAttribute = new BlankPanel();
        this.pnlAttribute.addBlankPanelListener(this);
        this.radAllowAll = new JRadioButton(IDARResourceSet.getString("groupAttributeResponseRestrictions", "ALLOW_ALL"));
        this.radAllowAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeResponseRestrictionView.this.setButtonEnablement();
            }
        });
        this.radForbidThese = new JRadioButton(IDARResourceSet.getString("groupAttributeResponseRestrictions", "FORBID_ATTRIBUTES"));
        this.radForbidThese.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeResponseRestrictionView.this.setButtonEnablement();
            }
        });
        this.radAllowThese = new JRadioButton(IDARResourceSet.getString("groupAttributeResponseRestrictions", "ALLOW_ONLY_ATTRIBUTES"));
        this.radAllowThese.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeResponseRestrictionView.this.setButtonEnablement();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radAllowAll);
        buttonGroup.add(this.radForbidThese);
        buttonGroup.add(this.radAllowThese);
        this.pnlButtons = this.initButtonBar();
        this.listModel = new DefaultListModel();
        this.lstAttributes = new JList(this.listModel);
        this.lstAttributes.setToolTipText(IDARResourceSet.getString("tooltip", "list_of_attributes_to_include_or_exclude"));
        this.lstAttributes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AttributeResponseRestrictionView.this.setButtonEnablement();
            }
        });
        this.lstAttributes.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                AttributeResponseRestrictionView.this.setButtonEnablement();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                AttributeResponseRestrictionView.this.setButtonEnablement();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                AttributeResponseRestrictionView.this.setButtonEnablement();
            }
        });
        this.lstAttributes.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AttributeResponseRestrictionView.this.butEdit.doClick();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.pnlAttribute.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlAttribute.add((Component)this.txtSearchNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlAttribute.add((Component)this.radAllowAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlAttribute.add((Component)this.radForbidThese, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlAttribute.add((Component)this.radAllowThese, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 24, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlAttribute.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 24, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.pnlAttribute.add((Component)new JScrollPane(this.lstAttributes), gridBagConstraints);
        n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.add((Component)this.pnlAttribute, gridBagConstraints);
    }

    protected JPanel initButtonBar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.butAdd = ButtonFactory.createButton((String)IDARResourceSet.getString("button", "ADD"));
        this.butAdd.setToolTipText(IDARResourceSet.getString("tooltip", "add_attribute"));
        this.butAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Frame frame = IDARUtilities.getParentFrame(AttributeResponseRestrictionView.this);
                AttributeDialog attributeDialog = new AttributeDialog(frame);
                attributeDialog.showModal();
                if (!attributeDialog.isCancel()) {
                    String string = attributeDialog.getAttribute();
                    AttributeResponseRestrictionView.this.listModel.addElement(string);
                    AttributeResponseRestrictionView.this.fireBlankPanelEvent(new BlankPanelEvent(null));
                }
            }
        });
        this.butAdd.setEnabled(false);
        this.butEdit = ButtonFactory.createButton((String)IDARResourceSet.getString("button", "EDIT"));
        this.butEdit.setToolTipText(IDARResourceSet.getString("tooltip", "edit_attribute"));
        this.butEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AttributeResponseRestrictionView.this.lstAttributes.getSelectedIndex();
                String string = AttributeResponseRestrictionView.this.listModel.get(n).toString();
                Frame frame = IDARUtilities.getParentFrame(AttributeResponseRestrictionView.this);
                AttributeDialog attributeDialog = new AttributeDialog(frame, string);
                attributeDialog.showModal();
                if (!attributeDialog.isCancel()) {
                    AttributeResponseRestrictionView.this.listModel.set(n, attributeDialog.getAttribute());
                    AttributeResponseRestrictionView.this.fireBlankPanelEvent(new BlankPanelEvent(null));
                }
            }
        });
        this.butEdit.setEnabled(false);
        this.butRemove = ButtonFactory.createButton((String)IDARResourceSet.getString("button", "REMOVE"));
        this.butRemove.setToolTipText(IDARResourceSet.getString("tooltip", "remove_attribute"));
        this.butRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AttributeResponseRestrictionView.this.lstAttributes.getSelectedIndex();
                if (n != -1) {
                    AttributeResponseRestrictionView.this.listModel.remove(n);
                    int n2 = AttributeResponseRestrictionView.this.listModel.size();
                    if (n >= n2) {
                        n = n2 - 1;
                    }
                    AttributeResponseRestrictionView.this.lstAttributes.addSelectionInterval(n, n);
                }
                AttributeResponseRestrictionView.this.fireBlankPanelEvent(new BlankPanelEvent(null));
            }
        });
        this.butRemove.setEnabled(false);
        ButtonFactory.resizeButton((JButton)this.butAdd);
        ButtonFactory.resizeButton((JButton)this.butEdit);
        ButtonFactory.resizeButton((JButton)this.butRemove);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.butAdd);
        jPanel2.add(Box.createHorizontalStrut(6));
        jPanel2.add(this.butEdit);
        jPanel2.add(Box.createHorizontalStrut(6));
        jPanel2.add(this.butRemove);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void setButtonEnablement() {
        if (this.radAllowAll.isSelected()) {
            this.butAdd.setEnabled(false);
            this.butRemove.setEnabled(false);
            this.butEdit.setEnabled(false);
            this.lstAttributes.setBackground(null);
            this.lstAttributes.setEnabled(false);
        } else {
            this.butAdd.setEnabled(true);
            boolean bl = this.lstAttributes.getModel().getSize() != 0 && this.lstAttributes.getSelectedIndex() != -1;
            this.butRemove.setEnabled(bl);
            this.butEdit.setEnabled(bl);
            this.lstAttributes.setBackground(Color.white);
            this.lstAttributes.setEnabled(true);
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        Vector vector;
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            vector = new Vector();
            Enumeration enumeration = this.listModel.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            if ((this.radForbidThese.isSelected() || this.radAllowThese.isSelected()) && vector.isEmpty()) {
                throw new ConfigurationViewException(this.getTitleText(), IDARResourceSet.getString("error", "ERR_NO_ATTRIBUTE"));
            }
            if (this.radForbidThese.isSelected()) {
                networkGroupBean.setForbiddenReturn(true);
                networkGroupBean.setPermittedReturn(false);
                networkGroupBean.setAllowAllReturn(false);
            } else if (this.radAllowThese.isSelected()) {
                networkGroupBean.setPermittedReturn(true);
                networkGroupBean.setForbiddenReturn(false);
                networkGroupBean.setAllowAllReturn(false);
            } else {
                networkGroupBean.setAllowAllReturn(true);
                networkGroupBean.setPermittedReturn(false);
                networkGroupBean.setForbiddenReturn(false);
            }
        } else {
            Debug.println((int)6, (String)("Unable to set data model in AttributeSearchRestrictionView: Model = " + networkGroupBean));
            throw new ConfigurationViewException();
        }
        networkGroupBean.setForbiddenPermitReturn(vector);
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupAttributeResponseRestrictions", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("AttributeResponseRestrictionView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            this.listModel.clear();
            Vector vector = networkGroupBean.getForbiddenPermitReturn();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.listModel.addElement(enumeration.nextElement().toString());
            }
            if (networkGroupBean.getForbiddenReturn()) {
                this.radForbidThese.setSelected(true);
            } else if (networkGroupBean.getPermittedReturn()) {
                this.radAllowThese.setSelected(true);
            } else {
                this.radAllowAll.setSelected(true);
            }
        } else {
            Debug.println((int)6, (String)("Unable to set data model in AttributeSearchRestrictionView: Model = " + networkGroupBean));
            throw new ConfigurationViewException();
        }
        this.setButtonEnablement();
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new AttributeResponseRestrictionView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

