/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator;

import com.iplanet.idar.common.DescriptorMap;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.AdminConfigData;
import com.iplanet.idar.objectmodel.bean.ConfigurationBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.task.TaskGroup;
import com.iplanet.idar.task.configuration.DeleteObjectTask;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.components.IDARJButtonFactory;
import com.iplanet.idar.ui.common.configuration.LoadErrorPanel;
import com.iplanet.idar.ui.common.enterprise.RestartIdarsPanel;
import com.iplanet.idar.ui.configurator.AbstractObjectViewTableModel;
import com.iplanet.idar.ui.configurator.ObjectViewTableModel;
import com.iplanet.idar.ui.task.TaskButton;
import com.iplanet.idar.ui.task.configuration.IplanetCreateAndEditObjectTask;
import com.iplanet.idar.ui.task.configuration.IplanetEditObjectTask;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.TitlePanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ObjectView
extends JPanel
implements SuiConstants {
    private String note;
    TitlePanel title;
    IDARReference configuration;
    String[] descriptors;
    boolean isLoading = false;
    boolean needsReloading = true;
    protected JButton butNew;
    protected JButton butEdit;
    protected JButton butDelete;
    protected JButton butHelp;
    protected JTable tblTable;
    protected JPanel pnlContent;
    protected JPopupMenu popup;
    protected static final String CONTENT = "content";
    protected static final String ERROR = "error";
    protected static final String LOAD = "load";
    protected final IplanetCreateAndEditObjectTask createTask = new IplanetCreateAndEditObjectTask();
    protected final DeleteObjectTask deleteTask = new DeleteObjectTask();
    protected final IplanetEditObjectTask editTask = new IplanetEditObjectTask();
    private ConsoleInfo info = null;
    private CardLayout cardLayout;
    private IDARBeanCollection collection = null;
    private ObjectViewTableModel tableModel;

    public ObjectView() {
        this.initComponents();
    }

    public ConsoleInfo getConsoleInfo() {
        return this.info;
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        this.info = consoleInfo;
        this.createTask.setConsoleInfo(consoleInfo);
        this.editTask.setConsoleInfo(consoleInfo);
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String string) {
        this.note = string;
    }

    public TitlePanel getTitle() {
        return this.title;
    }

    public void setTitle(TitlePanel titlePanel) {
        this.title = titlePanel;
    }

    public IDARReference getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IDARReference iDARReference) {
        this.configuration = iDARReference;
        this.createTask.setParentConfiguration(this.configuration);
    }

    public String[] getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(final String[] stringArray) {
        this.descriptors = stringArray;
        if (stringArray != null && stringArray.length > 1) {
            this.popup = new JPopupMenu();
            int n = 0;
            while (n < stringArray.length) {
                JMenuItem jMenuItem = new JMenuItem();
                jMenuItem.setText(DescriptorMap.lookupDisplayString(stringArray[n]));
                final int n2 = n++;
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ObjectView.this.createObject(stringArray[n2]);
                    }
                });
                this.popup.add(jMenuItem);
            }
        }
    }

    public boolean isNeedsReloading() {
        return this.needsReloading;
    }

    public void setNeedsReloading(boolean bl) {
        this.needsReloading = bl;
    }

    public void setModelInfo(IDARReference iDARReference, String[] stringArray) {
        this.setConfiguration(iDARReference);
        this.setDescriptors(stringArray);
        this.load();
    }

    public void addNotify() {
        super.addNotify();
        if (this.isLoading) {
            this.startProgress();
        }
    }

    protected void startProgress() {
        final IFramework iFramework = IDARUtilities.getFramework(this);
        if (iFramework != null) {
            new Thread(new Runnable(){

                public void run() {
                    iFramework.changeStatusItemState("StatusItemProgress", (Object)new Integer(-1));
                }
            }).start();
        }
    }

    protected void stopProgress() {
        IFramework iFramework = IDARUtilities.getFramework(this);
        if (iFramework != null) {
            iFramework.changeStatusItemState("StatusItemProgress", (Object)new Integer(0));
        }
    }

    protected void load() {
        this.loadingStart();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ObjectView.this.startProgress();
                IDARBeanCollection iDARBeanCollection = null;
                String string = null;
                try {
                    iDARBeanCollection = BeanSpace.getInstance().retrieveBeanCollection(ObjectView.this.configuration, ObjectView.this.descriptors);
                    ObjectView.this.setNeedsReloading(false);
                }
                catch (RetrievalException retrievalException) {
                    string = IDARResourceSet.getString(ObjectView.ERROR, "MODEL_RETRIEVAL_MESSAGE");
                    retrievalException.printStackTrace();
                    ObjectView.this.setNeedsReloading(true);
                    ObjectView.this.loadingError();
                }
                catch (NoSuchBeanException noSuchBeanException) {
                    string = noSuchBeanException.getMessage();
                    ObjectView.this.setNeedsReloading(true);
                    ObjectView.this.loadingError();
                }
                IDARBeanCollection iDARBeanCollection2 = iDARBeanCollection;
                String string2 = string;
                SwingUtilities.invokeLater(new Runnable(this, iDARBeanCollection2, string2){
                    private final /* synthetic */ IDARBeanCollection val$finalModel;
                    private final /* synthetic */ String val$finalErrorMessage;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$finalModel = iDARBeanCollection;
                        this.val$finalErrorMessage = string;
                    }

                    public void run() {
                        3.access$000(this.this$1).setModel(this.val$finalModel);
                        3.access$000(this.this$1).stopProgress();
                        if (this.val$finalErrorMessage != null) {
                            JOptionPane.showMessageDialog(IDARUtilities.getParentFrame(3.access$000(this.this$1)), this.val$finalErrorMessage, IDARResourceSet.getString("error", "MODEL_RETRIEVAL_TITLE"), 0);
                        }
                        if (!3.access$000(this.this$1).isNeedsReloading()) {
                            3.access$000(this.this$1).loadingFinished();
                        }
                    }
                });
            }

            static /* synthetic */ ObjectView access$000(3 var0) {
                return var0.ObjectView.this;
            }
        });
        thread.start();
    }

    public IDARBeanCollection getModel() {
        return this.collection;
    }

    public void setModel(IDARBeanCollection iDARBeanCollection) {
        this.collection = iDARBeanCollection;
        boolean bl = false;
        if (this.descriptors != null && this.descriptors.length > 1) {
            bl = true;
        }
        this.setTableModel(new AbstractObjectViewTableModel(this.collection, bl));
        this.initContentPanel();
    }

    public void setObjectModel(IDARBeanCollection iDARBeanCollection) {
        this.collection = iDARBeanCollection;
    }

    public ObjectViewTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(ObjectViewTableModel objectViewTableModel) {
        this.tableModel = objectViewTableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    ObjectView.this.setNewDeleteEnablement();
                }
            });
        }
        JTable jTable = this.getTable();
        jTable.setModel(this.tableModel);
    }

    private void initComponents() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(IDARResourceSet.getString("general", "LOADING"), 0), "Center");
        LoadErrorPanel loadErrorPanel = new LoadErrorPanel();
        loadErrorPanel.addReloadButtonActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectView.this.load();
            }
        });
        this.add(ERROR, loadErrorPanel);
        this.add(LOAD, jPanel);
        this.cardLayout.show(this, LOAD);
    }

    protected void newInvoked() {
        Debug.println((String)"ObjectView.newInvoked");
        String[] stringArray = this.getDescriptors();
        if (this.popup != null) {
            this.popup.show(this, this.butNew.getX() + this.butNew.getWidth(), this.butNew.getY());
        } else {
            this.createObject(stringArray[0]);
        }
    }

    protected void initContentPanel() {
        GridBagConstraints gridBagConstraints;
        this.pnlContent = new JPanel();
        this.butNew = IDARJButtonFactory.create(IDARResourceSet.getString("button", "NEW"));
        this.butNew.setToolTipText(IDARResourceSet.getString("taskCreateObject", "DESCRIPTION"));
        this.butNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectView.this.newInvoked();
            }
        });
        this.butDelete = new TaskButton(this.deleteTask);
        this.deleteTask.addTaskListener(new TaskAdapter(){

            public void taskStopped(TaskEvent taskEvent) {
                try {
                    ConfigurationBean configurationBean;
                    IDARReference[] iDARReferenceArray;
                    IDARReference iDARReference = ObjectView.this.collection.getParentConfiguration();
                    int n = ObjectView.this.deleteTask.getExecutionStatus();
                    if (n != -3 && iDARReference != null && (iDARReferenceArray = (configurationBean = (ConfigurationBean)iDARReference.getBean()).getSubscribers()) != null && iDARReferenceArray.length > 0) {
                        RestartIdarsPanel restartIdarsPanel = new RestartIdarsPanel(configurationBean.getSubscribers());
                        JDialog jDialog = new JOptionPane(restartIdarsPanel, 1, 0, null, new Object[]{RestartIdarsPanel.DONE}).createDialog(ObjectView.this, IDARResourceSet.getString("notice", "NOTICE_TITLE"));
                        jDialog.pack();
                        jDialog.show();
                    }
                }
                catch (IDARBeanException iDARBeanException) {
                    iDARBeanException.printStackTrace();
                }
            }
        });
        this.butEdit = new TaskButton(this.editTask);
        ButtonFactory.resizeButton((JButton)this.butEdit);
        TaskGroup taskGroup = new TaskGroup();
        taskGroup.addTask(this.createTask);
        taskGroup.addTask(this.editTask);
        taskGroup.addTask(this.deleteTask);
        taskGroup.addTaskGroupListener(new TaskAdapter(){

            public void taskStarted(TaskEvent taskEvent) {
                ObjectView.this.butNew.setEnabled(false);
                ObjectView.this.butNew.repaint();
            }

            public void taskStopped(TaskEvent taskEvent) {
                ObjectView.this.butNew.setEnabled(true);
                ObjectView.this.butNew.repaint();
            }
        });
        this.butHelp = IDARJButtonFactory.create(IDARResourceSet.getString("button", "HELP"));
        this.butHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminConfigData[] adminConfigDataArray = BeanSpace.getInstance().getUrls();
                AdminConfigData adminConfigData = null;
                for (int i = 0; i < adminConfigDataArray.length && (adminConfigData = adminConfigDataArray[i]) == null; ++i) {
                }
                URL uRL = null;
                if (adminConfigData != null) {
                    uRL = adminConfigData.getAdminServerURL();
                } else {
                    Debug.println((int)0, (String)"ERROR: UNABLE TO FIND ADMIN-SERVER URL");
                }
                if (uRL != null) {
                    Help.showContextHelp((String)"dps", (String)"Configuration-ObjectView", (URL)uRL);
                } else {
                    Debug.println((int)0, (String)"ERROR: UNABLE TO FIND ADMIN-SERVER URL");
                }
            }
        });
        this.pnlContent.setLayout(new GridBagLayout());
        int n = 0;
        TitlePanel titlePanel = this.getTitle();
        if (titlePanel != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(9, 9, 0, 9);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.fill = 2;
            this.pnlContent.add((Component)titlePanel, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        this.pnlContent.add((Component)this.butNew, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 6, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        this.pnlContent.add((Component)this.butEdit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 6, 0, 9);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        this.pnlContent.add((Component)this.butDelete, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        this.pnlContent.add((Component)this.butHelp, gridBagConstraints);
        this.getTable().setSelectionMode(0);
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ObjectView.this.setNewDeleteEnablement();
            }
        });
        this.getTable().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ObjectView.this.butEdit.doClick();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.pnlContent.add((Component)new JScrollPane(this.getTableComponent()), gridBagConstraints);
        this.add(CONTENT, this.pnlContent);
    }

    protected int getSelectedRow() {
        return this.getTable().getSelectedRow();
    }

    protected int getSelectedRowCount() {
        return this.getTable().getSelectedRowCount();
    }

    protected void setNewDeleteEnablement() {
        int n = this.getSelectedRow();
        IDARReference iDARReference = null;
        if (n != -1) {
            iDARReference = this.getTableModel().getBeanReferenceAt(n);
        }
        this.deleteTask.setObject(iDARReference);
        this.editTask.setObject(iDARReference);
    }

    protected void loadingStart() {
        this.isLoading = true;
        this.cardLayout.show(this, LOAD);
    }

    protected void loadingFinished() {
        this.isLoading = false;
        this.cardLayout.show(this, CONTENT);
    }

    protected void loadingError() {
        this.isLoading = false;
        this.cardLayout.show(this, ERROR);
    }

    protected void createObject(String string) {
        this.createTask.setDescriptor(string);
        if (this.createTask.isExecutable()) {
            this.createTask.execute();
        } else {
            Debug.println((String)("ObjectView.createObject: CANT EXECUTE CREATE - " + this.createTask.getUnexecutableMessage()));
        }
    }

    protected Component getTableComponent() {
        return this.getTable();
    }

    protected JTable getTable() {
        if (this.tblTable == null) {
            this.tblTable = new JTable();
            this.tblTable.setModel(this.getTableModel());
        }
        return this.tblTable;
    }
}

