/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator;

import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.TableModelBeanListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class ObjectTableModel
extends AbstractTableModel {
    private static final String NAME = IDARResourceSet.getString("configGeneral", "NAME");
    private static final String TYPE = IDARResourceSet.getString("configGeneral", "TYPE");
    private String[] columnNames = null;
    private Vector data = new Vector();
    private TableModelBeanListener listener = new TableModelBeanListener(this);

    public ObjectTableModel(boolean bl) {
        this.columnNames = bl ? new String[]{NAME, TYPE} : new String[]{NAME};
    }

    public Object getValueAt(int n, int n2) {
        String string = null;
        try {
            Object e = this.data.elementAt(n);
            if (e instanceof BeanListenable) {
                if (n2 == 0) {
                    string = ((BeanListenable)e).getId();
                } else if (n2 == 1) {
                    string = ((BeanListenable)e).getDescriptor();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        return string;
    }

    public void setElements(Vector vector) {
        this.removeAllElements();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.addElement(e);
        }
    }

    public void addElement(Object object) {
        if (object instanceof BeanListenable) {
            BeanListenable beanListenable = (BeanListenable)object;
            beanListenable.addBeanListener(this.listener);
            this.data.addElement(object);
            this.fireTableDataChanged();
        }
    }

    public Vector getElements() {
        return this.data;
    }

    public void removeElement(int n) {
        BeanListenable beanListenable = (BeanListenable)this.data.elementAt(n);
        beanListenable.removeBeanListener(this.listener);
        this.data.removeElementAt(n);
        this.fireTableDataChanged();
    }

    public void removeAllElements() {
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            BeanListenable beanListenable = (BeanListenable)enumeration.nextElement();
            beanListenable.removeBeanListener(this.listener);
        }
        this.data.clear();
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public BeanListenable getBeanListenable(int n) {
        BeanListenable beanListenable = null;
        try {
            Object e = this.data.elementAt(n);
            if (e instanceof BeanListenable) {
                beanListenable = (BeanListenable)e;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return beanListenable;
    }

    public IDARReference getReference(int n) {
        IDARReference iDARReference = null;
        BeanListenable beanListenable = this.getBeanListenable(n);
        if (beanListenable != null) {
            iDARReference = beanListenable.getSelfReference();
        }
        return iDARReference;
    }
}

