/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator;

import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARConfigurationModelBean;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.configurator.PriorityObjectViewTableModel;
import com.iplanet.idar.ui.configurator.PriorityTableObjectView;
import com.netscape.management.client.util.Debug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class NetworkGroupObjectView
extends PriorityTableObjectView {
    private Hashtable criteriaStrings = new Hashtable();
    private static final String ANY = IDARResourceSet.getString("groupNetwork", "ANY");
    private static final String NONE = IDARResourceSet.getString("groupNetwork", "NONE");
    private static final String CRITERIA = IDARResourceSet.getString("groupNetwork", "CRITERIA");

    public void setModel(IDARBeanCollection iDARBeanCollection) {
        Debug.println((int)7, (String)("NetworkGroupObjectView.setModel: model=" + iDARBeanCollection));
        this.setObjectModel(iDARBeanCollection);
        this.setTableModel(new NetworkGroupObjectViewTableModel(iDARBeanCollection));
        this.initContentPanel();
    }

    class NetworkGroupObjectViewTableModel
    extends PriorityObjectViewTableModel {
        NetworkGroupObjectViewTableModel(IDARBeanCollection iDARBeanCollection) {
            super(iDARBeanCollection);
            this.setColumnNames(new String[]{NAME, CRITERIA});
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            IDARConfigurationModelBean iDARConfigurationModelBean = null;
            try {
                iDARConfigurationModelBean = (IDARConfigurationModelBean)super.getBeanAt(n);
            }
            catch (NoSuchBeanException noSuchBeanException) {
                noSuchBeanException.printStackTrace();
            }
            catch (RetrievalException retrievalException) {
                retrievalException.printStackTrace();
            }
            if (iDARConfigurationModelBean != null && iDARConfigurationModelBean instanceof IDARConfigurationModelBean) {
                NetworkGroupBean networkGroupBean = (NetworkGroupBean)iDARConfigurationModelBean;
                switch (n2) {
                    case 0: {
                        string = networkGroupBean.getId();
                        break;
                    }
                    case 1: {
                        string = this.getNetworkCriteriaString(networkGroupBean);
                    }
                }
            }
            return string;
        }

        private String getNetworkCriteriaString(NetworkGroupBean networkGroupBean) {
            String string = (String)NetworkGroupObjectView.this.criteriaStrings.get(networkGroupBean);
            if (string == null) {
                string = this.createCriteriaString(networkGroupBean);
                NetworkGroupObjectView.this.criteriaStrings.put(networkGroupBean, string);
                networkGroupBean.addPropertyChangePersistanceListener("ids-proxy-con-client", new PropertyChangeListener(this, networkGroupBean){
                    private final /* synthetic */ NetworkGroupBean val$group;
                    private final /* synthetic */ NetworkGroupObjectViewTableModel this$1;
                    {
                        this.this$1 = networkGroupObjectViewTableModel;
                        this.val$group = networkGroupBean;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.val$group.removePropertyChangePersistanceListener("ids-proxy-con-client", this);
                        NetworkGroupObjectView.access$100(NetworkGroupObjectViewTableModel.access$200(this.this$1)).remove(this.val$group);
                    }
                });
            }
            return string;
        }

        private String createCriteriaString(NetworkGroupBean networkGroupBean) {
            StringBuffer stringBuffer = new StringBuffer();
            if (networkGroupBean.getAllIPBinding()) {
                stringBuffer.append(ANY);
            } else if (networkGroupBean.getNoIPBinding()) {
                stringBuffer.append(NONE);
            } else {
                Enumeration enumeration = networkGroupBean.getDomainNames().elements();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(enumeration.nextElement().toString() + ",");
                }
                enumeration = networkGroupBean.getIPAddresses().elements();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(enumeration.nextElement().toString() + ",");
                }
                enumeration = networkGroupBean.getBitMasks().elements();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(enumeration.nextElement().toString() + ",");
                }
                enumeration = networkGroupBean.getQuadMasks().elements();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(enumeration.nextElement().toString() + ",");
                }
                int n = stringBuffer.length() - 1;
                if (stringBuffer.charAt(n) == ',') {
                    stringBuffer.deleteCharAt(n);
                }
            }
            return stringBuffer.toString();
        }

        static /* synthetic */ NetworkGroupObjectView access$200(NetworkGroupObjectViewTableModel networkGroupObjectViewTableModel) {
            return networkGroupObjectViewTableModel.NetworkGroupObjectView.this;
        }
    }
}

