/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.bean.AdminConfigData;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.configuration.LoadErrorPanel;
import com.iplanet.idar.ui.configurator.ConfigurationTopResource;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ConfigurationTopView
extends JPanel
implements SuiConstants {
    protected static final String TITLE = IDARResourceSet.getString("configTopology", "CONFIGURATIONS");
    protected static final String HELP = IDARResourceSet.getString("button", "HELP");
    protected static final Icon ICON = ImageFactory.getImage("CONFIGURATION_TOP");
    private static final String ERR_TITLE = IDARResourceSet.getString("error", "TITLE");
    private static final String NO_LISTENING_ADMINS = IDARResourceSet.getString("error", "NO_LISTENING_ADMINS_TOP");
    protected Hashtable frameworks = new Hashtable();
    protected Vector configResources = new Vector();
    protected ConfigurationTopResource top;
    protected ConsoleInfo info;
    boolean loadError = false;

    public ConfigurationTopView(ConsoleInfo consoleInfo, ConfigurationTopResource configurationTopResource) {
        this.info = consoleInfo;
        this.top = configurationTopResource;
        this.initComponents();
    }

    private void initComponents() {
        Border border = BorderFactory.createEmptyBorder(9, 9, 9, 9);
        Border border2 = BorderFactory.createEtchedBorder();
        this.setBorder(BorderFactory.createCompoundBorder(border2, border));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(ICON);
        jLabel.setFont(UIManager.getFont("Title.font"));
        jLabel.setText(TITLE);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("West", jLabel);
        JSeparator jSeparator = new JSeparator();
        jSeparator.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        JButton jButton = JButtonFactory.createHelpButton((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminConfigData[] adminConfigDataArray = BeanSpace.getInstance().getUrls();
                AdminConfigData adminConfigData = null;
                for (int i = 0; i < adminConfigDataArray.length && (adminConfigData = adminConfigDataArray[i]) == null; ++i) {
                }
                URL uRL = null;
                if (adminConfigData != null) {
                    uRL = adminConfigData.getAdminServerURL();
                } else {
                    Debug.println((int)0, (String)"ERROR: UNABLE TO FIND ADMIN-SERVER URL");
                }
                if (uRL != null) {
                    Help.showContextHelp((String)"dps", (String)"Configuration-Topology", (URL)uRL);
                } else {
                    Debug.println((int)0, (String)"ERROR: UNABLE TO FIND ADMIN-SERVER URL");
                }
            }
        });
        JButtonFactory.resize((JButton)jButton);
        int n = 0;
        this.setLayout(new GridBagLayout());
        n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 0, 9, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jSeparator, gridBagConstraints);
        if (this.top.isLoadError()) {
            this.loadError = true;
            LoadErrorPanel loadErrorPanel = new LoadErrorPanel();
            loadErrorPanel.addReloadButtonActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!ConfigurationTopView.this.top.createChildren()) {
                        JOptionPane.showMessageDialog(ConfigurationTopView.this.info.getFrame(), NO_LISTENING_ADMINS, ERR_TITLE, 0);
                    } else {
                        ConfigurationTopView.this.loadError = false;
                        ConfigurationTopView.this.top.refresh();
                        ConfigurationTopView.this.reset();
                    }
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 10.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            this.add((Component)loadErrorPanel, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 14;
        this.add((Component)jButton, gridBagConstraints);
    }

    public boolean isShowingError() {
        return this.loadError;
    }

    public void reset() {
        this.removeAll();
        this.initComponents();
        this.revalidate();
    }
}

