/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common.configuration;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.task.configuration.CreateObjectTask;
import com.iplanet.idar.task.configuration.DeleteObjectTask;
import com.iplanet.idar.task.configuration.SaveObjectTask;
import com.iplanet.idar.ui.common.DynamicComboBoxModel;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.ToggleBorder;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.common.configuration.DynamicConfigurationView;
import com.iplanet.idar.ui.task.TaskButton;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public abstract class EmbeddedConfigurationView
extends ConfigurationView
implements SuiConstants {
    protected DynamicConfigurationView embeddedView;
    ActionListener itemChangeListener = new ActionListener(){

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            Debug.println((int)8);
            if (EmbeddedConfigurationView.this.embeddedView.isDirty()) {
                try {
                    EmbeddedConfigurationView.this.embeddedView.applyChanges();
                }
                catch (ConfigurationViewException configurationViewException) {
                    JOptionPane.showMessageDialog(IDARUtilities.getParentFrame(EmbeddedConfigurationView.this), configurationViewException.getMessage(), IDARResourceSet.getString("commonEditor", "ILLEGAL_DATA_TITLE"), 0);
                    return;
                }
            }
            Object object = EmbeddedConfigurationView.this.cboCurrentItem.getSelectedItem();
            IDARReference iDARReference = null;
            if (object == null) {
                iDARReference = EmbeddedConfigurationView.this.getCurrentItem();
            } else if (!object.toString().equals(DynamicComboBoxModel.NONE)) {
                iDARReference = ((DynamicComboBoxModel)EmbeddedConfigurationView.this.cboCurrentItem.getModel()).getReference(object.toString());
            }
            EmbeddedConfigurationView.this.setComponentDataModelToSelectedBean(iDARReference);
            EmbeddedConfigurationView.this.fireBlankPanelEvent(new BlankPanelEvent(EmbeddedConfigurationView.this, actionEvent));
        }
    };
    protected CreateObjectTask createTask;
    protected DeleteObjectTask deleteTask;
    private TaskButton butDelete;
    private TaskButton butCreate;
    private MyComboBox cboCurrentItem;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public abstract IDARReference getCurrentItem();

    public abstract void setCurrentItem(IDARReference var1);

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        Debug.println((int)6, (String)("EmbeddedConfigurationView.setDataModel: model=" + iDARModelBean + " reset=" + bl));
        super.setDataModel(iDARModelBean, false);
        IDARReference iDARReference = this.getCurrentItem();
        this.setCurrentlySelectedItem(iDARReference);
        if (bl) {
            this.setComponentDataModelToSelectedBean(iDARReference);
        }
    }

    public void setComponentDataModelToSelectedBean(IDARReference iDARReference) {
        Debug.println((int)6, (String)("EmbeddedConfigurationView.setComponentDataModelToSelectedBean: selected=" + iDARReference));
        if (iDARReference != null) {
            IDARModelBean iDARModelBean = this.embeddedView.getDataModel();
            if (iDARModelBean == null || !iDARReference.equals(iDARModelBean.getSelfReference())) {
                this.embeddedView.setModelInfo(iDARReference);
                if (iDARReference.equals(this.getCurrentItem())) {
                    this.deleteTask.setObject(null);
                } else {
                    this.deleteTask.setObject(iDARReference);
                }
            } else if (this.embeddedView.isShowingError()) {
                this.embeddedView.setModelInfo(iDARReference);
            } else {
                Debug.println((int)7, (String)"EmbeddedConfigurationView.setComponentDataModelToSelectedBean: model stays the same");
                try {
                    this.embeddedView.resetContent();
                }
                catch (ConfigurationViewException configurationViewException) {}
            }
        } else {
            this.embeddedView.setDataModel(null);
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        Debug.println((int)6, (String)"EmbeddedConfigurationView.applyChanges");
        this.setCurrentItem(this.getCurrentlySelectedItem());
        this.embeddedView.applyChanges();
    }

    public void resetContent() throws ConfigurationViewException {
        Debug.println((int)6, (String)"EmbeddedConfigurationView.resetContent");
        this.cboCurrentItem.removeActionListener(this.itemChangeListener);
        IDARReference iDARReference = this.getCurrentItem();
        this.setCurrentlySelectedItem(iDARReference);
        this.setComponentDataModelToSelectedBean(iDARReference);
        this.cboCurrentItem.addActionListener(this.itemChangeListener);
    }

    public JPanel getPanel() {
        return this;
    }

    protected void setCurrentlySelectedItem(IDARReference iDARReference) {
        Debug.println((int)6, (String)("EmbeddedConfigurationView.setCurrentlySelectedItem: ref=" + iDARReference));
        String string = DynamicComboBoxModel.NONE;
        if (iDARReference != null) {
            string = iDARReference.getId();
        }
        Debug.println((String)("EmbeddedConfigurationView.setCurrentlySelectedItem: item=" + string));
        this.cboCurrentItem.setSelectedItem(string);
    }

    private void removeAllActionListeners(MyComboBox myComboBox, ActionListener actionListener) {
        EventListenerList eventListenerList = myComboBox.getListenerList();
        int n = eventListenerList.getListenerCount(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = EmbeddedConfigurationView.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
        Debug.println((int)9, (String)("EmbeddedConfigurationView.removeAllActionListeners count = " + n));
        for (int i = 0; i < n; ++i) {
            eventListenerList.remove(class$java$awt$event$ActionListener == null ? EmbeddedConfigurationView.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener, actionListener);
        }
    }

    protected IDARReference getCurrentlySelectedItem() {
        return ((DynamicComboBoxModel)this.cboCurrentItem.getModel()).getSelectedReference();
    }

    protected void initComponents(DynamicConfigurationView dynamicConfigurationView, JLabel jLabel, String string, IDARReference iDARReference, boolean bl) {
        Object object;
        Serializable serializable;
        Object object2;
        Debug.println((String)"EmbeddedConfigurationView.initComponents");
        this.embeddedView = dynamicConfigurationView;
        this.createTask = new CreateObjectTask(string, iDARReference);
        this.createTask.addTaskListener(new TaskAdapter(){

            public void taskStopped(TaskEvent taskEvent) {
                if (EmbeddedConfigurationView.this.createTask.getExecutionStatus() == 0) {
                    IDARReference iDARReference = EmbeddedConfigurationView.this.createTask.getNewObjectReference();
                    EmbeddedConfigurationView.this.setCurrentlySelectedItem(iDARReference);
                    while (true) {
                        String string = (String)JOptionPane.showInputDialog(EmbeddedConfigurationView.this, IDARResourceSet.getString("commonEditor", "NEW_NAME"), IDARResourceSet.getString("commonEditor", "NEW_NAME_TITLE"), -1, null, null, iDARReference.getId());
                        Debug.println((int)0, (String)("new id = " + string));
                        Debug.println((int)0, (String)("new ref = " + iDARReference));
                        if (string != null) {
                            string.trim();
                        }
                        if (string != null && !string.equals("") && !iDARReference.getId().equals(string)) {
                            IDARModelBean iDARModelBean = null;
                            try {
                                Debug.println((int)0, (String)("bean =" + iDARModelBean));
                                iDARModelBean = iDARReference.getBean();
                                if (iDARModelBean != null) {
                                    iDARModelBean.setId(string);
                                    EmbeddedConfigurationView.this.setCurrentlySelectedItem(iDARReference);
                                    SaveObjectTask saveObjectTask = new SaveObjectTask(iDARModelBean);
                                    saveObjectTask.execute();
                                    break;
                                }
                                Debug.println((String)"EmbeddedConfigurationView.createTaskListener.taskStopped:  ERROR getting bean");
                            }
                            catch (UniqueNameException uniqueNameException) {
                                JOptionPane.showMessageDialog(IDARUtilities.getParentFrame(EmbeddedConfigurationView.this), IDARResourceSet.getString("error", "UNIQUE_NAME", string), IDARResourceSet.getString("commonEditor", "ILLEGAL_DATA_TITLE"), 0);
                            }
                            catch (NoSuchBeanException noSuchBeanException) {
                                Debug.println((int)0, (String)("ERROR: NO SUCH BEAN - " + noSuchBeanException.getLocalizedMessage()));
                            }
                            catch (RetrievalException retrievalException) {
                                Debug.println((int)0, (String)("ERROR: UNABLE TO RETRIEVE BEAN - " + retrievalException.getLocalizedMessage()));
                            }
                            continue;
                        }
                        if (string == null) {
                            EmbeddedConfigurationView.this.deleteTask.confirmWithUserBeforeDelete(false);
                            EmbeddedConfigurationView.this.deleteTask.setObject(iDARReference);
                            EmbeddedConfigurationView.this.deleteTask.execute();
                            iDARReference = null;
                            break;
                        }
                        if (!string.equals("")) break;
                        JOptionPane.showMessageDialog(IDARUtilities.getParentFrame(EmbeddedConfigurationView.this), IDARResourceSet.getString("error", "NAME_MISSING"), IDARResourceSet.getString("commonEditor", "ILLEGAL_DATA_TITLE"), 0);
                    }
                }
            }
        });
        this.deleteTask = new DeleteObjectTask();
        this.butCreate = new TaskButton(this.createTask);
        this.cboCurrentItem = new MyComboBox();
        try {
            object2 = BeanSpace.getInstance().retrieveBeanCollection(iDARReference, string);
            serializable = new DynamicComboBoxModel((IDARBeanCollection)object2, bl);
            this.cboCurrentItem.setModel(serializable);
            IDARBean iDARBean = (IDARBean)this.getDataModel();
            object = this.getCurrentItem();
            this.setCurrentlySelectedItem((IDARReference)object);
        }
        catch (RetrievalException retrievalException) {
            retrievalException.printStackTrace();
        }
        catch (NoSuchBeanException noSuchBeanException) {
            noSuchBeanException.printStackTrace();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
        this.cboCurrentItem.addActionListener(this.itemChangeListener);
        if (jLabel != null) {
            jLabel.setLabelFor(this.cboCurrentItem);
        }
        this.butDelete = new TaskButton(this.deleteTask);
        this.deleteTask.addTaskListener(new TaskAdapter(){

            public void taskStarted(TaskEvent taskEvent) {
                EmbeddedConfigurationView.this.cboCurrentItem.removeActionListener(EmbeddedConfigurationView.this.itemChangeListener);
            }

            public void taskStopped(TaskEvent taskEvent) {
                EmbeddedConfigurationView.this.cboCurrentItem.addActionListener(EmbeddedConfigurationView.this.itemChangeListener);
                if (EmbeddedConfigurationView.this.deleteTask.getExecutionStatus() == 0) {
                    EmbeddedConfigurationView.this.setCurrentlySelectedItem(EmbeddedConfigurationView.this.getCurrentItem());
                }
            }
        });
        this.setLayout(new GridBagLayout());
        object2 = new BlankPanel();
        ((Container)object2).setLayout(new GridBagLayout());
        int n = 0;
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(9, 9, 0, 0);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = n;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((BlankPanel)object2).add((Component)jLabel, serializable);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(9, 9, 0, 0);
        ((GridBagConstraints)serializable).gridx = 1;
        ((GridBagConstraints)serializable).gridy = n;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).weightx = 2.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((BlankPanel)object2).add((Component)this.cboCurrentItem, serializable);
        ((BlankPanel)object2).unregister(this.cboCurrentItem);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(9, 9, 0, 0);
        ((GridBagConstraints)serializable).gridx = 2;
        ((GridBagConstraints)serializable).gridy = n;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 0;
        ((BlankPanel)object2).add((Component)this.butCreate, serializable);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(9, 9, 0, 9);
        ((GridBagConstraints)serializable).gridx = 3;
        ((GridBagConstraints)serializable).gridy = n++;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((BlankPanel)object2).add((Component)this.butDelete, serializable);
        object = new BlankPanel();
        ((Container)object).setLayout(new GridBagLayout());
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).anchor = 16;
        ((BlankPanel)object).add((Component)object2, serializable);
        BlankPanel blankPanel = new BlankPanel("EmbeddedConfigurationView.SettingsBorder");
        blankPanel.setBorder(new ToggleBorder((JComponent)object, 3));
        blankPanel.setLayout(new GridBagLayout());
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 9, 0, 9);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        blankPanel.add((Component)object, serializable);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(9, 9, 0, 9);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).weightx = 2.0;
        ((GridBagConstraints)serializable).weighty = 2.0;
        blankPanel.add((Component)dynamicConfigurationView, serializable);
        n = 0;
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(9, 9, 9, 9);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = n;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 2.0;
        this.add((Component)IDARUtilities.createEmptyBorderScrollPane(blankPanel), serializable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MyComboBox
    extends JComboBox {
        MyComboBox() {
        }

        public EventListenerList getListenerList() {
            return this.listenerList;
        }
    }
}

