/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common.components;

import com.iplanet.idar.ui.common.components.PrecedenceTableModel;
import com.netscape.management.client.components.TableMap;
import com.netscape.management.client.util.Debug;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class PrecedenceTableSorter
extends TableMap
implements PrecedenceTableModel {
    protected int[] indexes;
    boolean ascending = true;
    int compares;

    public PrecedenceTableSorter() {
        this.indexes = new int[0];
    }

    public PrecedenceTableSorter(PrecedenceTableModel precedenceTableModel) {
        this.setModel(precedenceTableModel);
    }

    public void setModel(PrecedenceTableModel precedenceTableModel) {
        super.setModel((TableModel)precedenceTableModel);
        this.reallocateIndexes();
        this.sortByPrecedence();
        precedenceTableModel.addTableModelListener((TableModelListener)((Object)this));
    }

    public int compareRowsByPrecedence(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.model instanceof PrecedenceTableModel) {
            PrecedenceTableModel precedenceTableModel = (PrecedenceTableModel)this.model;
            n4 = precedenceTableModel.getPrecedenceOf(n);
            n3 = n4 < (n5 = precedenceTableModel.getPrecedenceOf(n2)) ? -1 : (n4 > n5 ? 1 : 0);
        } else {
            Debug.println((String)"PrecedenceTableSorter: model not of type PrecedenceTableModel");
        }
        return n3;
    }

    public int compare(int n, int n2) {
        ++this.compares;
        int n3 = this.compareRowsByPrecedence(n, n2);
        if (n3 != 0) {
            return this.ascending ? n3 : -n3;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int n = this.model.getRowCount();
        this.indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexes[i] = i;
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        Debug.println((int)7, (String)("PrecedenceTableSorter.tableChanged: evt=" + tableModelEvent));
        this.reallocateIndexes();
        this.sortByPrecedence();
        super.tableChanged(tableModelEvent);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            Debug.println((String)("PrecedenceTableSorter.checkModel: ERROR - Sorter not informed of a change in model indexes.length=" + this.indexes.length + " model.rows=" + this.model.getRowCount()));
        }
    }

    public void sort(Object object) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.indexes[i], this.indexes[j]) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            for (int i = n; i < n2; ++i) {
                nArray2[i] = nArray[i];
            }
            return;
        }
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
        }
    }

    public void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    public Object getValueAt(int n, int n2) {
        this.checkModel();
        Object object = this.model.getValueAt(this.indexes[n], n2);
        return object;
    }

    public int getPrecedenceOf(int n) {
        int n2 = 0;
        if (this.model instanceof PrecedenceTableModel) {
            n2 = ((PrecedenceTableModel)this.model).getPrecedenceOf(this.indexes[n]);
        } else {
            Debug.println((String)"PrecedenceTableSorter: model not of type PrecedenceTableModel");
        }
        return n2;
    }

    public void setValueAt(Object object, int n, int n2) {
        this.checkModel();
        this.model.setValueAt(object, this.indexes[n], n2);
    }

    public void swapPrecedences(int n, int n2) {
        int n3 = this.indexes[n];
        int n4 = this.indexes[n2];
        if (this.model instanceof PrecedenceTableModel) {
            int n5;
            PrecedenceTableModel precedenceTableModel = (PrecedenceTableModel)this.model;
            int n6 = precedenceTableModel.getPrecedenceOf(n3);
            if (n6 == (n5 = precedenceTableModel.getPrecedenceOf(n4))) {
                if (n > n2) {
                    precedenceTableModel.setPrecedenceOf(n3, ++n5);
                } else if (n5 != 0) {
                    precedenceTableModel.setPrecedenceOf(n3, --n5);
                }
            } else {
                precedenceTableModel.setPrecedenceOf(n3, n5);
                precedenceTableModel.setPrecedenceOf(n4, n6);
            }
            this.sortByPrecedence();
        }
    }

    public void addRow(Object[] objectArray) {
        this.makeZeroPrecedenceAvailable();
        if (this.model instanceof DefaultTableModel) {
            ((DefaultTableModel)this.model).addRow(objectArray);
            this.reallocateIndexes();
            this.sortByPrecedence();
        }
    }

    public void addRow(Vector vector) {
        this.makeZeroPrecedenceAvailable();
        if (this.model instanceof DefaultTableModel) {
            ((DefaultTableModel)this.model).addRow(vector);
            this.reallocateIndexes();
            this.sortByPrecedence();
        }
    }

    public void makeZeroPrecedenceAvailable() {
        if (this.model instanceof PrecedenceTableModel) {
            int n;
            PrecedenceTableModel precedenceTableModel = (PrecedenceTableModel)this.model;
            boolean bl = false;
            for (n = 0; n < this.indexes.length; ++n) {
                if (precedenceTableModel.getPrecedenceOf(n) != 0) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n = 0; n < this.indexes.length; ++n) {
                    int n2 = precedenceTableModel.getPrecedenceOf(n);
                    precedenceTableModel.setPrecedenceOf(n, n2 + 1);
                }
            }
        }
    }

    public void setPrecedenceOf(int n, int n2) {
        if (this.model instanceof PrecedenceTableModel) {
            ((PrecedenceTableModel)this.model).setPrecedenceOf(this.indexes[n], n2);
        } else {
            Debug.println((String)"PrecedenceTableSorter: model not of type PrecedenceTableModel");
        }
    }

    public void sortByPrecedence() {
        this.sortByPrecedence(false);
    }

    public void sortByPrecedence(boolean bl) {
        this.ascending = bl;
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    public int translateRow(int n) {
        return this.indexes[n];
    }

    public void removeRow(int n) {
        if (this.model instanceof DefaultTableModel) {
            ((DefaultTableModel)this.model).removeRow(this.indexes[n]);
        }
    }
}

