/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common;

import com.iplanet.idar.objectmodel.BeanEvent;
import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanListener;
import com.iplanet.idar.objectmodel.BeanListenerAdapter;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.ui.common.DynamicListModel;
import com.netscape.management.client.util.Debug;
import java.beans.PropertyChangeEvent;
import javax.swing.ComboBoxModel;

public class DynamicComboBoxModel
extends DynamicListModel
implements ComboBoxModel {
    Object selectedItem = null;
    BeanListenable selectedBean = null;
    private boolean allowNoneEntry = true;
    BeanListener beanListener = new BeanListenerAdapter(){

        public void beanDeleted(BeanEvent beanEvent) {
            Debug.println((String)("DynamicComboBoxModel.beanDeleted " + beanEvent.getBean() + "; selected=" + DynamicComboBoxModel.this.selectedBean));
            IDARModelBean iDARModelBean = beanEvent.getBean();
            IDARReference iDARReference = beanEvent.getReference();
            DynamicComboBoxModel.this.selectedItem = null;
            DynamicComboBoxModel.this.selectedBean = null;
            DynamicComboBoxModel.super.fireContentsChanged(this, -1, -1);
        }

        public void beanRenamed(BeanEvent beanEvent) {
            Debug.println((String)("DynamicComboBoxModel.beanRenamed " + beanEvent.getBean() + "; selected=" + DynamicComboBoxModel.this.selectedBean));
            IDARModelBean iDARModelBean = beanEvent.getBean();
            if (iDARModelBean.equals(DynamicComboBoxModel.this.selectedBean)) {
                DynamicComboBoxModel.this.selectedItem = iDARModelBean.getId();
                DynamicComboBoxModel.super.fireContentsChanged(this, -1, -1);
            }
        }

        public String toString() {
            return "the DynamicComboBox bean listener for ";
        }
    };

    public DynamicComboBoxModel() {
        this(null, true);
    }

    public DynamicComboBoxModel(IDARBeanCollection iDARBeanCollection) {
        this(iDARBeanCollection, true);
    }

    public DynamicComboBoxModel(boolean bl) {
        this(null, bl);
    }

    public DynamicComboBoxModel(IDARBeanCollection iDARBeanCollection, boolean bl) {
        this.allowNoneEntry = bl;
        this.setBeanCollection(iDARBeanCollection);
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public IDARReference getSelectedReference() {
        Debug.println((int)8, (String)("DynamicComboBoxModel.getSelectedReference: selectedItem=" + this.selectedItem));
        IDARReference iDARReference = null;
        if (this.selectedItem != null) {
            iDARReference = this.getReference((String)this.selectedItem);
        }
        return iDARReference;
    }

    public IDARModelBean getSelectedBean() {
        Debug.println((int)8, (String)("DynamicComboBoxModel.getSelectedBean: selectedItem=" + this.selectedItem));
        IDARModelBean iDARModelBean = null;
        IDARReference iDARReference = this.getSelectedReference();
        if (iDARReference != null) {
            try {
                iDARModelBean = iDARReference.getBean();
            }
            catch (IDARBeanException iDARBeanException) {
                iDARBeanException.printStackTrace();
            }
        }
        return iDARModelBean;
    }

    public void setSelectedItem(Object object) {
        Debug.println((int)8, (String)("DynamicComboBoxModel.setSelectedItem: o=" + object));
        if (this.selectedItem != null && !this.selectedItem.equals(object) || this.selectedItem == null && object != null) {
            String[] stringArray;
            if (this.contains(object)) {
                this.selectedItem = object;
                if (this.selectedItem.equals(DynamicListModel.NONE)) {
                    this.selectedBean = null;
                } else if (this.selectedItem instanceof String) {
                    this.selectedBean = this.getReference((String)this.selectedItem);
                } else if (this.selectedItem instanceof BeanListenable) {
                    this.selectedBean = (BeanListenable)this.selectedItem;
                }
                if (this.selectedBean != null) {
                    this.selectedBean.addBeanListener(this.beanListener);
                }
            } else if (!(this.selectedBean == null || (stringArray = this.selectedBean.getSelfReference().getOldIds()) != null && object != null && object.equals(stringArray[stringArray.length - 1]))) {
                this.selectedItem = null;
                if (this.selectedBean != null) {
                    this.selectedBean.removeBeanListener(this.beanListener);
                    this.selectedBean = null;
                }
            }
            super.fireContentsChanged(this, -1, -1);
        }
    }

    public void setBeanCollection(IDARBeanCollection iDARBeanCollection) {
        super.setBeanCollection(iDARBeanCollection);
        if (this.allowNoneEntry) {
            this.v.insertElementAt(DynamicListModel.NONE, 0);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (this.allowNoneEntry) {
            this.v.insertElementAt(DynamicListModel.NONE, 0);
        }
    }

    public boolean showNoneEntry() {
        return this.allowNoneEntry;
    }
}

