/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common;

import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.ui.common.ButtonComboBox;
import com.iplanet.idar.ui.common.DynamicListModel;
import com.iplanet.idar.ui.common.ObjectChooserDialog;
import com.iplanet.idar.ui.task.TaskButton;
import com.iplanet.idar.ui.task.configuration.IplanetCreateAndEditObjectTask;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AbstractChooserDialog
extends ObjectChooserDialog {
    String note = "";
    JList lstList = null;
    DynamicListModel lstModel = null;
    IDARBeanCollection collection = null;
    IDARReference configuration = null;
    ConsoleInfo consoleInfo = null;
    String[] descriptors = null;
    Frame parent = null;
    Vector newBeans = new Vector();
    IplanetCreateAndEditObjectTask createTask;
    protected ButtonComboBox cItems;
    protected JButton butNew;

    public AbstractChooserDialog(Frame frame, String string, String string2, IDARReference iDARReference, String string3, ConsoleInfo consoleInfo) {
        this(frame, string, string2, iDARReference, new String[]{string3}, consoleInfo, false);
    }

    public AbstractChooserDialog(Frame frame, String string, String string2, IDARReference iDARReference, String[] stringArray, ConsoleInfo consoleInfo) {
        this(frame, string, string2, iDARReference, stringArray, consoleInfo, false);
    }

    public AbstractChooserDialog(Frame frame, String string, String string2, IDARReference iDARReference, String string3, ConsoleInfo consoleInfo, boolean bl) {
        this(frame, string, string2, iDARReference, new String[]{string3}, consoleInfo, bl);
    }

    public AbstractChooserDialog(Frame frame, String string, String string2, IDARReference iDARReference, String[] stringArray, ConsoleInfo consoleInfo, boolean bl) {
        super(frame, string, bl);
        this.parent = frame;
        this.note = string2;
        this.configuration = iDARReference;
        this.consoleInfo = consoleInfo;
        this.descriptors = stringArray;
        this.createTask = new IplanetCreateAndEditObjectTask();
        this.createTask.setConsoleInfo(consoleInfo);
        this.createTask.setParentConfiguration(iDARReference);
        try {
            this.collection = BeanSpace.getInstance().retrieveBeanCollection(iDARReference, stringArray);
        }
        catch (IDARBeanException iDARBeanException) {
            iDARBeanException.printStackTrace();
        }
        super.getContentPane().removeAll();
        this.setComponent(new ObjectChooserDialog.ObjectChooserView(this, this).getPanel());
        this.pack();
        this.center();
        super.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDeactivated(WindowEvent windowEvent) {
                if (AbstractChooserDialog.this.isCancel()) {
                    Enumeration enumeration = AbstractChooserDialog.this.newBeans.elements();
                    while (enumeration.hasMoreElements()) {
                        IDARModelBean iDARModelBean = (IDARModelBean)enumeration.nextElement();
                        try {
                            iDARModelBean.delete();
                        }
                        catch (IDARBeanException iDARBeanException) {
                            iDARBeanException.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public String getNote() {
        return this.note;
    }

    private String[] getDescriptors() {
        return this.descriptors;
    }

    public Component getNewComponent() {
        TaskButton taskButton = null;
        String[] stringArray = this.getDescriptors();
        TaskButton taskButton2 = new TaskButton(this.createTask);
        if (stringArray != null && stringArray[0].equals("network-group")) {
            taskButton = null;
        } else if (stringArray != null && stringArray.length == 1) {
            this.createTask.setDescriptor(stringArray[0]);
            this.createTask.addTaskListener(new TaskAdapter(){

                public void taskStopped(TaskEvent taskEvent) {
                    IDARReference iDARReference = AbstractChooserDialog.this.createTask.getNewObjectReference();
                    if (iDARReference != null) {
                        AbstractChooserDialog.this.lstList.setSelectedValue(iDARReference.getId(), true);
                    }
                }
            });
            taskButton = taskButton2;
        } else if (stringArray != null && stringArray.length > 0) {
            Debug.println((String)"AbstractChooserDialog:  ERROR - Dynmaic creation not supported at this time");
            taskButton = null;
        }
        return taskButton;
    }

    public IDARBeanCollection getModel() {
        return this.collection;
    }

    public JList getList() {
        if (this.lstList == null && this.collection != null) {
            this.lstModel = new DynamicListModel(this.collection);
            this.lstList = new JList(this.lstModel);
            this.lstList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    AbstractChooserDialog.this.setOKButtonEnabled(!AbstractChooserDialog.this.lstList.isSelectionEmpty());
                }
            });
            this.lstModel.addListDataListener(new ListDataListener(){

                public void intervalAdded(ListDataEvent listDataEvent) {
                }

                public void intervalRemoved(ListDataEvent listDataEvent) {
                    Debug.println((int)0, (String)"removed item from list");
                    AbstractChooserDialog.this.setOKButtonEnabled(!AbstractChooserDialog.this.lstList.isSelectionEmpty());
                }

                public void contentsChanged(ListDataEvent listDataEvent) {
                }
            });
        }
        return this.lstList;
    }

    public BeanListenable getSelectedBean() {
        Object object;
        int n = this.lstList.getSelectedIndex();
        BeanListenable beanListenable = null;
        if (n > -1 && (object = this.lstModel.elementAt(n)) instanceof BeanListenable) {
            beanListenable = (BeanListenable)object;
        }
        return beanListenable;
    }

    public Vector getSelectedBeans() {
        Vector<Object> vector = new Vector<Object>();
        int[] nArray = this.lstList.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            vector.add(this.lstModel.elementAt(nArray[i]));
        }
        return vector;
    }
}

