/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.task.idar;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.LogPropertyBean;
import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.task.TaskParameters;
import com.iplanet.idar.task.idar.IdarTask;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.server.configuration.LogRecord;
import com.netscape.management.client.util.DARTask;
import com.netscape.management.client.util.Debug;
import java.util.Vector;

public class RetrieveLogRecordsTask
extends IdarTask
implements IDARConstants {
    public static final int DEFAULT_NUMBER_LINES_TO_RETRIEVE = 25;
    private int lines = 25;
    private Vector records = null;
    private int status;

    public RetrieveLogRecordsTask(IDARBean iDARBean) {
        this(iDARBean, null, null);
    }

    public RetrieveLogRecordsTask(IDARBean iDARBean, String string, String string2) {
        super(iDARBean, string, string2);
    }

    public String getName() {
        return IDARResourceSet.getString("taskRetrieveLogRecords", "NAME_SHORT");
    }

    public String getDescription() {
        return IDARResourceSet.getString("taskRetrieveLogRecords", "DESCRIPTION");
    }

    public String getLogFileName() {
        LogPropertyBean logPropertyBean;
        SystemBean systemBean;
        Debug.println((String)"RetrieveLogRecordsTask.getLogFileName");
        String string = null;
        if (this.idar != null && (systemBean = this.idar.getSystemBean()) != null && (logPropertyBean = systemBean.getLogPropertyBean()) != null) {
            string = logPropertyBean.getLogFileName();
        }
        if (string == null || string.trim().equals("")) {
            string = this.getDefaultLogFileName();
        }
        Debug.println((String)("RetrieveLogRecordsTask.getLogFileName: file=" + string));
        return string;
    }

    public String getDefaultLogFileName() {
        Debug.println((String)"RetrieveLogRecordsTask.getDefaultLogFileName");
        String string = null;
        if (this.idar != null) {
            String string2 = this.idar.getIdarRoot();
            String string3 = null;
            string3 = this.idar.getOS() == 0 ? "\\" : "/";
            string = string2 + string3 + "logs" + string3 + "fwd.log";
        }
        return string;
    }

    public void setNumberOfLinesToRetrieve(int n) {
        this.lines = n;
    }

    public int getNumberOfLinesToRetrieve() {
        return this.lines;
    }

    public int doExecute() {
        Debug.println((String)"RetrieveLogRecordsTask.doExecute");
        int n = -2;
        this.fireTaskStatusChanged(IDARResourceSet.getString("taskRetrieveLogRecords", "RETRIEVING_RECORDS", new String[]{this.idar.getId()}));
        TaskParameters taskParameters = new TaskParameters();
        taskParameters.addParameter("filename", this.getLogFileName());
        taskParameters.addParameter("lines", Integer.toString(this.lines));
        DARTask dARTask = this.getHttpTask("/tasks/operation/viewlogfile", taskParameters);
        if (dARTask != null) {
            Debug.println((int)6, (String)("********** parameters=" + taskParameters));
            dARTask.exec();
            this.status = dARTask.getStatus();
            Debug.println((String)("RetrieveLogRecordsTask.doExecute: status=" + this.status));
            if (this.status != 0) {
                n = -1;
            } else {
                this.fireTaskStatusChanged(IDARResourceSet.getString("taskRetrieveLogRecords", "ORDERING_RECORDS", new String[]{this.idar.getId()}));
                Vector<String> vector = new Vector<String>();
                for (int i = 0; i < this.lines; ++i) {
                    String string = dARTask.getResponseAttributeValue("log" + (this.lines - i - 1));
                    if (string == null) continue;
                    vector.add(string);
                }
                String[] stringArray = new String[]{};
                stringArray = vector.toArray(stringArray);
                this.records = this.parseRecords(stringArray);
                n = 0;
            }
        }
        return n;
    }

    public Vector getRecords() {
        return this.records;
    }

    public int getStatus() {
        return this.status;
    }

    private Vector parseRecords(String[] stringArray) {
        Vector<LogRecord> vector = null;
        if (stringArray == null) {
            vector = new Vector<LogRecord>(0);
        } else {
            vector = new Vector(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(new LogRecord(stringArray[i]));
            }
        }
        return vector;
    }
}

