/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.task.idar;

import com.iplanet.idar.objectmodel.bean.AdminServerBean;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.task.TaskParameters;
import com.netscape.management.client.util.Debug;
import java.net.MalformedURLException;
import java.net.URL;

public class IDARTaskUtilities {
    public static final String NULL_IDAR = "reference to idar is invalid";
    public static final String NULL_USER_ID = "null user id";
    public static final String NULL_PASSWORD = "null password";

    public static boolean setParameters(TaskParameters taskParameters, IDARBean iDARBean) {
        Debug.println((int)6, (String)("IDARTaskUtilities.setParameters: idar=" + iDARBean));
        boolean bl = false;
        if (iDARBean != null) {
            String string = iDARBean.getIdarRoot();
            if (string != null) {
                taskParameters.addParameter("idarroot", string);
                String string2 = iDARBean.getHostName();
                if (string2 != null) {
                    taskParameters.addParameter("host", string2);
                    SystemBean systemBean = iDARBean.getSystemBean();
                    if (systemBean != null) {
                        Integer n = systemBean.getPort();
                        if (n != null) {
                            taskParameters.addParameter("port", n.toString());
                            bl = true;
                        } else {
                            Debug.println((String)"IDARTaskUtilities.setParameters:  ERROR: null port");
                        }
                    } else {
                        Debug.println((String)"IDARTaskUtilities.setParameters:  ERROR: can't access system bean");
                    }
                } else {
                    Debug.println((String)"IDARTaskUtilities.setParameters:  ERROR: null host");
                }
            } else {
                Debug.println((String)"IDARTaskUtilities.setParameters: ERROR: null idarroot");
            }
        } else {
            Debug.println((String)"IDARTaskUtilities.setParameters: ERROR: null idar");
        }
        return bl;
    }

    public static URL getTaskUrl(IDARBean iDARBean, String string) {
        Debug.println((int)6, (String)("IDARTaskUtilities.getTaskUrl: idar=" + iDARBean + " uri=" + string));
        URL uRL = null;
        if (iDARBean != null) {
            AdminServerBean adminServerBean = iDARBean.getAdminServerBean();
            if (adminServerBean != null) {
                String string2 = iDARBean.getHostName();
                Integer n = adminServerBean.getPort();
                if (string2 != null && n != null) {
                    StringBuffer stringBuffer = new StringBuffer("http://");
                    stringBuffer.append(string2);
                    stringBuffer.append(":");
                    stringBuffer.append(n.toString());
                    stringBuffer.append("/");
                    stringBuffer.append(iDARBean.getId());
                    stringBuffer.append(string);
                    try {
                        uRL = new URL(stringBuffer.toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        Debug.println((String)("IDARTaskUtilities.getTaskUrl:  ERROR: invalid url " + stringBuffer.toString()));
                    }
                } else {
                    Debug.println((String)("IDARTaskUtilities.getTaskUrl:  ERROR: bad host or port " + string2 + " " + n));
                }
            } else {
                Debug.println((String)"IDARTaskUtilities.getTaskUrl:  ERROR: cannot access admin server info");
            }
        }
        return uRL;
    }

    public static boolean isExecutable(IDARBean iDARBean, String string, String string2) {
        return iDARBean != null && string != null && string2 != null;
    }

    public static String getUnexecutableMessage(IDARBean iDARBean, String string, String string2) {
        String string3 = "";
        if (iDARBean == null) {
            string3 = NULL_IDAR;
        } else if (string == null) {
            string3 = NULL_USER_ID;
        } else if (string2 == null) {
            string3 = NULL_PASSWORD;
        }
        return string3;
    }
}

