/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.task.configuration;

import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.task.TaskDialogManager;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;

public class SaveObjectTask
extends AbstractTask {
    IDARModelBean object = null;

    public SaveObjectTask() {
        this(null);
    }

    public SaveObjectTask(IDARModelBean iDARModelBean) {
        this.setObject(iDARModelBean);
    }

    public String getName() {
        return IDARResourceSet.getString("taskSaveObject", "NAME_SHORT");
    }

    public String getDescription() {
        return IDARResourceSet.getString("taskSaveObject", "DESCRIPTION");
    }

    public String getUnexecutableMessage() {
        String string = "";
        if (this.object != null) {
            string = IDARResourceSet.getString("taskSaveObject", "MISSING_OBJECT");
        }
        return string;
    }

    public boolean isCancelable() {
        return true;
    }

    public void setObject(IDARModelBean iDARModelBean) {
        Debug.println((String)("SaveObjectTask.setObject: model=" + iDARModelBean));
        this.object = iDARModelBean;
        this.setExecutable(this.object != null);
    }

    public int doExecute() {
        Debug.println((String)"SaveObjectTask.doExecute");
        int n = -2;
        TaskDialogManager taskDialogManager = this.getDialogManager();
        n = this.objectIsInSavableState(this.object, taskDialogManager);
        if (n != -1 && n != -3) {
            this.fireTaskStatusChanged(IDARResourceSet.getString("taskSaveObject", "SAVING", this.object.getId()));
            try {
                this.object.persist();
                n = 0;
            }
            catch (IDARBeanException iDARBeanException) {
                taskDialogManager.showMessage(iDARBeanException.getMessage(), IDARResourceSet.getString("error", "TITLE"), 0);
                n = -1;
            }
        }
        return n;
    }

    private int objectIsInSavableState(IDARModelBean iDARModelBean, TaskDialogManager taskDialogManager) {
        int n = -2;
        this.fireTaskStatusChanged(IDARResourceSet.getString("taskSaveObject", "VALIDATING", iDARModelBean.getId()));
        String string = iDARModelBean.getIllegalityExplanationMessage();
        if (!this.isCanceled()) {
            if (string != null) {
                taskDialogManager.showMessage(string, IDARResourceSet.getString("commonEditor", "ILLEGAL_DATA_TITLE"), 0);
                n = -1;
            } else {
                String string2 = iDARModelBean.getQuestionableExplanationMessage();
                if (!this.isCanceled()) {
                    if (string2 != null) {
                        int n2 = taskDialogManager.showConfirmation(string2 + "\n" + IDARResourceSet.getString("commonEditor", "QUESTIONABLE_DATA"), IDARResourceSet.getString("commonEditor", "QUESTIONABLE_DATA_TITLE"), 0, 3);
                        if (n2 == 1) {
                            n = -3;
                        }
                    }
                } else {
                    n = -3;
                }
            }
        } else {
            n = -3;
        }
        return n;
    }
}

