/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.task;

import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.task.TaskDialogManager;
import com.iplanet.idar.task.TaskManagerFactory;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.RDN;

public class Migrate50To51Task
extends AbstractTask {
    private static final String NEW_SYSTEM_ROOT = "ou=system,ou=dar-config,o=netscaperoot";
    private static final String NEW_LOG_ROOT = "ou=properties,ou=system,ou=dar-config,o=netscaperoot";
    private static final String[] ATTRS = new String[]{"1.1"};
    String host = null;
    int port = 389;
    String userDn = null;
    String password = null;
    boolean verbose = false;
    String configToMigrate = null;

    public Migrate50To51Task() {
        this(null, -1, null, null, false);
    }

    public Migrate50To51Task(String string, int n, String string2, String string3) {
        this(string, n, string2, string3, false);
    }

    public Migrate50To51Task(String string, int n, String string2, String string3, String string4) {
        this(string, n, string2, string3, string4, false);
    }

    public Migrate50To51Task(String string, int n, String string2, String string3, boolean bl) {
        this(string, n, string2, string3, null, bl);
    }

    public Migrate50To51Task(String string, int n, String string2, String string3, String string4, boolean bl) {
        this.host = string;
        this.port = n;
        this.userDn = string2;
        this.password = string3;
        this.verbose = bl;
        this.configToMigrate = string4;
        this.setExecutableness();
    }

    public String getName() {
        return IDARResourceSet.getString("taskMigrate50To51", "NAME_SHORT");
    }

    public String getDescription() {
        return IDARResourceSet.getString("taskMigrate50To51", "DESCRIPTION");
    }

    public String getUnexecutableMessage() {
        String string = "";
        if (this.host == null) {
            string = "No host";
        } else if (this.port == -1) {
            string = "No port";
        } else if (this.userDn == null) {
            string = "No user dn";
        } else if (this.password == null) {
            string = "No password";
        }
        return string;
    }

    public void setHost(String string) {
        this.host = string;
        this.setExecutableness();
    }

    public void setPort(int n) {
        this.port = n;
        this.setExecutableness();
    }

    public void setUserDn(String string) {
        this.userDn = string;
        this.setExecutableness();
    }

    public void setPassword(String string) {
        this.password = string;
        this.setExecutableness();
    }

    public void setConfigurationToMigrate(String string) {
        this.configToMigrate = string;
    }

    public int doExecute() {
        int n;
        block12: {
            Debug.println((String)"Migrate50To51Task.doExecute");
            n = -2;
            TaskDialogManager taskDialogManager = this.getDialogManager();
            LDAPConnection lDAPConnection = new LDAPConnection();
            if (this.verbose) {
                this.fireTaskStatusChanged("Migrating iDAR configuration directory model from 5.0 to 5.1...");
            }
            try {
                lDAPConnection.connect(this.host, this.port, this.userDn, this.password);
                this.create51Structure(lDAPConnection);
                if (this.configToMigrate == null) {
                    LDAPSearchResults lDAPSearchResults = lDAPConnection.search("ou=dar-config,o=netscaperoot", 1, "objectclass=nsdarconfiguration", null, false);
                    while (lDAPSearchResults.hasMoreElements()) {
                        this.migrateConfiguration(lDAPConnection, lDAPSearchResults.next());
                    }
                    n = 0;
                    if (this.verbose) {
                        this.fireTaskStatusChanged("Migrating completed successfully");
                    }
                    break block12;
                }
                try {
                    String string = "cn=" + this.configToMigrate + ",ou=dar-config,o=netscaperoot";
                    LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 0, "objectclass=nsdarconfiguration", null, false);
                    if (lDAPSearchResults.getCount() > 0) {
                        this.migrateConfiguration(lDAPConnection, lDAPSearchResults.next());
                        n = 0;
                        if (this.verbose) {
                            this.fireTaskStatusChanged("Migrating completed successfully");
                        }
                    } else {
                        taskDialogManager.showMessage("Could not access " + this.configToMigrate, "Migration Error", 0);
                        n = -1;
                    }
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 32) {
                        taskDialogManager.showMessage("Configuration " + this.configToMigrate + " not found", "Migration Error", 0);
                        n = -1;
                    }
                    throw lDAPException;
                }
            }
            catch (LDAPException lDAPException) {
                taskDialogManager.showMessage("Migration failed:  " + lDAPException.errorCodeToString(), "Migration Error", 0);
                n = -1;
            }
        }
        return n;
    }

    private void create51Structure(LDAPConnection lDAPConnection) throws LDAPException {
        block9: {
            block8: {
                if (this.verbose) {
                    this.fireTaskStatusChanged("Creating new system root ou=system,ou=dar-config,o=netscaperoot ...");
                }
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.add(new LDAPAttribute("ou", "system"));
                lDAPAttributeSet.add(new LDAPAttribute("objectclass", new String[]{"top", "ids-proxy-top", "organizationalunit"}));
                LDAPEntry lDAPEntry = new LDAPEntry(NEW_SYSTEM_ROOT, lDAPAttributeSet);
                try {
                    lDAPConnection.add(lDAPEntry);
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() != 68) {
                        throw lDAPException;
                    }
                    if (!this.verbose) break block8;
                    this.fireTaskStatusChanged("System root already exists");
                }
            }
            if (this.verbose) {
                this.fireTaskStatusChanged("Creating new log property root ou=properties,ou=system,ou=dar-config,o=netscaperoot ...");
            }
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute("ou", "log"));
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", new String[]{"top", "ids-proxy-top", "organizationalunit"}));
            LDAPEntry lDAPEntry = new LDAPEntry(NEW_LOG_ROOT, lDAPAttributeSet);
            try {
                lDAPConnection.add(lDAPEntry);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 68) {
                    throw lDAPException;
                }
                if (!this.verbose) break block9;
                this.fireTaskStatusChanged("Log root already exists");
            }
        }
    }

    private int migrateConfiguration(LDAPConnection lDAPConnection, LDAPEntry lDAPEntry) throws LDAPException {
        LDAPEntry lDAPEntry2;
        String[] stringArray;
        LDAPSearchResults lDAPSearchResults;
        Object object;
        int n = 0;
        if (this.verbose) {
            this.fireTaskStatusChanged("Migrating configuration " + lDAPEntry.getDN());
        }
        String[] stringArray2 = LDAPDN.explodeDN((String)lDAPEntry.getDN(), (boolean)true);
        String string = stringArray2[0];
        LDAPSearchResults lDAPSearchResults2 = lDAPConnection.search("ou=properties," + lDAPEntry.getDN(), 1, "objectclass=ids-proxy-sch-logproperty", null, false);
        while (lDAPSearchResults2.hasMoreElements()) {
            object = lDAPSearchResults2.next();
            lDAPSearchResults = this.move(object.getDN(), "-" + string, NEW_LOG_ROOT, lDAPConnection, true, this.verbose);
            if (lDAPSearchResults != null) {
                stringArray = LDAPDN.explodeDN((String)object.getDN(), (boolean)true);
                lDAPEntry2 = LDAPDN.explodeDN((String)lDAPSearchResults.getDN(), (boolean)true);
                this.updateSystems(lDAPConnection, lDAPEntry.getDN(), stringArray[0], (String)lDAPEntry2[0]);
                continue;
            }
            n = -1;
        }
        object = "ou=global," + lDAPEntry.getDN();
        lDAPSearchResults = lDAPConnection.search((String)object, 1, "objectclass=ids-proxy-sch-globalconfiguration", null, false);
        while (lDAPSearchResults.hasMoreElements()) {
            stringArray = lDAPSearchResults.next();
            lDAPEntry2 = this.move(stringArray.getDN(), "-" + string, NEW_SYSTEM_ROOT, lDAPConnection, true, this.verbose);
            if (lDAPEntry2 != null) {
                this.updateIdars(lDAPConnection, stringArray.getDN(), lDAPEntry2.getDN());
                continue;
            }
            n = -1;
        }
        return n;
    }

    private void updateSystems(LDAPConnection lDAPConnection, String string, String string2, String string3) throws LDAPException {
        if (string2 != null && string3 != null) {
            String string4 = "(&(objectclass=ids-proxy-sch-globalconfiguration)(ids-proxy-con-include-logproperty=" + string2 + "))";
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search("ou=global," + string, 1, string4, null, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                if (this.verbose) {
                    this.fireTaskStatusChanged("  Updating system " + lDAPEntry.getDN() + " log property from " + string2 + " to " + string3);
                }
                LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                LDAPAttribute lDAPAttribute = new LDAPAttribute("ids-proxy-con-include-logproperty", string2);
                LDAPAttribute lDAPAttribute2 = new LDAPAttribute("ids-proxy-con-include-logproperty", string3);
                LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                lDAPModificationSet.add(1, lDAPAttribute);
                lDAPModificationSet.add(0, lDAPAttribute2);
                lDAPConnection.modify(lDAPEntry.getDN(), lDAPModificationSet);
            }
        }
    }

    private void updateIdars(LDAPConnection lDAPConnection, String string, String string2) throws LDAPException {
        if (string != null && string2 != null) {
            String string3 = "(&(objectclass=ids-proxy-sch-ldapproxy)(ids-proxy-sch-global-config-dn=" + string + "))";
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search("o=netscaperoot", 2, string3, null, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                if (this.verbose) {
                    this.fireTaskStatusChanged("  Updating idar " + lDAPEntry.getDN() + " system pointer");
                }
                LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                LDAPAttribute lDAPAttribute = new LDAPAttribute("ids-proxy-sch-global-config-dn", string);
                LDAPAttribute lDAPAttribute2 = new LDAPAttribute("ids-proxy-sch-global-config-dn", string2);
                LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                lDAPModificationSet.add(1, lDAPAttribute);
                lDAPModificationSet.add(0, lDAPAttribute2);
                lDAPConnection.modify(lDAPEntry.getDN(), lDAPModificationSet);
            }
        }
    }

    private LDAPEntry move(String string, String string2, String string3, LDAPConnection lDAPConnection, boolean bl, boolean bl2) throws LDAPException {
        LDAPEntry lDAPEntry = lDAPConnection.read(string);
        String[] stringArray = LDAPDN.explodeDN((String)lDAPEntry.getDN(), (boolean)false);
        RDN rDN = null;
        rDN = string2 == null ? new RDN(stringArray[0]) : new RDN(stringArray[0] + string2);
        String string4 = rDN.toString() + "," + string3;
        RDN rDN2 = new RDN(stringArray[0]);
        String[] stringArray2 = rDN2.getTypes();
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute(stringArray2[0]);
        lDAPAttribute.removeValue(lDAPAttribute.getStringValueArray()[0]);
        lDAPAttribute.addValue(rDN.getValues()[0]);
        LDAPEntry lDAPEntry2 = new LDAPEntry(string4, lDAPEntry.getAttributeSet());
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setBatchSize(0);
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, "objectclass=*", ATTRS, false, lDAPSearchConstraints);
        if (bl2) {
            this.fireTaskStatusChanged("  Copying DN:" + string + " to -> " + string4);
        }
        if (!lDAPSearchResults.hasMoreElements()) {
            if (bl) {
                lDAPConnection.delete(string);
                try {
                    lDAPConnection.add(lDAPEntry2);
                }
                catch (LDAPException lDAPException) {
                    if (bl2) {
                        this.fireTaskStatusChanged("  Could not add new entry, restoring old one because " + lDAPException.errorCodeToString());
                    }
                    lDAPConnection.add(lDAPEntry);
                    lDAPEntry2 = null;
                }
            }
        } else {
            if (bl) {
                lDAPConnection.add(lDAPEntry2);
            }
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPUrl[] lDAPUrlArray;
                try {
                    LDAPEntry lDAPEntry3 = lDAPSearchResults.next();
                    lDAPUrlArray = lDAPEntry3.getDN();
                    this.move((String)lDAPUrlArray, string2, string4, lDAPConnection, bl, bl2);
                }
                catch (LDAPReferralException lDAPReferralException) {
                    if (bl2) {
                        this.fireTaskStatusChanged("  Search reference: ");
                    }
                    lDAPUrlArray = lDAPReferralException.getURLs();
                    for (int i = 0; i < lDAPUrlArray.length; ++i) {
                        if (!bl2) continue;
                        this.fireTaskStatusChanged("  " + lDAPUrlArray[i].getUrl());
                    }
                }
            }
        }
        return lDAPEntry2;
    }

    private void setExecutableness() {
        this.setExecutable(true);
    }

    public static void main(String[] stringArray) {
        TaskManagerFactory.setContextIndicator(1);
        Migrate50To51Task migrate50To51Task = Migrate50To51Task.createTask(stringArray);
        if (migrate50To51Task != null) {
            if (migrate50To51Task.isExecutable()) {
                migrate50To51Task.execute();
            } else {
                System.err.println(migrate50To51Task.getUnexecutableMessage());
            }
        }
    }

    private static Migrate50To51Task createTask(String[] stringArray) {
        String string = null;
        int n = 389;
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        Migrate50To51Task migrate50To51Task = null;
        boolean bl2 = true;
        String string4 = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            String string5 = stringArray[i];
            if (!string5.startsWith("-")) {
                bl2 = false;
                Migrate50To51Task.usage();
                break;
            }
            String string6 = null;
            if (i < stringArray.length - 1) {
                string6 = stringArray[i + 1];
            }
            if (string5.trim().equals("-h")) {
                string = string6;
                continue;
            }
            if (string5.trim().equals("-p")) {
                try {
                    n = Integer.parseInt(string6);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("ERROR:  illegal port " + string6);
                    return null;
                }
            }
            if (string5.trim().equals("-D")) {
                string2 = string6;
                continue;
            }
            if (string5.trim().equals("-w")) {
                string3 = string6;
                continue;
            }
            if (string5.trim().equals("-v")) {
                bl = true;
                --i;
                continue;
            }
            if (string5.trim().equals("-C")) {
                string4 = string6;
                continue;
            }
            Migrate50To51Task.usage();
            return null;
        }
        migrate50To51Task = new Migrate50To51Task(string, n, string2, string3, string4, bl);
        return migrate50To51Task;
    }

    private static void usage() {
        System.err.println("usage:  Migrate50To51Task <options>");
        System.err.println("options:");
        System.err.println("        -C     name of configuration to migrate (all if unspecified)");
        System.err.println("        -h     directory host name (localhost if unspecified)");
        System.err.println("        -p     directory port number (389 if unspecified)");
        System.err.println("        -D     directory user dn (anonymous bind if unspecified)");
        System.err.println("        -w     directory user password (anonymous bind if unspecified)");
        System.err.println("        -v");
    }
}

