/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.task;

import com.iplanet.idar.task.AbstractTask;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFRecord;

public class ImportConfigurationLdif
extends AbstractTask {
    public static final int DEFAULT_LDAP_PORT = 389;
    public static final String NETSCAPE_ROOT = "netscaperoot";
    public static final String OBJECTCLASS = "objectclass";
    public static final String ORGANIZATIONAL_UNIT = "organizationalunit";
    public static final String TOP = "top";
    public static final String IDS_PROXY_TOP = "ids-proxy-top";
    public static final String NSDARCONFIGURATION = "nsdarconfiguration";
    public static final String BELONGS_TO = "ids-proxy-sch-belongs-to";
    public static final String LDAP_PROXY = "ids-proxy-sch-ldapproxy";
    public static final String GLOBAL = "ids-proxy-sch-globalconfiguration";
    public static final String GROUP = "ids-proxy-sch-group";
    public static final String RULE = "ids-proxy-sch-rule";
    public static final String ON_SSL = "ids-proxy-sch-onsslestablishedrule";
    public static final String ON_BIND = "ids-proxy-sch-onbindsuccessrule";
    public static final String ACTION = "ids-proxy-sch-action";
    public static final String CHANGE_GROUP = "ids-proxy-sch-changegroupaction";
    public static final String PROPERTY = "ids-proxy-sch-property";
    public static final String RENAME_ATTRIBUTE = "ids-proxy-sch-renameattributeproperty";
    public static final String FORBIDDEN_ENTRY = "ids-proxy-sch-forbiddenentryproperty";
    public static final String LDAP_SERVER = "ids-proxy-sch-ldapserver";
    public static final String LOAD_BALANCE = "ids-proxy-sch-loadbalanceproperty";
    public static final String LOG = "ids-proxy-sch-logproperty";
    public static final String SIZE_LIMIT = "ids-proxy-sch-sizelimitproperty";
    public static final String NETWORK_GROUP = "ids-proxy-sch-networkgroup";
    public static final String O = "o";
    public static final String OU = "ou";
    public static final String CN = "cn";
    public static final String DAR_CONFIG = "dar-config";
    public static final int CONFIG_INDEX = 0;
    public static final int ACTIONS_INDEX = 1;
    public static final int GLOBAL_INDEX = 2;
    public static final int GROUPS_INDEX = 3;
    public static final int PROPERTIES_INDEX = 4;
    public static final int RULES_INDEX = 5;
    public static final int LOGS_INDEX = 6;
    public static final String CONFIGURATION_TOP_DN = "ou=dar-config,o=netscaperoot";
    String configurationName = "imported-configuration";
    LDIF ldif = null;
    LDAPConnection ldc = null;
    String host = null;
    int port = 389;
    String user = null;
    String password = null;
    Throwable error = null;
    boolean verbose = false;
    int numberImported = 0;
    boolean configExists = false;

    ImportConfigurationLdif(String string, String string2) throws IOException {
        this(string, string2, null, null, null, null);
    }

    ImportConfigurationLdif(String string, String string2, String string3, Integer n, String string4, String string5) throws IOException {
        this(string, string2, string3, n, string4, string5, false);
    }

    ImportConfigurationLdif(String string, String string2, String string3, Integer n, String string4, String string5, boolean bl) throws IOException {
        this.setConfigurationName(string);
        this.setLdifFileName(string2);
        this.setHost(string3);
        this.setPort(n);
        this.setUser(string4);
        this.setPassword(string5);
        this.verbose = bl;
        this.setExecutableness();
    }

    public String getName() {
        return "Import Configuration";
    }

    public String getDescription() {
        return "Import an LDIF file into the Configuration Directory";
    }

    public void setConfigurationName(String string) {
        if (string != null) {
            this.configurationName = string;
        }
    }

    public void setLdifFileName(String string) throws IOException {
        this.ldif = new LDIF(string);
    }

    public void setHost(String string) {
        if (string != null) {
            this.host = string;
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                this.host = "";
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(Integer n) {
        this.port = n != null ? n : 389;
    }

    public int getPort() {
        return this.port;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public int getNumberOfEntriesImported() {
        return this.numberImported;
    }

    public int doExecute() {
        int n = -2;
        if (this.ldif != null) {
            this.ldc = new LDAPConnection();
            try {
                if (this.user == null || this.password == null) {
                    this.ldc.connect(this.host, this.port);
                } else {
                    this.ldc.connect(this.host, this.port, this.user, this.password);
                }
                LDAPEntry lDAPEntry = this.findOrCreateConfigurationTop(this.ldc);
                if (lDAPEntry != null) {
                    LDAPEntry[] lDAPEntryArray = this.createConfiguration(this.ldc, lDAPEntry, this.configurationName);
                    this.numberImported = this.addEntries(this.ldc, lDAPEntryArray, this.ldif);
                    n = 0;
                }
            }
            catch (LDAPException lDAPException) {
                this.error = lDAPException;
                System.err.println("LDAP ERROR MESSAGE: " + lDAPException.getLDAPResultCode());
                n = -1;
            }
        }
        return n;
    }

    public Throwable getError() {
        return this.error;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ImportConfigurationLdif { config=");
        stringBuffer.append(this.configurationName);
        stringBuffer.append(", ldif=");
        stringBuffer.append(this.ldif);
        stringBuffer.append(", host=");
        stringBuffer.append(this.host);
        stringBuffer.append(", port=");
        stringBuffer.append(this.port);
        stringBuffer.append(", user=");
        stringBuffer.append(this.user);
        stringBuffer.append(", password=");
        stringBuffer.append(this.password);
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    private LDAPEntry findOrCreateConfigurationTop(LDAPConnection lDAPConnection) throws LDAPException {
        LDAPSearchResults lDAPSearchResults;
        LDAPEntry lDAPEntry = null;
        DN dN = new DN(CONFIGURATION_TOP_DN);
        boolean bl = false;
        try {
            lDAPSearchResults = lDAPConnection.search(CONFIGURATION_TOP_DN, 0, "objectclass=*", null, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry2 = lDAPSearchResults.next();
                DN dN2 = new DN(lDAPEntry2.getDN());
                if (!dN.equals(dN2)) continue;
                lDAPEntry = lDAPEntry2;
                break;
            }
            if (lDAPEntry == null) {
                bl = true;
            }
        }
        catch (LDAPException lDAPException) {
            bl = true;
        }
        if (bl) {
            try {
                lDAPSearchResults = new LDAPAttributeSet();
                lDAPSearchResults.add(new LDAPAttribute(OBJECTCLASS, IDS_PROXY_TOP));
                lDAPSearchResults.add(new LDAPAttribute(OBJECTCLASS, ORGANIZATIONAL_UNIT));
                lDAPSearchResults.add(new LDAPAttribute(OBJECTCLASS, TOP));
                lDAPEntry = new LDAPEntry(CONFIGURATION_TOP_DN, (LDAPAttributeSet)lDAPSearchResults);
                lDAPConnection.add(lDAPEntry);
            }
            catch (LDAPException lDAPException) {
                System.err.println("ERROR: Could not find/add " + dN.toString());
                throw lDAPException;
            }
        }
        return lDAPEntry;
    }

    private LDAPEntry[] createConfiguration(LDAPConnection lDAPConnection, LDAPEntry lDAPEntry, String string) throws LDAPException {
        LDAPEntry[] lDAPEntryArray = new LDAPEntry[7];
        if (lDAPConnection != null && lDAPEntry != null && string != null) {
            DN dN = new DN("cn=" + string + "," + lDAPEntry.getDN());
            LDAPAttributeSet lDAPAttributeSet = null;
            try {
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(dN.toString(), 0, "objectclass=*", null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry2 = lDAPSearchResults.next();
                    DN dN2 = new DN(lDAPEntry2.getDN());
                    if (!dN.equals(dN2)) continue;
                    lDAPEntryArray[0] = lDAPEntry2;
                    this.configExists = true;
                    break;
                }
            }
            catch (LDAPException lDAPException) {
                lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.add(new LDAPAttribute(OBJECTCLASS, NSDARCONFIGURATION));
                lDAPAttributeSet.add(new LDAPAttribute(OBJECTCLASS, TOP));
                lDAPEntryArray[0] = new LDAPEntry(dN.toString(), lDAPAttributeSet);
                lDAPConnection.add(lDAPEntryArray[0]);
            }
            if (lDAPEntryArray[0] != null) {
                lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.add(new LDAPAttribute(OBJECTCLASS, IDS_PROXY_TOP));
                lDAPAttributeSet.add(new LDAPAttribute(OBJECTCLASS, ORGANIZATIONAL_UNIT));
                lDAPAttributeSet.add(new LDAPAttribute(OBJECTCLASS, TOP));
                lDAPEntryArray[1] = this.findOrCreateEntry(lDAPConnection, new DN("ou=actions," + lDAPEntryArray[0].getDN()), lDAPAttributeSet);
                lDAPEntryArray[3] = this.findOrCreateEntry(lDAPConnection, new DN("ou=groups," + lDAPEntryArray[0].getDN()), lDAPAttributeSet);
                lDAPEntryArray[4] = this.findOrCreateEntry(lDAPConnection, new DN("ou=properties," + lDAPEntryArray[0].getDN()), lDAPAttributeSet);
                lDAPEntryArray[5] = this.findOrCreateEntry(lDAPConnection, new DN("ou=rules," + lDAPEntryArray[0].getDN()), lDAPAttributeSet);
            }
            if (this.configExists) {
                System.err.println("Configuration name, " + string + ", already exists.");
            }
            lDAPEntryArray[2] = this.findOrCreateEntry(lDAPConnection, new DN("ou=system,ou=dar-config,o=netscaperoot"), lDAPAttributeSet);
            lDAPEntryArray[6] = this.findOrCreateEntry(lDAPConnection, new DN("ou=properties, ou=system,ou=dar-config,o=netscaperoot"), lDAPAttributeSet);
        }
        return lDAPEntryArray;
    }

    private LDAPEntry findOrCreateEntry(LDAPConnection lDAPConnection, DN dN, LDAPAttributeSet lDAPAttributeSet) throws LDAPException {
        LDAPEntry lDAPEntry = null;
        if (dN != null && lDAPAttributeSet != null) {
            try {
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(dN.toString(), 0, "objectclass=*", null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry2 = lDAPSearchResults.next();
                    DN dN2 = new DN(lDAPEntry2.getDN());
                    if (!dN2.equals(dN)) continue;
                    lDAPEntry = lDAPEntry2;
                    break;
                }
            }
            catch (LDAPException lDAPException) {
                lDAPEntry = new LDAPEntry(dN.toString(), lDAPAttributeSet);
                lDAPConnection.add(lDAPEntry);
            }
        }
        return lDAPEntry;
    }

    private int addEntries(LDAPConnection lDAPConnection, LDAPEntry[] lDAPEntryArray, LDIF lDIF) {
        int n = 0;
        if (lDAPEntryArray != null) {
            try {
                LDIFRecord lDIFRecord = lDIF.nextRecord();
                while (lDIFRecord != null) {
                    if (0 == lDIFRecord.getContent().getType()) {
                        LDIFAttributeContent lDIFAttributeContent = (LDIFAttributeContent)lDIFRecord.getContent();
                        LDAPAttribute[] lDAPAttributeArray = lDIFAttributeContent.getAttributes();
                        for (int i = 0; i < lDAPAttributeArray.length; ++i) {
                            if (!OBJECTCLASS.equalsIgnoreCase(lDAPAttributeArray[i].getName())) continue;
                            String[] stringArray = lDAPAttributeArray[i].getStringValueArray();
                            String string = null;
                            LDAPEntry lDAPEntry = null;
                            Vector<String> vector = new Vector<String>();
                            for (int j = 0; j < stringArray.length; ++j) {
                                if (!this.configExists) {
                                    if (ACTION.equalsIgnoreCase(stringArray[j]) || CHANGE_GROUP.equalsIgnoreCase(stringArray[j])) {
                                        lDAPEntry = lDAPEntryArray[1];
                                        string = "ids-proxy-con-name";
                                    } else if (GROUP.equalsIgnoreCase(stringArray[j]) || NETWORK_GROUP.equalsIgnoreCase(stringArray[j])) {
                                        lDAPEntry = lDAPEntryArray[3];
                                        string = "ids-proxy-con-name";
                                    } else if (RULE.equalsIgnoreCase(stringArray[j]) || ON_SSL.equalsIgnoreCase(stringArray[j]) || ON_BIND.equalsIgnoreCase(stringArray[j])) {
                                        lDAPEntry = lDAPEntryArray[5];
                                        string = "ids-proxy-con-name";
                                    } else if (RENAME_ATTRIBUTE.equalsIgnoreCase(stringArray[j]) || FORBIDDEN_ENTRY.equalsIgnoreCase(stringArray[j]) || LDAP_SERVER.equalsIgnoreCase(stringArray[j]) || LOAD_BALANCE.equalsIgnoreCase(stringArray[j]) || SIZE_LIMIT.equalsIgnoreCase(stringArray[j])) {
                                        lDAPEntry = lDAPEntryArray[4];
                                        string = "ids-proxy-con-name";
                                    }
                                }
                                if (GLOBAL.equalsIgnoreCase(stringArray[j])) {
                                    lDAPEntry = lDAPEntryArray[2];
                                    string = "ids-proxy-con-config-name";
                                } else if (LOG.equalsIgnoreCase(stringArray[j])) {
                                    lDAPEntry = lDAPEntryArray[6];
                                    string = "ids-proxy-con-name";
                                }
                                vector.add(stringArray[j].toLowerCase());
                            }
                            if (lDAPEntry == null || string == null) break;
                            Object[] objectArray = new String[vector.size()];
                            vector.copyInto(objectArray);
                            lDAPAttributeArray[i] = new LDAPAttribute(OBJECTCLASS, (String[])objectArray);
                            String string2 = null;
                            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                            for (int j = 0; j < lDAPAttributeArray.length; ++j) {
                                String string3;
                                if (string.equalsIgnoreCase(lDAPAttributeArray[j].getName())) {
                                    string2 = lDAPAttributeArray[j].getStringValueArray()[0];
                                }
                                if ((string3 = lDAPAttributeArray[j].getName()).equalsIgnoreCase("dn") || string3.equalsIgnoreCase(BELONGS_TO)) continue;
                                lDAPAttributeSet.add(lDAPAttributeArray[j]);
                            }
                            LDAPEntry lDAPEntry2 = new LDAPEntry(string + "=" + string2 + "," + lDAPEntry.getDN(), lDAPAttributeSet);
                            try {
                                if (this.verbose) {
                                    this.fireTaskStatusChanged("Trying to add " + lDAPEntry2.getDN() + "...");
                                }
                                lDAPConnection.add(lDAPEntry2);
                                if (this.verbose) {
                                    this.fireTaskStatusChanged("Success");
                                }
                                ++n;
                            }
                            catch (LDAPException lDAPException) {
                                if (lDAPException.getLDAPResultCode() == 68) {
                                    System.err.println("Add failed because object already exists: " + lDAPEntry2.getDN());
                                    break;
                                }
                                System.err.println((Object)lDAPException);
                            }
                            break;
                        }
                    }
                    lDIFRecord = lDIF.nextRecord();
                }
            }
            catch (IOException iOException) {
                System.err.println("ERROR: " + iOException.toString());
            }
        }
        return n;
    }

    private void setExecutableness() {
        this.setExecutable(true);
    }

    public static void main(String[] stringArray) {
        ImportConfigurationLdif importConfigurationLdif = ImportConfigurationLdif.createTask(stringArray);
        if (importConfigurationLdif != null && importConfigurationLdif.isExecutable()) {
            importConfigurationLdif.executeAndWait();
            if (importConfigurationLdif.getExecutionStatus() == 0) {
                System.out.println("done");
                System.out.println(importConfigurationLdif.getNumberOfEntriesImported() + " object(s) imported");
                System.out.println("NOTE:  It will be necessary to restart the console in order to view the new configuration in the topology view.");
            }
        } else {
            System.err.println("ERROR:  could not perform import");
        }
    }

    private static ImportConfigurationLdif createTask(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        Integer n = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        ImportConfigurationLdif importConfigurationLdif = null;
        boolean bl2 = true;
        if (stringArray.length == 0) {
            bl2 = false;
            ImportConfigurationLdif.usage();
        } else {
            int n2;
            for (n2 = 0; n2 < stringArray.length - 1; n2 += 2) {
                String string6 = stringArray[n2];
                if (!string6.startsWith("-")) {
                    bl2 = false;
                    ImportConfigurationLdif.usage();
                    break;
                }
                String string7 = null;
                if (n2 < stringArray.length - 1) {
                    string7 = stringArray[n2 + 1];
                }
                if (string6.trim().equals("-C")) {
                    string = string7;
                    continue;
                }
                if (string6.trim().equals("-h")) {
                    string3 = string7;
                    continue;
                }
                if (string6.trim().equals("-p")) {
                    try {
                        n = new Integer(string7);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("ERROR:  illegal port " + string7);
                        return null;
                    }
                }
                if (string6.trim().equals("-D")) {
                    string4 = string7;
                    continue;
                }
                if (string6.trim().equals("-w")) {
                    string5 = string7;
                    continue;
                }
                if (string6.trim().equals("-v")) {
                    bl = true;
                    --n2;
                    continue;
                }
                ImportConfigurationLdif.usage();
                return null;
            }
            string2 = stringArray[n2];
        }
        boolean bl3 = bl2 = bl2 && string2 != null;
        if (bl2) {
            try {
                importConfigurationLdif = new ImportConfigurationLdif(string, string2, string3, n, string4, string5, bl);
            }
            catch (IOException iOException) {
                System.err.println("ERROR:  input/output error opening ldif file " + string2);
            }
        }
        return importConfigurationLdif;
    }

    private static void usage() {
        System.err.println("usage:  dpsldif2config <options> ldif");
        System.err.println("where:");
        System.err.println("        ldif   name of ldif file containing DPS objects");
        System.err.println("options:");
        System.err.println("        -C     name of configuration to create");
        System.err.println("               ('imported-configuration' if unspecified");
        System.err.println("        -h     directory host name (localhost if unspecified)");
        System.err.println("        -p     directory port number (389 if unspecified)");
        System.err.println("        -D     directory user dn (anonymous bind if unspecified)");
        System.err.println("        -w     directory user password (anonymous bind if unspecified)");
        System.err.println("        -v     verbose");
    }
}

