/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.objectmodel.BeanEvent;
import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanReferenceMonitor;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.HttpCommand;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.BeanAlreadyExistsException;
import com.iplanet.idar.objectmodel.bean.CreationException;
import com.iplanet.idar.objectmodel.bean.DeletionException;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARConfigurationModelBean;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.IllegalPropertyException;
import com.iplanet.idar.objectmodel.bean.LogPropertyBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.objectmodel.bean.UnknownBeanTypeException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.Vector;

public class SystemBean
extends IDARConfigurationModelBean
implements IDARConstants {
    private static final String PREDELETE_MESSAGE = IDARResourceSet.getString("error", "SYSTEM_DELETE");
    private static final String SYSLOG_ON_WINDOWS = IDARResourceSet.getString("error", "SYSTEM_SYSLOG_ON_WINDOWS");
    private SystemBeanReferenceMonitor logMonitor = new SystemBeanReferenceMonitor(this);
    private Integer port;
    private String host;
    private Integer maximumConnections;
    private Integer listenBacklog;
    private Integer ldapsPort;
    private String userId;
    private String workingDirectory;
    private Boolean sendCertificateAsClientEnabled;
    private String serverSslVersion;
    private String clientSslVersion;
    private Boolean sslCertificateRequired;
    private Boolean connectionPoolEnabled;
    private Integer connectionPoolInterval;
    private Integer connectionPoolTimeout;
    private Boolean debugInForeground;
    String illegalityMessage;
    IDARReference logRef = null;

    protected static String getIdPrefix() {
        return "system";
    }

    public String getLocalizableDescriptor() {
        return IDARResourceSet.getString("configType", "SYSTEM_DESCRIPTOR");
    }

    public boolean isLegal() {
        Debug.println((String)"SystemBean.isLegal");
        this.illegalityMessage = null;
        boolean bl = true;
        LogPropertyBean logPropertyBean = this.getLogPropertyBean();
        if (logPropertyBean != null && logPropertyBean.isSyslogging()) {
            Object object;
            IDARReference[] iDARReferenceArray = this.getSubscribers();
            Vector<IDARReference> vector = new Vector<IDARReference>();
            for (int i = 0; i < iDARReferenceArray.length; ++i) {
                try {
                    object = (IDARBean)iDARReferenceArray[i].getBean();
                    if (((IDARBean)object).getOS() != 0) continue;
                    bl = false;
                    vector.add(iDARReferenceArray[i]);
                    continue;
                }
                catch (IDARBeanException iDARBeanException) {
                    Debug.println((String)"SystemBean.isLegal:  ERROR - bean could not be de-referenced");
                }
            }
            Object[] objectArray = new IDARReference[vector.size()];
            vector.copyInto(objectArray);
            if (objectArray != null && objectArray.length > 0) {
                object = new StringBuffer(SYSLOG_ON_WINDOWS);
                ((StringBuffer)object).append('\n');
                for (int i = 0; i < objectArray.length && i < 5; ++i) {
                    ((StringBuffer)object).append("  ");
                    ((StringBuffer)object).append(((IDARReference)objectArray[i]).getId());
                    if (i == 4 && objectArray.length > 5) {
                        ((StringBuffer)object).append("\n  " + AND_OTHERS);
                    }
                    ((StringBuffer)object).append('\n');
                }
                this.illegalityMessage = ((StringBuffer)object).toString();
            }
        }
        return bl;
    }

    public String getIllegalityExplanationMessage() {
        this.isLegal();
        return this.illegalityMessage;
    }

    public boolean isQuestionable() {
        return false;
    }

    public String getQuestionableExplanationMessage() {
        return null;
    }

    public boolean isDeletable() {
        boolean bl = true;
        IDARReference[] iDARReferenceArray = this.getSubscribers();
        if (iDARReferenceArray.length > 0) {
            bl = false;
        }
        return bl;
    }

    public String getPredeletionMessage() {
        Debug.println((String)"SystemBean.getPredeletionMessage");
        String string = null;
        IDARReference[] iDARReferenceArray = this.getSubscribers();
        if (iDARReferenceArray != null && iDARReferenceArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(PREDELETE_MESSAGE);
            stringBuffer.append('\n');
            for (int i = 0; i < iDARReferenceArray.length && i < 5; ++i) {
                stringBuffer.append("    ");
                stringBuffer.append(iDARReferenceArray[i].getId());
                if (i == 4 && iDARReferenceArray.length > 5) {
                    stringBuffer.append("\n  " + AND_OTHERS);
                }
                stringBuffer.append('\n');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public IDARReference[] getSubscribers() {
        Object[] objectArray;
        Debug.println((String)"SystemBean.getSubscribers");
        Vector<IDARReference> vector = new Vector<IDARReference>();
        try {
            objectArray = BeanSpace.getInstance().retrieveBeanCollection(IDARReference.NULL_REFERENCE, "idar-server");
            Vector vector2 = objectArray.toBeanVector();
            String string = this.getId();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                IDARBean iDARBean = (IDARBean)enumeration.nextElement();
                if (!string.equals(iDARBean.getSystemConfigurationName())) continue;
                vector.add(iDARBean.getSelfReference());
            }
        }
        catch (IDARBeanException iDARBeanException) {
            Debug.println((String)"SystemBean.getSubscribers: WARNING: could not get bean collection");
        }
        objectArray = new IDARReference[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getDescriptor() {
        return SystemBean.getIdPrefix();
    }

    public String getIdField() {
        return "ids-proxy-con-config-name";
    }

    public String getConfigurationName() {
        return this.getId();
    }

    public void setConfigurationName(String string) throws UniqueNameException {
        this.setId(string);
    }

    public Integer getPort() {
        return this.returnIntegerOrDefaultIfNull(this.port, new Integer(389));
    }

    public void setPort(int n) {
        this.setPort(new Integer(n));
    }

    public void setPort(Integer n) {
        if (!this.getPort().equals(n)) {
            this.port = n != null && n != 389 ? n : null;
            this.setDirty(true);
        }
    }

    public String getHost() {
        return this.returnStringOrDefaultIfNull(this.host, new String("localhost"));
    }

    public void setHost(String string) {
        if (!this.getHost().equalsIgnoreCase(string)) {
            this.host = string != null && !string.equals("localhost") && !string.trim().equals("") ? string : null;
            this.setDirty(true);
        }
    }

    public Integer getMaximumConnections() {
        return this.returnIntegerOrDefaultIfNull(this.maximumConnections, null);
    }

    public void setMaximumConnections(int n) {
        this.setMaximumConnections(new Integer(n));
    }

    public void setMaximumConnections(Integer n) {
        Integer n2 = this.getMaximumConnections();
        if (n != null && !n.equals(n2) || n == null && n2 != null) {
            this.maximumConnections = n == null ? null : n;
        }
        this.setDirty(true);
    }

    public Integer getListenBacklog() {
        return this.returnIntegerOrDefaultIfNull(this.listenBacklog, new Integer(128));
    }

    public void setListenBacklog(int n) {
        this.setListenBacklog(new Integer(n));
    }

    public void setListenBacklog(Integer n) {
        if (!this.getListenBacklog().equals(n)) {
            this.listenBacklog = n == null || n == 128 ? null : n;
            this.setDirty(true);
        }
    }

    public Integer getLdapsPort() {
        return this.returnIntegerOrDefaultIfNull(this.ldapsPort, null);
    }

    public void setLdapsPort(int n) {
        this.setLdapsPort(new Integer(n));
    }

    public void setLdapsPort(Integer n) {
        Integer n2 = this.getLdapsPort();
        if (n != null && !n.equals(n2) || n == null && n2 != null) {
            this.ldapsPort = n == null ? null : n;
            this.setDirty(true);
        }
    }

    public String getUserId() {
        return this.returnStringOrDefaultIfNull(this.userId, new String("nobody"));
    }

    public void setUserId(String string) {
        if (!this.getUserId().equalsIgnoreCase(string)) {
            this.userId = string == null || string.equals("nobody") || string.trim().equals("") ? null : string;
            this.setDirty(true);
        }
    }

    public String getWorkingDirectory() {
        return this.returnStringOrDefaultIfNull(this.workingDirectory, new String("/tmp"));
    }

    public void setWorkingDirectory(String string) {
        if (!this.getWorkingDirectory().equals(string)) {
            this.workingDirectory = string == null || string.equals("/tmp") || string.trim().equals("") ? null : string;
            this.setDirty(true);
        }
    }

    public String getLogPropertyId() {
        String string = null;
        if (this.logRef != null) {
            string = this.logRef.getId();
        }
        return string;
    }

    public IDARReference getLogProperty() {
        return this.logRef;
    }

    public LogPropertyBean getLogPropertyBean() {
        LogPropertyBean logPropertyBean = null;
        try {
            BeanSpace beanSpace = BeanSpace.getInstance();
            logPropertyBean = (LogPropertyBean)beanSpace.retrieveBean(this.getLogPropertyId(), "log", this.getParentConfiguration());
        }
        catch (RetrievalException retrievalException) {
        }
        catch (UnknownBeanTypeException unknownBeanTypeException) {
        }
        catch (NoSuchBeanException noSuchBeanException) {
            // empty catch block
        }
        return logPropertyBean;
    }

    private void setLogPropertyId(String string) {
        if (string == null) {
            this.setLogProperty(null);
        } else {
            try {
                IDARReference iDARReference = BeanSpace.getInstance().getBeanReference(string, "log", this.getParentConfiguration());
                this.setLogProperty(iDARReference);
            }
            catch (IDARBeanException iDARBeanException) {
                iDARBeanException.printStackTrace();
            }
        }
    }

    public void setLogProperty(IDARReference iDARReference) {
        if (iDARReference != null && !iDARReference.equals(this.logRef) || iDARReference == null && this.logRef != null) {
            this.logMonitor.removeAllMonitors();
            String string = this.getId();
            this.logRef = iDARReference;
            if (iDARReference != null) {
                this.logMonitor.addMonitor(iDARReference);
                this.firePropertyChange(new PropertyChangeEvent("SystemBean", "ids-proxy-con-include-logproperty", string, iDARReference.getId()));
            }
            this.setDirty(true);
        }
    }

    public Boolean isSendCertificateAsClientEnabled() {
        return this.returnBooleanOrDefaultIfNull(this.sendCertificateAsClientEnabled, new Boolean(false));
    }

    public void setSendCertificateAsClientEnabled(boolean bl) {
        this.setSendCertificateAsClientEnabled(new Boolean(bl));
    }

    public void setSendCertificateAsClientEnabled(Boolean bl) {
        if (!this.isSendCertificateAsClientEnabled().equals(bl)) {
            this.sendCertificateAsClientEnabled = bl == null || bl == false ? null : bl;
            this.setDirty(true);
        }
    }

    public String getServerSslVersion() {
        return this.returnStringOrDefaultIfNull(this.serverSslVersion, new String("7"));
    }

    public void setServerSslVersion(String string) {
        if (!this.getServerSslVersion().equals(string)) {
            this.serverSslVersion = string == null || string.equals("7") ? null : string;
            this.setDirty(true);
        }
    }

    public String getClientSslVersion() {
        return this.returnStringOrDefaultIfNull(this.clientSslVersion, new String("7"));
    }

    public void setClientSslVersion(String string) {
        if (!this.getClientSslVersion().equals(string)) {
            this.clientSslVersion = string == null || string.equals("7") ? null : string;
            this.setDirty(true);
        }
    }

    public Boolean isSslCertificateRequired() {
        return this.returnBooleanOrDefaultIfNull(this.sslCertificateRequired, new Boolean(false));
    }

    public void setSslCertificateRequired(boolean bl) {
        this.setSslCertificateRequired(new Boolean(bl));
    }

    public void setSslCertificateRequired(Boolean bl) {
        if (!this.isSslCertificateRequired().equals(bl)) {
            this.sslCertificateRequired = bl == null || bl == false ? null : bl;
            this.setDirty(true);
        }
    }

    public Boolean isConnectionPoolEnabled() {
        return this.returnBooleanOrDefaultIfNull(this.connectionPoolEnabled, new Boolean(false));
    }

    public void setConnectionPoolEnabled(boolean bl) {
        this.setConnectionPoolEnabled(new Boolean(bl));
    }

    public void setConnectionPoolEnabled(Boolean bl) {
        if (!this.isConnectionPoolEnabled().equals(bl)) {
            this.connectionPoolEnabled = bl == null || bl == false ? null : bl;
            this.setDirty(true);
        }
    }

    public Integer getConnectionPoolInterval() {
        return this.returnIntegerOrDefaultIfNull(this.connectionPoolInterval, new Integer(15));
    }

    public void setConnectionPoolInterval(int n) {
        this.setConnectionPoolInterval(new Integer(n));
    }

    public void setConnectionPoolInterval(Integer n) {
        if (!this.getConnectionPoolInterval().equals(n)) {
            this.connectionPoolInterval = n == null || n == 15 ? null : n;
            this.setDirty(true);
        }
    }

    public Integer getConnectionPoolTimeout() {
        return this.returnIntegerOrDefaultIfNull(this.connectionPoolTimeout, new Integer(30));
    }

    public void setConnectionPoolTimeout(int n) {
        this.setConnectionPoolTimeout(new Integer(n));
    }

    public void setConnectionPoolTimeout(Integer n) {
        Debug.println((String)("SystemBean.setConnectionPoolTimeout: v=" + n));
        if (!this.getConnectionPoolTimeout().equals(n)) {
            this.connectionPoolTimeout = n == null || n == 30 ? null : n;
            this.setDirty(true);
        }
    }

    public Boolean getDebugInForeground() {
        return this.returnBooleanOrDefaultIfNull(this.debugInForeground, new Boolean(false));
    }

    public void setDebugInForeground(boolean bl) {
        this.setDebugInForeground(new Boolean(bl));
    }

    public void setDebugInForeground(Boolean bl) {
        if (!this.getDebugInForeground().equals(bl)) {
            this.debugInForeground = bl == null || bl == false ? null : bl;
            this.setDirty(true);
        }
    }

    private Integer returnIntegerOrDefaultIfNull(String string, Integer n) {
        Integer n2 = null;
        if (string == null) {
            n2 = n;
        } else {
            try {
                n2 = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return n2;
    }

    private Integer returnIntegerOrDefaultIfNull(Integer n, Integer n2) {
        Integer n3 = null;
        n3 = n == null ? n2 : n;
        return n3;
    }

    private String returnStringOrDefaultIfNull(String string, String string2) {
        String string3 = null;
        if (string == null) {
            string3 = string2;
        } else {
            try {
                string3 = new String(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return string3;
    }

    private Boolean returnBooleanOrDefaultIfNull(String string, Boolean bl) {
        Boolean bl2 = null;
        if (string != null) {
            if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) {
                bl2 = new Boolean(string);
            } else {
                Debug.println((String)("SystemBean: illegal boolean value " + string));
            }
        }
        if (bl2 == null) {
            bl2 = bl;
        }
        return bl2;
    }

    private Boolean returnBooleanOrDefaultIfNull(Boolean bl, Boolean bl2) {
        Boolean bl3 = null;
        if (bl != null) {
            bl3 = bl;
        }
        if (bl3 == null) {
            bl3 = bl2;
        }
        return bl3;
    }

    public void persist() throws IllegalPropertyException, NoSuchBeanException, PersistenceException, UniqueNameException {
        TaskParameters taskParameters = new TaskParameters();
        if (this.port != null) {
            taskParameters.addParameter("ids-proxy-con-listen-port", this.port.toString());
        }
        if (this.host != null) {
            taskParameters.addParameter("ids-proxy-con-listen-host", this.host.toString());
        }
        if (this.maximumConnections != null) {
            taskParameters.addParameter("ids-proxy-con-max-conns", this.maximumConnections.toString());
        }
        if (this.listenBacklog != null) {
            taskParameters.addParameter("ids-proxy-con-listen-backlog", this.listenBacklog.toString());
        }
        if (this.ldapsPort != null) {
            taskParameters.addParameter("ids-proxy-con-ldaps-port", this.ldapsPort.toString());
        }
        if (this.userId != null) {
            taskParameters.addParameter("ids-proxy-con-userid", this.userId.toString());
        }
        if (this.workingDirectory != null) {
            taskParameters.addParameter("ids-proxy-con-working-dir", this.workingDirectory.toString());
        }
        if (this.logRef != null) {
            taskParameters.addParameter("ids-proxy-con-include-logproperty", this.logRef.getId());
        }
        if (this.sendCertificateAsClientEnabled != null) {
            taskParameters.addParameter("ids-proxy-con-send-cert-as-client", this.sendCertificateAsClientEnabled.toString());
        }
        if (this.serverSslVersion != null) {
            taskParameters.addParameter("ids-proxy-con-server-ssl-version", this.serverSslVersion.toString());
        }
        if (this.clientSslVersion != null) {
            taskParameters.addParameter("ids-proxy-con-client-ssl-version", this.clientSslVersion.toString());
        }
        if (this.sslCertificateRequired != null) {
            taskParameters.addParameter("ids-proxy-con-ssl-cert-required", this.sslCertificateRequired.toString());
        }
        if (this.connectionPoolEnabled != null && this.isConnectionPoolEnabled().booleanValue()) {
            taskParameters.addParameter("ids-proxy-con-connection-pool", this.connectionPoolEnabled.toString());
            if (this.connectionPoolInterval != null) {
                taskParameters.addParameter("ids-proxy-con-connection-pool-interval", this.connectionPoolInterval.toString());
            }
            if (this.connectionPoolTimeout != null) {
                taskParameters.addParameter("ids-proxy-con-connection-pool-timeout", this.connectionPoolTimeout.toString());
            }
        }
        if (this.debugInForeground != null) {
            taskParameters.addParameter("ids-proxy-con-foreground", this.debugInForeground.toString());
        }
        taskParameters.addParameter("ids-proxy-sch-global-base", "ou=properties,ou=system,ou=dar-config,o=netscaperoot");
        super.doPersist(taskParameters);
        this.setDirty(false);
    }

    public void synchronize() throws RetrievalException, NoSuchBeanException {
        TaskResult taskResult = super.doSynchronize();
        this.setPort(this.getIntegerFromString(taskResult.getAttributeValue("ids-proxy-con-listen-port")));
        this.setHost(taskResult.getAttributeValue("ids-proxy-con-listen-host"));
        this.setMaximumConnections(this.getIntegerFromString(taskResult.getAttributeValue("ids-proxy-con-max-conns")));
        this.setListenBacklog(this.getIntegerFromString(taskResult.getAttributeValue("ids-proxy-con-listen-backlog")));
        this.setLdapsPort(this.getIntegerFromString(taskResult.getAttributeValue("ids-proxy-con-ldaps-port")));
        this.setUserId(taskResult.getAttributeValue("ids-proxy-con-userid"));
        this.setWorkingDirectory(taskResult.getAttributeValue("ids-proxy-con-working-dir"));
        this.setLogPropertyId(taskResult.getAttributeValue("ids-proxy-con-include-logproperty"));
        this.setSendCertificateAsClientEnabled(this.getBooleanFromString(taskResult.getAttributeValue("ids-proxy-con-send-cert-as-client")));
        this.setServerSslVersion(taskResult.getAttributeValue("ids-proxy-con-server-ssl-version"));
        this.setClientSslVersion(taskResult.getAttributeValue("ids-proxy-con-client-ssl-version"));
        this.setSslCertificateRequired(this.getBooleanFromString(taskResult.getAttributeValue("ids-proxy-con-ssl-cert-required")));
        this.setConnectionPoolEnabled(this.getBooleanFromString(taskResult.getAttributeValue("ids-proxy-con-connection-pool")));
        this.setConnectionPoolInterval(this.getIntegerFromString(taskResult.getAttributeValue("ids-proxy-con-connection-pool-interval")));
        this.setConnectionPoolTimeout(this.getIntegerFromString(taskResult.getAttributeValue("ids-proxy-con-connection-pool-timeout")));
        this.setDirty(false);
    }

    private Boolean getBooleanFromString(String string) {
        Boolean bl = null;
        if (string != null) {
            bl = new Boolean(string);
        }
        return bl;
    }

    private Integer getIntegerFromString(String string) {
        Integer n = null;
        if (string != null) {
            n = new Integer(string);
        }
        return n;
    }

    IDARReference invokeCreate(IDARReference iDARReference, String string, String string2, TaskParameters taskParameters) throws BeanAlreadyExistsException, CreationException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand != null) {
            return httpCommand.create(iDARReference, string, string2, taskParameters);
        }
        throw new CreationException("Bean management command not set by instantiator");
    }

    void invokeDelete(IDARReference iDARReference) throws NoSuchBeanException, DeletionException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand == null) {
            throw new DeletionException("Bean management command not set by instantiator");
        }
        httpCommand.delete(iDARReference);
    }

    IDARReference invokeRename(IDARReference iDARReference, String string) throws PersistenceException, NoSuchBeanException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand != null) {
            return httpCommand.rename(iDARReference, string);
        }
        throw new PersistenceException("Bean management command not set by instantiator");
    }

    TaskResult invokePersist(IDARReference iDARReference, TaskParameters taskParameters) throws PersistenceException, NoSuchBeanException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand != null) {
            return httpCommand.persist(iDARReference, taskParameters);
        }
        throw new PersistenceException("Bean management command not set by instantiator");
    }

    TaskResult invokeSynchronize(IDARReference iDARReference) throws RetrievalException, NoSuchBeanException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand != null) {
            return httpCommand.synchronize(iDARReference);
        }
        throw new RetrievalException("Bean management command not set by instantiator");
    }

    class SystemBeanReferenceMonitor
    extends BeanReferenceMonitor {
        SystemBeanReferenceMonitor(IDARModelBean iDARModelBean) {
            super(iDARModelBean);
        }

        SystemBeanReferenceMonitor(IDARModelBean iDARModelBean, BeanListenable beanListenable) {
            super(iDARModelBean, beanListenable);
        }

        public void beanDeleted(BeanEvent beanEvent) {
            Debug.println((int)6, (String)("SystemBeanReferenceMonitor.beanDeleted: evt=" + beanEvent));
            SystemBean.this.setLogProperty(null);
            super.beanDeleted(beanEvent);
        }
    }
}

