/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.objectmodel.BeanEvent;
import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanReferenceMonitor;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDAREnabledConfigurationModelBean;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.RuleData;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Vector;

public abstract class RuleBean
extends IDAREnabledConfigurationModelBean {
    Vector vRuleData = new Vector();
    private RuleBeanReferenceMonitor monitor = new RuleBeanReferenceMonitor(this);
    String questionableMessage;

    public abstract String getDescriptor();

    public String getLocalizableDescriptor() {
        return IDARResourceSet.getString("configType", "EVENT_DESCRIPTOR");
    }

    public boolean isQuestionable() {
        boolean bl = false;
        this.questionableMessage = null;
        if (this.vRuleData == null || this.vRuleData.size() == 0) {
            bl = true;
            this.questionableMessage = IDARResourceSet.getString("questionable", "NO_ACTION");
        }
        return bl;
    }

    public String getQuestionableExplanationMessage() {
        this.isQuestionable();
        return this.questionableMessage;
    }

    public RuleData[] getRuleData() {
        RuleData[] ruleDataArray = new RuleData[this.vRuleData.size()];
        for (int i = 0; i < ruleDataArray.length; ++i) {
            ruleDataArray[i] = (RuleData)((RuleData)this.vRuleData.elementAt(i)).clone();
        }
        return ruleDataArray;
    }

    public void setRuleData(RuleData[] ruleDataArray) {
        this.removeAllRuleData();
        for (int i = 0; i < ruleDataArray.length; ++i) {
            this.addRuleData(ruleDataArray[i]);
        }
    }

    public void addRuleData(RuleData ruleData) {
        this.vRuleData.add(ruleData);
        BeanListenable beanListenable = ruleData.getAction();
        this.monitor.addMonitor(beanListenable);
    }

    public void removeRuleData(RuleData ruleData) {
        BeanListenable beanListenable;
        if (ruleData != null && (beanListenable = ruleData.getAction()) != null) {
            this.monitor.removeMonitor(beanListenable.getSelfReference());
            this.vRuleData.removeElement(ruleData);
        }
    }

    public void setRuleData(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof RuleData)) continue;
            this.addRuleData((RuleData)e);
        }
    }

    public void removeAllRuleData() {
        this.monitor.removeAllMonitors();
        this.vRuleData.removeAllElements();
    }

    public TaskResult doPersist(TaskParameters taskParameters) throws PersistenceException, NoSuchBeanException, UniqueNameException {
        Enumeration enumeration = this.vRuleData.elements();
        while (enumeration.hasMoreElements()) {
            taskParameters.addParameter("ids-proxy-con-execute", ((RuleData)enumeration.nextElement()).toString());
        }
        return super.doPersist(taskParameters);
    }

    public TaskResult doSynchronize() throws RetrievalException, NoSuchBeanException {
        TaskResult taskResult = super.doSynchronize();
        this.removeAllRuleData();
        String[] stringArray = taskResult.getAttributeValues("ids-proxy-con-execute");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addRuleData(new RuleData(this.getParentConfiguration(), stringArray[i]));
            }
        }
        return taskResult;
    }

    class RuleBeanReferenceMonitor
    extends BeanReferenceMonitor {
        RuleBeanReferenceMonitor(IDARModelBean iDARModelBean) {
            super(iDARModelBean);
        }

        RuleBeanReferenceMonitor(IDARModelBean iDARModelBean, BeanListenable beanListenable) {
            super(iDARModelBean, beanListenable);
        }

        public void beanDeleted(BeanEvent beanEvent) {
            Debug.println((int)6, (String)("RuleBeanReferenceMonitor.beanDeleted: evt=" + beanEvent));
            IDARReference iDARReference = beanEvent.getReference();
            RuleData ruleData = null;
            if (iDARReference != null) {
                String string = iDARReference.getId();
                Enumeration enumeration = RuleBean.this.vRuleData.elements();
                while (enumeration.hasMoreElements()) {
                    RuleData ruleData2 = (RuleData)enumeration.nextElement();
                    BeanListenable beanListenable = ruleData2.getAction();
                    if (beanListenable == null || !string.equals(beanListenable.getId())) continue;
                    ruleData = ruleData2;
                    break;
                }
            }
            if (ruleData != null) {
                Debug.println((int)6, (String)("RuleBeanReferenceMonitor.beanDeleted: remove rule=" + ruleData));
                RuleBean.this.removeRuleData(ruleData);
            }
        }
    }
}

