/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IllegalPropertyException;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.PropertyBean;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Vector;

public class LogPropertyBean
extends PropertyBean
implements IDARConstants {
    private static final String STAT_DELIMITER = "|";
    private static final String SYSLOG_ON_WINDOWS = IDARResourceSet.getString("error", "LOG_SYSLOG_ON_WINDOWS");
    String illegalityMessage;
    private String logLevel = "warning";
    private String statisticsLevel = "none";
    private boolean mod;
    private boolean op;
    private boolean conn;
    private boolean general;
    private boolean audit;
    private boolean acl;
    String logSyslogCode;
    String auditSyslogCode;
    String logFileName;
    String auditFileName;
    private String logMaxFilesize;
    private String logMaxFiles;
    private String auditMaxFilesize;
    private String auditMaxFiles;

    protected static String getIdPrefix() {
        return "log";
    }

    public boolean isLegal() {
        this.illegalityMessage = null;
        boolean bl = true;
        if (this.isSyslogging()) {
            Object object;
            IDARReference[] iDARReferenceArray = this.getSubscribers();
            Vector<IDARReference> vector = new Vector<IDARReference>();
            block5: for (int i = 0; i < iDARReferenceArray.length; ++i) {
                try {
                    object = (SystemBean)iDARReferenceArray[i].getBean();
                    IDARReference[] iDARReferenceArray2 = ((SystemBean)object).getSubscribers();
                    for (int j = 0; j < iDARReferenceArray2.length; ++j) {
                        try {
                            IDARBean iDARBean = (IDARBean)iDARReferenceArray2[j].getBean();
                            if (iDARBean.getOS() != 0) continue;
                            bl = false;
                            vector.add(iDARReferenceArray[i]);
                            continue block5;
                        }
                        catch (IDARBeanException iDARBeanException) {
                            Debug.println((String)"LogPropertyBean.isLegal:  ERROR - idar bean could not be de-referenced");
                        }
                    }
                    continue;
                }
                catch (ClassCastException classCastException) {
                    Debug.println((String)"LogPropertyBean.isLegal:  ERROR - cast problem");
                    continue;
                }
                catch (IDARBeanException iDARBeanException) {
                    Debug.println((String)"LogPropertyBean.isLegal:  ERROR - system bean could not be de-referenced");
                }
            }
            Object[] objectArray = new IDARReference[vector.size()];
            vector.copyInto(objectArray);
            if (objectArray != null && objectArray.length > 0) {
                object = new StringBuffer(SYSLOG_ON_WINDOWS);
                ((StringBuffer)object).append('\n');
                for (int i = 0; i < objectArray.length && i < 5; ++i) {
                    ((StringBuffer)object).append("  ");
                    ((StringBuffer)object).append(((IDARReference)objectArray[i]).getId());
                    if (i == 4 && objectArray.length > 5) {
                        ((StringBuffer)object).append("\n  " + AND_OTHERS);
                    }
                    ((StringBuffer)object).append('\n');
                }
                this.illegalityMessage = ((StringBuffer)object).toString();
            }
        }
        return bl;
    }

    public String getIllegalityExplanationMessage() {
        this.isLegal();
        return this.illegalityMessage;
    }

    public boolean isQuestionable() {
        return false;
    }

    public String getQuestionableExplanationMessage() {
        return null;
    }

    public boolean isDeletable() {
        return true;
    }

    public String getPredeletionMessage() {
        return super.getPredeletionMessage();
    }

    public IDARReference[] getSubscribers() {
        Object[] objectArray;
        Vector<IDARReference> vector = new Vector<IDARReference>();
        try {
            objectArray = BeanSpace.getInstance().retrieveBeanCollection(this.getParentConfiguration(), "system");
            Vector vector2 = objectArray.toBeanVector();
            String string = this.getId();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof SystemBean) {
                    SystemBean systemBean = (SystemBean)e;
                    String string2 = systemBean.getLogPropertyId();
                    if (string2 == null || !string2.equals(string)) continue;
                    vector.add(systemBean.getSelfReference());
                    continue;
                }
                Debug.println((String)"LogPropertyBean.getSubscribers: WARNING: could not interogate bean");
            }
        }
        catch (IDARBeanException iDARBeanException) {
            Debug.println((String)"LogPropertyBean.getSubscribers: WARNING: could not get bean collection");
        }
        objectArray = new IDARReference[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getDescriptor() {
        return LogPropertyBean.getIdPrefix();
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String string) {
        if (string == null) {
            string = "warning";
        }
        if (this.logLevel == null) {
            this.logLevel = "warning";
        }
        if (!string.equals(this.logLevel)) {
            this.setDirty(true);
            this.logLevel = string;
        }
    }

    private String getStatisticsLevelString() {
        return this.statisticsLevel;
    }

    private void setStatisticsLevelString(String string) {
        if (string == null) {
            string = "none";
        }
        if (this.statisticsLevel == null) {
            this.statisticsLevel = "none";
        }
        if (!string.equals(this.statisticsLevel)) {
            this.setDirty(true);
            this.statisticsLevel = string;
        }
    }

    public boolean isModificationStatisticsEnabled() {
        return this.mod;
    }

    public boolean isOperationStatisticsEnabled() {
        return this.op;
    }

    public boolean isConnectionStatisticsEnabled() {
        return this.conn;
    }

    public boolean isGeneralStatisticsEnabled() {
        return this.general;
    }

    public boolean isAuditStatisticsEnabled() {
        return this.audit;
    }

    public boolean isAclStatisticsEnabled() {
        return this.acl;
    }

    public void setModificationStatisticsEnabled(boolean bl) {
        Debug.println((int)6, (String)("LogPropertyBean.setModificationStatisticsEnabled: stat=" + bl));
        if (this.mod != bl) {
            this.setDirty(true);
            this.mod = bl;
        }
        this.statisticsLevel = this.buildStatLevelString();
    }

    public void setOperationStatisticsEnabled(boolean bl) {
        if (this.op != bl) {
            this.setDirty(true);
            this.op = bl;
        }
        this.statisticsLevel = this.buildStatLevelString();
    }

    public void setConnectionStatisticsEnabled(boolean bl) {
        if (this.conn != bl) {
            this.setDirty(true);
            this.conn = bl;
        }
        this.statisticsLevel = this.buildStatLevelString();
    }

    public void setGeneralStatisticsEnabled(boolean bl) {
        if (this.general != bl) {
            this.setDirty(true);
            this.general = bl;
        }
        this.statisticsLevel = this.buildStatLevelString();
    }

    public void setAuditStatisticsEnabled(boolean bl) {
        if (this.audit != bl) {
            this.setDirty(true);
            this.audit = bl;
        }
        this.statisticsLevel = this.buildStatLevelString();
    }

    public void setAclStatisticsEnabled(boolean bl) {
        if (this.acl != bl) {
            this.setDirty(true);
            this.acl = bl;
        }
        this.statisticsLevel = this.buildStatLevelString();
    }

    public String getLogSyslogCode() {
        return this.logSyslogCode;
    }

    public void setLogSyslogCode(String string) {
        if (string != null && !string.equals(this.logSyslogCode) || string == null && this.logSyslogCode != null) {
            this.setDirty(true);
            this.logSyslogCode = string;
        }
    }

    public String getAuditSyslogCode() {
        return this.auditSyslogCode;
    }

    public void setAuditSyslogCode(String string) {
        if (string != null && !string.equals(this.auditSyslogCode) || string == null && this.auditSyslogCode != null) {
            this.setDirty(true);
            this.auditSyslogCode = string;
        }
    }

    public boolean isSyslogging() {
        boolean bl = false;
        String string = this.getLogSyslogCode();
        if (string != null && !string.trim().equals("")) {
            bl = true;
        } else {
            string = this.getAuditSyslogCode();
            if (string != null && !string.trim().equals("")) {
                bl = true;
            }
        }
        return bl;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String string) {
        if (string != null && !string.equals(this.logFileName) || string == null && this.logFileName != null) {
            this.setDirty(true);
            this.logFileName = string;
        }
    }

    public String getAuditFileName() {
        return this.auditFileName;
    }

    public void setAuditFileName(String string) {
        if (string != null && !string.equals(this.auditFileName) || string == null && this.auditFileName != null) {
            this.setDirty(true);
            this.auditFileName = string;
        }
    }

    public String getLogMaxFilesize() {
        return this.logMaxFilesize;
    }

    public void setLogMaxFilesize(String string) {
        this.logMaxFilesize = string;
    }

    public String getLogMaxFiles() {
        return this.logMaxFiles;
    }

    public void setLogMaxFiles(String string) {
        this.logMaxFiles = string;
    }

    public String getAuditMaxFilesize() {
        return this.auditMaxFilesize;
    }

    public void setAuditMaxFilesize(String string) {
        this.auditMaxFilesize = string;
    }

    public String getAuditMaxFiles() {
        return this.auditMaxFiles;
    }

    public void setAuditMaxFiles(String string) {
        this.auditMaxFiles = string;
    }

    public void persist() throws IllegalPropertyException, NoSuchBeanException, PersistenceException, UniqueNameException {
        TaskParameters taskParameters = new TaskParameters();
        if (this.logLevel != null && !this.logLevel.equals("warning")) {
            taskParameters.addParameter("ids-proxy-con-log-level", this.logLevel);
        }
        if (this.statisticsLevel != null && !this.statisticsLevel.equals("none")) {
            taskParameters.addParameter("ids-proxy-con-stat-level", this.statisticsLevel);
        }
        if (this.logFileName != null && !this.logFileName.trim().equals("")) {
            taskParameters.addParameter("ids-proxy-con-log-file", this.logFileName);
        }
        if (this.auditFileName != null && !this.auditFileName.trim().equals("")) {
            taskParameters.addParameter("ids-proxy-con-audit-file", this.auditFileName);
        }
        if (this.auditSyslogCode != null && !this.auditSyslogCode.trim().equals("")) {
            taskParameters.addParameter("ids-proxy-con-audit-syslog", this.auditSyslogCode);
        }
        if (this.logSyslogCode != null && !this.logSyslogCode.trim().equals("")) {
            taskParameters.addParameter("ids-proxy-con-log-syslog", this.logSyslogCode);
        }
        if (this.logMaxFilesize != null && !this.logMaxFilesize.trim().equals("")) {
            taskParameters.addParameter("ids-proxy-con-log-max-filesize", this.logMaxFilesize);
        }
        if (this.logMaxFiles != null) {
            taskParameters.addParameter("ids-proxy-con-log-max-files", this.logMaxFiles);
        }
        if (this.auditMaxFilesize != null && !this.auditMaxFilesize.trim().equals("")) {
            taskParameters.addParameter("ids-proxy-con-audit-max-filesize", this.auditMaxFilesize);
        }
        if (this.auditMaxFiles != null) {
            taskParameters.addParameter("ids-proxy-con-audit-max-files", this.auditMaxFiles);
        }
        super.doPersist(taskParameters);
    }

    public void synchronize() throws RetrievalException, NoSuchBeanException {
        TaskResult taskResult = super.doSynchronize();
        this.logLevel = taskResult.getAttributeValue("ids-proxy-con-log-level");
        if (this.logLevel == null) {
            this.logLevel = "warning";
        }
        this.logFileName = taskResult.getAttributeValue("ids-proxy-con-log-file");
        this.auditFileName = taskResult.getAttributeValue("ids-proxy-con-audit-file");
        this.auditSyslogCode = taskResult.getAttributeValue("ids-proxy-con-audit-syslog");
        this.logSyslogCode = taskResult.getAttributeValue("ids-proxy-con-log-syslog");
        this.logMaxFilesize = taskResult.getAttributeValue("ids-proxy-con-log-max-filesize");
        this.logMaxFiles = taskResult.getAttributeValue("ids-proxy-con-log-max-files");
        this.auditMaxFilesize = taskResult.getAttributeValue("ids-proxy-con-audit-max-filesize");
        this.auditMaxFiles = taskResult.getAttributeValue("ids-proxy-con-audit-max-files");
        this.statisticsLevel = taskResult.getAttributeValue("ids-proxy-con-stat-level");
        if (this.statisticsLevel == null) {
            this.statisticsLevel = "none";
        }
        this.mod = -1 != this.statisticsLevel.indexOf("mods");
        this.op = -1 != this.statisticsLevel.indexOf("op");
        this.conn = -1 != this.statisticsLevel.indexOf("conn");
        this.general = -1 != this.statisticsLevel.indexOf("stat");
        this.audit = -1 != this.statisticsLevel.indexOf("audit");
        this.acl = -1 != this.statisticsLevel.indexOf("acl");
    }

    private String buildStatLevelString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isModificationStatisticsEnabled()) {
            stringBuffer.append("mods");
            stringBuffer.append(STAT_DELIMITER);
        }
        if (this.isOperationStatisticsEnabled()) {
            stringBuffer.append("op");
            stringBuffer.append(STAT_DELIMITER);
        }
        if (this.isConnectionStatisticsEnabled()) {
            stringBuffer.append("conn");
            stringBuffer.append(STAT_DELIMITER);
        }
        if (this.isGeneralStatisticsEnabled()) {
            stringBuffer.append("stat");
            stringBuffer.append(STAT_DELIMITER);
        }
        if (this.isAuditStatisticsEnabled()) {
            stringBuffer.append("audit");
            stringBuffer.append(STAT_DELIMITER);
        }
        if (this.isAclStatisticsEnabled()) {
            stringBuffer.append("acl");
            stringBuffer.append(STAT_DELIMITER);
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("none");
        } else {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public String getLocalizableDescriptor() {
        return IDARResourceSet.getString("configType", "LOGGING_PROPERTY_DESCRIPTOR");
    }
}

