/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;

public class LoadBalanceData
implements Cloneable {
    private static final char DELIMITER = '#';
    BeanListenable server;
    IDARReference config;
    boolean isValid = false;
    Integer percentage = new Integer(0);

    private static String[] parseData(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(35);
        if (n == -1) {
            stringArray[0] = string;
        } else {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        }
        return stringArray;
    }

    public LoadBalanceData(IDARReference iDARReference) {
        this(iDARReference.getParentConfiguration(), iDARReference.getId());
    }

    public LoadBalanceData(IDARReference iDARReference, Integer n) {
        this(iDARReference.getParentConfiguration(), iDARReference.getId(), n);
    }

    public LoadBalanceData(IDARReference iDARReference, String string) {
        String[] stringArray = LoadBalanceData.parseData(string);
        this.setServerId(iDARReference, stringArray[0]);
        try {
            Integer n = new Integer(stringArray[1]);
            this.setPercentage(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public LoadBalanceData(IDARReference iDARReference, String string, Integer n) {
        this.setServerId(iDARReference, string);
        this.setPercentage(n);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getServerId() {
        String string = null;
        if (this.server != null) {
            string = this.server.getId();
        }
        return string;
    }

    public void setServerId(IDARReference iDARReference, String string) {
        if (iDARReference != null) {
            this.config = iDARReference;
        }
        if (string != null) {
            try {
                this.setServer(BeanSpace.getInstance().getBeanReference(string, "ldap-server", iDARReference));
            }
            catch (IDARBeanException iDARBeanException) {
                iDARBeanException.printStackTrace();
            }
        }
    }

    public void setServer(BeanListenable beanListenable) {
        this.isValid = beanListenable != null;
        this.server = beanListenable;
    }

    public BeanListenable getServer() {
        return this.server;
    }

    public Integer getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Integer n) {
        this.percentage = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getServerId();
        if (string != null) {
            stringBuffer.append(string);
        }
        if (this.percentage != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.percentage.toString());
        }
        return stringBuffer.toString();
    }

    public BeanListenable getBeanListenable() {
        return this.getServer();
    }

    public Object getDataElement(int n) {
        Object object = null;
        switch (n) {
            case 0: {
                object = this.getServerId();
            }
            case 1: {
                object = this.getPercentage();
            }
        }
        return object;
    }

    public Object clone() {
        LoadBalanceData loadBalanceData = null;
        try {
            loadBalanceData = (LoadBalanceData)super.clone();
            loadBalanceData.setPercentage(new Integer(this.percentage));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return loadBalanceData;
    }
}

