/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.objectmodel.HttpCommand;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.BeanAlreadyExistsException;
import com.iplanet.idar.objectmodel.bean.ConfigurationBean;
import com.iplanet.idar.objectmodel.bean.CreationException;
import com.iplanet.idar.objectmodel.bean.DeletionException;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public abstract class IDARConfigurationModelBean
extends IDARModelBean {
    private Integer priority = new Integer(0);
    private Vector vBelongsTo = new Vector();

    public String getIdField() {
        return "ids-proxy-con-name";
    }

    public String getName() {
        return this.getId();
    }

    public void setName(String string) throws UniqueNameException {
        this.setId(string);
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer n) {
        this.priority = n;
    }

    public void setParentConfiguration(IDARReference iDARReference) {
        Debug.println((String)("IDARConfigurationModelBean.setParentConfiguration: config=" + iDARReference));
        super.setParentConfiguration(iDARReference);
        if (iDARReference != null && !iDARReference.equals(IDARReference.NULL_REFERENCE)) {
            ConfigurationBean configurationBean = null;
            try {
                configurationBean = (ConfigurationBean)iDARReference.getBean();
            }
            catch (IDARBeanException iDARBeanException) {
                // empty catch block
            }
            if (configurationBean != null) {
                this.vBelongsTo.clear();
                Iterator iterator = configurationBean.getBelongsTo().iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next().toString();
                    Debug.println((String)("IDARConfigurationModelBean.setParentConfiguraiton: add " + string));
                    this.vBelongsTo.add(string);
                }
            }
        }
    }

    public Vector getBelongsTo() {
        return this.vBelongsTo;
    }

    public void addBelongsTo(String string) {
        Debug.println((String)("IDARConfigurationModelBean.addBelongsTo: name=" + string + " id=" + this.getId()));
        this.setDirty(true);
        if (!this.vBelongsTo.contains(string)) {
            this.vBelongsTo.addElement(string);
        }
    }

    public void removeBelongsTo(String string) {
        Debug.println((String)("IDARConfigurationModelBean.removeBelongsTo: name=" + string + " id=" + this.getId()));
        this.setDirty(true);
        this.vBelongsTo.remove(string);
    }

    public TaskResult doSynchronize() throws NoSuchBeanException, RetrievalException {
        TaskResult taskResult = super.doSynchronize();
        String string = taskResult.getAttributeValue("ids-proxy-con-priority");
        if (string != null) {
            this.priority = new Integer(string);
        }
        this.vBelongsTo.clear();
        String[] stringArray = taskResult.getAttributeValues("ids-proxy-sch-belongs-to");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.vBelongsTo.add(stringArray[i]);
            }
        }
        return taskResult;
    }

    protected TaskResult doPersist(TaskParameters taskParameters) throws PersistenceException, NoSuchBeanException, UniqueNameException {
        Debug.println((int)0);
        taskParameters.addParameter(this.getIdField(), this.getName());
        if (!this.priority.equals(new Integer(0))) {
            taskParameters.addParameter("ids-proxy-con-priority", this.priority.toString());
        }
        Enumeration enumeration = this.vBelongsTo.elements();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            taskParameters.addParameter("ids-proxy-sch-belongs-to", string);
        }
        Debug.println((String)("params:" + taskParameters));
        return super.doPersist(taskParameters);
    }

    IDARReference invokeCreate(IDARReference iDARReference, String string, String string2, TaskParameters taskParameters) throws BeanAlreadyExistsException, CreationException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand != null) {
            return httpCommand.create(iDARReference, string, string2, taskParameters);
        }
        throw new CreationException("Bean management command not set by instantiator");
    }

    void invokeDelete(IDARReference iDARReference) throws NoSuchBeanException, DeletionException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand == null) {
            throw new DeletionException("Bean management command not set by instantiator");
        }
        httpCommand.delete(iDARReference);
    }

    IDARReference invokeRename(IDARReference iDARReference, String string) throws PersistenceException, NoSuchBeanException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand != null) {
            return httpCommand.rename(iDARReference, string);
        }
        throw new PersistenceException("Bean management command not set by instantiator");
    }

    TaskResult invokePersist(IDARReference iDARReference, TaskParameters taskParameters) throws PersistenceException, NoSuchBeanException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand != null) {
            return httpCommand.persist(iDARReference, taskParameters);
        }
        throw new PersistenceException("Bean management command not set by instantiator");
    }

    TaskResult invokeSynchronize(IDARReference iDARReference) throws RetrievalException, NoSuchBeanException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand != null) {
            return httpCommand.synchronize(iDARReference);
        }
        throw new RetrievalException("Bean management command not set by instantiator");
    }
}

