/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.objectmodel.BeanEvent;
import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanReferenceMonitor;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.ActionBean;
import com.iplanet.idar.objectmodel.bean.ActionToGroupData;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.IllegalPropertyException;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.RuleBean;
import com.iplanet.idar.objectmodel.bean.RuleData;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Vector;

public class ChangeGroupActionBean
extends ActionBean {
    private Vector groupData;
    private ChangeGroupActionBeanReferenceMonitor monitor = new ChangeGroupActionBeanReferenceMonitor(this);
    String legalityMessage;
    String questionableMessage;

    public ChangeGroupActionBean() {
        this.groupData = new Vector();
    }

    public boolean isLegal() {
        boolean bl = true;
        this.legalityMessage = null;
        if (this.groupData.size() == 0) {
            this.legalityMessage = IDARResourceSet.getString("changeGroupActionError", "NO_CHANGE_DATA");
            bl = false;
        }
        return bl;
    }

    public String getIllegalityExplanationMessage() {
        this.isLegal();
        return this.legalityMessage;
    }

    public boolean isQuestionable() {
        boolean bl = true;
        this.questionableMessage = null;
        Enumeration enumeration = this.groupData.elements();
        while (enumeration.hasMoreElements()) {
            ActionToGroupData actionToGroupData = (ActionToGroupData)enumeration.nextElement();
            if ("NONE".equals(actionToGroupData.getGroupId())) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.questionableMessage = IDARResourceSet.getString("questionable", "NO_GROUP");
        }
        return bl;
    }

    public String getQuestionableExplanationMessage() {
        this.isQuestionable();
        return this.questionableMessage;
    }

    public boolean isDeletable() {
        return true;
    }

    public String getPredeletionMessage() {
        return super.getPredeletionMessage();
    }

    public IDARReference[] getSubscribers() {
        Object[] objectArray;
        Vector<IDARReference> vector = new Vector<IDARReference>();
        try {
            objectArray = BeanSpace.getInstance().retrieveBeanCollection(this.getParentConfiguration(), "rule");
            Vector vector2 = objectArray.toBeanVector();
            String string = this.getId();
            Enumeration enumeration = vector2.elements();
            block2: while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof RuleBean) {
                    RuleBean ruleBean = (RuleBean)e;
                    RuleData[] ruleDataArray = ruleBean.getRuleData();
                    if (ruleDataArray == null) continue;
                    for (int i = 0; i < ruleDataArray.length; ++i) {
                        String string2 = ruleDataArray[i].getActionId();
                        if (string2 == null || !string2.equals(string)) continue;
                        vector.add(ruleBean.getSelfReference());
                        continue block2;
                    }
                    continue;
                }
                Debug.println((String)"ChangeGroupActionBean.getSubscribers: WARNING: could not interogate bean");
            }
        }
        catch (IDARBeanException iDARBeanException) {
            Debug.println((String)"ChangeGroupActionBean.getSubscribers: WARNING: could not get bean collection");
        }
        objectArray = new IDARReference[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected static String getIdPrefix() {
        return "change-group";
    }

    public String getDescriptor() {
        return ChangeGroupActionBean.getIdPrefix();
    }

    public int getGroupDataCount() {
        return this.groupData.size();
    }

    public ActionToGroupData[] getGroupData() {
        ActionToGroupData[] actionToGroupDataArray = new ActionToGroupData[this.groupData.size()];
        for (int i = 0; i < actionToGroupDataArray.length; ++i) {
            actionToGroupDataArray[i] = (ActionToGroupData)((ActionToGroupData)this.groupData.elementAt(i)).clone();
        }
        return actionToGroupDataArray;
    }

    public void addGroupData(ActionToGroupData actionToGroupData) {
        Debug.println((String)("ChangeGroupActionBean.addGroupData: data=" + actionToGroupData));
        if (actionToGroupData.isValid()) {
            this.groupData.add(actionToGroupData);
            BeanListenable beanListenable = actionToGroupData.getGroup();
            this.monitor.addMonitor(beanListenable);
        } else {
            Debug.println((String)("ChangeGroupActionBean.addGroupData: invalid data " + actionToGroupData));
        }
    }

    public void setGroupData(ActionToGroupData[] actionToGroupDataArray) {
        this.removeAllGroupData();
        for (int i = 0; i < actionToGroupDataArray.length; ++i) {
            this.addGroupData(actionToGroupDataArray[i]);
        }
    }

    public void removeGroupData(ActionToGroupData actionToGroupData) {
        BeanListenable beanListenable;
        if (actionToGroupData != null && (beanListenable = actionToGroupData.getGroup()) != null) {
            this.monitor.removeMonitor(beanListenable.getSelfReference());
            this.groupData.removeElement(actionToGroupData);
        }
    }

    public void removeAllGroupData() {
        this.monitor.removeAllMonitors();
        this.groupData.clear();
    }

    public void persist() throws IllegalPropertyException, NoSuchBeanException, PersistenceException, UniqueNameException {
        TaskParameters taskParameters = new TaskParameters();
        if (this.groupData.size() == 0) {
            taskParameters.addParameter("ids-proxy-con-to-group", "");
        } else {
            Enumeration enumeration = this.groupData.elements();
            while (enumeration.hasMoreElements()) {
                taskParameters.addParameter("ids-proxy-con-to-group", enumeration.nextElement().toString());
            }
        }
        super.doPersist(taskParameters);
    }

    public void synchronize() throws RetrievalException, NoSuchBeanException {
        TaskResult taskResult = super.doSynchronize();
        this.removeAllGroupData();
        String[] stringArray = taskResult.getAttributeValues("ids-proxy-con-to-group");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addGroupData(new ActionToGroupData(this.getParentConfiguration(), stringArray[i]));
            }
        }
    }

    public String getLocalizableDescriptor() {
        return IDARResourceSet.getString("configType", "CHANGE_GROUP_ACTION_DESCRIPTOR");
    }

    class ChangeGroupActionBeanReferenceMonitor
    extends BeanReferenceMonitor {
        ChangeGroupActionBeanReferenceMonitor(IDARModelBean iDARModelBean) {
            super(iDARModelBean);
        }

        ChangeGroupActionBeanReferenceMonitor(IDARModelBean iDARModelBean, BeanListenable beanListenable) {
            super(iDARModelBean, beanListenable);
        }

        public void beanDeleted(BeanEvent beanEvent) {
            Debug.println((int)6, (String)("ChangeGroupActionBeanReferenceMonitor.beanDeleted: evt=" + beanEvent));
            IDARReference iDARReference = beanEvent.getReference();
            ActionToGroupData actionToGroupData = null;
            if (iDARReference != null) {
                String string = iDARReference.getId();
                Enumeration enumeration = ChangeGroupActionBean.this.groupData.elements();
                while (enumeration.hasMoreElements()) {
                    ActionToGroupData actionToGroupData2 = (ActionToGroupData)enumeration.nextElement();
                    BeanListenable beanListenable = actionToGroupData2.getGroup();
                    if (beanListenable == null || !string.equals(beanListenable.getId())) continue;
                    actionToGroupData = actionToGroupData2;
                    break;
                }
            }
            if (actionToGroupData != null) {
                Debug.println((int)6, (String)("ChangeGroupActionBeanReferenceMonitor.beanDeleted: remove data=" + actionToGroupData));
                ChangeGroupActionBean.this.removeGroupData(actionToGroupData);
                if (ChangeGroupActionBean.this.getGroupDataCount() == 0) {
                    ChangeGroupActionBean.this.addGroupData(new ActionToGroupData(null, "NONE"));
                }
                super.beanDeleted(beanEvent);
            }
        }
    }
}

