/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IllegalPropertyException;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.PropertyBean;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import java.util.Enumeration;
import java.util.Vector;

public class AttributeRenamingPropertyBean
extends PropertyBean
implements IDARConstants {
    private static final String NO_CLIENT_ATT_NAME = IDARResourceSet.getString("error", "NO_CLIENT_ATTRIBUTE_NAME");
    private static final String NO_SERVER_ATT_NAME = IDARResourceSet.getString("error", "NO_SERVER_ATTRIBUTE_NAME");
    String legalityMessage;
    String clientAttributeName = "";
    String serverAttributeName = "";

    protected static String getIdPrefix() {
        return "attribute-renaming";
    }

    public String getLocalizableDescriptor() {
        return IDARResourceSet.getString("configType", "ATTRIBUTE_RENAMING_PROPERTY_DESCRIPTOR");
    }

    public String getDescriptor() {
        return AttributeRenamingPropertyBean.getIdPrefix();
    }

    public boolean isLegal() {
        boolean bl = true;
        if (this.clientAttributeName == null || this.clientAttributeName.trim().equals("")) {
            bl = false;
            this.legalityMessage = IDARResourceSet.getString("error", "NO_CLIENT_ATTRIBUTE_NAME");
        } else if (this.serverAttributeName == null || this.serverAttributeName.trim().equals("")) {
            bl = false;
            this.legalityMessage = IDARResourceSet.getString("error", "NO_SERVER_ATTRIBUTE_NAME");
        } else if (!this.isValidAttributeName()) {
            bl = false;
            this.legalityMessage = IDARResourceSet.getString("error", "NON_SUPPORTED_CHARS");
        } else {
            this.legalityMessage = null;
        }
        return bl;
    }

    public String getIllegalityExplanationMessage() {
        this.isLegal();
        return this.legalityMessage;
    }

    public boolean isQuestionable() {
        return false;
    }

    public String getQuestionableExplanationMessage() {
        return null;
    }

    public boolean isDeletable() {
        return true;
    }

    public String getPredeletionMessage() {
        return super.getPredeletionMessage();
    }

    public IDARReference[] getSubscribers() {
        Object[] objectArray;
        Vector<IDARReference> vector = new Vector<IDARReference>();
        try {
            objectArray = BeanSpace.getInstance().retrieveBeanCollection(this.getParentConfiguration(), "network-group");
            Vector vector2 = objectArray.toBeanVector();
            String string = this.getId();
            Enumeration enumeration = vector2.elements();
            block2: while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof NetworkGroupBean) {
                    NetworkGroupBean networkGroupBean = (NetworkGroupBean)e;
                    Vector vector3 = networkGroupBean.getAttributeRenamingPropertyIds();
                    if (vector3 == null) continue;
                    Enumeration enumeration2 = vector3.elements();
                    while (enumeration2.hasMoreElements()) {
                        String string2 = enumeration2.nextElement().toString();
                        if (string2 == null || !string2.equals(string)) continue;
                        vector.add(networkGroupBean.getSelfReference());
                        continue block2;
                    }
                    continue;
                }
                Debug.println((String)"AttributeRenamingPropertyBean.getSubscribers: WARNING: could not interogate bean");
            }
        }
        catch (IDARBeanException iDARBeanException) {
            Debug.println((String)"AttributeRenamingPropertyBean.getSubscribers: WARNING: could not get bean collection");
        }
        objectArray = new IDARReference[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getClientAttributeName() {
        return this.clientAttributeName;
    }

    public void setClientAttributeName(String string) {
        if (string != null) {
            this.clientAttributeName = string;
        }
    }

    public String getServerAttributeName() {
        return this.serverAttributeName;
    }

    public void setServerAttributeName(String string) {
        if (string != null) {
            this.serverAttributeName = string;
        }
    }

    public void persist() throws IllegalPropertyException, NoSuchBeanException, PersistenceException, UniqueNameException {
        TaskParameters taskParameters = new TaskParameters();
        taskParameters.addParameter("ids-proxy-con-client-attr-name", this.clientAttributeName);
        taskParameters.addParameter("ids-proxy-con-server-attr-name", this.serverAttributeName);
        super.doPersist(taskParameters);
    }

    public void synchronize() throws RetrievalException, NoSuchBeanException {
        TaskResult taskResult = super.doSynchronize();
        this.setClientAttributeName(taskResult.getAttributeValue("ids-proxy-con-client-attr-name"));
        this.setServerAttributeName(taskResult.getAttributeValue("ids-proxy-con-server-attr-name"));
    }

    public boolean isValidAttributeName() {
        Debug.println((int)5);
        boolean bl = false;
        String string = "^(((0|[1-9]([0-9])*)(\\.(0|[1-9]([0-9])*))*)|([A-Za-z_][A-Za-z0-9\\-_]*))(;[A-Za-z0-9\\-]+)*$";
        Debug.println((int)5, (String)("regex: " + string));
        Pattern pattern = null;
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        try {
            pattern = perl5Compiler.compile(string);
        }
        catch (MalformedPatternException malformedPatternException) {
            Debug.println((int)6, (String)"ERROR: BAD REGEX");
            Debug.println((String)malformedPatternException.getMessage());
            malformedPatternException.printStackTrace();
        }
        Debug.println((int)5, (String)("client match = " + perl5Matcher.matches(this.clientAttributeName, pattern)));
        Debug.println((int)5, (String)("server match = " + perl5Matcher.matches(this.serverAttributeName, pattern)));
        return perl5Matcher.matches(this.clientAttributeName, pattern) && perl5Matcher.matches(this.serverAttributeName, pattern);
    }
}

