/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.objectmodel.HttpCommand;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class AdminServerBean
implements IDARConstants {
    String configDn = null;
    String ldapUserId = null;
    String ldapPassword = null;
    String ldapHost = null;
    LDAPConnection ldc = null;
    int ldapPort = 389;
    Integer port;
    boolean securityOn;
    String[] suiteSpotUsers;
    String serverAddress;
    boolean enableEndUser;
    boolean enableDSGW;
    String directoryInfoRef;
    String[] adminUsers;
    String errorLog;
    String pidLog;
    String accessLog;
    int cacheLifetime;
    String[] accessHosts;
    String[] accessAddresses;
    String oneAclDir;
    String defaultAcceptLanguage;

    public AdminServerBean(IDARBean iDARBean) {
        if (iDARBean != null) {
            this.ldc = iDARBean.getLDAPConnection();
            if (this.ldc != null) {
                DN dN = new DN(iDARBean.getHandle());
                if (!dN.toString().equals("")) {
                    DN dN2 = dN.getParent().getParent();
                    dN2.addRDNToFront(new RDN("cn=Administration Server"));
                    HttpCommand httpCommand = iDARBean.getCommand();
                    this.ldapUserId = httpCommand.getUserId();
                    this.ldapPassword = httpCommand.getPassword();
                    this.ldapHost = httpCommand.getHost();
                    this.ldapPort = httpCommand.getPort();
                    try {
                        this.ldc.connect(3, this.ldapHost, this.ldapPort, this.ldapUserId, this.ldapPassword);
                        String[] stringArray = new String[]{"dn", "nsServerSecurity"};
                        LDAPSearchResults lDAPSearchResults = this.ldc.search(dN2.toString(), 2, "(cn=Configuration)", stringArray, false);
                        if (lDAPSearchResults.hasMoreElements()) {
                            LDAPEntry lDAPEntry = lDAPSearchResults.next();
                            this.configDn = lDAPEntry.getDN();
                            LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                            Enumeration enumeration = lDAPAttributeSet.getAttributes();
                            while (enumeration.hasMoreElements()) {
                                String string;
                                LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                                String string2 = lDAPAttribute.getName();
                                if (!string2.equalsIgnoreCase("nsServerSecurity") || !(string = LDAPUtil.flatting((Enumeration)lDAPAttribute.getStringValues())).equalsIgnoreCase("on")) continue;
                                this.securityOn = true;
                            }
                        }
                        this.ldc.disconnect();
                        this.synchronize();
                    }
                    catch (LDAPException lDAPException) {}
                }
            } else {
                Debug.println((String)"AdminServerBean: ERROR - no ldap connection");
            }
        }
    }

    public Integer getPort() {
        return this.port;
    }

    public boolean isSecurityOn() {
        return this.securityOn;
    }

    public void synchronize() {
        if (this.ldc != null && this.configDn != null) {
            try {
                LDAPEntry lDAPEntry;
                this.ldc.connect(3, this.ldapHost, this.ldapPort, this.ldapUserId, this.ldapPassword);
                LDAPSearchResults lDAPSearchResults = this.ldc.search(this.configDn.toString(), 0, "(objectclass=*)", null, false);
                if (lDAPSearchResults.hasMoreElements() && (lDAPEntry = lDAPSearchResults.next()) != null) {
                    String string = this.getLDAPAttributeValue(lDAPEntry.getAttribute("nsServerPort", LDAPUtil.getLDAPAttributeLocale()));
                    try {
                        this.port = new Integer(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.suiteSpotUsers = this.getLDAPAttributeValues(lDAPEntry.getAttribute("nsSuiteSpotUser", LDAPUtil.getLDAPAttributeLocale()));
                    this.serverAddress = this.getLDAPAttributeValue(lDAPEntry.getAttribute("nsServerAddress", LDAPUtil.getLDAPAttributeLocale()));
                    string = this.getLDAPAttributeValue(lDAPEntry.getAttribute("nsAdminEnableEnduser", LDAPUtil.getLDAPAttributeLocale()));
                    this.enableEndUser = string.equals("on");
                    string = this.getLDAPAttributeValue(lDAPEntry.getAttribute("nsAdminEnableDSGW", LDAPUtil.getLDAPAttributeLocale()));
                    this.enableDSGW = string.equals("on");
                    this.directoryInfoRef = this.getLDAPAttributeValue(lDAPEntry.getAttribute("nsDirectoryInfoRef", LDAPUtil.getLDAPAttributeLocale()));
                    this.adminUsers = this.getLDAPAttributeValues(lDAPEntry.getAttribute("nsAdminUsers", LDAPUtil.getLDAPAttributeLocale()));
                    this.errorLog = this.getLDAPAttributeValue(lDAPEntry.getAttribute("nsErrorLog", LDAPUtil.getLDAPAttributeLocale()));
                    this.pidLog = this.getLDAPAttributeValue(lDAPEntry.getAttribute("nsPidLog", LDAPUtil.getLDAPAttributeLocale()));
                    this.accessLog = this.getLDAPAttributeValue(lDAPEntry.getAttribute("nsAccessLog", LDAPUtil.getLDAPAttributeLocale()));
                    string = this.getLDAPAttributeValue(lDAPEntry.getAttribute("nsAdminCacheLifetime", LDAPUtil.getLDAPAttributeLocale()));
                    try {
                        this.cacheLifetime = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.accessHosts = this.getLDAPAttributeValues(lDAPEntry.getAttribute("nsAdminAccessHosts", LDAPUtil.getLDAPAttributeLocale()));
                    this.accessAddresses = this.getLDAPAttributeValues(lDAPEntry.getAttribute("nsAdminAccessAddresses", LDAPUtil.getLDAPAttributeLocale()));
                    this.oneAclDir = this.getLDAPAttributeValue(lDAPEntry.getAttribute("nsAdminOneACLDir", LDAPUtil.getLDAPAttributeLocale()));
                    this.defaultAcceptLanguage = this.getLDAPAttributeValue(lDAPEntry.getAttribute("nsDefaultAcceptLanguage", LDAPUtil.getLDAPAttributeLocale()));
                }
                this.ldc.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
    }

    private String getLDAPAttributeValue(LDAPAttribute lDAPAttribute) {
        String[] stringArray;
        String string = "";
        if (lDAPAttribute != null && (stringArray = this.getLDAPAttributeValues(lDAPAttribute)).length != 0) {
            string = stringArray[0];
        }
        return string;
    }

    private String[] getLDAPAttributeValues(LDAPAttribute lDAPAttribute) {
        String[] stringArray = null;
        if (lDAPAttribute != null) {
            stringArray = lDAPAttribute.getStringValueArray();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }
}

