/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;

public class ActionToGroupData
implements Cloneable {
    public static final String NO_CHANGE = "NONE";
    public static final String MATCH_ALL = ".*";
    private static final char DELIMITER = '#';
    private IDARReference config = null;
    private BeanListenable group = null;
    private String dnRegexp = new String();
    private Integer precedence = new Integer(0);
    private boolean isValid = false;

    public ActionToGroupData(IDARReference iDARReference) {
        this(iDARReference.getParentConfiguration(), iDARReference.getId());
    }

    public ActionToGroupData(IDARReference iDARReference, String string) {
        this.config = iDARReference;
        String[] stringArray = ActionToGroupData.parseData(string);
        this.setGroupId(iDARReference, stringArray[0]);
        this.setDnRegexp(stringArray[1]);
        try {
            Integer n = new Integer(stringArray[2]);
            this.setPrecedence(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public ActionToGroupData(IDARReference iDARReference, String string, String string2, Integer n) {
        this.config = iDARReference;
        this.setGroupId(iDARReference, string);
        this.setDnRegexp(string2);
        this.setPrecedence(n);
    }

    public boolean isValid() {
        return this.isValid;
    }

    private static String[] parseData(String string) {
        String[] stringArray = new String[]{new String(), new String(), new String()};
        if (string == null || string.length() == 0) {
            return stringArray;
        }
        int n = string.indexOf(35);
        if (n == -1) {
            stringArray[0] = string;
            return stringArray;
        }
        stringArray[0] = string.substring(0, n);
        if (n + 1 > string.length()) {
            return stringArray;
        }
        int n2 = string.indexOf(35, n + 1);
        if (n2 == -1 || n2 + 1 > string.length()) {
            return stringArray;
        }
        stringArray[1] = string.substring(n + 1, n2);
        stringArray[2] = string.substring(n2 + 1);
        return stringArray;
    }

    public String getGroupId() {
        String string = null;
        string = this.group != null ? this.group.getId() : NO_CHANGE;
        return string;
    }

    public void setGroupId(IDARReference iDARReference, String string) {
        if (iDARReference != null) {
            this.config = iDARReference;
        }
        if (string != null && (string.equals(NO_CHANGE) || string.trim().equals(""))) {
            this.group = null;
            this.isValid = true;
        } else {
            try {
                this.setGroup(BeanSpace.getInstance().getBeanReference(string, "group", iDARReference));
                this.isValid = true;
            }
            catch (IDARBeanException iDARBeanException) {
                iDARBeanException.printStackTrace();
            }
        }
    }

    public BeanListenable getGroup() {
        return this.group;
    }

    public void setGroup(BeanListenable beanListenable) {
        this.group = beanListenable;
    }

    public String getDnRegexp() {
        return this.dnRegexp;
    }

    public void setDnRegexp(String string) {
        this.dnRegexp = string == null || string.trim().equals("") ? MATCH_ALL : string.toUpperCase();
    }

    public Integer getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(Integer n) {
        this.precedence = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getGroupId();
        if (string != null) {
            stringBuffer.append(string);
        }
        if (this.precedence != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.dnRegexp.toString());
            stringBuffer.append('#');
            stringBuffer.append(this.precedence.toString());
        }
        return stringBuffer.toString();
    }

    public BeanListenable getBeanListenable() {
        return this.getGroup();
    }

    public Object getDataElement(int n) {
        Object object = null;
        switch (n) {
            case 0: {
                object = this.getGroupId();
            }
            case 1: {
                object = this.getDnRegexp();
            }
            case 2: {
                object = this.getPrecedence();
            }
        }
        return object;
    }

    public Object clone() {
        ActionToGroupData actionToGroupData = null;
        try {
            actionToGroupData = (ActionToGroupData)super.clone();
            actionToGroupData.setPrecedence(new Integer(this.precedence));
            actionToGroupData.setDnRegexp(new String(this.dnRegexp));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return actionToGroupData;
    }
}

