/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel;

import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.AdminConfigData;
import com.iplanet.idar.objectmodel.bean.BeanAlreadyExistsException;
import com.iplanet.idar.objectmodel.bean.CreationException;
import com.iplanet.idar.objectmodel.bean.DeletionException;
import com.iplanet.idar.objectmodel.bean.InitializationException;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.netscape.management.client.util.DARTask;
import com.netscape.management.client.util.Debug;
import java.net.ConnectException;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPConnection;

public class HttpCommand {
    private Vector xtlUrls;
    private String userId = "";
    private String password = "";
    private String host = "";
    private int port = -1;
    private int[] urlPrecedence;
    private boolean retrying;
    Hashtable sessionRegistry = new Hashtable();

    public HttpCommand(String string, String string2, LDAPConnection lDAPConnection, AdminConfigData[] adminConfigDataArray) {
        Debug.println((int)6, (String)"******** HttpCommand.<init> *****************************");
        Debug.println((int)6, (String)("HttpCommand.<init>" + lDAPConnection.getPort()));
        this.userId = string;
        this.password = string2;
        this.host = lDAPConnection.getHost();
        this.port = lDAPConnection.getPort();
        this.xtlUrls = new Vector();
        if (adminConfigDataArray != null) {
            for (int i = 0; i < adminConfigDataArray.length; ++i) {
                this.addBaseUrl(adminConfigDataArray[i]);
            }
        } else {
            Debug.println((int)6, (String)"********** HttpCommand:  ERROR: base urls is null");
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void addBaseUrl(AdminConfigData adminConfigData) {
        if (adminConfigData != null) {
            if (!this.xtlUrls.contains(adminConfigData)) {
                try {
                    this.xtlUrls.addElement(adminConfigData);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                if (this.urlPrecedence == null) {
                    this.urlPrecedence = new int[1];
                    this.urlPrecedence[0] = 0;
                } else {
                    int[] nArray = new int[this.urlPrecedence.length + 1];
                    for (int i = 0; i < this.urlPrecedence.length; ++i) {
                        nArray[i] = this.urlPrecedence[i];
                    }
                    nArray[nArray.length - 1] = this.xtlUrls.size() - 1;
                    this.urlPrecedence = nArray;
                }
            }
        } else {
            Debug.println((int)6, (String)"********** HttpCommand:  WARNING: a base url is null");
        }
    }

    public void addBaseUrls(AdminConfigData[] adminConfigDataArray) {
        if (adminConfigDataArray != null) {
            for (int i = 0; i < adminConfigDataArray.length; ++i) {
                this.addBaseUrl(adminConfigDataArray[i]);
            }
        } else {
            Debug.println((int)6, (String)"********** HttpCommand:  WARNING: a base urls is null");
        }
    }

    public String tryInitialization(String string, String string2, String string3, int n, AdminConfigData adminConfigData) throws ConnectException, InitializationException {
        Debug.println((int)6, (String)("********** HttpCommand.tryInitialization: url=" + adminConfigData.getAdminServerTaskUrl()));
        TaskParameters taskParameters = new TaskParameters();
        taskParameters.addParameter("task", "init");
        taskParameters.addParameter("user", string);
        taskParameters.addParameter("passwd", string2);
        taskParameters.addParameter("host", string3);
        taskParameters.addParameter("port", Integer.toString(n));
        DARTask dARTask = new DARTask(adminConfigData.getAdminServerTaskUrl(), this.userId, this.password);
        dARTask.setArgumentCollection(taskParameters.toArgumentSet());
        Debug.println((int)6, (String)("********** parameters=" + taskParameters));
        int n2 = dARTask.exec();
        if (n2 == -1) {
            throw new ConnectException();
        }
        if (n2 != 0) {
            throw new InitializationException(adminConfigData.getAdminServerTaskUrl() + " returned error code " + n2, n2);
        }
        Hashtable hashtable = dARTask.getResult();
        Debug.println((int)6, (String)"********** HttpCommand.tryInitialization: result:");
        Debug.println((int)6, (String)(" " + hashtable));
        Debug.println((int)6, (String)"********************************** ");
        String string4 = (String)hashtable.get("session-id");
        return string4;
    }

    public TaskResult persist(IDARReference iDARReference, TaskParameters taskParameters) throws PersistenceException, NoSuchBeanException {
        return this.doPersist(iDARReference, taskParameters, "setsharedconfigelementattributes");
    }

    public TaskResult persistServer(IDARReference iDARReference, TaskParameters taskParameters) throws PersistenceException, NoSuchBeanException {
        return this.doPersist(iDARReference, taskParameters, "setserverattributes");
    }

    public TaskResult doPersist(IDARReference iDARReference, TaskParameters taskParameters, String string) throws PersistenceException, NoSuchBeanException {
        Debug.println((int)6, (String)("********** HttpCommand.doPersist: ref=" + iDARReference));
        TaskResult taskResult = null;
        if (this.xtlUrls != null) {
            for (int i = 0; i < this.urlPrecedence.length; ++i) {
                AdminConfigData adminConfigData = (AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]);
                try {
                    taskResult = this.tryPersist(iDARReference, taskParameters, adminConfigData, string);
                    this.setTopUrlPrecedenceIndex(i);
                    break;
                }
                catch (ConnectException connectException) {
                    Debug.println((int)6, (String)("********** HttpCommand.doPersist:  connection failure for " + adminConfigData.getAdminServerTaskUrl()));
                    this.uninitializeUrl((AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]));
                    if (i != this.urlPrecedence.length - 1) continue;
                    throw new PersistenceException("no listening admin servers");
                }
            }
        }
        return taskResult;
    }

    public synchronized TaskResult tryPersist(IDARReference iDARReference, TaskParameters taskParameters, AdminConfigData adminConfigData, String string) throws ConnectException, PersistenceException, NoSuchBeanException {
        Debug.println((int)6, (String)("********** HttpCommand.tryPersist: url=" + adminConfigData.getAdminServerTaskUrl()));
        taskParameters.setParameter("handle", iDARReference.getHandle());
        taskParameters.addParameter("id", iDARReference.getId());
        taskParameters.addParameter("task", string);
        taskParameters.setParameter("session-id", this.getSessionId(adminConfigData));
        DARTask dARTask = new DARTask(adminConfigData.getAdminServerTaskUrl(), this.getUserId(), this.getPassword());
        dARTask.setArgumentCollection(taskParameters.toArgumentSet());
        Debug.println((int)6, (String)("********** parameters=" + taskParameters));
        int n = dARTask.exec();
        Debug.println((int)6, (String)("HttpCommand.tryPersist: httpstatus =" + n));
        if (n == -1) {
            throw new ConnectException();
        }
        int n2 = dARTask.getStatus();
        if (n2 == 4) {
            throw new NoSuchBeanException("nonexistent bean " + iDARReference);
        }
        if (n2 != 0) {
            if (!this.retrying) {
                this.resetSession(adminConfigData);
                this.retrying = true;
                this.tryPersist(iDARReference, taskParameters, adminConfigData, string);
            } else {
                this.retrying = false;
                throw new PersistenceException(adminConfigData.getAdminServerTaskUrl() + " returned error code " + n2, n2);
            }
        }
        Debug.println((int)6, (String)("HttpCommand.tryPersist: nmcStatus =" + n2));
        TaskResult taskResult = new TaskResult(dARTask.getResult());
        Debug.println((int)6, (String)"********** HttpCommand.tryPersist: result:");
        Debug.println((int)6, (String)(" " + taskResult));
        Debug.println((int)6, (String)"********************************** ");
        return taskResult;
    }

    public IDARReference rename(IDARReference iDARReference, String string) throws PersistenceException, NoSuchBeanException {
        return this.doRename(iDARReference, string, "renamesharedconfigelement");
    }

    public IDARReference renameConfiguration(IDARReference iDARReference, String string) throws PersistenceException, NoSuchBeanException {
        return this.doRename(iDARReference, string, "renamesharedconfig");
    }

    protected IDARReference doRename(IDARReference iDARReference, String string, String string2) throws PersistenceException, NoSuchBeanException {
        Debug.println((int)6, (String)("********** HttpCommand.doRename: ref=" + iDARReference + " newId=" + string));
        IDARReference iDARReference2 = null;
        if (this.xtlUrls != null) {
            for (int i = 0; i < this.urlPrecedence.length; ++i) {
                AdminConfigData adminConfigData = (AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]);
                try {
                    iDARReference2 = this.tryRename(iDARReference, string, adminConfigData, string2);
                    this.setTopUrlPrecedenceIndex(i);
                    break;
                }
                catch (ConnectException connectException) {
                    Debug.println((int)6, (String)("********** HttpCommand.doRename:  connection failure for " + adminConfigData));
                    this.uninitializeUrl((AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]));
                    if (i != this.urlPrecedence.length - 1) continue;
                    throw new PersistenceException("no listening admin servers");
                }
            }
        }
        return iDARReference2;
    }

    protected synchronized IDARReference tryRename(IDARReference iDARReference, String string, AdminConfigData adminConfigData, String string2) throws ConnectException, PersistenceException, NoSuchBeanException {
        Debug.println((int)6, (String)("********** HttpCommand.tryRename: url=" + adminConfigData.getAdminServerTaskUrl() + " parameters="));
        TaskParameters taskParameters = new TaskParameters();
        taskParameters.setParameter(iDARReference);
        taskParameters.addParameter("task", string2);
        taskParameters.addParameter("new-id", string);
        taskParameters.setParameter("session-id", this.getSessionId(adminConfigData));
        DARTask dARTask = new DARTask(adminConfigData.getAdminServerTaskUrl(), this.userId, this.password);
        dARTask.setArgumentCollection(taskParameters.toArgumentSet());
        Debug.println((int)6, (String)("********** parameters=" + taskParameters));
        int n = dARTask.exec();
        if (n == -1) {
            throw new ConnectException();
        }
        if (n == 4) {
            throw new NoSuchBeanException("nonexistent bean " + iDARReference);
        }
        if (n != 0) {
            if (!this.retrying) {
                this.resetSession(adminConfigData);
                this.retrying = true;
                this.tryRename(iDARReference, string, adminConfigData, string2);
            } else {
                this.retrying = false;
                throw new PersistenceException(adminConfigData.getAdminServerTaskUrl() + " returned error code " + n, n);
            }
        }
        String string3 = dARTask.getResponseAttributeValue("ref");
        IDARReference iDARReference2 = null;
        if (string3 == null) {
            throw new PersistenceException("Rename error:  server failed to return a new reference");
        }
        iDARReference2 = new IDARReference(iDARReference.getParentConfiguration(), string3);
        return iDARReference2;
    }

    public TaskResult synchronize(IDARReference iDARReference) throws RetrievalException, NoSuchBeanException {
        return this.doSynchronize(iDARReference, "getsharedconfigelementattributes");
    }

    public TaskResult synchronizeServer(IDARReference iDARReference) throws RetrievalException, NoSuchBeanException {
        return this.doSynchronize(iDARReference, "getserverattributes");
    }

    public TaskResult doSynchronize(IDARReference iDARReference, String string) throws RetrievalException, NoSuchBeanException {
        Debug.println((int)6, (String)("********** HttpCommand.doSynchronize: ref=" + iDARReference));
        TaskResult taskResult = null;
        if (this.xtlUrls != null) {
            for (int i = 0; i < this.urlPrecedence.length; ++i) {
                AdminConfigData adminConfigData = (AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]);
                try {
                    taskResult = this.trySynchronize(iDARReference, adminConfigData, string);
                    this.setTopUrlPrecedenceIndex(i);
                    break;
                }
                catch (ConnectException connectException) {
                    Debug.println((int)6, (String)("********** HttpCommand.doSynchronize:  connection failure for " + adminConfigData.getAdminServerTaskUrl()));
                    this.uninitializeUrl((AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]));
                    if (i != this.urlPrecedence.length - 1) continue;
                    throw new RetrievalException("no listening admin servers");
                }
            }
        }
        return taskResult;
    }

    protected synchronized TaskResult trySynchronize(IDARReference iDARReference, AdminConfigData adminConfigData, String string) throws ConnectException, RetrievalException, NoSuchBeanException {
        Debug.println((int)6, (String)("********** HttpCommand.trySynchronize: url=" + adminConfigData.getAdminServerTaskUrl()));
        DARTask dARTask = new DARTask(adminConfigData.getAdminServerTaskUrl(), this.userId, this.password);
        TaskParameters taskParameters = new TaskParameters();
        taskParameters.setParameter("handle", iDARReference.getHandle());
        taskParameters.addParameter("task", string);
        taskParameters.setParameter("session-id", this.getSessionId(adminConfigData));
        dARTask.setArgumentCollection(taskParameters.toArgumentSet());
        Debug.println((int)6, (String)("********** parameters=" + taskParameters));
        dARTask.exec();
        int n = dARTask.getStatus();
        if (n == -1) {
            throw new ConnectException();
        }
        if (n == 4) {
            throw new NoSuchBeanException("nonexistent bean " + iDARReference);
        }
        if (n != 7 && n != 0) {
            if (!this.retrying) {
                this.resetSession(adminConfigData);
                this.retrying = true;
                this.trySynchronize(iDARReference, adminConfigData, string);
            } else {
                this.retrying = false;
                throw new RetrievalException(adminConfigData.getAdminServerTaskUrl() + " returned error code " + n, n);
            }
        }
        TaskResult taskResult = new TaskResult(dARTask.getResult());
        Debug.println((int)6, (String)"********** HttpCommand.trySynchronize: result:");
        Debug.println((int)6, (String)(" " + taskResult));
        Debug.println((int)6, (String)"********************************** ");
        return taskResult;
    }

    public IDARReference[] queryIds(IDARReference iDARReference, String string) throws RetrievalException {
        if (string.equals("configuration")) {
            return this.queryConfigurationIds();
        }
        if (string.equals("idar-server")) {
            return this.queryServerIds();
        }
        if (string.equals("system")) {
            return this.querySystemIds();
        }
        if (string.equals("log")) {
            return this.queryLogIds();
        }
        return this.doQueryIds(iDARReference, string, "getsharedconfigelementids");
    }

    public IDARReference[] queryConfigurationIds() throws RetrievalException {
        return this.doQueryIds(IDARReference.NULL_REFERENCE, "configuration", "getsharedconfigids");
    }

    public IDARReference[] queryServerIds() throws RetrievalException {
        return this.doQueryIds(IDARReference.NULL_REFERENCE, "idar-server", "getserverids");
    }

    public IDARReference[] querySystemIds() throws RetrievalException {
        return this.doQueryIds(IDARReference.NULL_REFERENCE, "system", "getsystemconfigids");
    }

    public IDARReference[] queryLogIds() throws RetrievalException {
        return this.doQueryIds(IDARReference.NULL_REFERENCE, "log", "getlogids");
    }

    protected IDARReference[] doQueryIds(IDARReference iDARReference, String string, String string2) throws RetrievalException {
        Debug.println((int)6, (String)"********** HttpCommand.doQueryIds");
        IDARReference[] iDARReferenceArray = new IDARReference[]{};
        if (this.xtlUrls != null) {
            for (int i = 0; i < this.urlPrecedence.length; ++i) {
                AdminConfigData adminConfigData = (AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]);
                try {
                    Debug.println((int)6, (String)("********** HttpCommand.doQueryIds: trying " + adminConfigData.getAdminServerTaskUrl()));
                    iDARReferenceArray = this.tryQueryIds(iDARReference, string, adminConfigData, string2);
                    this.setTopUrlPrecedenceIndex(i);
                    break;
                }
                catch (ConnectException connectException) {
                    Debug.println((int)6, (String)("********** HttpCommand.doQueryIds:  connect exception for " + adminConfigData.getAdminServerTaskUrl()));
                    this.uninitializeUrl((AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]));
                    if (i != this.urlPrecedence.length - 1) continue;
                    throw new RetrievalException("no listening admin servers");
                }
            }
        }
        return iDARReferenceArray;
    }

    protected synchronized IDARReference[] tryQueryIds(IDARReference iDARReference, String string, AdminConfigData adminConfigData, String string2) throws ConnectException, RetrievalException {
        Debug.println((int)6, (String)("********** HttpCommand.tryQueryIds: url=" + adminConfigData.getAdminServerTaskUrl()));
        DARTask dARTask = new DARTask(adminConfigData.getAdminServerTaskUrl(), this.userId, this.password);
        TaskParameters taskParameters = new TaskParameters();
        if (iDARReference != null) {
            taskParameters.setParameter(iDARReference);
        }
        taskParameters.addParameter("desc", string);
        taskParameters.addParameter("task", string2);
        taskParameters.setParameter("session-id", this.getSessionId(adminConfigData));
        dARTask.setArgumentCollection(taskParameters.toArgumentSet());
        Debug.println((int)6, (String)("HttpCommand.tryQueryIds: ********** parameters=" + taskParameters));
        dARTask.exec();
        int n = dARTask.getStatus();
        if (n == -1) {
            Debug.println((int)6, (String)"HttpCommand.tryQueryIds: ********** DARTask executed with code = CONNECTION_ERROR");
            throw new ConnectException();
        }
        if (n == 5) {
            Debug.println((int)6, (String)"HttpCommand.tryQueryIds: ********** DARTask executed with code = STATUS_NO_SUCH_CONFIGURATION");
            throw new RetrievalException(iDARReference + " is no longer valid.  The configuration may have " + "been deleted or moved in the directory");
        }
        if (n != 0) {
            Debug.println((int)6, (String)"HttpCommand.tryQueryIds: ********** DARTask executed with code != STATUS_SUCCESS");
            if (!this.retrying) {
                this.resetSession(adminConfigData);
                this.retrying = true;
                this.tryQueryIds(iDARReference, string, adminConfigData, string2);
            } else {
                this.retrying = false;
                throw new RetrievalException(adminConfigData.getAdminServerTaskUrl() + " returned error code " + n, n);
            }
        }
        Debug.println((int)6, (String)"********** HttpCommand.tryQueryIds: refs:");
        String[] stringArray = dARTask.getResponseAttributeValues("ref");
        Vector<IDARReference> vector = new Vector<IDARReference>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                IDARReference iDARReference2 = new IDARReference(iDARReference, stringArray[i]);
                if (iDARReference2.isValid()) {
                    vector.add(iDARReference2);
                    Debug.println((String)stringArray[i]);
                    continue;
                }
                Debug.println((String)("HttpCommand.tryQueryIds: ERROR invalid ref=" + iDARReference2));
            }
        }
        Debug.println((int)6, (String)"********************************** ");
        Object[] objectArray = new IDARReference[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public IDARReference create(IDARReference iDARReference, String string, String string2, TaskParameters taskParameters) throws BeanAlreadyExistsException, CreationException {
        IDARReference iDARReference2 = null;
        iDARReference2 = string2.equals("system") ? this.createSystemConfiguration(string, taskParameters) : (string2.equals("log") ? this.createLogProperty(string, taskParameters) : this.doCreate(iDARReference, string, string2, taskParameters, "createsharedconfigelement"));
        return iDARReference2;
    }

    public IDARReference createConfiguration(String string) throws BeanAlreadyExistsException, CreationException {
        return this.doCreate(IDARReference.NULL_REFERENCE, string, "configuration", new TaskParameters(), "createsharedconfig");
    }

    public IDARReference createLogProperty(String string, TaskParameters taskParameters) throws BeanAlreadyExistsException, CreationException {
        return this.doCreate(IDARReference.NULL_REFERENCE, string, "log", taskParameters, "createlog");
    }

    public IDARReference createSystemConfiguration(String string, TaskParameters taskParameters) throws BeanAlreadyExistsException, CreationException {
        return this.doCreate(IDARReference.NULL_REFERENCE, string, "system", taskParameters, "createsystem");
    }

    protected IDARReference doCreate(IDARReference iDARReference, String string, String string2, TaskParameters taskParameters, String string3) throws BeanAlreadyExistsException, CreationException {
        Debug.println((int)6, (String)"********** HttpCommand.doCreate");
        IDARReference iDARReference2 = null;
        if (this.xtlUrls != null) {
            for (int i = 0; i < this.urlPrecedence.length; ++i) {
                AdminConfigData adminConfigData = (AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]);
                try {
                    Debug.println((int)6, (String)("********** HttpCommand.doCreate: trying " + adminConfigData.getAdminServerTaskUrl() + " parameters="));
                    Debug.println((int)6, (String)("  " + taskParameters));
                    iDARReference2 = this.tryCreate(iDARReference, string, string2, taskParameters, adminConfigData, string3);
                    this.setTopUrlPrecedenceIndex(i);
                    break;
                }
                catch (ConnectException connectException) {
                    Debug.println((int)6, (String)("********** HttpCommand.doCreate:  CreationException for URL " + adminConfigData.getAdminServerTaskUrl()));
                    this.uninitializeUrl((AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]));
                    if (i != this.urlPrecedence.length - 1) continue;
                    throw new CreationException("no listening admin servers");
                }
            }
        }
        return iDARReference2;
    }

    protected synchronized IDARReference tryCreate(IDARReference iDARReference, String string, String string2, TaskParameters taskParameters, AdminConfigData adminConfigData, String string3) throws ConnectException, BeanAlreadyExistsException, CreationException {
        Debug.println((int)6, (String)("********** HttpCommand.tryCreate: url=" + adminConfigData.getAdminServerTaskUrl()));
        DARTask dARTask = new DARTask(adminConfigData.getAdminServerTaskUrl(), this.userId, this.password);
        taskParameters.setParameter(iDARReference);
        taskParameters.addParameter("id", string);
        taskParameters.addParameter("desc", string2);
        taskParameters.setParameter("session-id", this.getSessionId(adminConfigData));
        taskParameters.addParameter("task", string3);
        dARTask.setArgumentCollection(taskParameters.toArgumentSet());
        Debug.println((int)6, (String)("********** parameters=" + taskParameters));
        dARTask.exec();
        int n = dARTask.getStatus();
        if (n == -1) {
            throw new ConnectException();
        }
        if (n == 2) {
            throw new BeanAlreadyExistsException("id:" + string + " descriptor:" + string2);
        }
        if (n != 0) {
            if (!this.retrying) {
                this.resetSession(adminConfigData);
                this.retrying = true;
                this.tryCreate(iDARReference, string, string2, taskParameters, adminConfigData, string3);
            } else {
                this.retrying = false;
                throw new CreationException(adminConfigData.getAdminServerTaskUrl() + " returned error code " + n, n);
            }
        }
        TaskResult taskResult = new TaskResult(dARTask.getResult());
        Debug.println((int)6, (String)"********** HttpCommand.tryCreate: result:");
        Debug.println((int)6, (String)(" " + taskResult));
        Debug.println((int)6, (String)"********************************** ");
        String string4 = dARTask.getResponseAttributeValue("ref");
        if (string4 == null) {
            throw new CreationException("Create error:  server failed to return a valid reference");
        }
        IDARReference iDARReference2 = new IDARReference(iDARReference, string4);
        return iDARReference2;
    }

    public void delete(IDARReference iDARReference) throws NoSuchBeanException, DeletionException {
        this.doDelete(iDARReference, "deletesharedconfigelement");
    }

    public void deleteConfiguration(IDARReference iDARReference) throws NoSuchBeanException, DeletionException {
        this.doDelete(iDARReference, "deletesharedconfig");
    }

    public void doDelete(IDARReference iDARReference, String string) throws NoSuchBeanException, DeletionException {
        Debug.println((int)6, (String)"********** HttpCommand.doDelete");
        if (this.xtlUrls != null) {
            for (int i = 0; i < this.urlPrecedence.length; ++i) {
                AdminConfigData adminConfigData = (AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]);
                try {
                    Debug.println((int)6, (String)("********** HttpCommand.doDelete: trying " + adminConfigData + " parameters="));
                    Debug.println((int)6, (String)("  " + iDARReference));
                    this.tryDelete(iDARReference, adminConfigData, string);
                    this.setTopUrlPrecedenceIndex(i);
                    break;
                }
                catch (ConnectException connectException) {
                    Debug.println((int)6, (String)("********** HttpCommand.doDelete:  connection failure for " + adminConfigData.getAdminServerTaskUrl()));
                    this.uninitializeUrl((AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]));
                    if (i != this.urlPrecedence.length - 1) continue;
                    throw new DeletionException("no listening admin servers");
                }
            }
        }
    }

    protected synchronized void tryDelete(IDARReference iDARReference, AdminConfigData adminConfigData, String string) throws ConnectException, NoSuchBeanException, DeletionException {
        Debug.println((int)6, (String)("********** HttpCommand.tryDelete: url=" + adminConfigData.getAdminServerTaskUrl()));
        if (iDARReference == null) {
            throw new DeletionException("attempt to delete object with null reference");
        }
        DARTask dARTask = new DARTask(adminConfigData.getAdminServerTaskUrl(), this.userId, this.password);
        TaskParameters taskParameters = new TaskParameters();
        taskParameters.setParameter(iDARReference);
        taskParameters.setParameter("session-id", this.getSessionId(adminConfigData));
        taskParameters.addParameter("task", string);
        dARTask.setArgumentCollection(taskParameters.toArgumentSet());
        Debug.println((int)6, (String)("********** parameters=" + taskParameters));
        int n = dARTask.exec();
        Debug.println((int)6, (String)("HttpCommand.tryDelete: httpstatus =" + n));
        int n2 = dARTask.getStatus();
        Debug.println((int)6, (String)("HttpCommand.tryDelete: nmcStatus =" + n2));
        if (n2 == -1) {
            throw new ConnectException();
        }
        if (n2 == 4) {
            throw new NoSuchBeanException("ref: " + iDARReference);
        }
        if (n2 != 0) {
            if (!this.retrying) {
                this.resetSession(adminConfigData);
                this.retrying = true;
                this.tryDelete(iDARReference, adminConfigData, string);
            } else {
                this.retrying = false;
                throw new DeletionException(adminConfigData.getAdminServerTaskUrl() + " returned error code " + n2, n2);
            }
        }
    }

    public void subscribeToConfiguration(String string, String string2) throws PersistenceException {
        Debug.println((int)6, (String)"********** HttpCommand.subscribeToConfiguration");
        if (this.xtlUrls != null) {
            for (int i = 0; i < this.urlPrecedence.length; ++i) {
                AdminConfigData adminConfigData = (AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]);
                try {
                    Debug.println((int)6, (String)("********** HttpCommand.subscribeToConfiguration: trying " + adminConfigData.getAdminServerTaskUrl() + " parameters=" + string + "; " + string2));
                    this.trySubscribeToConfiguration(adminConfigData, string, string2);
                    this.setTopUrlPrecedenceIndex(i);
                    break;
                }
                catch (ConnectException connectException) {
                    Debug.println((int)6, (String)("********** HttpCommand.subscribeToConfiguration:  connection failure for " + adminConfigData.getAdminServerTaskUrl()));
                    this.uninitializeUrl((AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]));
                    if (i != this.urlPrecedence.length - 1) continue;
                    throw new PersistenceException("no listening admin servers");
                }
            }
        }
    }

    public void unsubscribeFromConfiguration(String string, String string2) throws PersistenceException {
        Debug.println((int)6, (String)"********** HttpCommand.subscribeToConfiguration");
        if (this.xtlUrls != null) {
            for (int i = 0; i < this.urlPrecedence.length; ++i) {
                AdminConfigData adminConfigData = (AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]);
                try {
                    Debug.println((int)6, (String)("********** HttpCommand.subscribeToConfiguration: trying " + adminConfigData.getAdminServerTaskUrl() + " parameters="));
                    this.tryUnsubscribeFromConfiguration(adminConfigData, string, string2);
                    this.setTopUrlPrecedenceIndex(i);
                    break;
                }
                catch (ConnectException connectException) {
                    Debug.println((int)6, (String)("********** HttpCommand.subscribeToConfiguration:  connection failure for " + adminConfigData.getAdminServerTaskUrl()));
                    this.uninitializeUrl((AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[i]));
                    if (i != this.urlPrecedence.length - 1) continue;
                    throw new PersistenceException("no listening admin servers");
                }
            }
        }
    }

    protected synchronized void trySubscribeToConfiguration(AdminConfigData adminConfigData, String string, String string2) throws ConnectException, PersistenceException {
        Debug.println((int)6, (String)("********** HttpCommand.trySubscribeToConfiguration: url=" + adminConfigData.getAdminServerTaskUrl()));
        TaskParameters taskParameters = new TaskParameters();
        taskParameters.addParameter("task", "add-configuration-user");
        taskParameters.setParameter("session-id", this.getSessionId(adminConfigData));
        taskParameters.addParameter("configdn", string);
        taskParameters.addParameter("serverid", string2);
        DARTask dARTask = new DARTask(adminConfigData.getAdminServerTaskUrl(), this.userId, this.password);
        dARTask.setArgumentCollection(taskParameters.toArgumentSet());
        Debug.println((int)6, (String)("********** parameters=" + taskParameters));
        dARTask.exec();
        int n = dARTask.getStatus();
        if (n == -1) {
            throw new ConnectException();
        }
        if (n != 0) {
            if (!this.retrying) {
                this.resetSession(adminConfigData);
                this.retrying = true;
                this.trySubscribeToConfiguration(adminConfigData, string, string2);
            } else {
                this.retrying = false;
                throw new PersistenceException("subscribe failed: error=" + n, n);
            }
        }
    }

    protected synchronized void tryUnsubscribeFromConfiguration(AdminConfigData adminConfigData, String string, String string2) throws ConnectException, PersistenceException {
        Debug.println((int)6, (String)("********** HttpCommand.tryUnsubscribeFromConfiguration: url=" + adminConfigData.getAdminServerTaskUrl()));
        TaskParameters taskParameters = new TaskParameters();
        taskParameters.addParameter("task", "remove-configuration-user");
        taskParameters.setParameter("session-id", this.getSessionId(adminConfigData));
        taskParameters.addParameter("configdn", string);
        taskParameters.addParameter("serverid", string2);
        DARTask dARTask = new DARTask(adminConfigData.getAdminServerTaskUrl(), this.userId, this.password);
        dARTask.setArgumentCollection(taskParameters.toArgumentSet());
        Debug.println((int)6, (String)("********** parameters=" + taskParameters));
        dARTask.exec();
        int n = dARTask.getStatus();
        if (n == -1) {
            throw new ConnectException();
        }
        if (n != 0) {
            if (!this.retrying) {
                this.resetSession(adminConfigData);
                this.retrying = true;
                this.trySubscribeToConfiguration(adminConfigData, string, string2);
            } else {
                this.retrying = false;
                throw new PersistenceException("unsubscribe failed: error=" + n, n);
            }
        }
    }

    private void setTopUrlPrecedenceIndex(int n) {
        if (n != 0) {
            Debug.println((int)6, (String)("HttpCommand.setTopUrlPrecedenceIndex: setting url " + ((AdminConfigData)this.xtlUrls.elementAt(this.urlPrecedence[n])).getAdminServerTaskUrl() + " to top precedence"));
            int n2 = this.urlPrecedence[0];
            this.urlPrecedence[0] = this.urlPrecedence[n];
            this.urlPrecedence[n] = n2;
        }
    }

    private String getSessionId(AdminConfigData adminConfigData) throws ConnectException {
        Debug.println((int)6, (String)("HttpCommand.getSessionId: url=" + adminConfigData.getAdminServerTaskUrl()));
        String string = null;
        if (adminConfigData != null && (string = (String)this.sessionRegistry.get(adminConfigData.getAdminServerTaskUrl())) == null) {
            try {
                string = this.tryInitialization(this.userId, this.password, this.host, this.port, adminConfigData);
                if (string != null) {
                    this.sessionRegistry.put(adminConfigData.getAdminServerTaskUrl(), string);
                } else {
                    Debug.println((String)("HttpCommand.getSessionId: init failed for " + adminConfigData.getAdminServerTaskUrl()));
                }
            }
            catch (InitializationException initializationException) {
                throw new ConnectException("initialization failed");
            }
        }
        Debug.println((int)6, (String)("HttpCommand.getSessionId: url=" + adminConfigData.getAdminServerTaskUrl() + " session-id=" + string));
        return string;
    }

    private void resetSession(AdminConfigData adminConfigData) {
        Debug.println((int)6, (String)("HttpCommand.resetSession: url=" + adminConfigData.getAdminServerTaskUrl()));
        this.uninitializeUrl(adminConfigData);
    }

    private void uninitializeUrl(AdminConfigData adminConfigData) {
        Debug.println((int)6, (String)("HttpCommand.unitializeUrl: url=" + adminConfigData.getAdminServerTaskUrl()));
        if (adminConfigData != null) {
            this.sessionRegistry.remove(adminConfigData.getAdminServerTaskUrl());
        }
    }
}

