/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel;

import com.iplanet.idar.common.DescriptorMap;
import com.iplanet.idar.objectmodel.HttpCommand;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.AdminConfigData;
import com.iplanet.idar.objectmodel.bean.CreationException;
import com.iplanet.idar.objectmodel.bean.DeletionException;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.IModelBean;
import com.iplanet.idar.objectmodel.bean.IllegalPropertyException;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.objectmodel.bean.UnknownBeanTypeException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.LDAPComm;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import netscape.ldap.util.DN;

public class BeanSpace {
    private static final boolean DEBUG_REG = true;
    private static BeanSpace theInstance = null;
    private static ConsoleInfo info = null;
    private static AdminConfigData[] urls;
    private static final int REG_COLL = 0;
    private static final int REG_BEAN = 1;
    private static final String ERR_PERSIST;
    private static final String ERR_ILLEGAL_PROPERTY;
    private static final int REG_ID = 2;
    private HttpCommand command = null;
    private Hashtable registries = new Hashtable();

    public static void initialize(ConsoleInfo consoleInfo, AdminConfigData[] adminConfigDataArray) throws IllegalArgumentException {
        if (consoleInfo == null || adminConfigDataArray == null) {
            throw new IllegalArgumentException("BeanSpace.initialize: attempted initialization with null data");
        }
        info = consoleInfo;
        urls = adminConfigDataArray;
    }

    public static boolean isInitialized() {
        return info != null;
    }

    public static ConsoleInfo getConsoleInfo() {
        return info;
    }

    public static BeanSpace getInstance() throws IllegalStateException {
        if (theInstance == null) {
            if (!BeanSpace.isInitialized()) {
                throw new IllegalStateException("BeanSpace uninitialized");
            }
            Debug.println((int)7, (String)"BeanSpace.getInstance: creating new BeanSpace...");
            theInstance = new BeanSpace(info, urls);
        }
        Debug.println((String)"BeanSpace.getInstance: 3");
        return theInstance;
    }

    public void addAccessUrl(AdminConfigData adminConfigData) {
        this.command.addBaseUrl(adminConfigData);
    }

    public void addAccessUrls(AdminConfigData[] adminConfigDataArray) {
        for (int i = 0; i < adminConfigDataArray.length; ++i) {
            this.addAccessUrl(adminConfigDataArray[i]);
        }
    }

    public synchronized IDARBeanCollection retrieveBeanCollection(IDARReference iDARReference, Set set) throws RetrievalException, NoSuchBeanException {
        Debug.println((int)6, (String)("BeanSpace.retrieveBeanCollection: config=" + iDARReference + " desc=" + set));
        IDARBeanCollection iDARBeanCollection = this.getCollectionFromRegistry(iDARReference, set);
        if (iDARBeanCollection == null) {
            iDARBeanCollection = new IDARBeanCollection(iDARReference, set);
            iDARBeanCollection.synchronize();
            this.registerCollection(iDARBeanCollection);
        }
        this.dumpCollectionRegistry(iDARReference);
        return iDARBeanCollection;
    }

    public synchronized IDARBeanCollection retrieveBeanCollection(IDARReference iDARReference, String string) throws RetrievalException, NoSuchBeanException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        return this.retrieveBeanCollection(iDARReference, hashSet);
    }

    public synchronized IDARBeanCollection retrieveBeanCollection(IDARReference iDARReference, String[] stringArray) throws RetrievalException, NoSuchBeanException {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        return this.retrieveBeanCollection(iDARReference, hashSet);
    }

    public synchronized IDARModelBean retrieveBean(String string, String string2, IDARReference iDARReference) throws NoSuchBeanException, RetrievalException, UnknownBeanTypeException {
        return this.retrieveBean(this.getBeanReference(string, string2, iDARReference));
    }

    public synchronized IDARModelBean retrieveBean(IDARReference iDARReference) throws NoSuchBeanException, RetrievalException {
        Debug.println((int)6, (String)("BeanSpace.retrieveBean: ref=" + iDARReference));
        IDARModelBean iDARModelBean = null;
        if (iDARReference != null && iDARReference.isValid()) {
            String string = iDARReference.getId();
            String string2 = iDARReference.getDescriptor();
            IDARReference iDARReference2 = iDARReference.getParentConfiguration();
            Hashtable hashtable = this.getBeanRegistry(iDARReference2);
            Debug.println((int)0, (String)(" configuration=" + iDARReference2));
            if (hashtable == null) {
                throw new RetrievalException("can't access bean registry with handle " + iDARReference2);
            }
            String string3 = this.getBeanRegistryKey(string, string2);
            iDARModelBean = (IDARModelBean)hashtable.get(string3);
            if (iDARModelBean == null) {
                iDARModelBean = this.checkRegistryForBeanUnderOldName(iDARReference);
            }
            Debug.println((int)6, (String)("BeanSpace.retrieveBean *** access of bean registry " + iDARReference2.getHandle()));
            Debug.println((int)6, (String)("BeanSpace.retrieveBean ***   " + string3 + " --> " + iDARModelBean));
            if (iDARModelBean == null) {
                Debug.println((int)6, (String)("BeanSpace.retrieveBean: instantiating new bean for " + iDARReference));
                Class clazz = DescriptorMap.lookupBeanClass(string2);
                try {
                    iDARModelBean = (IDARModelBean)this.instantiateBean(clazz);
                }
                catch (CreationException creationException) {
                    throw new RetrievalException(creationException.getMessage());
                }
                catch (ClassCastException classCastException) {
                    classCastException.printStackTrace();
                }
                catch (UnknownBeanTypeException unknownBeanTypeException) {
                    unknownBeanTypeException.printStackTrace();
                }
                if (iDARModelBean == null) {
                    throw new RetrievalException("could not instantiate bean");
                }
                iDARModelBean.setCommand(this.command);
                iDARModelBean.setParentConfiguration(iDARReference2);
                iDARModelBean.setSelfReference(iDARReference);
                if (iDARModelBean instanceof LDAPComm && info != null) {
                    ((LDAPComm)((Object)iDARModelBean)).setLDAPConnection(info.getLDAPConnection());
                }
                iDARModelBean.synchronize();
                hashtable.put(string3, iDARModelBean);
                Debug.println((int)6, (String)("BeanSpace.retrieveBean *** instantiated bean " + iDARModelBean));
                this.dumpCollectionRegistry(iDARReference2);
                this.dumpBeanRegistry(iDARReference2);
                this.dumpIdRegistry(iDARReference2);
                iDARReference.fireBeanLoaded(iDARModelBean);
            }
        }
        return iDARModelBean;
    }

    public synchronized IDARModelBean createBean(IDARReference iDARReference, String string) throws CreationException, UnknownBeanTypeException {
        Debug.println((int)6, (String)("BeanSpace.createBean: desc=" + string));
        Hashtable hashtable = this.getBeanRegistry(iDARReference);
        Hashtable hashtable2 = this.getIdRegistry(iDARReference);
        if (hashtable == null || hashtable2 == null) {
            throw new CreationException("can't access bean registry with key " + iDARReference);
        }
        Class clazz = DescriptorMap.lookupBeanClass(string);
        if (clazz == null) {
            throw new UnknownBeanTypeException("Unknown descriptor " + string + "   DescriptorMap needs updating");
        }
        IDARModelBean iDARModelBean = (IDARModelBean)this.instantiateBean(clazz);
        iDARModelBean.setCommand(this.command);
        iDARModelBean.setParentConfiguration(iDARReference);
        try {
            iDARModelBean.persist();
            String string2 = this.getBeanRegistryKey(iDARModelBean.getId(), iDARModelBean.getDescriptor());
            hashtable.put(string2, iDARModelBean);
            HashSet hashSet = (HashSet)hashtable2.get(string);
            hashSet.add(iDARModelBean.getSelfReference());
            String string3 = IDARUtilities.getDescriptorSuperclass(string);
            if (string3 != null) {
                HashSet hashSet2 = (HashSet)hashtable2.get(string3);
                if (hashSet2 != null) {
                    hashSet2.add(iDARModelBean.getSelfReference());
                }
            } else {
                Debug.println((String)("BeanSpace.createBean:  WARNING: no superclass for descriptor " + string));
            }
            Debug.println((int)1, (String)("BeanSpace.createBean *** created bean " + iDARModelBean));
            this.dumpCollectionRegistry(iDARReference);
            this.dumpBeanRegistry(iDARReference);
            this.dumpIdRegistry(iDARReference);
            this.notifyCollectionsOfNewBean(iDARModelBean);
        }
        catch (UniqueNameException uniqueNameException) {
            uniqueNameException.printStackTrace();
        }
        catch (NoSuchBeanException noSuchBeanException) {
            noSuchBeanException.printStackTrace();
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
            throw new CreationException(ERR_PERSIST, persistenceException.getErrorCode());
        }
        catch (IllegalPropertyException illegalPropertyException) {
            illegalPropertyException.printStackTrace();
            if (illegalPropertyException.getMessage().equals("")) {
                throw new CreationException(ERR_ILLEGAL_PROPERTY);
            }
            throw new CreationException(illegalPropertyException.getMessage());
        }
        return iDARModelBean;
    }

    public synchronized void deleteBean(IDARModelBean iDARModelBean) throws NoSuchBeanException, DeletionException {
        String string;
        Hashtable hashtable = this.getBeanRegistry(iDARModelBean.getParentConfiguration());
        Hashtable hashtable2 = this.getIdRegistry(iDARModelBean.getParentConfiguration());
        if (hashtable == null || hashtable2 == null) {
            throw new DeletionException("can't access registry with dn " + iDARModelBean.getParentConfiguration());
        }
        iDARModelBean.fDelete();
        if (iDARModelBean.getDescriptor().equals("configuration")) {
            Debug.println((String)("BeanSpace.deleteBean:  configuration " + iDARModelBean.getId() + " deleted"));
            this.deleteRegistries(iDARModelBean.getSelfReference());
        }
        this.notifyCollectionsOfDeadBean(iDARModelBean);
        String string2 = this.getBeanRegistryKey(iDARModelBean.getId(), iDARModelBean.getDescriptor());
        hashtable.remove(string2);
        HashSet hashSet = (HashSet)hashtable2.get(iDARModelBean.getDescriptor());
        if (hashSet != null) {
            hashSet.remove(iDARModelBean.getSelfReference());
        }
        if ((string = IDARUtilities.getDescriptorSuperclass(iDARModelBean.getDescriptor())) != null && (hashSet = (HashSet)hashtable2.get(string)) != null) {
            hashSet.remove(iDARModelBean.getSelfReference());
        }
        IDARReference iDARReference = iDARModelBean.getParentConfiguration();
        Debug.println((int)6, (String)("BeanSpace.deleteBean *** delete bean " + iDARModelBean));
        this.dumpCollectionRegistry(iDARReference);
        this.dumpBeanRegistry(iDARReference);
        this.dumpIdRegistry(iDARReference);
        iDARModelBean.fireBeanDeleted();
    }

    public synchronized IDARReference renameBean(IDARModelBean iDARModelBean, String string) throws NoSuchBeanException, PersistenceException {
        Debug.println((String)("BeanSpace.renameBean: bean=" + iDARModelBean + " newId=" + string));
        IDARReference iDARReference = iDARModelBean.getSelfReference();
        Hashtable hashtable = this.getIdRegistry(iDARModelBean.getParentConfiguration());
        Hashtable hashtable2 = this.getBeanRegistry(iDARModelBean.getParentConfiguration());
        if (hashtable == null || hashtable2 == null) {
            throw new PersistenceException("can't access registry with dn " + iDARModelBean.getParentConfiguration());
        }
        String string2 = iDARReference.getId();
        IDARReference iDARReference2 = iDARModelBean.fRename(string);
        String string3 = iDARReference2.getHandle();
        if (iDARModelBean.getDescriptor().equals("configuration")) {
            this.modifyConfigurationChildrenReferences(iDARReference, string3);
            this.moveRegistries(iDARReference.getHandle(), string3);
        }
        String string4 = this.getBeanRegistryKey(string2, iDARModelBean.getDescriptor());
        String string5 = this.getBeanRegistryKey(string, iDARModelBean.getDescriptor());
        hashtable2.remove(string4);
        hashtable2.put(string5, iDARModelBean);
        HashSet hashSet = (HashSet)hashtable.get(iDARModelBean.getDescriptor());
        HashSet hashSet2 = null;
        String string6 = IDARUtilities.getDescriptorSuperclass(iDARModelBean.getDescriptor());
        if (string6 != null) {
            hashSet2 = (HashSet)hashtable.get(string6);
        }
        if (hashSet != null) {
            hashSet.remove(iDARReference);
        }
        if (hashSet2 != null) {
            hashSet2.remove(iDARReference);
        }
        iDARReference.setId(iDARReference2.getId());
        iDARReference.setHandle(iDARReference2.getHandle());
        if (hashSet != null) {
            hashSet.add(iDARReference);
        }
        if (hashSet2 != null) {
            hashSet2.add(iDARReference);
        }
        IDARReference iDARReference3 = iDARModelBean.getParentConfiguration();
        Debug.println((int)6, (String)("BeanSpace.renameBean *** rename bean " + iDARModelBean + " from " + iDARReference.getId() + " to " + string));
        this.dumpCollectionRegistry(iDARReference3);
        this.dumpBeanRegistry(iDARReference3);
        this.dumpIdRegistry(iDARReference3);
        if (iDARModelBean.getDescriptor().equals("configuration")) {
            Debug.println((int)6, (String)("BeanSpace.renameBean *** CONFIGURATION RENAME " + iDARModelBean + " from " + string2 + " to " + string));
            Debug.println((int)6, (String)"BeanSpace.renameBean *** DUMP OF AFFECTED REGISTRIES");
            this.dumpCollectionRegistry(iDARModelBean.getSelfReference());
            this.dumpBeanRegistry(iDARModelBean.getSelfReference());
            this.dumpIdRegistry(iDARModelBean.getSelfReference());
        }
        return iDARReference;
    }

    private void modifyConfigurationChildrenReferences(IDARReference iDARReference, String string) {
        Debug.println((String)("BeanSpace.moveConfiguration: ref=" + iDARReference + " newRef=" + string));
        Hashtable hashtable = this.getIdRegistry(iDARReference);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                HashSet hashSet = (HashSet)enumeration.nextElement();
                HashSet<IDARReference> hashSet2 = new HashSet<IDARReference>();
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    IDARReference iDARReference2 = (IDARReference)iterator.next();
                    iterator.remove();
                    String string2 = iDARReference2.getHandle();
                    int n = string2.lastIndexOf(iDARReference.getHandle());
                    String string3 = null;
                    if (n == -1) {
                        if (-1 == string2.lastIndexOf(string)) {
                            Debug.println((String)("BeanSpace.modifyConfigurationChildrenReferences: ERROR - cant find " + iDARReference.getHandle() + " or " + string + " in current ref " + string2));
                        }
                        string3 = string2;
                    } else {
                        string3 = string2.substring(0, n) + string;
                    }
                    iDARReference2.setHandle(string3);
                    hashSet2.add(iDARReference2);
                }
                hashSet.addAll(hashSet2);
            }
        }
    }

    private BeanSpace(ConsoleInfo consoleInfo, AdminConfigData[] adminConfigDataArray) {
        Debug.println((String)"BeanSpace: creating new BeanSpace ...");
        String string = consoleInfo.getAuthenticationDN();
        String string2 = consoleInfo.getAuthenticationPassword();
        this.command = new HttpCommand(string, string2, consoleInfo.getLDAPConnection(), adminConfigDataArray);
    }

    private Hashtable getRegistry(IDARReference iDARReference, int n) {
        Hashtable hashtable = null;
        if (iDARReference != null) {
            Debug.println((int)5, (String)("finding registry for configuration with DN=" + iDARReference.getHandle()));
            String string = iDARReference.getHandle();
            if (string != null) {
                Hashtable[] hashtableArray = (Hashtable[])this.registries.get(string);
                if (hashtableArray == null) {
                    hashtableArray = new Hashtable[]{new Hashtable(), new Hashtable(), new Hashtable()};
                    this.registries.put(string, hashtableArray);
                }
                hashtable = hashtableArray[n];
            } else {
                Debug.println((int)0, (String)("FAILED TO FIND ENTRY IN REGISTRY FOR CONFIGURATION: " + iDARReference.getId()));
            }
        }
        return hashtable;
    }

    private void deleteRegistries(IDARReference iDARReference) {
        String string = iDARReference.getHandle();
        if (string != null) {
            this.registries.remove(string);
        }
    }

    private void moveRegistries(String string, String string2) {
        Hashtable[] hashtableArray;
        if (string != null && (hashtableArray = (Hashtable[])this.registries.remove(string)) != null && string2 != null) {
            this.registries.put(string2, hashtableArray);
        }
    }

    private Hashtable getIdRegistry(IDARReference iDARReference) {
        return this.getRegistry(iDARReference, 2);
    }

    private Hashtable getBeanRegistry(IDARReference iDARReference) {
        return this.getRegistry(iDARReference, 1);
    }

    private Hashtable getCollectionRegistry(IDARReference iDARReference) {
        return this.getRegistry(iDARReference, 0);
    }

    private IDARBeanCollection getCollectionFromRegistry(IDARReference iDARReference, Set set) {
        IDARBeanCollection iDARBeanCollection = null;
        Hashtable hashtable = this.getCollectionRegistry(iDARReference);
        if (hashtable != null && set != null) {
            Collection collection = hashtable.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Vector vector = (Vector)iterator.next();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    IDARBeanCollection iDARBeanCollection2 = (IDARBeanCollection)enumeration.nextElement();
                    if (!((Object)set).equals(iDARBeanCollection2.getDescriptorSet())) continue;
                    iDARBeanCollection = iDARBeanCollection2;
                    break;
                }
                if (iDARBeanCollection == null) continue;
                break;
            }
        }
        return iDARBeanCollection;
    }

    private void registerCollection(IDARBeanCollection iDARBeanCollection) {
        if (iDARBeanCollection != null) {
            int n;
            Object object;
            String[] stringArray = iDARBeanCollection.getDescriptors();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                object = IDARUtilities.getDescriptorSubclasses(stringArray[i]);
                vector.add(stringArray[i]);
                if (object == null) continue;
                for (n = 0; n < ((String[])object).length; ++n) {
                    vector.add(object[n]);
                }
            }
            String[] stringArray2 = new String[]{};
            stringArray2 = vector.toArray(stringArray2);
            object = this.getCollectionRegistry(iDARBeanCollection.getParentConfiguration());
            if (object != null) {
                for (n = 0; n < stringArray2.length; ++n) {
                    Vector<IDARBeanCollection> vector2 = (Vector<IDARBeanCollection>)((Hashtable)object).get(stringArray2[n]);
                    if (vector2 == null) {
                        vector2 = new Vector<IDARBeanCollection>();
                    }
                    vector2.add(iDARBeanCollection);
                    ((Hashtable)object).put(stringArray2[n], vector2);
                }
            } else {
                Debug.println((String)("BeanSpace.registerCollection:  ERROR: can't access collection registry with handle " + iDARBeanCollection.getParentConfiguration().getHandle()));
            }
            this.dumpCollectionRegistry(iDARBeanCollection.getParentConfiguration());
        }
    }

    private synchronized void notifyCollectionsOfNewBean(IDARModelBean iDARModelBean) {
        Debug.println((String)("BeanSpace.notifyCollectionsOfNewBean: bean=" + iDARModelBean));
        String string = iDARModelBean.getDescriptor();
        Hashtable hashtable = this.getCollectionRegistry(iDARModelBean.getParentConfiguration());
        if (hashtable != null) {
            Vector vector = (Vector)hashtable.get(string);
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    IDARBeanCollection iDARBeanCollection = (IDARBeanCollection)enumeration.nextElement();
                    Debug.println((int)6, (String)("BeanSpace.notifyCollectionsOfNewBean: collection=" + iDARBeanCollection));
                    iDARBeanCollection.addBean(iDARModelBean);
                }
            }
        } else {
            Debug.println((String)("BeanSpace.notifyCollectionsOfNewBean:  ERROR: can't access collection registry with handle " + iDARModelBean.getParentConfiguration().getHandle()));
        }
    }

    private synchronized void notifyCollectionsOfDeadBean(IDARModelBean iDARModelBean) {
        Debug.println((String)("BeanSpace.notifyCollectionsOfDeadBean: bean=" + iDARModelBean));
        String string = iDARModelBean.getDescriptor();
        Hashtable hashtable = this.getCollectionRegistry(iDARModelBean.getParentConfiguration());
        if (hashtable != null) {
            Vector vector = (Vector)hashtable.get(string);
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    IDARBeanCollection iDARBeanCollection = (IDARBeanCollection)enumeration.nextElement();
                    Debug.println((int)6, (String)("BeanSpace.notifyCollectionsOfDeadBean: collection=" + iDARBeanCollection));
                    iDARBeanCollection.removeBean(iDARModelBean);
                }
            }
        } else {
            Debug.println((String)("BeanSpace.notifyCollectionsOfDeadBean:  ERROR: can't access collection registry with handle " + iDARModelBean.getParentConfiguration().getHandle()));
        }
    }

    private String getBeanRegistryKey(String string, String string2) {
        return string + ":" + string2;
    }

    private IModelBean instantiateBean(Class clazz) throws CreationException, UnknownBeanTypeException {
        IModelBean iModelBean = null;
        if (clazz != null) {
            try {
                iModelBean = (IModelBean)clazz.newInstance();
            }
            catch (ClassCastException classCastException) {
                classCastException.printStackTrace();
                throw new CreationException(classCastException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                throw new UnknownBeanTypeException(illegalAccessException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                throw new CreationException(instantiationException.getMessage());
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                exceptionInInitializerError.printStackTrace();
                throw new CreationException(exceptionInInitializerError.getMessage());
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                throw new CreationException(securityException.getMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                throw new CreationException(illegalArgumentException.getMessage());
            }
        }
        return iModelBean;
    }

    public Vector getExistingClientAndServerSideIdsAsVector(IDARReference iDARReference, String string) throws RetrievalException {
        IDARReference[] iDARReferenceArray = this.getExistingInstanceReferences(iDARReference, string);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < iDARReferenceArray.length; ++i) {
            vector.add(iDARReferenceArray[i].getId());
            String[] stringArray = iDARReferenceArray[i].getOldIds();
            if (stringArray == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                vector.add(stringArray[j]);
            }
        }
        return vector;
    }

    public String[] getExistingClientAndServerSideIds(IDARReference iDARReference, String string) throws RetrievalException {
        Debug.println((String)("BeanSpace.getExistingClientAndServerSideIds: desc=" + string));
        Vector vector = this.getExistingClientAndServerSideIdsAsVector(iDARReference, string);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public IDARReference[] getExistingInstanceReferences(IDARReference iDARReference, String string) throws RetrievalException {
        HashSet<IDARReference> hashSet;
        Debug.println((String)("BeanSpace.getExistingInstanceReferences: config=" + iDARReference + " desc=" + string));
        IDARReference[] iDARReferenceArray = null;
        Hashtable hashtable = this.getIdRegistry(iDARReference);
        String string2 = IDARUtilities.getDescriptorSuperclass(string);
        if (string2 != null && (hashSet = (HashSet<IDARReference>)hashtable.get(string2)) == null) {
            this.getExistingInstanceReferences(iDARReference, string2);
        }
        if ((hashSet = (HashSet)hashtable.get(string)) == null) {
            hashSet = new HashSet<IDARReference>();
            iDARReferenceArray = this.command.queryIds(iDARReference, string);
            for (int i = 0; i < iDARReferenceArray.length; ++i) {
                hashSet.add(iDARReferenceArray[i]);
                String string3 = iDARReferenceArray[i].getDescriptor();
                if (string3 != null) {
                    if (string3.equals(string)) continue;
                    HashSet<IDARReference> hashSet2 = (HashSet<IDARReference>)hashtable.get(string3);
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<IDARReference>();
                        hashtable.put(string3, hashSet2);
                    }
                    hashSet2.add(iDARReferenceArray[i]);
                    continue;
                }
                Debug.println((String)("BeanSpace.getExistingInstanceReferences: ERROR: ref " + iDARReferenceArray[i] + " is malformed"));
            }
            hashtable.put(string, hashSet);
            this.dumpIdRegistry(iDARReference);
        } else {
            iDARReferenceArray = new IDARReference[hashSet.size()];
            iDARReferenceArray = hashSet.toArray(iDARReferenceArray);
        }
        return iDARReferenceArray;
    }

    public boolean idIsUnique(IDARReference iDARReference, String string, String string2) throws RetrievalException {
        Debug.println((int)6, (String)("BeanSpace.idIsUnique: config=" + iDARReference + " id=" + string + " desc=" + string2));
        boolean bl = true;
        String string3 = null;
        string3 = IDARUtilities.getDescriptorSuperclass(string2);
        if (string3 == null) {
            string3 = string2;
        }
        String[] stringArray = this.getExistingClientAndServerSideIds(iDARReference, string3);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean beanHasBeenLoaded(IDARReference iDARReference) {
        Debug.println((int)6, (String)("BeanSpace.beanHasBeenLoaded: ref=" + iDARReference));
        boolean bl = false;
        if (iDARReference != null && iDARReference.isValid()) {
            String string = iDARReference.getId();
            String string2 = iDARReference.getDescriptor();
            IDARReference iDARReference2 = iDARReference.getParentConfiguration();
            Hashtable hashtable = this.getBeanRegistry(iDARReference2);
            if (hashtable != null) {
                String string3 = this.getBeanRegistryKey(string, string2);
                IDARModelBean iDARModelBean = (IDARModelBean)hashtable.get(string3);
                if (iDARModelBean != null) {
                    bl = true;
                } else {
                    iDARModelBean = this.checkRegistryForBeanUnderOldName(iDARReference);
                    if (iDARModelBean != null) {
                        bl = true;
                    }
                }
            }
        }
        Debug.println((int)6, (String)("BeanSpace.beanHasBeenLoaded: loaded=" + bl));
        return bl;
    }

    public IDARReference getBeanReferenceByDn(DN dN, String string, IDARReference iDARReference) throws RetrievalException {
        Debug.println((String)("BeanSpace.getBeanReferenceByDn: dn=" + dN + " desc=" + string + " config=" + iDARReference));
        IDARReference iDARReference2 = null;
        if (dN != null && !dN.toString().trim().equals("") && string != null && iDARReference != null) {
            IDARReference[] iDARReferenceArray = this.getExistingInstanceReferences(iDARReference, string);
            for (int i = 0; i < iDARReferenceArray.length; ++i) {
                DN dN2 = new DN(iDARReferenceArray[i].getHandle());
                if (!dN.equals(dN2)) continue;
                iDARReference2 = iDARReferenceArray[i];
                break;
            }
        }
        return iDARReference2;
    }

    public IDARReference getBeanReference(String string, String string2, IDARReference iDARReference) throws RetrievalException {
        Debug.println((String)("BeanSpace.getBeanReference: id=" + string + " desc=" + string2 + " config=" + iDARReference));
        IDARReference iDARReference2 = null;
        if (string != null && string2 != null && iDARReference != null) {
            int n;
            IDARReference[] iDARReferenceArray = this.getExistingInstanceReferences(iDARReference, string2);
            for (n = 0; n < iDARReferenceArray.length; ++n) {
                if (!string.equals(iDARReferenceArray[n].getId())) continue;
                iDARReference2 = iDARReferenceArray[n];
                break;
            }
            if (iDARReference2 == null) {
                block1: for (n = 0; n < iDARReferenceArray.length; ++n) {
                    String[] stringArray = iDARReferenceArray[n].getOldIds();
                    if (stringArray == null) continue;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string.equals(stringArray[i])) continue;
                        Debug.println((String)("BeanSpace.getBeanReference: request for old id " + string + " satisfied"));
                        iDARReference2 = iDARReferenceArray[n];
                        continue block1;
                    }
                }
            }
        }
        Debug.println((String)("BeanSpace.getBeanReference: ref=" + iDARReference2));
        return iDARReference2;
    }

    public IDARReference getServerReference(String string) {
        DN dN;
        Debug.println((int)6, (String)("BeanSpace.getServerReference:  dnString=" + string));
        IDARReference iDARReference = null;
        if (string != null && !(dN = new DN(string)).toString().trim().equals("")) {
            try {
                IDARReference[] iDARReferenceArray = this.getExistingInstanceReferences(IDARReference.NULL_REFERENCE, "idar-server");
                for (int i = 0; i < iDARReferenceArray.length; ++i) {
                    DN dN2 = new DN(iDARReferenceArray[i].getHandle());
                    if (!dN.equals(dN2)) continue;
                    iDARReference = iDARReferenceArray[i];
                    break;
                }
            }
            catch (IDARBeanException iDARBeanException) {
                Debug.println((String)("BeanSpace.getServerReference: ERROR " + iDARBeanException));
            }
        }
        Debug.println((int)6, (String)("BeanSpace.getServerReference:  ref=" + iDARReference));
        return iDARReference;
    }

    private void dumpIdRegistry(IDARReference iDARReference) {
        Hashtable hashtable = this.getIdRegistry(iDARReference);
        Debug.println((int)6, (String)("*** dump id registry " + iDARReference + ":"));
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            HashSet hashSet = (HashSet)hashtable.get(string);
            Debug.println((int)6, (String)("***   " + string));
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Debug.println((int)6, (String)("***     " + iterator.next()));
            }
        }
    }

    private void dumpBeanRegistry(IDARReference iDARReference) {
        Hashtable hashtable = this.getBeanRegistry(iDARReference);
        Debug.println((int)6, (String)("*** dump bean registry " + iDARReference + ":"));
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            IDARModelBean iDARModelBean = (IDARModelBean)hashtable.get(string);
            Debug.println((int)6, (String)("***      " + string + " --> " + iDARModelBean.toString()));
        }
    }

    private void dumpCollectionRegistry(IDARReference iDARReference) {
        Hashtable hashtable = this.getCollectionRegistry(iDARReference);
        Debug.println((int)6, (String)("*** dump collection registry " + iDARReference + ":"));
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            Debug.println((int)6, (String)("***   " + string));
            Vector vector = (Vector)hashtable.get(string);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Debug.println((int)6, (String)("***     " + enumeration2.nextElement()));
            }
        }
    }

    private IDARModelBean checkRegistryForBeanUnderOldName(IDARReference iDARReference) {
        IDARModelBean iDARModelBean = null;
        if (iDARReference != null) {
            String[] stringArray = iDARReference.getOldIds();
            String string = iDARReference.getDescriptor();
            IDARReference iDARReference2 = iDARReference.getParentConfiguration();
            Hashtable hashtable = this.getBeanRegistry(iDARReference2);
            if (stringArray != null && stringArray.length > 0) {
                String string2 = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = this.getBeanRegistryKey(stringArray[i], string);
                    iDARModelBean = (IDARModelBean)hashtable.get(string2);
                    if (iDARModelBean == null) continue;
                    Debug.println((int)6, (String)("BeanSpace.checkRegistryForBeanUnderOldName: bean found under old name " + stringArray[i]));
                    break;
                }
                if (iDARModelBean != null) {
                    hashtable.remove(string2);
                    String string3 = this.getBeanRegistryKey(iDARReference.getId(), string);
                    hashtable.put(string3, iDARModelBean);
                } else {
                    Debug.println((int)6, (String)"BeanSpace.checkRegistryForBeanUnderOldName: bean not found under old ids");
                }
            }
        }
        return iDARModelBean;
    }

    public AdminConfigData[] getUrls() {
        return urls;
    }

    static {
        ERR_PERSIST = IDARResourceSet.getString("error", "ERR_PERSIST");
        ERR_ILLEGAL_PROPERTY = IDARResourceSet.getString("error", "ERR_ILLEGAL_PROPERTY");
    }
}

