/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ldap.task;

import com.iplanet.idar.ldap.LdapServer;
import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class LdapPingTask
extends AbstractTask {
    private LdapServer server = null;
    private String userId = null;
    private String password = null;

    public LdapPingTask(LdapServer ldapServer) {
        this.server = ldapServer;
    }

    public String getName() {
        return IDARResourceSet.getString("taskLdapPing", "NAME_SHORT");
    }

    public String getDescription() {
        return IDARResourceSet.getString("taskLdapPing", "DESCRIPTION");
    }

    public boolean isExecutable() {
        return this.server != null;
    }

    public int doExecute() {
        Debug.println((String)"LdapPingTask.doExecute");
        int n = -1;
        if (this.isExecutable()) {
            String string = this.server.getHostName();
            Integer n2 = this.server.getPort();
            if (string != null && n2 != null) {
                LDAPConnection lDAPConnection = new LDAPConnection();
                lDAPConnection.setConnectTimeout(5);
                try {
                    if (this.userId != null && this.password != null) {
                        lDAPConnection.connect(string, n2.intValue(), this.userId, this.password);
                    } else {
                        lDAPConnection.connect(string, n2.intValue());
                    }
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }
}

