/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.Namespaces;
import com.sun.mail.util.i18n.StringManager;
import java.io.IOException;
import java.util.Vector;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.URLName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IMAPStore
extends Store
implements ResponseHandler {
    private String name = "imap";
    private int blksize = 16384;
    private int port = 143;
    private int statusCacheTimeout = 1000;
    private int appendBufferSize = -1;
    private String host;
    private String user;
    private String password;
    private Namespaces namespaces;
    private boolean debug = false;
    private static Log _logger = LogFactory.getLog((String)"javax.enterprise.resource.javamail");
    private static StringManager localStrings = StringManager.getManager("com.sun.mail");
    private ConnectionPool pool = new ConnectionPool();

    public IMAPStore(Session session, URLName uRLName) {
        super(session, uRLName);
        int n;
        this.pool.lastTimePruned = System.currentTimeMillis();
        this.debug = session.getDebug();
        String string = session.getProperty("mail." + this.name + ".connectionpool.debug");
        if (string != null && string.equalsIgnoreCase("true")) {
            this.pool.debug = true;
        }
        if (uRLName != null) {
            this.name = uRLName.getProtocol();
        }
        if ((string = session.getProperty("mail." + this.name + ".partialfetch")) != null && string.equalsIgnoreCase("false")) {
            this.blksize = -1;
        } else {
            string = session.getProperty("mail." + this.name + ".fetchsize");
            if (string != null) {
                this.blksize = Integer.parseInt(string);
            }
        }
        string = session.getProperty("mail." + this.name + ".statuscachetimeout");
        if (string != null) {
            this.statusCacheTimeout = Integer.parseInt(string);
        }
        if ((string = session.getProperty("mail." + this.name + ".appendbuffersize")) != null) {
            this.appendBufferSize = Integer.parseInt(string);
        }
        if ((string = session.getProperty("mail." + this.name + ".connectionpoolsize")) != null) {
            try {
                n = Integer.parseInt(string);
                if (n > 0) {
                    this.pool.poolSize = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.pool.debug && _logger.isDebugEnabled()) {
                String string2 = localStrings.getString("java_mail.found_pool_size_prop");
                _logger.debug((Object)(string2 + this.pool.poolSize));
            }
        }
        if ((string = session.getProperty("mail." + this.name + ".connectionpooltimeout")) != null) {
            try {
                n = Integer.parseInt(string);
                if (n > 0) {
                    this.pool.clientTimeoutInterval = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.pool.debug && _logger.isDebugEnabled()) {
                String string3 = localStrings.getString("java_mail.found_timeout_prop");
                _logger.debug((Object)(string3 + this.pool.clientTimeoutInterval));
            }
        }
        if ((string = session.getProperty("mail." + this.name + ".separatestoreconnection")) != null && string.equalsIgnoreCase("true")) {
            if (this.pool.debug && _logger.isDebugEnabled()) {
                String string4 = localStrings.getString("java_mail.dedicate_store_conn");
                _logger.debug((Object)string4);
            }
            this.pool.separateStoreConnection = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean protocolConnect(String string, int n, String string2, String string3) throws MessagingException {
        block15: {
            IMAPProtocol iMAPProtocol = null;
            if (string == null || string3 == null || string2 == null) {
                return false;
            }
            if (n != -1) {
                this.port = n;
            } else {
                String string4 = this.session.getProperty("mail." + this.name + ".port");
                if (string4 != null) {
                    this.port = Integer.parseInt(string4);
                }
            }
            if (this.port == -1) {
                this.port = 143;
            }
            try {
                boolean bl;
                ConnectionPool connectionPool = this.pool;
                synchronized (connectionPool) {
                    bl = this.pool.authenticatedConnections.isEmpty();
                }
                if (!bl) break block15;
                iMAPProtocol = new IMAPProtocol(this.name, string, this.port, this.session.getDebug(), this.session.getProperties());
                this.login(iMAPProtocol, string2, string3);
                iMAPProtocol.addResponseHandler(this);
                this.host = string;
                this.user = string2;
                this.password = string3;
                ConnectionPool connectionPool2 = this.pool;
                synchronized (connectionPool2) {
                    this.pool.authenticatedConnections.addElement(iMAPProtocol);
                }
            }
            catch (CommandFailedException commandFailedException) {
                iMAPProtocol.disconnect();
                iMAPProtocol = null;
                throw new AuthenticationFailedException(commandFailedException.getResponse().getRest());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            catch (IOException iOException) {
                throw new MessagingException(iOException.getMessage(), iOException);
            }
        }
        return true;
    }

    private void login(IMAPProtocol iMAPProtocol, String string, String string2) throws ProtocolException {
        if (iMAPProtocol.isAuthenticated()) {
            return;
        }
        if (iMAPProtocol.hasCapability("AUTH-LOGIN") || iMAPProtocol.hasCapability("AUTH=LOGIN")) {
            iMAPProtocol.authlogin(string, string2);
        } else {
            iMAPProtocol.login(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMAPProtocol getProtocol(IMAPFolder iMAPFolder) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.authenticatedConnections.isEmpty() || this.pool.separateStoreConnection && this.pool.authenticatedConnections.size() == 1 || this.pool.borrowedStoreConnections > 0L && this.pool.authenticatedConnections.size() == 1) {
                if (this.debug && _logger.isDebugEnabled()) {
                    String string = localStrings.getString("java_mail.no_connections_in_pool");
                    _logger.debug((Object)string);
                }
                try {
                    iMAPProtocol = new IMAPProtocol(this.name, this.host, this.port, this.session.getDebug(), this.session.getProperties());
                    this.login(iMAPProtocol, this.user, this.password);
                }
                catch (Exception exception) {
                    if (iMAPProtocol != null) {
                        try {
                            iMAPProtocol.disconnect();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    iMAPProtocol = null;
                }
                if (iMAPProtocol == null) {
                    throw new MessagingException("connection failure");
                }
            } else {
                if (this.debug && _logger.isDebugEnabled()) {
                    String string = localStrings.getString("java_mail.connections_avail");
                    _logger.debug((Object)(string + this.pool.authenticatedConnections.size()));
                }
                iMAPProtocol = (IMAPProtocol)this.pool.authenticatedConnections.lastElement();
                iMAPProtocol.removeResponseHandler(this);
                this.pool.authenticatedConnections.removeElement(iMAPProtocol);
            }
            this.timeoutConnections();
            if (iMAPFolder != null) {
                if (this.pool.folders == null) {
                    this.pool.folders = new Vector();
                }
                this.pool.folders.addElement(iMAPFolder);
            }
        }
        return iMAPProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMAPProtocol getStoreProtocol() throws ProtocolException {
        IMAPProtocol iMAPProtocol = null;
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            String string;
            if (this.pool.authenticatedConnections.isEmpty()) {
                if (this.pool.debug && _logger.isDebugEnabled()) {
                    string = localStrings.getString("java_mail.no_connections_in_pool");
                    _logger.debug((Object)string);
                }
                try {
                    iMAPProtocol = new IMAPProtocol(this.name, this.host, this.port, this.session.getDebug(), this.session.getProperties());
                    this.login(iMAPProtocol, this.user, this.password);
                }
                catch (Exception exception) {
                    if (iMAPProtocol != null) {
                        try {
                            iMAPProtocol.logout();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    iMAPProtocol = null;
                }
                if (iMAPProtocol == null) {
                    throw new ProtocolException("connection failure");
                }
                iMAPProtocol.addResponseHandler(this);
                this.pool.authenticatedConnections.addElement(iMAPProtocol);
            } else {
                if (this.pool.debug && _logger.isDebugEnabled()) {
                    string = localStrings.getString("java_mail.connections_avail");
                    _logger.debug((Object)(string + this.pool.authenticatedConnections.size()));
                }
                iMAPProtocol = (IMAPProtocol)this.pool.authenticatedConnections.firstElement();
            }
            if (!this.pool.separateStoreConnection) {
                this.pool.borrowedStoreConnections++;
                if (this.pool.debug && _logger.isDebugEnabled()) {
                    string = localStrings.getString("java_mail.borrowed_connection");
                    _logger.debug((Object)(string + this.pool.borrowedStoreConnections));
                }
            }
            this.timeoutConnections();
            return iMAPProtocol;
        }
    }

    boolean hasSeparateStoreConnection() {
        return this.pool.separateStoreConnection;
    }

    boolean getConnectionPoolDebug() {
        return this.pool.debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isConnectionPoolFull() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.debug && _logger.isDebugEnabled()) {
                String string = localStrings.getString("java_mail.current_pool_size");
                _logger.debug((Object)(string + this.pool.poolSize));
            }
            return this.pool.authenticatedConnections.size() >= this.pool.poolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseProtocol(IMAPFolder iMAPFolder, IMAPProtocol iMAPProtocol) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (iMAPProtocol != null) {
                if (!this.isConnectionPoolFull()) {
                    iMAPProtocol.addResponseHandler(this);
                    this.pool.authenticatedConnections.addElement(iMAPProtocol);
                    if (this.debug && _logger.isDebugEnabled()) {
                        String string = localStrings.getString("java_mail.added_auth_conn");
                        _logger.debug((Object)(string + this.pool.authenticatedConnections.size()));
                    }
                } else {
                    if (this.debug && _logger.isDebugEnabled()) {
                        String string = localStrings.getString("java_mail.pool_full");
                        _logger.debug((Object)string);
                    }
                    try {
                        iMAPProtocol.logout();
                    }
                    catch (ProtocolException protocolException) {
                        // empty catch block
                    }
                }
            }
            if (this.pool.folders != null) {
                this.pool.folders.removeElement(iMAPFolder);
            }
            this.timeoutConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseStoreProtocol(IMAPProtocol iMAPProtocol) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (!this.pool.separateStoreConnection) {
                this.pool.borrowedStoreConnections--;
                if (this.pool.debug && _logger.isDebugEnabled()) {
                    String string = localStrings.getString("java_mail.borrowed_stored_connection");
                    _logger.debug((Object)(string + this.pool.borrowedStoreConnections));
                }
            }
            this.timeoutConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyConnectionPool() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            int n = this.pool.authenticatedConnections.size() - 1;
            while (n >= 0) {
                try {
                    ((IMAPProtocol)this.pool.authenticatedConnections.elementAt(n)).removeResponseHandler(this);
                    ((IMAPProtocol)this.pool.authenticatedConnections.elementAt(n)).logout();
                }
                catch (ProtocolException protocolException) {
                    // empty catch block
                }
                --n;
            }
            this.pool.authenticatedConnections.removeAllElements();
        }
        if (this.pool.debug && _logger.isDebugEnabled()) {
            String string = localStrings.getString("java_mail.removed_auth_conn");
            _logger.debug((Object)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutConnections() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (System.currentTimeMillis() - this.pool.lastTimePruned > this.pool.pruningInterval && this.pool.authenticatedConnections.size() > 1) {
                Object object;
                if (this.pool.debug && _logger.isDebugEnabled()) {
                    object = localStrings.getString("java_mail.check_conn_prune");
                    String string = localStrings.getString("java_mail.client_timeout_interval");
                    _logger.debug((Object)((String)object + (System.currentTimeMillis() - this.pool.lastTimePruned)));
                    _logger.debug((Object)(string + this.pool.clientTimeoutInterval));
                }
                int n = this.pool.authenticatedConnections.size() - 1;
                while (n > 0) {
                    String string;
                    object = (IMAPProtocol)this.pool.authenticatedConnections.elementAt(n);
                    if (this.pool.debug && _logger.isDebugEnabled()) {
                        string = localStrings.getString("java_mail.last_protocol_used");
                        _logger.debug((Object)(string + (System.currentTimeMillis() - ((Protocol)object).getTimestamp())));
                    }
                    if (System.currentTimeMillis() - ((Protocol)object).getTimestamp() > this.pool.clientTimeoutInterval) {
                        if (this.pool.debug && _logger.isDebugEnabled()) {
                            string = localStrings.getString("java_mail.auth_conn_timed_out");
                            String string2 = localStrings.getString("java_mail.loggin_out_conn");
                            _logger.debug((Object)string);
                            _logger.debug((Object)string2);
                        }
                        ((Protocol)object).removeResponseHandler(this);
                        this.pool.authenticatedConnections.removeElementAt(n);
                        try {
                            ((IMAPProtocol)object).logout();
                        }
                        catch (ProtocolException protocolException) {
                            // empty catch block
                        }
                    }
                    --n;
                }
                this.pool.lastTimePruned = System.currentTimeMillis();
            }
        }
    }

    int getFetchBlockSize() {
        return this.blksize;
    }

    Session getSession() {
        return this.session;
    }

    int getStatusCacheTimeout() {
        return this.statusCacheTimeout;
    }

    int getAppendBufferSize() {
        return this.appendBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                iMAPProtocol.noop();
            }
            catch (ProtocolException protocolException) {
                Object var4_3 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            Object var4_2 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return super.isConnected();
    }

    public void close() throws MessagingException {
        if (!super.isConnected()) {
            return;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                iMAPProtocol.logout();
            }
            catch (ProtocolException protocolException) {
                this.cleanup();
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            Object var4_2 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanup() {
        ConnectionPool connectionPool;
        Vector vector = null;
        boolean bl = true;
        block10: while (true) {
            connectionPool = this.pool;
            synchronized (connectionPool) {
                if (this.pool.folders != null) {
                    bl = false;
                    vector = this.pool.folders;
                    this.pool.folders = null;
                } else {
                    bl = true;
                }
            }
            if (bl) break;
            int n = 0;
            int n2 = vector.size();
            while (true) {
                if (n >= n2) continue block10;
                IMAPFolder iMAPFolder = (IMAPFolder)vector.elementAt(n);
                try {
                    iMAPFolder.close(false);
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                ++n;
            }
            break;
        }
        connectionPool = this.pool;
        synchronized (connectionPool) {
            this.emptyConnectionPool();
        }
        try {
            super.close();
        }
        catch (MessagingException messagingException) {}
    }

    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new DefaultFolder(this);
    }

    public Folder getFolder(String string) throws MessagingException {
        this.checkConnected();
        return new IMAPFolder(string, '\uffff', this);
    }

    public Folder getFolder(URLName uRLName) throws MessagingException {
        this.checkConnected();
        return new IMAPFolder(uRLName.getFile(), '\uffff', this);
    }

    public Folder[] getPersonalNamespaces() throws MessagingException {
        Namespaces namespaces = this.getNamespaces();
        if (namespaces == null || namespaces.personal == null) {
            return super.getPersonalNamespaces();
        }
        return this.namespaceToFolders(namespaces.personal, null);
    }

    public Folder[] getUserNamespaces(String string) throws MessagingException {
        Namespaces namespaces = this.getNamespaces();
        if (namespaces == null || namespaces.otherUsers == null) {
            return super.getUserNamespaces(string);
        }
        return this.namespaceToFolders(namespaces.otherUsers, string);
    }

    public Folder[] getSharedNamespaces() throws MessagingException {
        Namespaces namespaces = this.getNamespaces();
        if (namespaces == null || namespaces.shared == null) {
            return super.getSharedNamespaces();
        }
        return this.namespaceToFolders(namespaces.shared, null);
    }

    private synchronized Namespaces getNamespaces() throws MessagingException {
        block6: {
            this.checkConnected();
            IMAPProtocol iMAPProtocol = null;
            if (this.namespaces == null) {
                try {
                    try {
                        iMAPProtocol = this.getStoreProtocol();
                        this.namespaces = iMAPProtocol.namespace();
                    }
                    catch (BadCommandException badCommandException) {
                        Object var5_3 = null;
                        this.releaseStoreProtocol(iMAPProtocol);
                        break block6;
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                    Object var5_2 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    throw throwable;
                }
            }
        }
        return this.namespaces;
    }

    private Folder[] namespaceToFolders(Namespaces.Namespace[] namespaceArray, String string) {
        Folder[] folderArray = new Folder[namespaceArray.length];
        int n = 0;
        while (n < folderArray.length) {
            String string2 = namespaceArray[n].prefix;
            if (string == null) {
                int n2 = string2.length();
                if (n2 > 0 && string2.charAt(n2 - 1) == namespaceArray[n].delimiter) {
                    string2 = string2.substring(0, n2 - 1);
                }
            } else {
                string2 = string2 + string;
            }
            folderArray[n] = new IMAPFolder(string2, namespaceArray[n].delimiter, this);
            ++n;
        }
        return folderArray;
    }

    public Quota[] getQuota(String string) throws MessagingException {
        Quota[] quotaArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                quotaArray = iMAPProtocol.getQuotaRoot(string);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("QUOTA not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            Object var8_4 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return quotaArray;
    }

    public void setQuota(Quota quota) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                iMAPProtocol.setQuota(quota);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("QUOTA not supported", badCommandException);
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            Object var7_3 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    private void checkConnected() {
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    public void handleResponse(Response response) {
        if (response.isBYE()) {
            if (super.isConnected()) {
                this.cleanup();
            }
            return;
        }
        if (response.isOK()) {
            String string = response.toString();
            if (string.indexOf("ALERT") != -1) {
                this.notifyStoreListeners(1, string);
            } else {
                this.notifyStoreListeners(2, string);
            }
        }
    }

    static class ConnectionPool {
        private Vector authenticatedConnections = new Vector();
        private Vector folders;
        private boolean separateStoreConnection = false;
        private long borrowedStoreConnections = 0L;
        private long clientTimeoutInterval = 45000L;
        private long lastTimePruned;
        private int poolSize = 1;
        private long pruningInterval = 60000L;
        private boolean debug = false;

        ConnectionPool() {
        }
    }
}

