/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Properties;

public class SocketFetcher
implements Runnable {
    private Socket socket;
    private String host;
    private int port;
    private Properties props;
    private String prefix;
    private int cto;
    private IOException exception;
    private boolean aborted = false;
    private boolean done = false;
    static /* synthetic */ Class class$java$lang$String;

    private SocketFetcher(String string, int n, Properties properties, String string2, int n2) throws IOException {
        this.host = string;
        this.port = n;
        this.props = properties;
        this.prefix = string2;
        this.cto = n2;
    }

    public static Socket getSocket(String string, int n, Properties properties, String string2) throws IOException {
        if (string2 == null) {
            string2 = "socket";
        }
        if (properties == null) {
            properties = new Properties();
        }
        String string3 = properties.getProperty(string2 + ".connectiontimeout", null);
        int n2 = -1;
        if (string3 != null) {
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n2 > 0) {
            SocketFetcher socketFetcher = new SocketFetcher(string, n, properties, string2, n2);
            try {
                Thread thread = new Thread((Runnable)socketFetcher, "Connection thread for host " + string);
                thread.start();
            }
            catch (Exception exception) {
                return SocketFetcher.getSocket0(string, n, properties, string2);
            }
            return socketFetcher.getSocket();
        }
        return SocketFetcher.getSocket0(string, n, properties, string2);
    }

    private static Socket getSocket0(String string, int n, Properties properties, String string2) throws IOException {
        Socket socket = null;
        String string3 = properties.getProperty(string2 + ".socketFactory.class", null);
        String string4 = properties.getProperty(string2 + ".timeout", null);
        if (string3 == null || string3.length() <= 0) {
            socket = new Socket(string, n);
        } else {
            String string5 = properties.getProperty(string2 + ".socketFactory.fallback", null);
            boolean bl = string5 == null || !string5.equalsIgnoreCase("false");
            String string6 = properties.getProperty(string2 + ".socketFactory.port", null);
            int n2 = -1;
            if (string6 != null) {
                try {
                    n2 = Integer.parseInt(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                Class<?> clazz = Class.forName(string3);
                Method method = clazz.getMethod("getDefault", new Class[0]);
                Object object = method.invoke(new Object(), new Object[0]);
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SocketFetcher.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE};
                Method method2 = clazz.getMethod("createSocket", classArray);
                Integer n3 = new Integer(n2 != -1 ? n2 : n);
                Object[] objectArray = new Object[]{string, n3};
                socket = (Socket)method2.invoke(object, objectArray);
            }
            catch (Exception exception) {
                if (bl) {
                    socket = new Socket(string, n);
                }
                throw new IOException("Couldn't connect using \"" + string3 + "\" socket factory to host, port: " + string + ", " + n2 + "; Exception: " + exception);
            }
        }
        int n4 = -1;
        if (string4 != null) {
            try {
                n4 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n4 >= 0) {
            socket.setSoTimeout(n4);
        }
        return socket;
    }

    private synchronized Socket getSocket() throws IOException {
        if (!this.done) {
            try {
                long l = System.currentTimeMillis();
                long l2 = l + (long)this.cto;
                while (l < l2) {
                    this.wait(l2 - l);
                    if (!this.done) {
                        l = System.currentTimeMillis();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                this.exception = new InterruptedIOException(interruptedException.toString());
            }
        }
        if (this.exception != null) {
            this.aborted = true;
            throw this.exception;
        }
        if (this.socket == null) {
            this.aborted = true;
            throw new ConnectException("connection to " + this.host + " timed out");
        }
        Socket socket = this.socket;
        this.socket = null;
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Socket socket = SocketFetcher.getSocket0(this.host, this.port, this.props, this.prefix);
            SocketFetcher socketFetcher = this;
            synchronized (socketFetcher) {
                if (this.aborted) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    this.socket = socket;
                }
                this.done = true;
                this.notify();
            }
        }
        catch (IOException iOException) {
            SocketFetcher socketFetcher = this;
            synchronized (socketFetcher) {
                this.exception = iOException;
                this.done = true;
                this.notify();
            }
        }
    }

    protected synchronized void finalize() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

