/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http.ea;

import com.sun.xml.rpc.server.http.JAXRPCServletException;
import com.sun.xml.rpc.server.http.ea.WSDLPortInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class WSDLPublisher {
    private ServletConfig _servletConfig;
    private ServletContext _servletContext;
    private String _wsdlLocation;
    private boolean _wsdlTransform;
    private Map _ports = new HashMap();
    private byte[] _xsltDocument;
    private Templates _xsltTemplates;
    private static final String PROPERTY_PORT_COUNT = "portcount";
    private static final String PROPERTY_PORT = "port";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_WSDL = "wsdl";
    private static final String PROPERTY_TNS = "targetNamespace";
    private static final String PROPERTY_SERVICE_NAME = "serviceName";
    private static final String PROPERTY_PORT_NAME = "portName";
    private static final String PROPERTY_LOCATION = "location";
    private static final String PROPERTY_TRANSFORM = "transform";

    public WSDLPublisher(ServletConfig servletConfig) {
        this._servletConfig = servletConfig;
    }

    public WSDLPublisher(ServletConfig servletConfig, InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("error.wsdlPublisher.noInputStream");
        }
        this._servletConfig = servletConfig;
        this._servletContext = servletConfig.getServletContext();
        this.readFrom(inputStream);
    }

    public boolean hasDocument() {
        return this._wsdlLocation != null;
    }

    public void publish(String string, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType("text/xml");
        httpServletResponse.setStatus(200);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (this._wsdlTransform) {
            try {
                StreamSource streamSource = new StreamSource(this._servletContext.getResourceAsStream(this._wsdlLocation));
                Transformer transformer = this._xsltTemplates.newTransformer();
                transformer.setParameter("baseURI", string);
                transformer.transform(streamSource, new StreamResult((OutputStream)servletOutputStream));
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new IOException("cannot create transformer");
            }
            catch (TransformerException transformerException) {
                throw new IOException("transformation failed");
            }
        } else {
            InputStream inputStream = this._servletContext.getResourceAsStream(this._wsdlLocation);
            WSDLPublisher.copyStream(inputStream, (OutputStream)servletOutputStream);
            inputStream.close();
        }
    }

    protected void readFrom(InputStream inputStream) {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            this._wsdlLocation = properties.getProperty("wsdl.location");
            if (this._wsdlLocation != null) {
                this._wsdlLocation = this._wsdlLocation.trim();
                InputStream inputStream2 = this._servletContext.getResourceAsStream(this._wsdlLocation);
                if (inputStream2 == null) {
                    this._wsdlLocation = null;
                    return;
                }
                inputStream2.close();
                this._wsdlTransform = true;
                String string = properties.getProperty("wsdl.transform");
                if (string != null && !Boolean.valueOf(string).booleanValue()) {
                    this._wsdlTransform = false;
                }
                if (this._wsdlTransform) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    int n = Integer.parseInt(properties.getProperty(PROPERTY_PORT_COUNT));
                    int n2 = 0;
                    while (n2 < n) {
                        object5 = PROPERTY_PORT + Integer.toString(n2) + ".";
                        object4 = properties.getProperty((String)object5 + PROPERTY_NAME);
                        object3 = (String)object5 + PROPERTY_WSDL + ".";
                        object2 = properties.getProperty((String)object3 + PROPERTY_TNS);
                        object = properties.getProperty((String)object3 + PROPERTY_SERVICE_NAME);
                        String string2 = properties.getProperty((String)object3 + PROPERTY_PORT_NAME);
                        if (object4 != null && object2 != null && object != null && string2 != null) {
                            this._ports.put(object4, new WSDLPortInfo((String)object2, (String)object, string2));
                        }
                        ++n2;
                    }
                    object5 = new ByteArrayOutputStream();
                    object4 = new OutputStreamWriter((OutputStream)object5, "UTF-8");
                    ((Writer)object4).write("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\">\n");
                    ((Writer)object4).write("<xsl:param name=\"baseURI\"/>\n");
                    ((Writer)object4).write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
                    object3 = this._ports.keySet().iterator();
                    while (object3.hasNext()) {
                        object2 = (String)object3.next();
                        object = (WSDLPortInfo)this._ports.get(object2);
                        ((Writer)object4).write("<xsl:template match=\"wsdl:definitions[@targetNamespace='");
                        ((Writer)object4).write(((WSDLPortInfo)object).getTargetNamespace());
                        ((Writer)object4).write("']/wsdl:service[@name='");
                        ((Writer)object4).write(((WSDLPortInfo)object).getServiceName());
                        ((Writer)object4).write("']/wsdl:port[@name='");
                        ((Writer)object4).write(((WSDLPortInfo)object).getPortName());
                        ((Writer)object4).write("']/soap:address\" mode=\"copy\">");
                        ((Writer)object4).write("<soap:address><xsl:attribute name=\"location\"><xsl:value-of select=\"$baseURI\"/><xsl:text>");
                        ((Writer)object4).write((String)object2);
                        ((Writer)object4).write("</xsl:text></xsl:attribute></soap:address></xsl:template>");
                    }
                    ((Writer)object4).write("<xsl:template match=\"@*|node()\" mode=\"copy\"><xsl:copy><xsl:apply-templates select=\"@*\" mode=\"copy\"/><xsl:apply-templates mode=\"copy\"/></xsl:copy></xsl:template>\n");
                    ((Writer)object4).write("</xsl:stylesheet>\n");
                    ((OutputStreamWriter)object4).close();
                    this._xsltDocument = ((ByteArrayOutputStream)object5).toByteArray();
                    try {
                        object2 = new StreamSource(new ByteArrayInputStream(this._xsltDocument));
                        object = TransformerFactory.newInstance();
                        this._xsltTemplates = ((TransformerFactory)object).newTemplates((Source)object2);
                    }
                    catch (TransformerConfigurationException transformerConfigurationException) {
                        this._wsdlTransform = false;
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new JAXRPCServletException("error.wsdlPublisher.cannotReadConfiguration");
        }
    }

    protected static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }
}

