/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http;

import com.sun.xml.rpc.server.http.JAXRPCRuntimeInfo;
import com.sun.xml.rpc.server.http.JAXRPCServletException;
import com.sun.xml.rpc.server.http.RuntimeEndpointInfo;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderException;
import com.sun.xml.rpc.streaming.XMLReaderFactory;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class JAXRPCRuntimeInfoParser {
    protected ClassLoader classLoader;
    public static final String NS_RUNTIME = "http://java.sun.com/xml/ns/jax-rpc/ri/runtime";
    public static final QName QNAME_ENDPOINTS = new QName("http://java.sun.com/xml/ns/jax-rpc/ri/runtime", "endpoints");
    public static final QName QNAME_ENDPOINT = new QName("http://java.sun.com/xml/ns/jax-rpc/ri/runtime", "endpoint");
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_INTERFACE = "interface";
    public static final String ATTR_IMPLEMENTATION = "implementation";
    public static final String ATTR_TIE = "tie";
    public static final String ATTR_MODEL = "model";
    public static final String ATTR_WSDL = "wsdl";
    public static final String ATTR_SERVICE = "service";
    public static final String ATTR_PORT = "port";
    public static final String ATTR_URL_PATTERN = "urlpattern";
    public static final String ATTRVALUE_VERSION_1_0 = "1.0";

    public JAXRPCRuntimeInfoParser(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public JAXRPCRuntimeInfo parse(InputStream inputStream) {
        try {
            XMLReader xMLReader = XMLReaderFactory.newInstance().createXMLReader(inputStream);
            xMLReader.next();
            return this.parseEndpoints(xMLReader);
        }
        catch (XMLReaderException xMLReaderException) {
            throw new JAXRPCServletException("runtime.parser.xmlReader", xMLReaderException);
        }
    }

    protected JAXRPCRuntimeInfo parseEndpoints(XMLReader xMLReader) {
        if (!xMLReader.getName().equals(QNAME_ENDPOINTS)) {
            JAXRPCRuntimeInfoParser.failWithFullName("runtime.parser.invalidElement", xMLReader);
        }
        JAXRPCRuntimeInfo jAXRPCRuntimeInfo = new JAXRPCRuntimeInfo();
        ArrayList<RuntimeEndpointInfo> arrayList = new ArrayList<RuntimeEndpointInfo>();
        String string = this.getMandatoryNonEmptyAttribute(xMLReader, ATTR_VERSION);
        if (!string.equals(ATTRVALUE_VERSION_1_0)) {
            JAXRPCRuntimeInfoParser.failWithLocalName("runtime.parser.invalidVersionNumber", xMLReader, string);
        }
        while (xMLReader.nextElementContent() != 2) {
            if (xMLReader.getName().equals(QNAME_ENDPOINT)) {
                RuntimeEndpointInfo runtimeEndpointInfo = new RuntimeEndpointInfo();
                runtimeEndpointInfo.setName(this.getMandatoryNonEmptyAttribute(xMLReader, ATTR_NAME));
                String string2 = this.getMandatoryNonEmptyAttribute(xMLReader, ATTR_INTERFACE);
                runtimeEndpointInfo.setRemoteInterface(this.loadClass(string2));
                String string3 = this.getMandatoryNonEmptyAttribute(xMLReader, ATTR_IMPLEMENTATION);
                runtimeEndpointInfo.setImplementationClass(this.loadClass(string3));
                String string4 = this.getMandatoryNonEmptyAttribute(xMLReader, ATTR_TIE);
                runtimeEndpointInfo.setTieClass(this.loadClass(string4));
                runtimeEndpointInfo.setModelFileName(this.getAttribute(xMLReader, ATTR_MODEL));
                runtimeEndpointInfo.setWSDLFileName(this.getAttribute(xMLReader, ATTR_WSDL));
                runtimeEndpointInfo.setServiceName(this.getQNameAttribute(xMLReader, ATTR_SERVICE));
                runtimeEndpointInfo.setPortName(this.getQNameAttribute(xMLReader, ATTR_PORT));
                runtimeEndpointInfo.setUrlPattern(this.getMandatoryNonEmptyAttribute(xMLReader, ATTR_URL_PATTERN));
                JAXRPCRuntimeInfoParser.ensureNoContent(xMLReader);
                runtimeEndpointInfo.setDeployed(true);
                arrayList.add(runtimeEndpointInfo);
                continue;
            }
            JAXRPCRuntimeInfoParser.failWithLocalName("runtime.parser.invalidElement", xMLReader);
        }
        xMLReader.close();
        jAXRPCRuntimeInfo.setEndpoints(arrayList);
        return jAXRPCRuntimeInfo;
    }

    protected String getAttribute(XMLReader xMLReader, String string) {
        Attributes attributes = xMLReader.getAttributes();
        String string2 = attributes.getValue(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    protected QName getQNameAttribute(XMLReader xMLReader, String string) {
        String string2 = this.getAttribute(xMLReader, string);
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return QName.valueOf(string2);
    }

    protected String getNonEmptyAttribute(XMLReader xMLReader, String string) {
        String string2 = this.getAttribute(xMLReader, string);
        if (string2 != null && string2.equals("")) {
            JAXRPCRuntimeInfoParser.failWithLocalName("runtime.parser.invalidAttributeValue", xMLReader, string);
        }
        return string2;
    }

    protected String getMandatoryAttribute(XMLReader xMLReader, String string) {
        String string2 = this.getAttribute(xMLReader, string);
        if (string2 == null) {
            JAXRPCRuntimeInfoParser.failWithLocalName("runtime.parser.missing.attribute", xMLReader, string);
        }
        return string2;
    }

    protected String getMandatoryNonEmptyAttribute(XMLReader xMLReader, String string) {
        String string2 = this.getAttribute(xMLReader, string);
        if (string2 == null) {
            JAXRPCRuntimeInfoParser.failWithLocalName("runtime.parser.missing.attribute", xMLReader, string);
        } else if (string2.equals("")) {
            JAXRPCRuntimeInfoParser.failWithLocalName("runtime.parser.invalidAttributeValue", xMLReader, string);
        }
        return string2;
    }

    protected static void ensureNoContent(XMLReader xMLReader) {
        if (xMLReader.nextElementContent() != 2) {
            JAXRPCRuntimeInfoParser.fail("runtime.parser.unexpectedContent", xMLReader);
        }
    }

    protected static void fail(String string, XMLReader xMLReader) {
        throw new JAXRPCServletException(string, Integer.toString(xMLReader.getLineNumber()));
    }

    protected static void failWithFullName(String string, XMLReader xMLReader) {
        throw new JAXRPCServletException(string, new Object[]{Integer.toString(xMLReader.getLineNumber()), xMLReader.getName().toString()});
    }

    protected static void failWithLocalName(String string, XMLReader xMLReader) {
        throw new JAXRPCServletException(string, new Object[]{Integer.toString(xMLReader.getLineNumber()), xMLReader.getLocalName()});
    }

    protected static void failWithLocalName(String string, XMLReader xMLReader, String string2) {
        throw new JAXRPCServletException(string, new Object[]{Integer.toString(xMLReader.getLineNumber()), xMLReader.getLocalName(), string2});
    }

    protected Class loadClass(String string) {
        try {
            return Class.forName(string, true, this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXRPCServletException("runtime.parser.classNotFound", string);
        }
    }
}

