/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model;

import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.ModelObject;
import com.sun.xml.rpc.processor.model.ModelVisitor;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class Service
extends ModelObject {
    private QName name;
    private List ports = new ArrayList();
    private Map portsByName = new HashMap();
    private JavaInterface javaInterface;

    public Service() {
    }

    public Service(QName qName, JavaInterface javaInterface) {
        this.name = qName;
        this.javaInterface = javaInterface;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName qName) {
        this.name = qName;
    }

    public void addPort(Port port) {
        if (this.portsByName.containsKey(port.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this.ports.add(port);
        this.portsByName.put(port.getName(), port);
    }

    public Iterator getPorts() {
        return this.ports.iterator();
    }

    public Port getPortByName(QName qName) {
        if (this.portsByName.size() != this.ports.size()) {
            this.initializePortsByName();
        }
        return (Port)this.portsByName.get(qName);
    }

    public List getPortsList() {
        return this.ports;
    }

    public void setPortsList(List list) {
        this.ports = list;
        this.initializePortsByName();
    }

    private void initializePortsByName() {
        this.portsByName = new HashMap();
        if (this.ports != null) {
            Iterator iterator = this.ports.iterator();
            while (iterator.hasNext()) {
                Port port = (Port)iterator.next();
                if (port.getName() != null && this.portsByName.containsKey(port.getName())) {
                    throw new ModelException("model.uniqueness");
                }
                this.portsByName.put(port.getName(), port);
            }
        }
    }

    public JavaInterface getJavaInterface() {
        return this.javaInterface;
    }

    public void setJavaInterface(JavaInterface javaInterface) {
        this.javaInterface = javaInterface;
    }

    public void accept(ModelVisitor modelVisitor) throws Exception {
        modelVisitor.visit(this);
    }
}

