/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.HandlerChainInfo;
import com.sun.xml.rpc.processor.config.HandlerInfo;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.StubTieGeneratorBase;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class TieGenerator
extends StubTieGeneratorBase {
    private Set operationNames;
    private Set soapActionValues;
    private boolean hasUniqueOperationNames;
    private boolean hasUniqueSoapActions;

    public TieGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new TieGenerator(model, configuration, properties);
    }

    private TieGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    protected String getClassName() {
        return this.env.getNames().tieFor(this.port.getJavaInterface());
    }

    protected String getStateType() {
        return "StreamingHandlerState";
    }

    protected Message getMessageToDeserialize(Operation operation) {
        Request request = operation.getRequest();
        if (request.getBodyBlockCount() > 1) {
            GeneratorBase.fail("generator.tie.cannot.dispatch", operation.getName().getLocalPart());
        }
        return request;
    }

    protected String getStateGetRequestResponseString() {
        return "getRequest";
    }

    protected String getInitializeAccess() {
        return "private";
    }

    protected boolean superClassHasInitialize() {
        return false;
    }

    protected void writeImports(IndentingWriter indentingWriter) throws IOException {
        super.writeImports(indentingWriter);
        indentingWriter.pln("import com.sun.xml.rpc.server.*;");
        indentingWriter.pln("import javax.xml.rpc.handler.HandlerInfo;");
        indentingWriter.pln("import com.sun.xml.rpc.client.HandlerChainImpl;");
    }

    protected void preVisitPort(Port port) throws Exception {
        super.preVisitPort(port);
        this.operationNames = new HashSet();
        this.soapActionValues = new HashSet();
        this.hasUniqueOperationNames = true;
        this.hasUniqueSoapActions = true;
    }

    protected void postVisitPort(Port port) throws Exception {
        this.operationNames = null;
        this.soapActionValues = null;
        super.postVisitPort(port);
    }

    protected void preVisitOperation(Operation operation) throws Exception {
        String string = operation.getName().getLocalPart();
        if (this.operationNames.contains(string)) {
            this.hasUniqueOperationNames = false;
        }
        this.operationNames.add(string);
        if (operation.getSOAPAction() != null) {
            if (this.soapActionValues.contains(operation.getSOAPAction())) {
                this.hasUniqueSoapActions = false;
            }
            this.soapActionValues.add(operation.getSOAPAction());
        } else {
            this.hasUniqueSoapActions = false;
        }
    }

    protected void writeClassDecl(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).toString());
        indentingWriter.pln("extends com.sun.xml.rpc.server.TieBase implements SerializerConstants {");
        indentingWriter.pln();
    }

    protected void writeConstructor(IndentingWriter indentingWriter, String string) throws IOException {
        JavaInterface javaInterface = this.service.getJavaInterface();
        String string2 = this.env.getNames().serializerRegistryClassName(javaInterface);
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append("() throws Exception {").toString());
        indentingWriter.pln("super(new " + string2 + "().getRegistry());");
        indentingWriter.pln("initialize(internalTypeMappingRegistry);");
        HandlerChainInfo handlerChainInfo = this.port.getServerHandlerChainInfo();
        Iterator iterator = handlerChainInfo.getHandlers();
        if (iterator.hasNext()) {
            Object object;
            Object object2;
            indentingWriter.pln();
            indentingWriter.plnI("{");
            indentingWriter.pln("java.util.List handlerInfos = new java.util.Vector();");
            while (iterator.hasNext()) {
                Object object3;
                object2 = (HandlerInfo)iterator.next();
                Map map = ((HandlerInfo)object2).getProperties();
                object = "null";
                indentingWriter.plnI("{");
                if (map.size() > 0) {
                    object = "props";
                    indentingWriter.pln("java.util.Map " + (String)object + " = new java.util.HashMap();");
                    object3 = map.entrySet().iterator();
                    while (object3.hasNext()) {
                        Map.Entry entry = (Map.Entry)object3.next();
                        indentingWriter.pln((String)object + ".put(\"" + (String)entry.getKey() + "\", \"" + (String)entry.getValue() + "\");");
                    }
                }
                if ((object3 = ((HandlerInfo)object2).getHeaderNames().toArray()) != null && ((Object[])object3).length > 0) {
                    indentingWriter.plnI("QName[] headers = {");
                    int n = 0;
                    while (n < ((Object[])object3).length) {
                        QName qName = (QName)object3[n];
                        indentingWriter.pln("new QName(\"" + qName.getNamespaceURI() + "\"" + ", " + "\"" + qName.getLocalPart() + "\"" + ")" + (n != ((Object)object3).length - 1 ? "," : ""));
                        ++n;
                    }
                    indentingWriter.pOln("};");
                } else {
                    indentingWriter.pln("QName[] headers = null;");
                }
                indentingWriter.pln("HandlerInfo handlerInfo = new HandlerInfo(" + ((HandlerInfo)object2).getHandlerClassName() + ".class" + ", " + (String)object + ", headers);");
                indentingWriter.pln("handlerInfos.add(handlerInfo);");
                indentingWriter.pOln("}");
            }
            object2 = this.port.getServerHandlerChainInfo().getRoles();
            indentingWriter.p("String[] roles = new String[] {");
            boolean bl = true;
            object = object2.iterator();
            while (object.hasNext()) {
                if (!bl) {
                    indentingWriter.p(", ");
                } else {
                    bl = false;
                }
                indentingWriter.p("\"" + object.next() + "\"");
            }
            indentingWriter.pln("};");
            indentingWriter.pln("handlerChain = new HandlerChainImpl(handlerInfos);");
            indentingWriter.pln("handlerChain.setRoles(roles);");
            indentingWriter.pln("handlerChain.addUnderstoodHeaders(getUnderstoodHeaders());");
            indentingWriter.pOln("}");
        }
        indentingWriter.pOln("}");
    }

    protected void writePeekFirstBodyElementMethod(IndentingWriter indentingWriter) throws IOException {
        boolean bl;
        boolean bl2 = this.hasUniqueOperationNames;
        boolean bl3 = bl = !bl2 && this.hasUniqueSoapActions;
        if (!bl2 && !bl) {
            throw new GeneratorException("generator.tie.port.cannot.dispatch", this.port.getName().getLocalPart());
        }
        indentingWriter.pln("/*");
        indentingWriter.pln(" * This method must determine the opcode of the operation that has been invoked.");
        indentingWriter.pln(" */");
        indentingWriter.plnI("protected void peekFirstBodyElement(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, StreamingHandlerState state) throws Exception {");
        if (bl) {
            indentingWriter.pln("String soapaction = null;");
            indentingWriter.pln("String[] soapactionheaders = state.getMessageContext().getMessage().getMimeHeaders().getHeader(\"SOAPAction\");");
            indentingWriter.plnI("if (soapactionheaders.length > 0) {");
            indentingWriter.pln("soapaction = soapactionheaders[0];");
            indentingWriter.pOlnI("} else {");
            indentingWriter.pln("throw new SOAPProtocolViolationException(\"soap.request.missing.soapaction.cannot.dispatch\");");
            indentingWriter.pOln("}");
        }
        Iterator iterator = this.operations.iterator();
        Operation operation = null;
        int n = 0;
        while (iterator.hasNext()) {
            Operation operation2 = (Operation)iterator.next();
            if (bl2) {
                boolean bl4;
                Request request = operation2.getRequest();
                boolean bl5 = bl4 = request.getBodyBlockCount() == 0;
                if (bl4) {
                    if (operation != null) {
                        GeneratorBase.fail("generator.tie.cannot.dispatch", operation2.getName().getLocalPart());
                    } else {
                        operation = operation2;
                    }
                }
                if (request.getBodyBlockCount() > 1) {
                    GeneratorBase.fail("generator.tie.cannot.dispatch", operation2.getName().getLocalPart());
                }
                if (bl4) continue;
                Block block = (Block)request.getBodyBlocks().next();
                if (n++ > 0) {
                    indentingWriter.p("else ");
                }
                indentingWriter.plnI("if (bodyReader.getName().equals(" + this.env.getNames().getBlockQNameName(operation2, block) + ")) {");
                if (operation2.isOverloaded()) {
                    indentingWriter.pln("throw new SOAPProtocolViolationException(\"soap.operation.cannot.dispatch\", \"" + operation2.getName().getLocalPart() + "\");");
                } else {
                    indentingWriter.pln("state.getRequest().setOperationCode(" + this.env.getNames().getOPCodeName(operation2.getUniqueName()) + ");");
                }
                indentingWriter.pOln("}");
                continue;
            }
            if (!bl) continue;
            if (n++ > 0) {
                indentingWriter.p("else ");
            }
            indentingWriter.plnI("if (soapaction.equals(\"\\\"" + operation2.getSOAPAction() + "\\\"\")) {");
            indentingWriter.pln("state.getRequest().setOperationCode(" + this.env.getNames().getOPCodeName(operation2.getUniqueName()) + ");");
            indentingWriter.pOln("}");
        }
        if (n > 0) {
            indentingWriter.plnI("else {");
        }
        indentingWriter.pln("throw new SOAPProtocolViolationException(\"soap.operation.unrecognized\", bodyReader.getName().toString());");
        if (n > 0) {
            indentingWriter.pOln("}");
        }
        indentingWriter.pOln("}");
    }

    protected void writeHandleEmptyBody(IndentingWriter indentingWriter, Operation operation) throws IOException {
        indentingWriter.pln("/*");
        indentingWriter.pln(" * This method handles the case of an empty SOAP body.");
        indentingWriter.pln(" */");
        indentingWriter.plnI("protected void handleEmptyBody(XMLReader reader, SOAPDeserializationContext deserializationContext, StreamingHandlerState state) throws Exception {");
        indentingWriter.pln("state.getRequest().setOperationCode(" + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ");");
        indentingWriter.pOln("}");
    }

    protected void writeProcessingHookMethod(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("/*");
        indentingWriter.pln(" * This method must invoke the correct method on the servant based on the opcode.");
        indentingWriter.pln(" */");
        indentingWriter.plnI("protected void processingHook(StreamingHandlerState state) throws Exception {");
        Iterator iterator = this.operations.iterator();
        indentingWriter.plnI("switch (state.getRequest().getOperationCode()) {");
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            indentingWriter.plnI("case " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ":");
            indentingWriter.pln("invoke_" + operation.getUniqueName() + "(state);");
            indentingWriter.pln("break;");
            indentingWriter.pO();
        }
        indentingWriter.plnI("default:");
        indentingWriter.pln("throw new SOAPProtocolViolationException(\"soap.operation.unrecognized\", Integer.toString(state.getRequest().getOperationCode()));");
        indentingWriter.pO();
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    protected void writeRpcOperation(IndentingWriter indentingWriter, String string, Operation operation) throws IOException {
        Object object;
        Object object2;
        String string2 = operation.getName().getLocalPart();
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType javaType = javaMethod.getReturnType();
        String string3 = null;
        String string4 = null;
        SOAPType sOAPType = null;
        boolean bl = operation.getFaults().hasNext();
        Request request = operation.getRequest();
        Iterator iterator = request.getBodyBlocks();
        Block block = null;
        while (iterator.hasNext()) {
            block = (Block)iterator.next();
            if (!block.getName().getLocalPart().equals(string2)) continue;
            sOAPType = (SOAPType)block.getType();
            string3 = sOAPType.getJavaType().getRealName();
            string4 = this.env.getNames().getTypeMemberName(sOAPType.getJavaType());
            break;
        }
        this.writeInvokeMethodDecl(indentingWriter, operation);
        this.declareRequestObjects(indentingWriter, string3, string4);
        this.declareHolderHeaderObjects(indentingWriter, block, operation);
        boolean bl2 = false;
        iterator = operation.getRequest().getHeaderBlocks();
        bl2 = iterator.hasNext();
        if (bl2) {
            this.writeRequestHeaders(indentingWriter, operation);
        }
        if (bl) {
            indentingWriter.plnI("try {");
        }
        this.declareRpcReturnType(indentingWriter, operation, javaType);
        indentingWriter.p("((" + string + ") getTarget())." + operation.getJavaMethod().getName() + "(");
        if (javaType != null && !javaType.getName().equals(ModelerConstants.VOID_CLASSNAME)) {
            indentingWriter.pO();
        }
        iterator = javaMethod.getParameters();
        request = operation.getRequest();
        int n = 0;
        while (iterator.hasNext()) {
            JavaParameter javaParameter;
            Parameter parameter;
            Block block2;
            if (n > 0) {
                indentingWriter.p(", ");
            }
            if ((block2 = (parameter = (javaParameter = (JavaParameter)iterator.next()).getParameter()).getBlock()).getLocation() != 1) {
                if (javaParameter.isHolder()) {
                    if (javaParameter.getType().getHolderName() != null) {
                        indentingWriter.p(javaParameter.getParameter().getName());
                    } else {
                        indentingWriter.p(javaParameter.getParameter().getName() + "_holder");
                    }
                } else {
                    indentingWriter.p(parameter.getName());
                }
            } else {
                object2 = block2.getType().getJavaType();
                object = this.env.getNames().getTypeMemberName((JavaType)object2);
                JavaStructureMember javaStructureMember = StubTieGeneratorBase.getJavaMember(parameter);
                if (javaParameter.isHolder()) {
                    indentingWriter.p(javaParameter.getParameter().getName() + "_holder");
                } else if (javaStructureMember.isPublic()) {
                    indentingWriter.p((String)object + "." + parameter.getName());
                } else {
                    indentingWriter.p((String)object + "." + javaStructureMember.getReadMethod() + "()");
                }
            }
            ++n;
        }
        indentingWriter.pln(");");
        this.declareRpcResponseObject(indentingWriter, operation);
        object2 = new TreeSet(new GeneratorUtil.FaultComparator());
        object2.addAll(operation.getFaultsSet());
        object = object2.iterator();
        while (object.hasNext()) {
            Fault fault = (Fault)object.next();
            indentingWriter.pOlnI("} catch (" + this.env.getNames().customExceptionClassName(fault) + " e) {");
            indentingWriter.plnI("SOAPFaultInfo fault = new SOAPFaultInfo(com.sun.xml.rpc.encoding.soap.SOAPConstants.FAULT_CODE_SERVER,");
            indentingWriter.pln("\"" + this.env.getNames().customExceptionClassName(fault) + "\", null, e);");
            indentingWriter.pO();
            indentingWriter.pln("SOAPBlockInfo faultBlock = new SOAPBlockInfo(com.sun.xml.rpc.encoding.soap.SOAPConstants.QNAME_SOAP_FAULT);");
            indentingWriter.pln("faultBlock.setValue(fault);");
            indentingWriter.pln("faultBlock.setSerializer(" + this.env.getNames().getClassMemberName(this.env.getNames().faultSerializerClassName(this.port, operation)) + ");");
            indentingWriter.pln("state.getResponse().setBody(faultBlock);");
            indentingWriter.pln("state.getResponse().setFailure(true);");
        }
        if (bl) {
            indentingWriter.pOln("}");
        }
        indentingWriter.pOln("}");
    }

    private void writeInvokeMethodDecl(IndentingWriter indentingWriter, Operation operation) throws IOException {
        String string = operation.getName().getLocalPart();
        indentingWriter.pln("/*");
        indentingWriter.pln(" * This method does the actual method invocation for operation: " + string);
        indentingWriter.pln(" */");
        indentingWriter.plnI("private void invoke_" + operation.getUniqueName() + "(StreamingHandlerState state) throws Exception {");
        indentingWriter.pln();
    }

    private void declareRequestObjects(IndentingWriter indentingWriter, String string, String string2) throws IOException {
        if (string != null && string2 != null) {
            String string3 = string2 + "Obj";
            indentingWriter.pln(string + " " + string2 + " = null;");
            indentingWriter.plnI("Object " + string3 + " =");
            indentingWriter.pln("state.getRequest().getBody().getValue();");
            indentingWriter.pO();
            indentingWriter.pln();
            indentingWriter.plnI("if (" + string3 + " instanceof SOAPDeserializationState) {");
            indentingWriter.p(string2 + " =");
            indentingWriter.pln("(" + string + ")((SOAPDeserializationState)" + string3 + ").getInstance();");
            indentingWriter.pOlnI("} else {");
            indentingWriter.p(string2 + " =");
            indentingWriter.pln("(" + string + ")" + string3 + ";");
            indentingWriter.pOln("}");
            indentingWriter.pln();
        }
    }

    private void declareHolderHeaderObjects(IndentingWriter indentingWriter, Block block, Operation operation) throws IOException {
        AbstractType abstractType = block.getType();
        String string = abstractType.getJavaType().getRealName();
        String string2 = this.env.getNames().getTypeMemberName(abstractType.getJavaType());
        String string3 = string2 + "Obj";
        JavaMethod javaMethod = operation.getJavaMethod();
        Iterator iterator = javaMethod.getParameters();
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            Object object;
            JavaParameter javaParameter = (JavaParameter)iterator.next();
            if (javaParameter.isHolder()) {
                object = this.env.getNames().holderClassName(this.port, javaParameter.getType());
                indentingWriter.plnI((String)object + " " + javaParameter.getParameter().getName() + "_holder =");
                indentingWriter.pln("new " + (String)object + "();");
                indentingWriter.pO();
                if (javaParameter.getParameter().getLinkedParameter() == null) continue;
                JavaStructureMember javaStructureMember = StubTieGeneratorBase.getJavaMember(javaParameter.getParameter());
                indentingWriter.pln(" " + javaParameter.getParameter().getName() + "_holder.value = " + string2 + "." + javaStructureMember.getReadMethod() + "();");
                continue;
            }
            if (javaParameter.getParameter().getBlock().getLocation() != 2) continue;
            if (!bl) {
                indentingWriter.pln("Object _headerObj;");
                bl = true;
            }
            object = javaParameter.getParameter().getType();
            String string4 = javaParameter.getType().getInitString();
            indentingWriter.pln(((AbstractType)object).getJavaType().getRealName() + " " + javaParameter.getParameter().getName() + " = " + string4 + ";");
        }
    }

    private void declareRpcReturnType(IndentingWriter indentingWriter, Operation operation, JavaType javaType) throws IOException {
        Response response = operation.getResponse();
        Iterator iterator = response.getBodyBlocks();
        if (javaType != null && !javaType.getName().equals(ModelerConstants.VOID_CLASSNAME) && (iterator = response.getParameters()).hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            indentingWriter.plnI(parameter.getType().getJavaType().getRealName() + " " + parameter.getName() + " = ");
        }
    }

    private void writeRequestHeaders(IndentingWriter indentingWriter, Operation operation) throws IOException {
        indentingWriter.pln("Iterator headers = state.getRequest().headers();");
        indentingWriter.pln("SOAPHeaderBlockInfo curHeader;");
        indentingWriter.plnI("while (headers.hasNext()) {");
        indentingWriter.pln("curHeader = (SOAPHeaderBlockInfo)headers.next();");
        Iterator iterator = operation.getRequest().getParameters();
        boolean bl = false;
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter.getBlock().getLocation() != 2) continue;
            if (bl) {
                indentingWriter.p(" else ");
            }
            bl = true;
            String string = parameter.getName();
            String string2 = parameter.getType().getJavaType().getRealName();
            String string3 = this.env.getNames().getBlockQNameName(null, parameter.getBlock());
            indentingWriter.plnI("if (curHeader.getName().equals(" + string3 + ")) {");
            indentingWriter.pln("_headerObj = (" + string2 + ")curHeader.getValue();");
            indentingWriter.plnI("if (_headerObj instanceof SOAPDeserializationState) {");
            indentingWriter.pln(string + " = (" + string2 + ")((SOAPDeserializationState)" + "_headerObj).getInstance();");
            indentingWriter.pOlnI("} else {");
            indentingWriter.pln(string + " = (" + string2 + ")_headerObj;");
            indentingWriter.pOln("}");
            indentingWriter.pO("}");
        }
        if (bl) {
            indentingWriter.pln();
        }
        indentingWriter.pOln("}");
        indentingWriter.pln();
    }

    private void declareRpcResponseObject(IndentingWriter indentingWriter, Operation operation) throws IOException {
        String string = operation.getName().getLocalPart();
        Response response = operation.getResponse();
        Iterator iterator = response.getBodyBlocks();
        Block block = null;
        SOAPType sOAPType = null;
        String string2 = null;
        String string3 = null;
        while (iterator.hasNext()) {
            block = (Block)iterator.next();
            if (block.getName().getLocalPart().equals(string + "Response")) {
                sOAPType = (SOAPType)block.getType();
                string2 = sOAPType.getJavaType().getRealName();
                string3 = this.env.getNames().getTypeMemberName(sOAPType.getJavaType());
                break;
            }
            block = null;
        }
        indentingWriter.plnI(string2 + " " + string3 + " =");
        indentingWriter.pln("new " + string2 + "();");
        indentingWriter.pO();
        response = operation.getResponse();
        Iterator iterator2 = response.getParameters();
        indentingWriter.pln("SOAPHeaderBlockInfo headerInfo;");
        int n = 0;
        while (iterator2.hasNext()) {
            String string4;
            JavaParameter javaParameter;
            Parameter parameter = (Parameter)iterator2.next();
            Block block2 = parameter.getBlock();
            if (block2.getLocation() == 1) {
                JavaStructureMember javaStructureMember = StubTieGeneratorBase.getJavaMember(parameter);
                javaParameter = parameter.getJavaParameter();
                string4 = parameter.getLinkedParameter() != null || javaParameter != null && javaParameter.isHolder() ? parameter.getName() + "_holder.value" : parameter.getName();
                if (javaStructureMember != null) {
                    if (javaStructureMember.isPublic()) {
                        indentingWriter.pln(string3 + "." + javaStructureMember.getName() + " = " + string4 + ";");
                    } else {
                        indentingWriter.pln(string3 + "." + javaStructureMember.getWriteMethod() + "(" + string4 + ");");
                    }
                }
            } else {
                javaParameter = parameter.getJavaParameter();
                String string5 = this.env.getNames().getBlockQNameName(null, block2);
                string4 = parameter.getLinkedParameter() != null || javaParameter != null && javaParameter.isHolder() ? parameter.getName() + "_holder.value" : parameter.getName();
                indentingWriter.pln("headerInfo = new SOAPHeaderBlockInfo(" + string5 + ", null, false);");
                indentingWriter.pln("headerInfo.setValue(" + string4 + ");");
                indentingWriter.pln("headerInfo.setSerializer(" + this.writerFactory.createWriter((SOAPType)block2.getType()).serializerMemberName() + ");");
                indentingWriter.pln("state.getResponse().add(headerInfo);");
            }
            ++n;
        }
        indentingWriter.pln();
        indentingWriter.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, block) + ");");
        indentingWriter.pln("bodyBlock.setValue(" + string3 + ");");
        indentingWriter.pln("bodyBlock.setSerializer(" + this.writerFactory.createWriter(sOAPType).serializerMemberName() + ");");
        indentingWriter.pln("state.getResponse().setBody(bodyBlock);");
    }

    protected void writeDocumentOperation(IndentingWriter indentingWriter, String string, Operation operation) throws IOException {
        JavaParameter javaParameter;
        JavaStructureMember javaStructureMember;
        Response response;
        Block block;
        Parameter parameter;
        String string2 = operation.getName().getLocalPart();
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType javaType = javaMethod.getReturnType();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        LiteralType literalType = null;
        LiteralType literalType2 = null;
        Block block2 = null;
        Request request = operation.getRequest();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = request.getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            block = parameter.getBlock();
            if (block.getLocation() == 1) {
                if (parameter.isEmbedded()) {
                    ++n;
                    continue;
                }
                ++n2;
                continue;
            }
            ++n3;
        }
        if (n2 > 1 || n2 > 0 && n > 0) {
            throw new GeneratorException("generator.internal.error.should.not.happen", "stub.generator.002");
        }
        iterator = request.getBodyBlocks();
        block = null;
        if (iterator.hasNext()) {
            block = (Block)iterator.next();
            literalType2 = (LiteralType)block.getType();
            string3 = literalType2.getJavaType().getRealName();
            string4 = this.env.getNames().getTypeMemberName(literalType2.getJavaType());
        }
        this.writeInvokeMethodDecl(indentingWriter, operation);
        this.declareRequestObjects(indentingWriter, string3, string4);
        this.declareHolderHeaderObjects(indentingWriter, block, operation);
        boolean bl = false;
        iterator = operation.getRequest().getHeaderBlocks();
        bl = iterator.hasNext();
        if (bl) {
            this.writeRequestHeaders(indentingWriter, operation);
        }
        if ((iterator = (response = operation.getResponse()).getBodyBlocks()).hasNext()) {
            block2 = (Block)iterator.next();
            literalType = (LiteralType)block2.getType();
            string5 = literalType.getJavaType().getRealName();
            string6 = "_response";
        }
        boolean bl2 = false;
        if (javaType != null && !javaType.getName().equals(ModelerConstants.VOID_CLASSNAME) && (iterator = response.getParameters()).hasNext()) {
            parameter = (Parameter)iterator.next();
            if (parameter.isEmbedded()) {
                bl2 = true;
                indentingWriter.p(javaType.getRealName() + " _result = ");
            } else {
                indentingWriter.p(string5 + " " + string6 + " = ");
            }
        }
        indentingWriter.p("((" + string + ") getTarget())." + operation.getJavaMethod().getName() + "(");
        if (n2 > 0) {
            indentingWriter.p(string4);
        } else {
            int n4 = 0;
            iterator = request.getParameters();
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                if (parameter.getBlock().getLocation() == 1) {
                    javaStructureMember = StubTieGeneratorBase.getJavaMember(parameter);
                    if (n4 > 0) {
                        indentingWriter.p(", ");
                    }
                    if (javaStructureMember.isPublic()) {
                        indentingWriter.p(string4 + "." + parameter.getName());
                    } else {
                        indentingWriter.p(string4 + "." + javaStructureMember.getReadMethod() + "()");
                    }
                }
                ++n4;
            }
        }
        if (n3 > 0) {
            iterator = request.getParameters();
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                if (parameter.getBlock().getLocation() != 2) continue;
                indentingWriter.p(", ");
                indentingWriter.p(parameter.getName());
            }
        }
        iterator = operation.getResponse().getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            if (parameter.getBlock().getLocation() != 2) continue;
            indentingWriter.p(", ");
            javaParameter = parameter.getJavaParameter();
            if (javaParameter.isHolder()) {
                indentingWriter.p(parameter.getName() + "_holder");
                continue;
            }
            indentingWriter.p(parameter.getName());
        }
        indentingWriter.pln(");");
        indentingWriter.pln();
        indentingWriter.pln("SOAPHeaderBlockInfo headerInfo;");
        iterator = operation.getResponse().getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            block2 = parameter.getBlock();
            if (block2.getLocation() != 2) continue;
            javaParameter = parameter.getJavaParameter();
            String string7 = this.env.getNames().getBlockQNameName(null, block2);
            String string8 = javaParameter.isHolder() ? parameter.getName() + "_holder.value" : parameter.getName();
            indentingWriter.pln("headerInfo = new SOAPHeaderBlockInfo(" + string7 + ", null, false);");
            indentingWriter.pln("headerInfo.setValue(" + string8 + ");");
            indentingWriter.pln("headerInfo.setSerializer(" + this.writerFactory.createWriter(block2.getType()).serializerMemberName() + ");");
            indentingWriter.pln("state.getResponse().add(headerInfo);");
        }
        indentingWriter.pln();
        if (bl2) {
            indentingWriter.pln(string5 + " " + string6 + " = new " + string5 + "();");
            iterator = response.getParameters();
            parameter = (Parameter)iterator.next();
            javaStructureMember = StubTieGeneratorBase.getJavaMember(parameter);
            if (javaStructureMember.isPublic()) {
                indentingWriter.pln(string6 + "." + parameter.getName() + " = _result;");
            } else {
                indentingWriter.pln(string6 + "." + javaStructureMember.getWriteMethod() + "(_result);");
            }
        }
        indentingWriter.pln();
        if (block2 != null) {
            indentingWriter.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, block2) + ");");
            indentingWriter.pln("bodyBlock.setValue(" + string6 + ");");
            String string9 = this.writerFactory.createWriter(literalType).serializerMemberName();
            indentingWriter.pln("bodyBlock.setSerializer(" + string9 + ");");
            indentingWriter.pln("state.getResponse().setBody(bodyBlock);");
        } else {
            indentingWriter.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(null);");
            indentingWriter.pln("bodyBlock.setSerializer(DummySerializer.getInstance());");
            indentingWriter.pln("state.getResponse().setBody(bodyBlock);");
        }
        indentingWriter.pOln("}");
    }

    protected void writeReadFirstBodyElementDefault(IndentingWriter indentingWriter, String string) throws IOException {
        indentingWriter.pln("throw new SOAPProtocolViolationException(\"soap.operation.unrecognized\", Integer.toString(" + string + "));");
    }

    protected void writeStaticMembers(IndentingWriter indentingWriter, Map map) throws IOException {
        super.writeStaticMembers(indentingWriter, map);
    }

    protected void writeUnderstoodHeadersMember(IndentingWriter indentingWriter, Map map) throws IOException {
        indentingWriter.p("private static final QName[] understoodHeaderNames = new QName[] { ");
        boolean bl = true;
        Iterator iterator = this.operations.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            Iterator iterator2 = operation.getRequest().getHeaderBlocks();
            while (iterator2.hasNext()) {
                Block block = (Block)iterator2.next();
                String string = this.env.getNames().getBlockQNameName(operation, block);
                if (!bl) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(string);
                bl = false;
            }
            ++n;
        }
        indentingWriter.pln(" };");
    }
}

