/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeConstants;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.xml.namespace.QName;

public class SimpleTypeSerializer
extends SerializerBase
implements SimpleTypeConstants {
    protected SimpleTypeEncoder encoder;

    public SimpleTypeSerializer(QName qName, boolean bl, boolean bl2, String string, SimpleTypeEncoder simpleTypeEncoder) {
        super(qName, bl, bl2, string);
        this.encoder = simpleTypeEncoder;
    }

    public void serialize(Object object, QName qName, SerializerCallback serializerCallback, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) {
        boolean bl = false;
        try {
            try {
                xMLWriter.startElement(qName != null ? qName : this.type);
                if (serializerCallback != null) {
                    serializerCallback.onStartTag(object, qName, xMLWriter, sOAPSerializationContext);
                }
                if (this.encodingStyle != null) {
                    bl = sOAPSerializationContext.pushEncodingStyle(this.encodingStyle, xMLWriter);
                }
                if (this.encodeType) {
                    String string = XMLWriterUtil.encodeQName(xMLWriter, this.type);
                    xMLWriter.writeAttributeUnquoted(SimpleTypeConstants.QNAME_XSI_TYPE, string);
                }
                if (object == null) {
                    if (!this.isNullable) {
                        throw new SerializationException("xsd.unexpectedNull");
                    }
                    xMLWriter.writeAttributeUnquoted(SimpleTypeConstants.QNAME_XSI_NIL, "1");
                } else {
                    this.encoder.writeAdditionalNamespaceDeclarations(object, xMLWriter);
                    this.encoder.writeValue(object, xMLWriter);
                }
                xMLWriter.endElement();
            }
            catch (SerializationException serializationException) {
                throw serializationException;
            }
            catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
                throw new SerializationException(jAXRPCExceptionBase);
            }
            catch (Exception exception) {
                throw new SerializationException(new LocalizableExceptionAdapter(exception));
            }
            Object var11_9 = null;
            if (bl) {
                sOAPSerializationContext.popEncodingStyle();
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (bl) {
                sOAPSerializationContext.popEncodingStyle();
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object deserialize(QName qName, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) {
        boolean bl = false;
        try {
            try {
                String string;
                Object object;
                bl = sOAPDeserializationContext.processEncodingStyle(xMLReader);
                if (this.encodingStyle != null) {
                    sOAPDeserializationContext.verifyEncodingStyle(this.encodingStyle);
                }
                if (qName != null && !((QName)(object = xMLReader.getName())).equals(qName)) {
                    throw new DeserializationException("xsd.unexpectedElementName", new Object[]{qName.toString(), ((QName)object).toString()});
                }
                this.verifyType(xMLReader);
                object = xMLReader.getAttributes();
                String string2 = object.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
                boolean bl2 = string2 != null && (string2.equals("true") || string2.equals("1"));
                xMLReader.next();
                Object object2 = null;
                if (bl2) {
                    if (!this.isNullable) {
                        throw new DeserializationException("xsd.unexpectedNull");
                    }
                } else {
                    string = null;
                    switch (xMLReader.getState()) {
                        case 3: {
                            string = xMLReader.getValue();
                            xMLReader.next();
                            break;
                        }
                        case 2: {
                            string = "";
                            break;
                        }
                    }
                    object2 = this.encoder.stringToObject(string, xMLReader);
                }
                XMLReaderUtil.verifyReaderState(xMLReader, 2);
                string = object2;
                Object var11_13 = null;
                if (!bl) return string;
                sOAPDeserializationContext.popEncodingStyle();
                return string;
            }
            catch (DeserializationException deserializationException) {
                throw deserializationException;
            }
            catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
                throw new DeserializationException(jAXRPCExceptionBase);
            }
            catch (Exception exception) {
                throw new DeserializationException(new LocalizableExceptionAdapter(exception));
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!bl) throw throwable;
            sOAPDeserializationContext.popEncodingStyle();
            throw throwable;
        }
    }
}

