/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.EventProducer;
import org.exolab.castor.xml.FileLocation;
import org.exolab.castor.xml.IDResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLMappingLoader;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;
import org.exolab.castor.xml.util.DOMEventProducer;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class Unmarshaller {
    private Class _class = null;
    private ClassDescriptorResolver _cdResolver = null;
    private IDResolver _idResolver = null;
    EntityResolver entityResolver = null;
    private ClassLoader _loader = null;
    private PrintWriter pw = null;
    private boolean debug = false;
    private boolean validate = false;

    public Unmarshaller(Class clazz) {
        this(clazz, null);
    }

    public Unmarshaller(Class clazz, ClassLoader classLoader) {
        this._class = clazz;
        this.debug = Configuration.debug();
        this.validate = Configuration.marshallingValidation();
        this._loader = classLoader;
        this._cdResolver = new ClassDescriptorResolverImpl(classLoader);
    }

    public Unmarshaller(Mapping mapping) throws MappingException {
        this.debug = Configuration.debug();
        if (mapping != null) {
            this.setMapping(mapping);
            this._loader = mapping.getClassLoader();
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._loader = classLoader;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setIDResolver(IDResolver iDResolver) {
        this._idResolver = iDResolver;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.pw = printWriter;
    }

    public void setMapping(Mapping mapping) throws MappingException {
        if (this._cdResolver == null) {
            this._cdResolver = new ClassDescriptorResolverImpl(this._loader);
        }
        this._cdResolver.setMappingLoader((XMLMappingLoader)mapping.getResolver(Mapping.XML));
    }

    public void setResolver(ClassDescriptorResolver classDescriptorResolver) {
        this._cdResolver = classDescriptorResolver != null ? classDescriptorResolver : new ClassDescriptorResolverImpl(this._loader);
    }

    public void setValidation(boolean bl) {
        this.validate = bl;
    }

    public Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return this.unmarshal(new InputSource(reader));
    }

    public Object unmarshal(EventProducer eventProducer) throws MarshalException, ValidationException {
        UnmarshalHandler unmarshalHandler = this.createHandler();
        eventProducer.setDocumentHandler(unmarshalHandler);
        try {
            eventProducer.start();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                exception = sAXException;
            }
            MarshalException marshalException = new MarshalException(exception);
            if (unmarshalHandler.getDocumentLocator() != null) {
                FileLocation fileLocation = new FileLocation();
                fileLocation.setFilename(unmarshalHandler.getDocumentLocator().getSystemId());
                fileLocation.setLineNumber(unmarshalHandler.getDocumentLocator().getLineNumber());
                fileLocation.setColumnNumber(unmarshalHandler.getDocumentLocator().getColumnNumber());
                marshalException.setLocation(fileLocation);
            }
            throw marshalException;
        }
        return unmarshalHandler.getObject();
    }

    public Object unmarshal(InputSource inputSource) throws MarshalException, ValidationException {
        Parser parser = Configuration.getParser();
        if (parser == null) {
            throw new MarshalException("unable to create parser");
        }
        if (this.entityResolver != null) {
            parser.setEntityResolver(this.entityResolver);
        }
        UnmarshalHandler unmarshalHandler = this.createHandler();
        parser.setDocumentHandler(unmarshalHandler);
        parser.setErrorHandler(unmarshalHandler);
        try {
            parser.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new MarshalException(iOException);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                exception = sAXException;
            }
            MarshalException marshalException = new MarshalException(exception);
            if (unmarshalHandler.getDocumentLocator() != null) {
                FileLocation fileLocation = new FileLocation();
                fileLocation.setFilename(unmarshalHandler.getDocumentLocator().getSystemId());
                fileLocation.setLineNumber(unmarshalHandler.getDocumentLocator().getLineNumber());
                fileLocation.setColumnNumber(unmarshalHandler.getDocumentLocator().getColumnNumber());
                marshalException.setLocation(fileLocation);
            }
            throw marshalException;
        }
        return unmarshalHandler.getObject();
    }

    public Object unmarshal(Node node) throws MarshalException, ValidationException {
        return this.unmarshal(new DOMEventProducer(node));
    }

    public static Object unmarshal(Class clazz, Reader reader) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = new Unmarshaller(clazz);
        return unmarshaller.unmarshal(reader);
    }

    public static Object unmarshal(Class clazz, InputSource inputSource) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = new Unmarshaller(clazz);
        return unmarshaller.unmarshal(inputSource);
    }

    public static Object unmarshal(Class clazz, Node node) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = new Unmarshaller(clazz);
        return unmarshaller.unmarshal(node);
    }

    public UnmarshalHandler createHandler() {
        UnmarshalHandler unmarshalHandler = new UnmarshalHandler(this._class);
        unmarshalHandler.setResolver(this._cdResolver);
        unmarshalHandler.setLogWriter(this.pw);
        unmarshalHandler.setDebug(this.debug);
        unmarshalHandler.setValidation(this.validate);
        if (this._idResolver != null) {
            unmarshalHandler.setIDResolver(this._idResolver);
        }
        if (this._loader != null) {
            unmarshalHandler.setClassLoader(this._loader);
        }
        return unmarshalHandler;
    }
}

