/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.infomodel.KeyImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import java.io.Serializable;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;

public class AssociationImpl
extends RegistryObjectImpl
implements Association,
Serializable {
    boolean isExtramural = false;
    boolean isConfirmedBySourceOwner = false;
    boolean isConfirmedByTargetOwner = false;
    private RegistryObject sourceObject;
    private RegistryObject targetObject;
    private Concept associationType;
    private boolean keyFieldsSet = false;
    private boolean keyGenerated = false;

    public AssociationImpl() {
    }

    public AssociationImpl(RegistryObject registryObject, Concept concept) throws JAXRException {
        this.targetObject = registryObject;
        this.associationType = concept;
        try {
            if (this.areKeyFieldsSet()) {
                this.createKey();
            }
        }
        catch (JAXRException jAXRException) {}
    }

    public boolean isConfirmedBySourceOwner() throws JAXRException {
        return this.isConfirmedBySourceOwner;
    }

    public boolean isConfirmedByTargetOwner() throws JAXRException {
        return this.isConfirmedByTargetOwner;
    }

    public void setIsConfirmedBySourceOwner(boolean bl) throws JAXRException {
        this.isConfirmedBySourceOwner = bl;
    }

    public void setIsConfirmedByTargetOwner(boolean bl) throws JAXRException {
        this.isConfirmedByTargetOwner = bl;
    }

    public boolean isConfirmed() throws JAXRException {
        return !this.isExtramural ? true : this.isConfirmedBySourceOwner && this.isConfirmedByTargetOwner;
    }

    public RegistryObject getSourceObject() throws JAXRException {
        return this.sourceObject;
    }

    public void setSourceObject(RegistryObject registryObject) throws JAXRException {
        this.sourceObject = registryObject;
        this.checkObjects();
        if (this.areKeyFieldsSet()) {
            this.createKey();
        }
    }

    public RegistryObject getTargetObject() throws JAXRException {
        return this.targetObject;
    }

    public void setTargetObject(RegistryObject registryObject) throws JAXRException {
        this.targetObject = registryObject;
        this.checkObjects();
        if (this.areKeyFieldsSet()) {
            this.createKey();
        }
    }

    public Concept getAssociationType() throws JAXRException {
        return this.associationType;
    }

    public void setAssociationType(Concept concept) throws JAXRException {
        this.associationType = concept;
        if (this.areKeyFieldsSet()) {
            this.createKey();
        }
    }

    public boolean isExtramural() throws JAXRException {
        return this.isExtramural;
    }

    public void setIsExtramural(boolean bl) throws JAXRException {
        this.isExtramural = bl;
    }

    public void createKey() throws JAXRException {
        if (!this.keyGenerated && this.keyFieldsSet) {
            String string = this.sourceObject.getKey().getId();
            String string2 = this.targetObject.getKey().getId();
            String string3 = this.associationType.getValue();
            StringBuffer stringBuffer = new StringBuffer(400);
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append(string2);
            stringBuffer.append(":");
            stringBuffer.append(string3);
            this.key = new KeyImpl(stringBuffer.toString());
            this.keyGenerated = true;
        }
    }

    boolean areKeyFieldsSet() throws JAXRException {
        if (this.sourceObject != null && this.targetObject != null && this.associationType != null) {
            Key key = this.sourceObject.getKey();
            Key key2 = this.targetObject.getKey();
            String string = this.associationType.getValue();
            if (key != null && key2 != null && string != null) {
                this.keyFieldsSet = true;
            }
        }
        return this.keyFieldsSet;
    }

    private void checkObjects() throws JAXRException {
        if (this.sourceObject == null || this.targetObject == null) {
            return;
        }
        Key key = this.sourceObject.getKey();
        Key key2 = this.targetObject.getKey();
        if (key == null && key2 == null) {
            this.isConfirmedBySourceOwner = true;
            this.isConfirmedByTargetOwner = true;
            this.isExtramural = false;
        }
    }
}

