/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;
import org.dom4j.tree.DefaultText;
import org.dom4j.tree.ElementIterator;
import org.dom4j.tree.ElementNameIterator;
import org.dom4j.tree.ElementQNameIterator;

public class DefaultElement
extends AbstractElement {
    private static final transient DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();
    private QName qname;
    private Branch parentBranch;
    private Object content;
    private Object attributes;

    public DefaultElement(String name) {
        this.qname = DOCUMENT_FACTORY.createQName(name);
    }

    public DefaultElement(String name, Namespace namespace) {
        this.qname = DOCUMENT_FACTORY.createQName(name, namespace);
    }

    public DefaultElement(QName qname) {
        this.qname = qname;
    }

    public DefaultElement(QName qname, int attributeCount) {
        this.qname = qname;
        if (attributeCount > 1) {
            this.attributes = new ArrayList(attributeCount);
        }
    }

    public void add(Attribute attribute) {
        if (attribute.getParent() != null) {
            String message = "The Attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, (Node)attribute, message);
        }
        if (this.attributes == null) {
            this.attributes = attribute;
        } else {
            this.attributeList().add(attribute);
        }
        this.childAdded(attribute);
    }

    protected void addNewNode(Node node) {
        if (this.content == null) {
            this.content = node;
        } else if (this.content instanceof List) {
            List list = (List)this.content;
            list.add(node);
        } else {
            List list = this.createContentList();
            list.add(this.content);
            list.add(node);
            this.content = list;
        }
        this.childAdded(node);
    }

    public List additionalNamespaces() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            int size = list.size();
            BackedList answer = this.createResultList();
            int i = 0;
            while (i < size) {
                Object object = list.get(i);
                if (object instanceof Namespace) {
                    Namespace namespace = (Namespace)object;
                    answer.addLocal(namespace);
                }
                ++i;
            }
            return answer;
        }
        if (this.content instanceof Namespace) {
            Namespace namespace = (Namespace)this.content;
            return this.createSingleResultList(namespace);
        }
        return this.createEmptyList();
    }

    public List additionalNamespaces(String defaultNamespaceURI) {
        Namespace namespace;
        if (this.content instanceof List) {
            List list = (List)this.content;
            BackedList answer = this.createResultList();
            int size = list.size();
            int i = 0;
            while (i < size) {
                Namespace namespace2;
                Object object = list.get(i);
                if (object instanceof Namespace && !defaultNamespaceURI.equals((namespace2 = (Namespace)object).getURI())) {
                    answer.addLocal(namespace2);
                }
                ++i;
            }
            return answer;
        }
        if (this.content instanceof Namespace && !defaultNamespaceURI.equals((namespace = (Namespace)this.content).getURI())) {
            return this.createSingleResultList(namespace);
        }
        return this.createEmptyList();
    }

    public Attribute attribute(int index) {
        if (this.attributes instanceof List) {
            List list = (List)this.attributes;
            return (Attribute)list.get(index);
        }
        if (this.attributes != null && index == 0) {
            return (Attribute)this.attributes;
        }
        return null;
    }

    public Attribute attribute(String name) {
        Attribute attribute;
        if (this.attributes instanceof List) {
            List list = (List)this.attributes;
            int size = list.size();
            int i = 0;
            while (i < size) {
                Attribute attribute2 = (Attribute)list.get(i);
                if (name.equals(attribute2.getName())) {
                    return attribute2;
                }
                ++i;
            }
        } else if (this.attributes != null && name.equals((attribute = (Attribute)this.attributes).getName())) {
            return attribute;
        }
        return null;
    }

    public Attribute attribute(String name, Namespace namespace) {
        return this.attribute(this.getDocumentFactory().createQName(name, namespace));
    }

    public Attribute attribute(QName qName) {
        Attribute attribute;
        if (this.attributes instanceof List) {
            List list = (List)this.attributes;
            int size = list.size();
            int i = 0;
            while (i < size) {
                Attribute attribute2 = (Attribute)list.get(i);
                if (qName.equals(attribute2.getQName())) {
                    return attribute2;
                }
                ++i;
            }
        } else if (this.attributes != null && qName.equals((attribute = (Attribute)this.attributes).getQName())) {
            return attribute;
        }
        return null;
    }

    public int attributeCount() {
        if (this.attributes instanceof List) {
            List list = (List)this.attributes;
            return list.size();
        }
        return this.attributes != null ? 1 : 0;
    }

    public Iterator attributeIterator() {
        if (this.attributes instanceof List) {
            List list = (List)this.attributes;
            return list.iterator();
        }
        if (this.attributes != null) {
            return this.createSingleIterator(this.attributes);
        }
        return AbstractElement.EMPTY_ITERATOR;
    }

    protected List attributeList() {
        if (this.attributes instanceof List) {
            return (List)this.attributes;
        }
        if (this.attributes != null) {
            List list = this.createAttributeList();
            list.add(this.attributes);
            this.attributes = list;
            return list;
        }
        List list = this.createAttributeList();
        this.attributes = list;
        return list;
    }

    protected List attributeList(int size) {
        if (this.attributes instanceof List) {
            return (List)this.attributes;
        }
        if (this.attributes != null) {
            List list = this.createAttributeList(size);
            list.add(this.attributes);
            this.attributes = list;
            return list;
        }
        List list = this.createAttributeList(size);
        this.attributes = list;
        return list;
    }

    public List attributes() {
        return new ContentListFacade(this, this.attributeList());
    }

    public void clearContent() {
        if (this.content != null) {
            this.contentRemoved();
        }
        this.content = null;
    }

    public Object clone() {
        DefaultElement answer = (DefaultElement)super.clone();
        if (answer != this) {
            answer.content = null;
            answer.attributes = null;
            answer.appendAttributes(this);
            answer.appendContent(this);
        }
        return answer;
    }

    protected List contentList() {
        if (this.content instanceof List) {
            return (List)this.content;
        }
        List list = this.createContentList();
        if (this.content != null) {
            list.add(this.content);
        }
        this.content = list;
        return list;
    }

    public List declaredNamespaces() {
        BackedList answer = this.createResultList();
        if (this.getNamespaceURI().length() > 0) {
            answer.addLocal(this.getNamespace());
        }
        if (this.content instanceof List) {
            List list = (List)this.content;
            int size = list.size();
            int i = 0;
            while (i < size) {
                Object object = list.get(i);
                if (object instanceof Namespace) {
                    answer.addLocal(object);
                }
                ++i;
            }
        } else if (this.content instanceof Namespace) {
            answer.addLocal(this.content);
        }
        return answer;
    }

    public Element element(String name) {
        Element element;
        if (this.content instanceof List) {
            List list = (List)this.content;
            int size = list.size();
            int i = 0;
            while (i < size) {
                Element element2;
                Object object = list.get(i);
                if (object instanceof Element && name.equals((element2 = (Element)object).getName())) {
                    return element2;
                }
                ++i;
            }
        } else if (this.content instanceof Element && name.equals((element = (Element)this.content).getName())) {
            return element;
        }
        return null;
    }

    public Element element(String name, Namespace namespace) {
        return this.element(this.getDocumentFactory().createQName(name, namespace));
    }

    public Element element(QName qName) {
        Element element;
        if (this.content instanceof List) {
            List list = (List)this.content;
            int size = list.size();
            int i = 0;
            while (i < size) {
                Element element2;
                Object object = list.get(i);
                if (object instanceof Element && qName.equals((element2 = (Element)object).getQName())) {
                    return element2;
                }
                ++i;
            }
        } else if (this.content instanceof Element && qName.equals((element = (Element)this.content).getQName())) {
            return element;
        }
        return null;
    }

    public Iterator elementIterator() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            return new ElementIterator(list.iterator());
        }
        if (this.content instanceof Element) {
            Element element = (Element)this.content;
            return this.createSingleIterator(element);
        }
        return AbstractElement.EMPTY_ITERATOR;
    }

    public Iterator elementIterator(String name) {
        Element element;
        if (this.content instanceof List) {
            List list = (List)this.content;
            return new ElementNameIterator(list.iterator(), name);
        }
        if (this.content instanceof Element && name.equals((element = (Element)this.content).getName())) {
            return this.createSingleIterator(element);
        }
        return AbstractElement.EMPTY_ITERATOR;
    }

    public Iterator elementIterator(String name, Namespace namespace) {
        return this.elementIterator(this.getDocumentFactory().createQName(name, namespace));
    }

    public Iterator elementIterator(QName qName) {
        Element element;
        if (this.content instanceof List) {
            List list = (List)this.content;
            return new ElementQNameIterator(list.iterator(), qName);
        }
        if (this.content instanceof Element && qName.equals((element = (Element)this.content).getQName())) {
            return this.createSingleIterator(element);
        }
        return AbstractElement.EMPTY_ITERATOR;
    }

    public List elements() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            BackedList answer = this.createResultList();
            int size = list.size();
            int i = 0;
            while (i < size) {
                Object object = list.get(i);
                if (object instanceof Element) {
                    answer.addLocal(object);
                }
                ++i;
            }
            return answer;
        }
        if (this.content instanceof Element) {
            Element element = (Element)this.content;
            return this.createSingleResultList(element);
        }
        return this.createEmptyList();
    }

    public List elements(String name) {
        Element element;
        if (this.content instanceof List) {
            List list = (List)this.content;
            BackedList answer = this.createResultList();
            int size = list.size();
            int i = 0;
            while (i < size) {
                Element element2;
                Object object = list.get(i);
                if (object instanceof Element && name.equals((element2 = (Element)object).getName())) {
                    answer.addLocal(element2);
                }
                ++i;
            }
            return answer;
        }
        if (this.content instanceof Element && name.equals((element = (Element)this.content).getName())) {
            return this.createSingleResultList(element);
        }
        return this.createEmptyList();
    }

    public List elements(String name, Namespace namespace) {
        return this.elements(this.getDocumentFactory().createQName(name, namespace));
    }

    public List elements(QName qName) {
        Element element;
        if (this.content instanceof List) {
            List list = (List)this.content;
            BackedList answer = this.createResultList();
            int size = list.size();
            int i = 0;
            while (i < size) {
                Element element2;
                Object object = list.get(i);
                if (object instanceof Element && qName.equals((element2 = (Element)object).getQName())) {
                    answer.addLocal(element2);
                }
                ++i;
            }
            return answer;
        }
        if (this.content instanceof Element && qName.equals((element = (Element)this.content).getQName())) {
            return this.createSingleResultList(element);
        }
        return this.createEmptyList();
    }

    public Document getDocument() {
        if (this.parentBranch instanceof Document) {
            return (Document)this.parentBranch;
        }
        if (this.parentBranch instanceof Element) {
            Element parent = (Element)this.parentBranch;
            return parent.getDocument();
        }
        return null;
    }

    protected DocumentFactory getDocumentFactory() {
        DocumentFactory factory = this.qname.getDocumentFactory();
        return factory != null ? factory : DOCUMENT_FACTORY;
    }

    public Namespace getNamespaceForPrefix(String prefix) {
        Namespace answer;
        Namespace namespace;
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (this.content instanceof List) {
            List list = (List)this.content;
            int size = list.size();
            int i = 0;
            while (i < size) {
                Namespace namespace2;
                Object object = list.get(i);
                if (object instanceof Namespace && prefix.equals((namespace2 = (Namespace)object).getPrefix())) {
                    return namespace2;
                }
                ++i;
            }
        } else if (this.content instanceof Namespace && prefix.equals((namespace = (Namespace)this.content).getPrefix())) {
            return namespace;
        }
        Element parent = this.getParent();
        if (parent != null && (answer = parent.getNamespaceForPrefix(prefix)) != null) {
            return answer;
        }
        if (prefix == null || prefix.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        return null;
    }

    public Namespace getNamespaceForURI(String uri) {
        Namespace namespace;
        if (uri == null || uri.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        if (uri.equals(this.getNamespaceURI())) {
            return this.getNamespace();
        }
        if (this.content instanceof List) {
            List list = (List)this.content;
            int size = list.size();
            int i = 0;
            while (i < size) {
                Namespace namespace2;
                Object object = list.get(i);
                if (object instanceof Namespace && uri.equals((namespace2 = (Namespace)object).getURI())) {
                    return namespace2;
                }
                ++i;
            }
        } else if (this.content instanceof Namespace && uri.equals((namespace = (Namespace)this.content).getURI())) {
            return namespace;
        }
        Element parent = this.getParent();
        if (parent != null) {
            return parent.getNamespaceForURI(uri);
        }
        return null;
    }

    public Element getParent() {
        return this.parentBranch instanceof Element ? (Element)this.parentBranch : null;
    }

    public QName getQName() {
        return this.qname;
    }

    public String getStringValue() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            int size = list.size();
            if (size > 0) {
                if (size == 1) {
                    return this.getContentAsStringValue(list.get(0));
                }
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < size) {
                    Object node = list.get(i);
                    String string = this.getContentAsStringValue(node);
                    if (string.length() > 0) {
                        buffer.append(string);
                    }
                    ++i;
                }
                return buffer.toString();
            }
        } else if (this.content != null) {
            return this.getContentAsStringValue(this.content);
        }
        return "";
    }

    public String getText() {
        if (this.content instanceof List) {
            return super.getText();
        }
        if (this.content != null) {
            return this.getContentAsText(this.content);
        }
        return "";
    }

    public int indexOf(Node node) {
        if (this.content instanceof List) {
            List list = (List)this.content;
            return list.indexOf(node);
        }
        return this.content != null && this.content.equals(node) ? 0 : -1;
    }

    public Node node(int index) {
        if (index >= 0) {
            Object node = this.content;
            if (this.content instanceof List) {
                List list = (List)this.content;
                if (index >= list.size()) {
                    return null;
                }
                node = list.get(index);
            }
            if (node != null) {
                if (node instanceof Node) {
                    return (Node)node;
                }
                return new DefaultText(node.toString());
            }
        }
        return null;
    }

    public int nodeCount() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            return list.size();
        }
        return this.content != null ? 1 : 0;
    }

    public Iterator nodeIterator() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            return list.iterator();
        }
        if (this.content != null) {
            return this.createSingleIterator(this.content);
        }
        return AbstractElement.EMPTY_ITERATOR;
    }

    public ProcessingInstruction processingInstruction(String target) {
        ProcessingInstruction pi;
        if (this.content instanceof List) {
            List list = (List)this.content;
            int size = list.size();
            int i = 0;
            while (i < size) {
                ProcessingInstruction pi2;
                Object object = list.get(i);
                if (object instanceof ProcessingInstruction && target.equals((pi2 = (ProcessingInstruction)object).getName())) {
                    return pi2;
                }
                ++i;
            }
        } else if (this.content instanceof ProcessingInstruction && target.equals((pi = (ProcessingInstruction)this.content).getName())) {
            return pi;
        }
        return null;
    }

    public List processingInstructions() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            BackedList answer = this.createResultList();
            int size = list.size();
            int i = 0;
            while (i < size) {
                Object object = list.get(i);
                if (object instanceof ProcessingInstruction) {
                    answer.addLocal(object);
                }
                ++i;
            }
            return answer;
        }
        if (this.content instanceof ProcessingInstruction) {
            return this.createSingleResultList(this.content);
        }
        return this.createEmptyList();
    }

    public List processingInstructions(String target) {
        ProcessingInstruction pi;
        if (this.content instanceof List) {
            List list = (List)this.content;
            BackedList answer = this.createResultList();
            int size = list.size();
            int i = 0;
            while (i < size) {
                ProcessingInstruction pi2;
                Object object = list.get(i);
                if (object instanceof ProcessingInstruction && target.equals((pi2 = (ProcessingInstruction)object).getName())) {
                    answer.addLocal(pi2);
                }
                ++i;
            }
            return answer;
        }
        if (this.content instanceof ProcessingInstruction && target.equals((pi = (ProcessingInstruction)this.content).getName())) {
            return this.createSingleResultList(pi);
        }
        return this.createEmptyList();
    }

    public boolean remove(Attribute attribute) {
        boolean answer = false;
        if (this.attributes instanceof List) {
            Attribute copy;
            List list = (List)this.attributes;
            answer = list.remove(attribute);
            if (!answer && (copy = this.attribute(attribute.getQName())) != null) {
                list.remove(copy);
                answer = true;
            }
        } else if (this.attributes != null) {
            if (attribute.equals(this.attributes)) {
                this.attributes = null;
                answer = true;
            } else {
                Attribute other = (Attribute)this.attributes;
                if (attribute.getQName().equals(other.getQName())) {
                    this.attributes = null;
                    answer = true;
                }
            }
        }
        if (answer) {
            this.childRemoved(attribute);
        }
        return answer;
    }

    protected boolean removeNode(Node node) {
        boolean answer = false;
        if (this.content != null) {
            if (this.content == node) {
                this.content = null;
                answer = true;
            } else if (this.content instanceof List) {
                List list = (List)this.content;
                answer = list.remove(node);
            }
        }
        if (answer) {
            this.childRemoved(node);
        }
        return answer;
    }

    public boolean removeProcessingInstruction(String target) {
        ProcessingInstruction pi;
        if (this.content instanceof List) {
            List list = (List)this.content;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ProcessingInstruction pi2;
                Object object = iter.next();
                if (!(object instanceof ProcessingInstruction) || !target.equals((pi2 = (ProcessingInstruction)object).getName())) continue;
                iter.remove();
                return true;
            }
        } else if (this.content instanceof ProcessingInstruction && target.equals((pi = (ProcessingInstruction)this.content).getName())) {
            this.content = null;
            return true;
        }
        return false;
    }

    protected void setAttributeList(List attributes) {
        this.attributes = attributes;
    }

    public void setAttributes(List attributes) {
        this.attributes = attributes;
        if (attributes instanceof ContentListFacade) {
            this.attributes = ((ContentListFacade)attributes).getBackingList();
        }
    }

    public void setContent(List content) {
        if (content instanceof ContentListFacade) {
            content = ((ContentListFacade)content).getBackingList();
        }
        if (content == null) {
            this.content = null;
        } else {
            int size = content.size();
            List newContent = this.createContentList(size);
            int i = 0;
            while (i < size) {
                Object object = content.get(i);
                if (object instanceof Node) {
                    Node node = (Node)object;
                    Element parent = node.getParent();
                    if (parent != null && parent != this) {
                        node = (Node)node.clone();
                    }
                    newContent.add(node);
                    this.childAdded(node);
                } else if (object != null) {
                    String text = object.toString();
                    Text node = this.getDocumentFactory().createText(text);
                    newContent.add(node);
                    this.childAdded(node);
                }
                ++i;
            }
            this.contentRemoved();
            this.content = newContent;
        }
    }

    public void setDocument(Document document) {
        if (this.parentBranch instanceof Document || document != null) {
            this.parentBranch = document;
        }
    }

    public void setParent(Element parent) {
        if (this.parentBranch instanceof Element || parent != null) {
            this.parentBranch = parent;
        }
    }

    public boolean supportsParent() {
        return true;
    }
}

