/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.exolab.castor.types.Date;
import org.exolab.castor.types.Time;

public class DatatypeHandler {
    public static final String BOOLEAN_TYPE = "boolean";
    public static final String DATE_TYPE = "date";
    public static final String DATETIME_TYPE = "dateTime";
    public static final String DOUBLE_TYPE = "double";
    public static final String FLOAT_TYPE = "float";
    public static final String INTEGER_TYPE = "integer";
    public static final String LONG_TYPE = "long";
    public static final String STRING_TYPE = "string";
    public static final String TIME_TYPE = "time";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String DATE_FORMAT_2 = "yyyy-MM-dd'T'HH:mm:ss";

    private DatatypeHandler() {
    }

    public static String guessType(String string) {
        if (string == null) {
            return null;
        }
        try {
            Integer.parseInt(string);
            return INTEGER_TYPE;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Long.parseLong(string);
                return LONG_TYPE;
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    Float.parseFloat(string);
                    return FLOAT_TYPE;
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        Double.parseDouble(string);
                        return DOUBLE_TYPE;
                    }
                    catch (NumberFormatException numberFormatException4) {
                        if (string.equals(TRUE) || string.equals(FALSE)) {
                            return BOOLEAN_TYPE;
                        }
                        try {
                            Date.parseDate(string);
                            return DATE_TYPE;
                        }
                        catch (ParseException parseException) {
                            try {
                                Time.parseTime(string);
                                return TIME_TYPE;
                            }
                            catch (ParseException parseException2) {
                                SimpleDateFormat simpleDateFormat = null;
                                simpleDateFormat = string.indexOf(46) < 0 ? new SimpleDateFormat(DATE_FORMAT) : new SimpleDateFormat(DATE_FORMAT_2);
                                try {
                                    simpleDateFormat.parse(string);
                                    return DATETIME_TYPE;
                                }
                                catch (ParseException parseException3) {
                                    return STRING_TYPE;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

