/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.document.schema;

import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaElement;
import com.sun.xml.rpc.wsdl.document.schema.SchemaEntity;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.framework.AbstractDocument;
import com.sun.xml.rpc.wsdl.framework.Defining;
import com.sun.xml.rpc.wsdl.framework.Extension;
import com.sun.xml.rpc.wsdl.framework.Kind;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class Schema
extends Extension
implements Defining {
    private AbstractDocument _document;
    private String _targetNamespaceURI;
    private SchemaElement _content;
    private List _definedEntities;
    private Map _nsPrefixes;

    public Schema(AbstractDocument abstractDocument) {
        this._document = abstractDocument;
        this._nsPrefixes = new HashMap();
        this._definedEntities = new ArrayList();
    }

    public QName getElementName() {
        return SchemaConstants.QNAME_SCHEMA;
    }

    public SchemaElement getContent() {
        return this._content;
    }

    public void setContent(SchemaElement schemaElement) {
        this._content = schemaElement;
        this._content.setSchema(this);
    }

    public void setTargetNamespaceURI(String string) {
        this._targetNamespaceURI = string;
    }

    public String getTargetNamespaceURI() {
        return this._targetNamespaceURI;
    }

    public void addPrefix(String string, String string2) {
        this._nsPrefixes.put(string, string2);
    }

    public String getURIForPrefix(String string) {
        return (String)this._nsPrefixes.get(string);
    }

    public Iterator prefixes() {
        return this._nsPrefixes.keySet().iterator();
    }

    public void defineAllEntities() {
        if (this._content == null) {
            throw new ValidationException("validation.shouldNotHappen", "missing schema content");
        }
        Iterator iterator = this._content.children();
        while (iterator.hasNext()) {
            QName qName;
            SchemaElement schemaElement = (SchemaElement)iterator.next();
            if (schemaElement.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE)) {
                qName = new QName(this._targetNamespaceURI, schemaElement.getValueOfMandatoryAttribute("name"));
                this.defineEntity(schemaElement, SchemaKinds.XSD_ATTRIBUTE, qName);
                continue;
            }
            if (schemaElement.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE_GROUP)) {
                qName = new QName(this._targetNamespaceURI, schemaElement.getValueOfMandatoryAttribute("name"));
                this.defineEntity(schemaElement, SchemaKinds.XSD_ATTRIBUTE_GROUP, qName);
                continue;
            }
            if (schemaElement.getQName().equals(SchemaConstants.QNAME_ELEMENT)) {
                qName = new QName(this._targetNamespaceURI, schemaElement.getValueOfMandatoryAttribute("name"));
                this.defineEntity(schemaElement, SchemaKinds.XSD_ELEMENT, qName);
                continue;
            }
            if (schemaElement.getQName().equals(SchemaConstants.QNAME_GROUP)) {
                qName = new QName(this._targetNamespaceURI, schemaElement.getValueOfMandatoryAttribute("name"));
                this.defineEntity(schemaElement, SchemaKinds.XSD_GROUP, qName);
                continue;
            }
            if (schemaElement.getQName().equals(SchemaConstants.QNAME_COMPLEX_TYPE)) {
                qName = new QName(this._targetNamespaceURI, schemaElement.getValueOfMandatoryAttribute("name"));
                this.defineEntity(schemaElement, SchemaKinds.XSD_TYPE, qName);
                continue;
            }
            if (!schemaElement.getQName().equals(SchemaConstants.QNAME_SIMPLE_TYPE)) continue;
            qName = new QName(this._targetNamespaceURI, schemaElement.getValueOfMandatoryAttribute("name"));
            this.defineEntity(schemaElement, SchemaKinds.XSD_TYPE, qName);
        }
    }

    public void defineEntity(SchemaElement schemaElement, Kind kind, QName qName) {
        SchemaEntity schemaEntity = new SchemaEntity(this, schemaElement, kind, qName);
        this._document.define(schemaEntity);
        this._definedEntities.add(schemaEntity);
    }

    public Iterator definedEntities() {
        return this._definedEntities.iterator();
    }

    public void validateThis() {
        if (this._content == null) {
            throw new ValidationException("validation.shouldNotHappen", "missing schema content");
        }
    }

    public String asString(QName qName) {
        if (qName.getNamespaceURI().equals("")) {
            return qName.getLocalPart();
        }
        Iterator iterator = this.prefixes();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.equals(qName.getNamespaceURI())) continue;
            return string + ":" + qName.getLocalPart();
        }
        return null;
    }
}

