/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.sp;

import com.sun.xml.rpc.sp.AttributeDecl;
import com.sun.xml.rpc.sp.AttributesExImpl;
import com.sun.xml.rpc.sp.ContentModel;
import com.sun.xml.rpc.sp.ElementDecl;
import com.sun.xml.rpc.sp.EndOfInputException;
import com.sun.xml.rpc.sp.EntityDecl;
import com.sun.xml.rpc.sp.ExternalEntity;
import com.sun.xml.rpc.sp.InputEntity;
import com.sun.xml.rpc.sp.InternalEntity;
import com.sun.xml.rpc.sp.MessageCatalog;
import com.sun.xml.rpc.sp.NamespaceSupport;
import com.sun.xml.rpc.sp.ParseException;
import com.sun.xml.rpc.sp.Resolver;
import com.sun.xml.rpc.sp.SimpleHashtable;
import com.sun.xml.rpc.sp.XmlChars;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class Parser {
    private String curName = null;
    private String curValue = null;
    private String curURI = null;
    private InputEntity in;
    private AttributesExImpl attTmp;
    private String[] parts = new String[3];
    private StringBuffer strTmp;
    private char[] nameTmp;
    private NameCache nameCache;
    private char[] charTmp = new char[2];
    private boolean namespace = false;
    private NamespaceSupport ns = null;
    private boolean isInAttribute = false;
    private boolean inExternalPE;
    private boolean doLexicalPE;
    private boolean donePrologue;
    private boolean doneEpilogue;
    private boolean doneContent;
    private AttributesExImpl attr = null;
    private int attrIndex = 0;
    private boolean startEmptyStack = true;
    private boolean isStandalone;
    private String rootElementName;
    private boolean ignoreDeclarations;
    private SimpleHashtable elements = new SimpleHashtable(47);
    private SimpleHashtable params = new SimpleHashtable(7);
    Map notations = new HashMap(7);
    SimpleHashtable entities = new SimpleHashtable(17);
    static final String strANY = "ANY";
    static final String strEMPTY = "EMPTY";
    private Locale locale;
    private EntityResolver resolver;
    Locator locator;
    private boolean fastStandalone = false;
    private static final String XmlLang = "xml:lang";
    static final Catalog messages = new Catalog();
    private InputSource input = null;
    private boolean coalescing = false;
    private StringBuffer charsBuffer = null;
    private int cacheRet = -1;
    private String cacheName = null;
    private String cacheValue = null;
    private String simpleCharsBuffer = null;
    private FastStack stack = new FastStack(100);
    private PIQueue piQueue = new PIQueue(10);
    private static final int ELEMENT_IN_CONTENT = 1;
    private static final int ELEMENT_ROOT = 2;
    private static final int CONTENT_IN_ELEMENT = 4;
    private static final int CONTENT_IN_INTREF = 8;
    private static final int CONTENT_IN_EXTREF = 16;
    private static final int ELEMENT = 256;
    private static final int CONTENT = 1024;
    private static final int START = 0;
    private static final int END = 1;
    private static final int ATTR = 2;
    private static final int CHARS = 3;
    private static final int PI = 5;
    private static final int EMPTY = 10;
    private boolean haveAttributes = false;
    private int startLine;
    private boolean hasContent = true;
    static /* synthetic */ Class class$com$sun$xml$rpc$sp$Parser;

    public void setLocale(Locale locale) throws ParseException {
        if (locale != null && !messages.isLocaleSupported(locale.toString())) {
            this.fatal(messages.getMessage(this.locale, "P-078", new Object[]{locale}));
        }
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getCurName() {
        return this.curName;
    }

    public String getCurURI() {
        return this.curURI;
    }

    public String getCurValue() {
        return this.curValue;
    }

    public int getLineNumber() {
        return this.locator.getLineNumber();
    }

    public int getColumnNumber() {
        return this.locator.getColumnNumber();
    }

    public String getPublicId() {
        return this.locator.getPublicId();
    }

    public String getSystemId() {
        return this.locator.getSystemId();
    }

    public Locale chooseLocale(String[] stringArray) throws ParseException {
        Locale locale = messages.chooseLocale(stringArray);
        if (locale != null) {
            this.setLocale(locale);
        }
        return locale;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setFastStandalone(boolean bl) {
        this.fastStandalone = bl;
    }

    public boolean isFastStandalone() {
        return this.fastStandalone;
    }

    private void init() {
        this.in = null;
        this.attTmp = new AttributesExImpl();
        this.strTmp = new StringBuffer();
        this.nameTmp = new char[20];
        this.nameCache = new NameCache();
        if (this.namespace) {
            if (this.ns == null) {
                this.ns = new NamespaceSupport();
            } else {
                this.ns.reset();
            }
        }
        this.isStandalone = false;
        this.rootElementName = null;
        this.isInAttribute = false;
        this.inExternalPE = false;
        this.doLexicalPE = false;
        this.donePrologue = false;
        this.doneEpilogue = false;
        this.doneContent = false;
        this.attr = null;
        this.attrIndex = 0;
        this.startEmptyStack = true;
        this.entities.clear();
        this.notations.clear();
        this.params.clear();
        this.elements.clear();
        this.ignoreDeclarations = false;
        this.stack.clear();
        this.piQueue.clear();
        this.builtin("amp", "&#38;");
        this.builtin("lt", "&#60;");
        this.builtin("gt", ">");
        this.builtin("quot", "\"");
        this.builtin("apos", "'");
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.resolver == null) {
            this.resolver = new Resolver();
        }
    }

    private void builtin(String string, String string2) {
        InternalEntity internalEntity = new InternalEntity(string, string2.toCharArray());
        this.entities.put(string, internalEntity);
    }

    void afterRoot() throws ParseException {
    }

    void afterDocument() {
    }

    private void whitespace(String string) throws IOException, ParseException {
        if (!this.maybeWhitespace()) {
            this.fatal("P-004", new Object[]{messages.getMessage(this.locale, string)});
        }
    }

    private boolean maybeWhitespace() throws IOException, ParseException {
        if (!this.inExternalPE || !this.doLexicalPE) {
            return this.in.maybeWhitespace();
        }
        char c = this.getc();
        boolean bl = false;
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            bl = true;
            if (this.in.isEOF() && !this.in.isInternal()) {
                return bl;
            }
            c = this.getc();
        }
        this.ungetc();
        return bl;
    }

    private String maybeGetName() throws IOException, ParseException {
        NameCacheEntry nameCacheEntry = this.maybeGetNameCacheEntry();
        return nameCacheEntry == null ? null : nameCacheEntry.name;
    }

    private NameCacheEntry maybeGetNameCacheEntry() throws IOException, ParseException {
        char c = this.getc();
        if (!XmlChars.isLetter(c) && c != ':' && c != '_') {
            this.ungetc();
            return null;
        }
        return this.nameCharString(c);
    }

    private String getNmtoken() throws ParseException, IOException {
        char c = this.getc();
        if (!XmlChars.isNameChar(c)) {
            this.fatal("P-006", new Object[]{new Character(c)});
        }
        return this.nameCharString((char)c).name;
    }

    private NameCacheEntry nameCharString(char c) throws IOException, ParseException {
        int n = 1;
        this.nameTmp[0] = c;
        while ((c = this.in.getNameChar()) != '\u0000') {
            if (n >= this.nameTmp.length) {
                char[] cArray = new char[this.nameTmp.length + 10];
                System.arraycopy(this.nameTmp, 0, cArray, 0, this.nameTmp.length);
                this.nameTmp = cArray;
            }
            this.nameTmp[n++] = c;
        }
        return this.nameCache.lookupEntry(this.nameTmp, n);
    }

    private void parseLiteral(boolean bl) throws IOException, ParseException {
        boolean bl2 = this.doLexicalPE;
        this.doLexicalPE = bl;
        char c = this.getc();
        InputEntity inputEntity = this.in;
        if (c != '\'' && c != '\"') {
            this.fatal("P-007");
        }
        this.isInAttribute = !bl;
        this.strTmp = new StringBuffer();
        while (true) {
            String string;
            if (this.in != inputEntity && this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            char c2 = this.getc();
            if (c2 == c && this.in == inputEntity) break;
            if (c2 == '&') {
                string = this.maybeGetName();
                if (string != null) {
                    this.nextChar(';', "F-020", string);
                    if (bl) {
                        this.strTmp.append('&');
                        this.strTmp.append(string);
                        this.strTmp.append(';');
                        continue;
                    }
                    this.expandEntityInLiteral(string, this.entities, bl);
                    continue;
                }
                c2 = this.getc();
                if (c2 == '#') {
                    int n = this.parseCharNumber();
                    if (n > 65535) {
                        n = this.surrogatesToCharTmp(n);
                        this.strTmp.append(this.charTmp[0]);
                        if (n != 2) continue;
                        this.strTmp.append(this.charTmp[1]);
                        continue;
                    }
                    this.strTmp.append((char)n);
                    continue;
                }
                this.fatal("P-009");
                continue;
            }
            if (c2 == '%' && bl) {
                string = this.maybeGetName();
                if (string != null) {
                    this.nextChar(';', "F-021", string);
                    if (this.inExternalPE) {
                        this.expandEntityInLiteral(string, this.params, bl);
                        continue;
                    }
                    this.fatal("P-010", new Object[]{string});
                    continue;
                }
                this.fatal("P-011");
            }
            if (!bl) {
                if (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r') {
                    this.strTmp.append(' ');
                    continue;
                }
                if (c2 == '<') {
                    this.fatal("P-012");
                }
            }
            this.strTmp.append(c2);
        }
        this.isInAttribute = false;
        this.doLexicalPE = bl2;
    }

    private void expandEntityInLiteral(String string, SimpleHashtable simpleHashtable, boolean bl) throws ParseException, IOException {
        Object object = simpleHashtable.get(string);
        if (object instanceof InternalEntity) {
            InternalEntity internalEntity = (InternalEntity)object;
            this.pushReader(internalEntity.buf, string, !internalEntity.isPE);
        } else if (object instanceof ExternalEntity) {
            if (!bl) {
                this.fatal("P-013", new Object[]{string});
            }
            this.pushReader((ExternalEntity)object);
        } else if (object == null) {
            this.fatal(simpleHashtable == this.params ? "V-022" : "P-014", new Object[]{string});
        }
    }

    private String getQuotedString(String string, String string2) throws IOException, ParseException {
        char c;
        char c2 = this.in.getc();
        if (c2 != '\'' && c2 != '\"') {
            this.fatal("P-015", new Object[]{messages.getMessage(this.locale, string, new Object[]{string2})});
        }
        this.strTmp = new StringBuffer();
        while ((c = this.in.getc()) != c2) {
            this.strTmp.append(c);
        }
        return this.strTmp.toString();
    }

    private String parsePublicId() throws IOException, ParseException {
        String string = this.getQuotedString("F-033", null);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(" \r\n-'()+,./:=?;!*#@$_%0123456789".indexOf(c) != -1 || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                this.fatal("P-016", new Object[]{new Character(c)});
            }
            ++n;
        }
        this.strTmp = new StringBuffer();
        this.strTmp.append(string);
        return this.normalize(false);
    }

    /*
     * Unable to fully structure code
     */
    private boolean maybeComment(boolean var1_1) throws IOException, ParseException {
        if (!this.in.peek(var1_1 != false ? "!--" : "<!--", null)) {
            return false;
        }
        var2_2 = this.doLexicalPE;
        this.doLexicalPE = false;
        var3_3 = false;
        if (!var3_3) ** GOTO lbl-1000
        this.strTmp = new StringBuffer();
lbl-1000:
        // 2 sources

        {
            while (true) {
                if ((var4_4 = this.getc()) == '-') {
                    var4_4 = this.getc();
                    if (var4_4 != '-') {
                        if (var3_3) {
                            this.strTmp.append('-');
                        }
                        this.ungetc();
                        continue;
                    }
                    this.nextChar('>', "F-022", null);
                    break;
                }
                if (!var3_3) continue;
                this.strTmp.append(var4_4);
            }
        }
        this.doLexicalPE = var2_2;
        return true;
    }

    private void maybeXmlDecl() throws IOException, ParseException {
        if (!this.peek("<?xml")) {
            return;
        }
        this.readVersion(true, "1.0");
        this.readEncoding(false);
        this.readStandalone();
        this.maybeWhitespace();
        if (!this.peek("?>")) {
            char c = this.getc();
            this.fatal("P-023", new Object[]{Integer.toHexString(c), new Character(c)});
        }
    }

    private String maybeReadAttribute(String string, boolean bl) throws IOException, ParseException {
        if (!this.maybeWhitespace()) {
            if (!bl) {
                return null;
            }
            this.fatal("P-024", new Object[]{string});
        }
        if (!this.peek(string)) {
            if (bl) {
                this.fatal("P-024", new Object[]{string});
            } else {
                this.ungetc();
                return null;
            }
        }
        this.maybeWhitespace();
        this.nextChar('=', "F-023", null);
        this.maybeWhitespace();
        return this.getQuotedString("F-035", string);
    }

    private void readVersion(boolean bl, String string) throws IOException, ParseException {
        String string2 = this.maybeReadAttribute("version", bl);
        if (bl && string2 == null) {
            this.fatal("P-025", new Object[]{string});
        }
        if (string2 != null) {
            int n = string2.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string2.charAt(n2);
                if (!(c >= '0' && c <= '9' || c == '_' || c == '.' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':' || c == '-')) {
                    this.fatal("P-026", new Object[]{string2});
                }
                ++n2;
            }
        }
        if (string2 != null && !string2.equals(string)) {
            this.error("P-027", new Object[]{string, string2});
        }
    }

    private void maybeMisc(boolean bl) throws IOException, ParseException {
        while (!bl || !this.in.isEOF()) {
            if (!this.maybeComment(false) && !this.maybePI(false) && !this.maybeWhitespace()) break;
        }
    }

    private String getMarkupDeclname(String string, boolean bl) throws IOException, ParseException {
        this.whitespace(string);
        String string2 = this.maybeGetName();
        if (string2 == null) {
            this.fatal("P-005", new Object[]{messages.getMessage(this.locale, string)});
        }
        return string2;
    }

    private boolean maybeDoctypeDecl() throws IOException, ParseException {
        String string;
        if (!this.peek("<!DOCTYPE")) {
            return false;
        }
        ExternalEntity externalEntity = null;
        this.rootElementName = this.getMarkupDeclname("F-014", true);
        if (this.maybeWhitespace() && (externalEntity = this.maybeExternalID()) != null) {
            this.maybeWhitespace();
        }
        if (this.in.peekc('[')) {
            this.in.startRemembering();
            while (true) {
                if (this.in.isEOF() && !this.in.isDocument()) {
                    this.in = this.in.pop();
                    continue;
                }
                if (this.maybeMarkupDecl() || this.maybePEReference() || this.maybeWhitespace()) continue;
                if (!this.peek("<![")) break;
                this.fatal("P-028");
            }
            this.nextChar(']', "F-024", null);
            this.maybeWhitespace();
        }
        this.nextChar('>', "F-025", null);
        if (externalEntity != null) {
            // empty if block
        }
        this.params.clear();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.notations.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            Object v = this.notations.get(string);
            if (v == Boolean.TRUE) {
                arrayList.add(string);
                continue;
            }
            if (!(v instanceof String)) continue;
            arrayList.add(string);
        }
        while (!arrayList.isEmpty()) {
            string = arrayList.get(0);
            arrayList.remove(string);
            this.notations.remove(string);
        }
        return true;
    }

    private boolean maybeMarkupDecl() throws IOException, ParseException {
        return this.maybeElementDecl() || this.maybeAttlistDecl() || this.maybeEntityDecl() || this.maybeNotationDecl() || this.maybePI(false) || this.maybeComment(false);
    }

    private void readStandalone() throws IOException, ParseException {
        String string = this.maybeReadAttribute("standalone", false);
        if (string == null || "no".equals(string)) {
            return;
        }
        if ("yes".equals(string)) {
            this.isStandalone = true;
            return;
        }
        this.fatal("P-029", new Object[]{string});
    }

    /*
     * Unable to fully structure code
     */
    private boolean isXmlLang(String var1_1) {
        block6: {
            block5: {
                if (var1_1.length() < 2) {
                    return false;
                }
                var3_2 = var1_1.charAt(1);
                if (var3_2 != '-') break block5;
                var3_2 = var1_1.charAt(0);
                if (var3_2 != 'i' && var3_2 != 'I' && var3_2 != 'x' && var3_2 != 'X') {
                    return false;
                }
                var2_3 = 1;
                ** GOTO lbl24
            }
            if ((var3_2 < 'a' || var3_2 > 'z') && (var3_2 < 'A' || var3_2 > 'Z')) break block6;
            var3_2 = var1_1.charAt(0);
            if (!(var3_2 >= 'a' && var3_2 <= 'z' || var3_2 >= 'A' && var3_2 <= 'Z')) {
                return false;
            }
            var2_3 = 2;
            if (true) ** GOTO lbl24
        }
        return false;
        do {
            if ((var3_2 = var1_1.charAt(var2_3)) == '-') ** GOTO lbl-1000
            break;
            while ((var3_2 = var1_1.charAt(var2_3)) >= 'a' && var3_2 <= 'z' || var3_2 >= 'A' && var3_2 <= 'Z') lbl-1000:
            // 2 sources

            {
                if (++var2_3 < var1_1.length()) continue;
            }
lbl24:
            // 4 sources

        } while (var2_3 < var1_1.length());
        return var1_1.length() == var2_3 && var3_2 != '-';
    }

    private boolean defaultAttributes(AttributesExImpl attributesExImpl, ElementDecl elementDecl) throws ParseException {
        boolean bl = false;
        Iterator iterator = elementDecl.attributes.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = attributesExImpl.getValue(string);
            if (string2 != null) continue;
            AttributeDecl attributeDecl = (AttributeDecl)elementDecl.attributes.get(string);
            if (attributeDecl.defaultValue == null) continue;
            attributesExImpl.addAttribute("", string, string, attributeDecl.type, attributeDecl.defaultValue, attributeDecl.defaultValue, false);
            bl = true;
        }
        return bl;
    }

    private boolean maybeElementDecl() throws IOException, ParseException {
        InputEntity inputEntity = this.peekDeclaration("!ELEMENT");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-015", true);
        ElementDecl elementDecl = (ElementDecl)this.elements.get(string);
        boolean bl = false;
        if (elementDecl != null) {
            if (elementDecl.contentType != null) {
                elementDecl = new ElementDecl(string);
            }
        } else {
            elementDecl = new ElementDecl(string);
            if (!this.ignoreDeclarations) {
                this.elements.put(elementDecl.name, elementDecl);
                bl = true;
            }
        }
        elementDecl.isFromInternalSubset = !this.inExternalPE;
        this.whitespace("F-000");
        if (this.peek(strEMPTY)) {
            elementDecl.contentType = strEMPTY;
            elementDecl.ignoreWhitespace = true;
        } else if (this.peek(strANY)) {
            elementDecl.contentType = strANY;
            elementDecl.ignoreWhitespace = false;
        } else {
            elementDecl.contentType = this.getMixedOrChildren(elementDecl);
        }
        this.maybeWhitespace();
        char c = this.getc();
        if (c != '>') {
            this.fatal("P-036", new Object[]{string, new Character(c)});
        }
        return true;
    }

    private String getMixedOrChildren(ElementDecl elementDecl) throws IOException, ParseException {
        this.strTmp = new StringBuffer();
        this.nextChar('(', "F-028", elementDecl.name);
        InputEntity inputEntity = this.in;
        this.maybeWhitespace();
        this.strTmp.append('(');
        if (this.peek("#PCDATA")) {
            this.strTmp.append("#PCDATA");
            this.getMixed(elementDecl.name, inputEntity);
            elementDecl.ignoreWhitespace = false;
        } else {
            elementDecl.model = this.getcps(elementDecl.name, inputEntity);
            elementDecl.ignoreWhitespace = true;
        }
        return this.strTmp.toString();
    }

    private ContentModel getcps(String string, InputEntity inputEntity) throws IOException, ParseException {
        boolean bl = false;
        char c = '\u0000';
        ContentModel contentModel = null;
        ContentModel contentModel2 = null;
        ContentModel contentModel3 = null;
        do {
            String string2;
            if ((string2 = this.maybeGetName()) != null) {
                this.strTmp.append(string2);
                contentModel = this.getFrequency(null);
            } else if (this.peek("(")) {
                InputEntity inputEntity2 = this.in;
                this.strTmp.append('(');
                this.maybeWhitespace();
                contentModel = this.getFrequency(this.getcps(string, inputEntity2));
            } else {
                this.fatal(c == '\u0000' ? "P-039" : (c == ',' ? "P-037" : "P-038"), new Object[]{new Character(this.getc())});
            }
            this.maybeWhitespace();
            if (bl) {
                char c2 = this.getc();
                if (contentModel2 != null) {
                    contentModel2 = contentModel2.next = null;
                }
                if (c2 == c) {
                    this.strTmp.append(c);
                    this.maybeWhitespace();
                    continue;
                }
                if (c2 == ')') {
                    this.ungetc();
                    continue;
                }
                this.fatal(c == '\u0000' ? "P-041" : "P-040", new Object[]{new Character(c2), new Character(c)});
            } else {
                c = this.getc();
                if (c != '|' && c != ',') {
                    contentModel3 = contentModel2 = contentModel;
                    this.ungetc();
                    continue;
                }
                bl = true;
                contentModel2 = null;
                contentModel3 = null;
                this.strTmp.append(c);
            }
            this.maybeWhitespace();
        } while (!this.peek(")"));
        this.strTmp.append(')');
        return this.getFrequency(contentModel3);
    }

    private ContentModel getFrequency(ContentModel contentModel) throws IOException, ParseException {
        char c = this.getc();
        if (c == '?' || c == '+' || c == '*') {
            this.strTmp.append(c);
            if (contentModel == null) {
                return null;
            }
            if (contentModel.type == '\u0000') {
                contentModel.type = c;
                return contentModel;
            }
            return null;
        }
        this.ungetc();
        return contentModel;
    }

    /*
     * Unable to fully structure code
     */
    private void getMixed(String var1_1, InputEntity var2_2) throws IOException, ParseException {
        this.maybeWhitespace();
        if (!this.peek(")*") && !this.peek(")")) ** GOTO lbl18
        this.strTmp.append(')');
        return;
lbl-1000:
        // 1 sources

        {
            this.strTmp.append('|');
            this.maybeWhitespace();
            var3_3 = this.maybeGetName();
            if (var3_3 == null) {
                this.fatal("P-042", new Object[]{var1_1, Integer.toHexString(this.getc())});
            }
            this.strTmp.append(var3_3);
            this.maybeWhitespace();
lbl18:
            // 2 sources

            ** while (this.peek((String)"|"))
        }
lbl19:
        // 1 sources

        if (!this.peek(")*")) {
            this.fatal("P-043", new Object[]{var1_1, new Character(this.getc())});
        }
        this.strTmp.append(')');
    }

    private boolean maybeAttlistDecl() throws IOException, ParseException {
        InputEntity inputEntity = this.peekDeclaration("!ATTLIST");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-016", true);
        ElementDecl elementDecl = (ElementDecl)this.elements.get(string);
        if (elementDecl == null) {
            elementDecl = new ElementDecl(string);
            if (!this.ignoreDeclarations) {
                this.elements.put(string, elementDecl);
            }
        }
        this.maybeWhitespace();
        while (!this.peek(">")) {
            int n;
            ArrayList<String> arrayList;
            string = this.maybeGetName();
            if (string == null) {
                this.fatal("P-044", new Object[]{new Character(this.getc())});
            }
            this.whitespace("F-001");
            AttributeDecl attributeDecl = new AttributeDecl(string);
            boolean bl = attributeDecl.isFromInternalSubset = !this.inExternalPE;
            if (this.peek("CDATA")) {
                attributeDecl.type = "CDATA";
            } else if (this.peek("IDREFS")) {
                attributeDecl.type = "IDREFS";
            } else if (this.peek("IDREF")) {
                attributeDecl.type = "IDREF";
            } else if (this.peek("ID")) {
                attributeDecl.type = "ID";
                if (elementDecl.id == null) {
                    elementDecl.id = string;
                }
            } else if (this.peek("ENTITY")) {
                attributeDecl.type = "ENTITY";
            } else if (this.peek("ENTITIES")) {
                attributeDecl.type = "ENTITIES";
            } else if (this.peek("NMTOKENS")) {
                attributeDecl.type = "NMTOKENS";
            } else if (this.peek("NMTOKEN")) {
                attributeDecl.type = "NMTOKEN";
            } else if (this.peek("NOTATION")) {
                attributeDecl.type = "NOTATION";
                this.whitespace("F-002");
                this.nextChar('(', "F-029", null);
                this.maybeWhitespace();
                arrayList = new ArrayList();
                do {
                    if ((string = this.maybeGetName()) == null) {
                        this.fatal("P-068");
                    }
                    arrayList.add(string);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
                attributeDecl.values = new String[arrayList.size()];
                n = 0;
                while (n < arrayList.size()) {
                    attributeDecl.values[n] = (String)arrayList.get(n);
                    ++n;
                }
            } else if (this.peek("(")) {
                attributeDecl.type = "ENUMERATION";
                this.maybeWhitespace();
                arrayList = new ArrayList<String>();
                do {
                    string = this.getNmtoken();
                    arrayList.add(string);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
                attributeDecl.values = new String[arrayList.size()];
                n = 0;
                while (n < arrayList.size()) {
                    attributeDecl.values[n] = (String)arrayList.get(n);
                    ++n;
                }
            } else {
                this.fatal("P-045", new Object[]{string, new Character(this.getc())});
            }
            this.whitespace("F-003");
            if (this.peek("#REQUIRED")) {
                attributeDecl.isRequired = true;
            } else if (this.peek("#FIXED")) {
                attributeDecl.isFixed = true;
                this.whitespace("F-004");
                this.parseLiteral(false);
                attributeDecl.defaultValue = attributeDecl.type != "CDATA" ? this.normalize(false) : this.strTmp.toString();
            } else if (!this.peek("#IMPLIED")) {
                this.parseLiteral(false);
                attributeDecl.defaultValue = attributeDecl.type != "CDATA" ? this.normalize(false) : this.strTmp.toString();
            }
            if (XmlLang.equals(attributeDecl.name) && attributeDecl.defaultValue != null && !this.isXmlLang(attributeDecl.defaultValue)) {
                this.error("P-033", new Object[]{attributeDecl.defaultValue});
            }
            if (!this.ignoreDeclarations && elementDecl.attributes.get(attributeDecl.name) == null) {
                elementDecl.attributes.put(attributeDecl.name, attributeDecl);
            }
            this.maybeWhitespace();
        }
        return true;
    }

    private String normalize(boolean bl) throws ParseException {
        String string = this.strTmp.toString();
        String string2 = string.trim();
        boolean bl2 = false;
        if (string != string2) {
            string = string2;
            string2 = null;
            bl2 = true;
        }
        this.strTmp = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!XmlChars.isSpace(c)) {
                this.strTmp.append(c);
            } else {
                this.strTmp.append(' ');
                while (++n < string.length() && XmlChars.isSpace(string.charAt(n))) {
                    bl2 = true;
                }
                --n;
            }
            ++n;
        }
        if (bl2) {
            return this.strTmp.toString();
        }
        return string;
    }

    private boolean maybeConditionalSect() throws IOException, ParseException {
        if (!this.peek("<![")) {
            return false;
        }
        InputEntity inputEntity = this.in;
        this.maybeWhitespace();
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-046");
        }
        this.maybeWhitespace();
        this.nextChar('[', "F-030", null);
        if ("INCLUDE".equals(string)) {
            while (true) {
                if (this.in.isEOF() && this.in != inputEntity) {
                    this.in = this.in.pop();
                    continue;
                }
                if (this.in.isEOF()) {
                    this.in = this.in.pop();
                }
                if (!this.peek("]]>")) {
                    this.doLexicalPE = false;
                    if (this.maybeWhitespace() || this.maybePEReference()) continue;
                    this.doLexicalPE = true;
                    if (this.maybeMarkupDecl() || this.maybeConditionalSect()) continue;
                    this.fatal("P-047");
                    continue;
                }
                break;
            }
        } else if ("IGNORE".equals(string)) {
            int n = 1;
            this.doLexicalPE = false;
            while (n > 0) {
                char c = this.getc();
                if (c == '<') {
                    if (!this.peek("![")) continue;
                    ++n;
                    continue;
                }
                if (c != ']' || !this.peek("]>")) continue;
                --n;
            }
        } else {
            this.fatal("P-048", new Object[]{string});
        }
        return true;
    }

    private int parseCharNumber() throws ParseException, IOException {
        int n = 0;
        if (this.getc() != 'x') {
            this.ungetc();
            while (true) {
                char c;
                if ((c = this.getc()) >= '0' && c <= '9') {
                    n *= 10;
                    n += c - 48;
                    continue;
                }
                if (c == ';') {
                    return n;
                }
                this.fatal("P-049");
            }
        }
        while (true) {
            char c;
            if ((c = this.getc()) >= '0' && c <= '9') {
                n <<= 4;
                n += c - 48;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                n <<= 4;
                n += 10 + (c - 97);
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                n <<= 4;
                n += 10 + (c - 65);
                continue;
            }
            if (c == ';') {
                return n;
            }
            this.fatal("P-050");
        }
    }

    private int surrogatesToCharTmp(int n) throws ParseException {
        if (n <= 65535) {
            if (XmlChars.isChar(n)) {
                this.charTmp[0] = (char)n;
                return 1;
            }
        } else if (n <= 0x10FFFF) {
            this.charTmp[0] = (char)(0xD800 | (n -= 65536) >> 10 & 0x3FF);
            this.charTmp[1] = (char)(0xDC00 | n & 0x3FF);
            return 2;
        }
        this.fatal("P-051", new Object[]{Integer.toHexString(n)});
        return -1;
    }

    private boolean maybePEReference() throws IOException, ParseException {
        if (!this.in.peekc('%')) {
            return false;
        }
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-011");
        }
        this.nextChar(';', "F-021", string);
        Object object = this.params.get(string);
        if (object instanceof InternalEntity) {
            InternalEntity internalEntity = (InternalEntity)object;
            this.pushReader(internalEntity.buf, string, false);
        } else if (object instanceof ExternalEntity) {
            this.externalParameterEntity((ExternalEntity)object);
        } else if (object == null) {
            this.ignoreDeclarations = true;
            this.warning("V-022", new Object[]{string});
        }
        return true;
    }

    private boolean maybeEntityDecl() throws IOException, ParseException {
        boolean bl;
        SimpleHashtable simpleHashtable;
        InputEntity inputEntity = this.peekDeclaration("!ENTITY");
        if (inputEntity == null) {
            return false;
        }
        this.doLexicalPE = false;
        this.whitespace("F-005");
        if (this.in.peekc('%')) {
            this.whitespace("F-006");
            simpleHashtable = this.params;
        } else {
            simpleHashtable = this.entities;
        }
        this.ungetc();
        this.doLexicalPE = true;
        String string = this.getMarkupDeclname("F-017", false);
        this.whitespace("F-007");
        ExternalEntity externalEntity = this.maybeExternalID();
        boolean bl2 = bl = simpleHashtable.get(string) == null;
        if (!bl && simpleHashtable == this.entities) {
            this.warning("P-054", new Object[]{string});
        }
        bl &= !this.ignoreDeclarations;
        if (externalEntity == null) {
            this.doLexicalPE = false;
            this.parseLiteral(true);
            this.doLexicalPE = true;
            if (bl) {
                char[] cArray = new char[this.strTmp.length()];
                if (cArray.length != 0) {
                    this.strTmp.getChars(0, cArray.length, cArray, 0);
                }
                InternalEntity internalEntity = new InternalEntity(string, cArray);
                internalEntity.isPE = simpleHashtable == this.params;
                internalEntity.isFromInternalSubset = !this.inExternalPE;
                simpleHashtable.put(string, internalEntity);
            }
        } else {
            if (simpleHashtable == this.entities && this.maybeWhitespace() && this.peek("NDATA")) {
                externalEntity.notation = this.getMarkupDeclname("F-018", false);
            }
            externalEntity.name = string;
            externalEntity.isPE = simpleHashtable == this.params;
            boolean bl3 = externalEntity.isFromInternalSubset = !this.inExternalPE;
            if (bl) {
                simpleHashtable.put(string, externalEntity);
            }
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-031", string);
        return true;
    }

    private ExternalEntity maybeExternalID() throws IOException, ParseException {
        String string = null;
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            string = this.parsePublicId();
        } else if (!this.peek("SYSTEM")) {
            return null;
        }
        ExternalEntity externalEntity = new ExternalEntity(this.in);
        externalEntity.publicId = string;
        this.whitespace("F-008");
        externalEntity.systemId = this.parseSystemId();
        return externalEntity;
    }

    private String parseSystemId() throws IOException, ParseException {
        String string = this.getQuotedString("F-034", null);
        int n = string.indexOf(58);
        if (n == -1 || string.indexOf(47) < n) {
            String string2 = this.in.getSystemId();
            if (string2 == null) {
                string2 = "NODOCTYPE:///tmp/";
            }
            if (string.length() == 0) {
                string = ".";
            }
            string2 = string2.substring(0, string2.lastIndexOf(47) + 1);
            if (string.charAt(0) != '/') {
                string = string2 + string;
            } else {
                throw new InternalError();
            }
        }
        if (string.indexOf(35) != -1) {
            this.error("P-056", new Object[]{string});
        }
        return string;
    }

    private void maybeTextDecl() throws IOException, ParseException {
        if (this.peek("<?xml")) {
            this.readVersion(false, "1.0");
            this.readEncoding(true);
            this.maybeWhitespace();
            if (!this.peek("?>")) {
                this.fatal("P-057");
            }
        }
    }

    private void externalParameterEntity(ExternalEntity externalEntity) throws IOException, ParseException {
        if (this.isStandalone && this.fastStandalone) {
            return;
        }
        this.inExternalPE = true;
        this.pushReader(externalEntity);
        InputEntity inputEntity = this.in;
        this.maybeTextDecl();
        while (!inputEntity.isEOF()) {
            if (this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            this.doLexicalPE = false;
            if (this.maybeWhitespace() || this.maybePEReference()) continue;
            this.doLexicalPE = true;
            if (!this.maybeMarkupDecl() && !this.maybeConditionalSect()) break;
        }
        if (!inputEntity.isEOF()) {
            this.fatal("P-059", new Object[]{this.in.getName()});
        }
        this.in = this.in.pop();
        this.inExternalPE = !this.in.isDocument();
        this.doLexicalPE = false;
    }

    private void readEncoding(boolean bl) throws IOException, ParseException {
        String string = this.maybeReadAttribute("encoding", bl);
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || n != 0 && (c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.'))) {
                this.fatal("P-060", new Object[]{new Character(c)});
            }
            ++n;
        }
        String string2 = this.in.getEncoding();
        if (string2 != null && !string.equalsIgnoreCase(string2)) {
            this.warning("P-061", new Object[]{string, string2});
        }
    }

    private boolean maybeNotationDecl() throws IOException, ParseException {
        Object v;
        InputEntity inputEntity = this.peekDeclaration("!NOTATION");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-019", false);
        ExternalEntity externalEntity = new ExternalEntity(this.in);
        this.whitespace("F-011");
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            externalEntity.publicId = this.parsePublicId();
            if (this.maybeWhitespace() && !this.peek(">")) {
                externalEntity.systemId = this.parseSystemId();
            }
        } else if (this.peek("SYSTEM")) {
            this.whitespace("F-008");
            externalEntity.systemId = this.parseSystemId();
        } else {
            this.fatal("P-062");
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-032", string);
        if (externalEntity.systemId != null && externalEntity.systemId.indexOf(35) != -1) {
            this.error("P-056", new Object[]{externalEntity.systemId});
        }
        if ((v = this.notations.get(string)) != null && v instanceof ExternalEntity) {
            this.warning("P-063", new Object[]{string});
        } else if (!this.ignoreDeclarations) {
            this.notations.put(string, externalEntity);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private char getc() throws IOException, ParseException {
        if (this.inExternalPE && this.doLexicalPE) ** GOTO lbl10
        var1_1 = this.in.getc();
        if (var1_1 == '%' && this.doLexicalPE) {
            this.fatal("P-080");
        }
        return var1_1;
lbl-1000:
        // 1 sources

        {
            if (this.in.isInternal() || this.doLexicalPE && !this.in.isDocument()) {
                this.in = this.in.pop();
                continue;
            }
            this.fatal("P-064", new Object[]{this.in.getName()});
lbl10:
            // 3 sources

            ** while (this.in.isEOF())
        }
lbl11:
        // 1 sources

        var1_2 = this.in.getc();
        if (var1_2 == '%' && this.doLexicalPE) {
            var2_3 = this.maybeGetName();
            if (var2_3 == null) {
                this.fatal("P-011");
            }
            this.nextChar(';', "F-021", var2_3);
            var3_4 = this.params.get(var2_3);
            this.pushReader(" ".toCharArray(), null, false);
            if (var3_4 instanceof InternalEntity) {
                this.pushReader(((InternalEntity)var3_4).buf, var2_3, false);
            } else if (var3_4 instanceof ExternalEntity) {
                this.pushReader((ExternalEntity)var3_4);
            } else if (var3_4 == null) {
                this.fatal("V-022");
            } else {
                throw new InternalError();
            }
            this.pushReader(" ".toCharArray(), null, false);
            return this.in.getc();
        }
        return var1_2;
    }

    private void ungetc() {
        this.in.ungetc();
    }

    private boolean peek(String string) throws IOException, ParseException {
        return this.in.peek(string, null);
    }

    private InputEntity peekDeclaration(String string) throws IOException, ParseException {
        if (!this.in.peekc('<')) {
            return null;
        }
        InputEntity inputEntity = this.in;
        if (this.in.peek(string, null)) {
            return inputEntity;
        }
        this.in.ungetc();
        return null;
    }

    private void nextChar(char c, String string, String string2) throws IOException, ParseException {
        while (this.in.isEOF() && !this.in.isDocument()) {
            this.in = this.in.pop();
        }
        if (!this.in.peekc(c)) {
            this.fatal("P-008", new Object[]{new Character(c), messages.getMessage(this.locale, string), string2 == null ? "" : '\"' + string2 + '\"'});
        }
    }

    private void pushReader(char[] cArray, String string, boolean bl) throws ParseException {
        InputEntity inputEntity = InputEntity.getInputEntity(this.locale);
        inputEntity.init(cArray, string, this.in, !bl);
        this.in = inputEntity;
    }

    private boolean pushReader(ExternalEntity externalEntity) throws ParseException, IOException {
        try {
            InputEntity inputEntity = InputEntity.getInputEntity(this.locale);
            InputSource inputSource = externalEntity.getInputSource(this.resolver);
            inputEntity.init(inputSource, externalEntity.name, this.in, externalEntity.isPE);
            this.in = inputEntity;
        }
        catch (SAXException sAXException) {
            throw this.translate(sAXException);
        }
        return true;
    }

    private void warning(String string, Object[] objectArray) throws ParseException {
        this.fatal(messages.getMessage(this.locale, string, objectArray));
    }

    void error(String string, Object[] objectArray) throws ParseException {
        this.fatal(messages.getMessage(this.locale, string, objectArray));
    }

    private void fatal(String string) throws ParseException {
        this.fatal(string, null, null);
    }

    private void fatal(String string, Object[] objectArray) throws ParseException {
        this.fatal(string, objectArray, null);
    }

    private void fatal(String string, Object[] objectArray, Exception exception) throws ParseException {
        String string2;
        String string3 = messages.getMessage(this.locale, string, objectArray);
        String string4 = string2 = exception == null ? null : exception.toString();
        if (string2 != null) {
            string3 = string3 + ": " + string2;
        }
        ParseException parseException = new ParseException(string3, this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        throw parseException;
    }

    private ParseException translate(SAXException sAXException) {
        String string = sAXException.getMessage();
        if (sAXException.getException() != null) {
            String string2 = sAXException.getException().toString();
            string = string != null ? string + ": " + string2 : string2;
        }
        return new ParseException(string);
    }

    public Parser(InputStream inputStream, boolean bl, boolean bl2) {
        this(new InputSource(inputStream), bl, bl2);
    }

    public Parser(InputStream inputStream) {
        this(new InputSource(inputStream), false, false);
    }

    public Parser(File file, boolean bl, boolean bl2) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        InputSource inputSource = new InputSource(bufferedInputStream);
        inputSource.setSystemId(file.toURL().toString());
        this.locator = new DocLocator();
        this.input = inputSource;
        this.coalescing = bl;
        this.namespace = bl2;
    }

    public Parser(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        InputSource inputSource = new InputSource(bufferedInputStream);
        inputSource.setSystemId(file.toURL().toString());
        this.locator = new DocLocator();
        this.input = inputSource;
    }

    private Parser(InputSource inputSource, boolean bl, boolean bl2) {
        this.locator = new DocLocator();
        this.input = inputSource;
        this.coalescing = bl;
        this.namespace = bl2;
    }

    private void prologue() throws IOException, ParseException {
        this.init();
        if (this.input == null) {
            this.fatal("P-000");
        }
        this.in = InputEntity.getInputEntity(this.locale);
        this.in.init(this.input, null, null, false);
        this.maybeXmlDecl();
        this.maybeMisc(false);
        this.maybeDoctypeDecl();
        this.maybeMisc(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int parse() throws ParseException, IOException {
        int n = 0;
        try {
            block22: {
                if (!this.donePrologue) {
                    this.prologue();
                    this.donePrologue = true;
                }
                if ((n = this.retrievePIs()) != -1) {
                    return n;
                }
                if (!this.doneContent) {
                    if (!this.coalescing) {
                        n = this.parseContent();
                        if (n != 10) {
                            return n;
                        }
                        this.doneContent = true;
                    } else {
                        if (this.cacheRet != -1) {
                            n = this.cacheRet;
                            this.curName = this.cacheName;
                            this.curValue = this.cacheValue;
                            this.cacheRet = -1;
                            this.cacheName = null;
                            this.cacheValue = null;
                            return n;
                        }
                        while (true) {
                            if ((n = this.parseContent()) == 10) {
                                this.doneContent = true;
                                break block22;
                            }
                            if (n == 3) {
                                if (this.simpleCharsBuffer == null) {
                                    this.simpleCharsBuffer = this.curValue;
                                    continue;
                                }
                                if (this.charsBuffer == null) {
                                    this.charsBuffer = new StringBuffer();
                                    this.charsBuffer.append(this.simpleCharsBuffer);
                                }
                                this.charsBuffer.append(this.curValue);
                                continue;
                            }
                            if (n != 3) break;
                        }
                        if (this.simpleCharsBuffer == null) return n;
                        this.cacheRet = n;
                        this.cacheName = this.curName;
                        this.cacheValue = this.curValue;
                        if (this.charsBuffer == null) {
                            this.curName = null;
                            this.curValue = this.simpleCharsBuffer;
                        } else {
                            this.curName = null;
                            this.curValue = this.charsBuffer.toString();
                            this.charsBuffer = null;
                        }
                        this.simpleCharsBuffer = null;
                        return 3;
                    }
                }
            }
            if (this.doneEpilogue) return this.retrievePIs();
            this.epilogue();
            this.doneEpilogue = true;
            return this.retrievePIs();
        }
        catch (EndOfInputException endOfInputException) {
            if (this.in.isDocument()) {
                this.fatal("P-003", null, endOfInputException);
                return n;
            }
            String string = this.in.getName();
            try {
                do {
                    this.in = this.in.pop();
                } while (this.in.isInternal());
                this.fatal("P-002", new Object[]{string}, endOfInputException);
                return n;
            }
            catch (IOException iOException) {
                this.fatal("P-002", new Object[]{string}, endOfInputException);
                return n;
            }
        }
        catch (RuntimeException runtimeException) {
            String string;
            if (runtimeException.getMessage() != null) {
                string = runtimeException.getMessage();
                throw new ParseException(string, this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
            }
            string = runtimeException.getClass().getName();
            throw new ParseException(string, this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        }
    }

    private int retrievePIs() {
        if (!this.piQueue.empty()) {
            this.curName = this.piQueue.getNextTarget();
            this.curValue = this.piQueue.getNextContent();
            return 5;
        }
        return -1;
    }

    private void epilogue() throws IOException, ParseException {
        try {
            this.afterRoot();
            this.maybeMisc(true);
            if (!this.in.isEOF()) {
                this.fatal("P-001", new Object[]{Integer.toHexString(this.getc())});
            }
        }
        catch (EndOfInputException endOfInputException) {
            if (!this.in.isDocument()) {
                String string = this.in.getName();
                do {
                    this.in = this.in.pop();
                } while (this.in.isInternal());
                this.fatal("P-002", new Object[]{string}, endOfInputException);
            } else {
                this.fatal("P-003", null, endOfInputException);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ParseException(runtimeException.getMessage() != null ? runtimeException.getMessage() : runtimeException.getClass().getName(), this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        }
        finally {
            this.strTmp = null;
            this.attTmp = null;
            this.nameTmp = null;
            this.nameCache = null;
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            this.params.clear();
            this.entities.clear();
            this.notations.clear();
            this.elements.clear();
            this.afterDocument();
        }
    }

    private ElementDecl getElement() throws IOException, ParseException {
        NameCacheEntry nameCacheEntry = this.maybeGetNameCacheEntry();
        if (nameCacheEntry == null) {
            return null;
        }
        ElementDecl elementDecl = (ElementDecl)this.elements.get(nameCacheEntry.name);
        if (elementDecl == null || elementDecl.contentType == null) {
            elementDecl = new ElementDecl(nameCacheEntry.name);
            elementDecl.contentType = strANY;
            this.elements.put(nameCacheEntry.name, elementDecl);
        }
        this.startLine = this.in.getLineNumber();
        boolean bl = this.in.maybeWhitespace();
        while (!this.in.peekc('>')) {
            AttributeDecl attributeDecl;
            String string;
            if (this.in.peekc('/')) {
                this.hasContent = false;
                break;
            }
            if (!bl) {
                this.fatal("P-030");
            }
            if ((string = this.maybeGetName()) == null) {
                this.fatal("P-031", new Object[]{new Character(this.getc())});
            }
            if (this.attTmp.getValue(string) != null) {
                this.fatal("P-032", new Object[]{string});
            }
            this.in.maybeWhitespace();
            this.nextChar('=', "F-026", string);
            this.in.maybeWhitespace();
            this.parseLiteral(false);
            bl = this.in.maybeWhitespace();
            AttributeDecl attributeDecl2 = attributeDecl = elementDecl == null ? null : (AttributeDecl)elementDecl.attributes.get(string);
            String string2 = attributeDecl == null ? this.strTmp.toString() : (!"CDATA".equals(attributeDecl.type) ? this.normalize(!attributeDecl.isFromInternalSubset) : this.strTmp.toString());
            if (XmlLang.equals(string) && !this.isXmlLang(string2)) {
                this.error("P-033", new Object[]{string2});
            }
            this.attTmp.addAttribute("", string, string, attributeDecl == null ? "CDATA" : attributeDecl.type, string2, attributeDecl == null ? null : attributeDecl.defaultValue, true);
            this.haveAttributes = true;
        }
        if (elementDecl != null) {
            this.attTmp.setIdAttributeName(elementDecl.id);
        }
        if (elementDecl != null && elementDecl.attributes.size() != 0) {
            this.haveAttributes = this.defaultAttributes(this.attTmp, elementDecl) || this.haveAttributes;
        }
        this.attr = this.attTmp;
        return elementDecl;
    }

    private boolean maybeReferenceInContent() throws IOException, ParseException {
        return this.in.peekc('&');
    }

    private boolean maybeEntityReference() throws IOException, ParseException {
        return !this.in.peekc('#');
    }

    private Object getEntityReference() throws IOException, ParseException {
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-009");
        }
        this.nextChar(';', "F-020", string);
        Object object = this.entities.get(string);
        this.err(" after in = " + this.in);
        if (object == null) {
            this.fatal("P-014", new Object[]{string});
        }
        return object;
    }

    private void elementEpilogue(ElementDecl elementDecl) throws IOException, ParseException {
        if (!this.in.peek(elementDecl.name, null)) {
            this.fatal("P-034", new Object[]{elementDecl.name, new Integer(this.startLine)});
        }
        this.in.maybeWhitespace();
        this.nextChar('>', "F-027", elementDecl.name);
    }

    private void intRefEpilogue(StackElement stackElement) throws IOException, ParseException {
        InternalEntity internalEntity = (InternalEntity)stackElement.entity;
        InputEntity inputEntity = stackElement.in;
        if (this.in != inputEntity && !this.in.isEOF()) {
            while (this.in.isInternal()) {
                this.in = this.in.pop();
            }
            this.fatal("P-052", new Object[]{internalEntity.name});
        }
        this.in = this.in.pop();
    }

    private void extRefEpilogue(StackElement stackElement) throws IOException, ParseException {
        ExternalEntity externalEntity = (ExternalEntity)stackElement.entity;
        if (!this.in.isEOF()) {
            this.fatal("P-058", new Object[]{externalEntity.name});
        }
        this.in = this.in.pop();
    }

    private boolean maybePI(boolean bl) throws IOException, ParseException {
        boolean bl2 = this.doLexicalPE;
        if (!this.in.peek(bl ? "?" : "<?", null)) {
            return false;
        }
        this.doLexicalPE = false;
        String string = this.maybeGetName();
        String string2 = null;
        if (string == null) {
            this.fatal("P-018");
        }
        if ("xml".equals(string)) {
            this.fatal("P-019");
        }
        if ("xml".equalsIgnoreCase(string)) {
            this.fatal("P-020", new Object[]{string});
        }
        if (this.maybeWhitespace()) {
            this.strTmp = new StringBuffer();
            try {
                char c;
                while ((c = this.in.getc()) != '?' || !this.in.peekc('>')) {
                    this.strTmp.append(c);
                }
            }
            catch (EndOfInputException endOfInputException) {
                this.fatal("P-021");
            }
            string2 = this.strTmp.toString();
        } else {
            if (!this.in.peek("?>", null)) {
                this.fatal("P-022");
            }
            string2 = "";
        }
        this.doLexicalPE = bl2;
        this.piQueue.in(string, string2);
        return true;
    }

    private void processStartElement(ElementDecl elementDecl) throws IOException, ParseException {
        String string;
        this.ns.pushContext();
        boolean bl = false;
        int n = this.attr.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string2 = this.attr.getQName(n2);
            string = this.attr.getValue(n2);
            boolean bl2 = false;
            String string3 = "";
            if (string2.startsWith("xmlns")) {
                bl2 = true;
                if (string2.length() != 5) {
                    if (string2.charAt(5) == ':') {
                        string3 = string2.substring(6);
                    } else {
                        bl2 = false;
                    }
                }
            }
            if (bl2) {
                if (!this.ns.declarePrefix(string3, string)) {
                    this.fatal("Illegal Namespace prefix: " + string3);
                }
                bl = true;
            } else {
                String[] stringArray = this.ns.processName(string2, this.parts, true);
                if (stringArray != null) {
                    this.attr.setURI(n2, stringArray[0]);
                    this.attr.setLocalName(n2, stringArray[1]);
                }
            }
            ++n2;
        }
        if (bl) {
            n = this.attr.getLength();
            int n3 = 0;
            while (n3 < n) {
                String[] stringArray;
                string = this.attr.getQName(n3);
                if ((!string.startsWith("xmlns") || string.length() != 5 && string.charAt(5) != ':') && (stringArray = this.ns.processName(string, this.parts, true)) != null) {
                    this.attr.setURI(n3, stringArray[0]);
                    this.attr.setLocalName(n3, stringArray[1]);
                }
                ++n3;
            }
        }
        this.getSetCurName(elementDecl.name, false);
        this.curValue = null;
    }

    private void processEndElement(ElementDecl elementDecl) throws IOException, ParseException {
        this.getSetCurName(elementDecl.name, false);
        this.ns.popContext();
    }

    private void getSetCurName(String string, boolean bl) throws ParseException {
        String[] stringArray = this.ns.processName(string, this.parts, bl);
        if (stringArray == null) {
            this.fatal("P-084", new Object[]{string});
        }
        this.curURI = stringArray[0];
        this.curName = stringArray[1];
        this.curValue = null;
    }

    private int parseContent() throws IOException, ParseException {
        ElementDecl elementDecl = null;
        block4: while (true) {
            if (this.stack.empty()) {
                if (!this.startEmptyStack) {
                    return 10;
                }
                if (this.startEmptyStack && (!this.in.peekc('<') || (elementDecl = this.getElement()) == null)) {
                    this.fatal("P-067");
                    continue;
                }
                this.startEmptyStack = false;
                this.stack.push(this.newStackElement(2, 256, elementDecl, null, null));
                if (!this.haveAttributes && this.hasContent) {
                    this.stack.push(this.newStackElement(4, 1024, elementDecl, null, null));
                }
                if (!this.namespace) {
                    this.curName = elementDecl.name;
                    this.curValue = null;
                } else {
                    this.processStartElement(elementDecl);
                }
                return 0;
            }
            StackElement stackElement = this.stack.pop();
            elementDecl = stackElement.elt;
            switch (stackElement.curState) {
                case 256: {
                    if (this.attr == null) {
                        this.fatal("P-082");
                    }
                    if (this.attrIndex < this.attr.getLength()) {
                        this.curName = this.attr.getLocalName(this.attrIndex);
                        this.curValue = this.attr.getValue(this.attrIndex);
                        this.curURI = this.attr.getURI(this.attrIndex);
                        ++this.attrIndex;
                        this.stack.push(stackElement);
                        return 2;
                    }
                    if (this.haveAttributes) {
                        this.attr = null;
                        this.attrIndex = 0;
                        this.attTmp.clear();
                        this.haveAttributes = false;
                    }
                    if (this.hasContent) {
                        this.stack.push(stackElement);
                        this.stack.push(this.newStackElement(4, 1024, elementDecl, null, null));
                        continue block4;
                    }
                    this.hasContent = true;
                    this.nextChar('>', "F-027", elementDecl.name);
                    this.freeStackElement(stackElement);
                    this.curName = elementDecl.name;
                    if (!this.namespace) {
                        this.curValue = null;
                    } else {
                        this.processEndElement(elementDecl);
                    }
                    return 1;
                }
                case 1024: {
                    ElementDecl elementDecl2 = null;
                    StackElement stackElement2 = null;
                    String string = null;
                    if (this.in.peekc('<')) {
                        elementDecl2 = this.getElement();
                        if (elementDecl2 != null) {
                            this.stack.push(stackElement);
                            this.stack.push(this.newStackElement(1, 256, elementDecl2, null, null));
                            if (!this.haveAttributes && this.hasContent) {
                                this.stack.push(this.newStackElement(4, 1024, elementDecl2, null, null));
                            }
                            if (!this.namespace) {
                                this.curName = elementDecl2.name;
                                this.curValue = null;
                            } else {
                                this.processStartElement(elementDecl2);
                            }
                            return 0;
                        }
                        if (!this.in.peekc('/')) {
                            if (this.maybeComment(true)) {
                                this.stack.push(stackElement);
                                continue block4;
                            }
                            if (this.maybePI(true)) {
                                this.stack.push(stackElement);
                                this.curName = this.piQueue.getNextTarget();
                                this.curValue = this.piQueue.getNextContent();
                                return 5;
                            }
                            string = this.in.getUnparsedContent(elementDecl != null && elementDecl.ignoreWhitespace, null);
                            if (string != null) {
                                this.stack.push(stackElement);
                                if (string.length() == 0) continue block4;
                                this.curName = null;
                                this.curValue = string;
                                return 3;
                            }
                            char c = this.getc();
                            this.fatal("P-079", new Object[]{Integer.toHexString(c), new Character(c)});
                        }
                    } else {
                        if (elementDecl != null && elementDecl.ignoreWhitespace && this.in.ignorableWhitespace()) {
                            this.stack.push(stackElement);
                            continue block4;
                        }
                        string = this.in.getParsedContent(this.coalescing);
                        if (string != null) {
                            this.stack.push(stackElement);
                            if (string.length() == 0) continue block4;
                            this.curName = null;
                            this.curValue = string;
                            return 3;
                        }
                        if (this.in.isEOF()) {
                            if (stackElement.origState == 4) {
                                this.fatal("P-035");
                            }
                        } else if (this.maybeReferenceInContent()) {
                            if (this.maybeEntityReference()) {
                                EntityDecl entityDecl;
                                this.stack.push(stackElement);
                                Object object = this.getEntityReference();
                                InputEntity inputEntity = this.in;
                                if (object instanceof InternalEntity) {
                                    entityDecl = (InternalEntity)object;
                                    this.stack.push(this.newStackElement(8, 1024, elementDecl, entityDecl, inputEntity));
                                    this.pushReader(entityDecl.buf, entityDecl.name, true);
                                    continue block4;
                                }
                                if (object instanceof ExternalEntity) {
                                    entityDecl = (ExternalEntity)object;
                                    if (((ExternalEntity)entityDecl).notation != null) {
                                        this.fatal("P-053", new Object[]{((ExternalEntity)entityDecl).name});
                                    }
                                    if (!this.pushReader((ExternalEntity)entityDecl)) continue block4;
                                    this.maybeTextDecl();
                                    this.stack.push(this.newStackElement(16, 1024, elementDecl, entityDecl, null));
                                    continue block4;
                                }
                                throw new InternalError();
                            }
                            this.stack.push(stackElement);
                            int n = this.surrogatesToCharTmp(this.parseCharNumber());
                            this.curName = null;
                            this.curValue = new String(this.charTmp, 0, n);
                            return 3;
                        }
                    }
                    if (stackElement.origState == 4) {
                        stackElement2 = this.stack.pop();
                        if (stackElement2.curState != 256) {
                            this.fatal("P-083");
                        }
                        this.elementEpilogue(elementDecl);
                        this.curName = elementDecl.name;
                        if (!this.namespace) {
                            this.curValue = null;
                        } else {
                            this.processEndElement(elementDecl);
                        }
                        this.freeStackElement(stackElement);
                        this.freeStackElement(stackElement2);
                        return 1;
                    }
                    if (stackElement.origState == 8) {
                        this.intRefEpilogue(stackElement);
                        this.freeStackElement(stackElement);
                        continue block4;
                    }
                    if (stackElement.origState != 16) continue block4;
                    this.extRefEpilogue(stackElement);
                    this.freeStackElement(stackElement);
                    continue block4;
                }
            }
            this.fatal("P-083");
        }
    }

    private StackElement newStackElement(int n, int n2, ElementDecl elementDecl, EntityDecl entityDecl, InputEntity inputEntity) {
        return new StackElement(n, n2, elementDecl, entityDecl, inputEntity);
    }

    private void freeStackElement(StackElement stackElement) {
    }

    private void err(String string) {
    }

    private void debug() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class PIQueue {
        private String[] pi;
        private int size = 0;
        private int index = 0;

        public PIQueue(int n) {
            this.pi = new String[2 * n];
        }

        public boolean empty() {
            return this.size == this.index;
        }

        public void clear() {
            this.size = 0;
        }

        public void in(String string, String string2) {
            this.ensureCapacity();
            this.pi[this.size++] = string;
            this.pi[this.size++] = string2;
        }

        public String getNextTarget() {
            String string = null;
            if (this.index < this.size) {
                string = this.pi[this.index];
                this.pi[this.index++] = null;
            }
            return string;
        }

        public String getNextContent() {
            String string = null;
            if (this.index < this.size) {
                string = this.pi[this.index];
                this.pi[this.index++] = null;
            }
            return string;
        }

        private void ensureCapacity() {
            if (this.pi.length == this.size) {
                String[] stringArray = this.pi;
                this.pi = new String[2 * this.pi.length + 2];
                System.arraycopy(stringArray, 0, this.pi, 0, this.size);
            }
        }
    }

    private final class StackElement {
        int origState;
        int curState;
        ElementDecl elt;
        EntityDecl entity;
        InputEntity in;
        StackElement next;

        public StackElement(int n, int n2, ElementDecl elementDecl, EntityDecl entityDecl, InputEntity inputEntity) {
            this.origState = n;
            this.curState = n2;
            this.elt = elementDecl;
            this.entity = entityDecl;
            this.in = inputEntity;
        }
    }

    private final class FastStack {
        private StackElement first;

        public FastStack(int n) {
        }

        public boolean empty() {
            return this.first == null;
        }

        public void push(StackElement stackElement) {
            if (this.first == null) {
                this.first = stackElement;
            } else {
                stackElement.next = this.first;
                this.first = stackElement;
            }
        }

        public StackElement pop() {
            StackElement stackElement = this.first;
            this.first = this.first.next;
            stackElement.next = null;
            return stackElement;
        }

        public void clear() {
            this.first = null;
        }
    }

    static final class Catalog
    extends MessageCatalog {
        Catalog() {
            super(class$com$sun$xml$rpc$sp$Parser == null ? (class$com$sun$xml$rpc$sp$Parser = Parser.class$("com.sun.xml.rpc.sp.Parser")) : class$com$sun$xml$rpc$sp$Parser);
        }
    }

    static final class NameCacheEntry {
        String name;
        char[] chars;
        NameCacheEntry next;

        NameCacheEntry() {
        }

        boolean matches(char[] cArray, int n) {
            if (this.chars.length != n) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (cArray[n2] != this.chars[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    static final class NameCache {
        NameCacheEntry[] hashtable = new NameCacheEntry[541];

        NameCache() {
        }

        String lookup(char[] cArray, int n) {
            return this.lookupEntry((char[])cArray, (int)n).name;
        }

        NameCacheEntry lookupEntry(char[] cArray, int n) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 = n2 * 31 + cArray[n3];
                ++n3;
            }
            n2 &= Integer.MAX_VALUE;
            NameCacheEntry nameCacheEntry = this.hashtable[n2 %= this.hashtable.length];
            while (nameCacheEntry != null) {
                if (nameCacheEntry.matches(cArray, n)) {
                    return nameCacheEntry;
                }
                nameCacheEntry = nameCacheEntry.next;
            }
            nameCacheEntry = new NameCacheEntry();
            nameCacheEntry.chars = new char[n];
            System.arraycopy(cArray, 0, nameCacheEntry.chars, 0, n);
            nameCacheEntry.name = new String(nameCacheEntry.chars);
            nameCacheEntry.name = nameCacheEntry.name.intern();
            nameCacheEntry.next = this.hashtable[n2];
            this.hashtable[n2] = nameCacheEntry;
            return nameCacheEntry;
        }
    }

    class DocLocator
    implements Locator {
        DocLocator() {
        }

        public String getPublicId() {
            return Parser.this.in == null ? null : Parser.this.in.getPublicId();
        }

        public String getSystemId() {
            return Parser.this.in == null ? null : Parser.this.in.getSystemId();
        }

        public int getLineNumber() {
            return Parser.this.in == null ? -1 : Parser.this.in.getLineNumber();
        }

        public int getColumnNumber() {
            return Parser.this.in == null ? -1 : Parser.this.in.getColumnNumber();
        }
    }
}

