/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.util;

import com.sun.xml.rpc.processor.schema.AnnotationComponent;
import com.sun.xml.rpc.processor.schema.AttributeDeclarationComponent;
import com.sun.xml.rpc.processor.schema.AttributeGroupDefinitionComponent;
import com.sun.xml.rpc.processor.schema.AttributeUseComponent;
import com.sun.xml.rpc.processor.schema.ComplexTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.ComponentVisitor;
import com.sun.xml.rpc.processor.schema.ElementDeclarationComponent;
import com.sun.xml.rpc.processor.schema.IdentityConstraintDefinitionComponent;
import com.sun.xml.rpc.processor.schema.InternalSchemaConstants;
import com.sun.xml.rpc.processor.schema.ModelGroupComponent;
import com.sun.xml.rpc.processor.schema.ModelGroupDefinitionComponent;
import com.sun.xml.rpc.processor.schema.NotationDeclarationComponent;
import com.sun.xml.rpc.processor.schema.ParticleComponent;
import com.sun.xml.rpc.processor.schema.SimpleTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.WildcardComponent;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class ComponentWriter
implements ComponentVisitor {
    private IndentingWriter _writer;

    public ComponentWriter(IndentingWriter indentingWriter) {
        this._writer = indentingWriter;
    }

    public void visit(AnnotationComponent annotationComponent) throws Exception {
    }

    public void visit(AttributeDeclarationComponent attributeDeclarationComponent) throws Exception {
        this._writer.p("ATTRIBUTE ");
        this.writeName(attributeDeclarationComponent.getName());
        this._writer.pln();
        this._writer.pI();
        if (attributeDeclarationComponent.getScope() == null) {
            this._writer.pln("SCOPE global");
        }
        if (attributeDeclarationComponent.getTypeDefinition() != null) {
            this._writer.pln("TYPE");
            this._writer.pI();
            attributeDeclarationComponent.getTypeDefinition().accept(this);
            this._writer.pO();
        }
        this._writer.pO();
    }

    public void visit(AttributeGroupDefinitionComponent attributeGroupDefinitionComponent) throws Exception {
    }

    public void visit(AttributeUseComponent attributeUseComponent) throws Exception {
        this._writer.p("ATTRIBUTE USE ");
        this._writer.pln(attributeUseComponent.isRequired() ? "required" : "optional");
        this._writer.pI();
        attributeUseComponent.getAttributeDeclaration().accept(this);
        this._writer.pO();
    }

    public void visit(ComplexTypeDefinitionComponent complexTypeDefinitionComponent) throws Exception {
        this._writer.p("COMPLEX-TYPE ");
        this.writeName(complexTypeDefinitionComponent.getName());
        this._writer.pln();
        if (complexTypeDefinitionComponent.getName() != null && complexTypeDefinitionComponent.getName().equals(InternalSchemaConstants.QNAME_TYPE_URTYPE)) {
            return;
        }
        this._writer.pI();
        if (complexTypeDefinitionComponent.getBaseTypeDefinition() != null) {
            this._writer.pln("BASE-TYPE");
            this._writer.pI();
            complexTypeDefinitionComponent.getBaseTypeDefinition().accept(this);
            this._writer.pO();
        }
        Iterator iterator = complexTypeDefinitionComponent.attributeUses();
        while (iterator.hasNext()) {
            ((AttributeUseComponent)iterator.next()).accept(this);
        }
        switch (complexTypeDefinitionComponent.getContentTag()) {
            case 1: {
                this._writer.pln("EMPTY");
                break;
            }
            case 2: {
                this._writer.pln("SIMPLE");
                complexTypeDefinitionComponent.getSimpleTypeContent().accept(this);
                break;
            }
            case 3: {
                this._writer.pln("MIXED");
                complexTypeDefinitionComponent.getParticleContent().accept(this);
                break;
            }
            case 4: {
                this._writer.pln("ELEMENT-ONLY");
                complexTypeDefinitionComponent.getParticleContent().accept(this);
                break;
            }
        }
        this._writer.pO();
    }

    public void visit(ElementDeclarationComponent elementDeclarationComponent) throws Exception {
        this._writer.p("ELEMENT ");
        this.writeName(elementDeclarationComponent.getName());
        this._writer.pln();
        this._writer.pI();
        if (elementDeclarationComponent.getScope() == null) {
            this._writer.pln("SCOPE global");
        }
        if (elementDeclarationComponent.getTypeDefinition() != null) {
            elementDeclarationComponent.getTypeDefinition().accept(this);
        }
        this._writer.pO();
    }

    public void visit(IdentityConstraintDefinitionComponent identityConstraintDefinitionComponent) throws Exception {
    }

    public void visit(ModelGroupComponent modelGroupComponent) throws Exception {
        this._writer.p("GROUP ");
        this._writer.p(modelGroupComponent.getCompositor().getName());
        this._writer.pln();
        this._writer.pI();
        Iterator iterator = modelGroupComponent.particles();
        while (iterator.hasNext()) {
            ParticleComponent particleComponent = (ParticleComponent)iterator.next();
            particleComponent.accept(this);
        }
        this._writer.pO();
    }

    public void visit(ModelGroupDefinitionComponent modelGroupDefinitionComponent) throws Exception {
    }

    public void visit(NotationDeclarationComponent notationDeclarationComponent) throws Exception {
    }

    public void visit(ParticleComponent particleComponent) throws Exception {
        this._writer.p("PARTICLE (");
        this._writer.p(Integer.toString(particleComponent.getMinOccurs()));
        this._writer.p(", ");
        if (particleComponent.isMaxOccursUnbounded()) {
            this._writer.p("UNBOUNDED)");
        } else {
            this._writer.p(Integer.toString(particleComponent.getMaxOccurs()));
            this._writer.p(")");
        }
        this._writer.pln();
        this._writer.pI();
        if (particleComponent.getModelGroupTerm() != null) {
            particleComponent.getModelGroupTerm().accept(this);
        } else if (particleComponent.getElementTerm() != null) {
            particleComponent.getElementTerm().accept(this);
        }
        this._writer.pO();
    }

    public void visit(SimpleTypeDefinitionComponent simpleTypeDefinitionComponent) throws Exception {
        this._writer.p("SIMPLE-TYPE ");
        this.writeName(simpleTypeDefinitionComponent.getName());
        this._writer.pln();
        if (simpleTypeDefinitionComponent.getName() != null && simpleTypeDefinitionComponent.getName().equals(InternalSchemaConstants.QNAME_TYPE_SIMPLE_URTYPE)) {
            return;
        }
        this._writer.pI();
        this._writer.pO();
    }

    public void visit(WildcardComponent wildcardComponent) throws Exception {
    }

    private void writeName(QName qName) throws IOException {
        if (qName != null) {
            String string = qName.getNamespaceURI();
            if (string.equals("http://www.w3.org/2001/XMLSchema")) {
                this._writer.p("xsd:");
            } else if (string.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                this._writer.p("soap-enc:");
            }
            this._writer.p(qName.getLocalPart());
        }
    }
}

