/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.soap;

import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public abstract class SOAPStructureType
extends SOAPType {
    private List _members = new ArrayList();
    private Map _membersByName = new HashMap();
    private Set _subtypes = null;
    private SOAPStructureType _parentType = null;

    protected SOAPStructureType() {
    }

    protected SOAPStructureType(QName qName) {
        super(qName);
    }

    public void add(SOAPStructureMember sOAPStructureMember) {
        if (this._membersByName.containsKey(sOAPStructureMember.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this._members.add(sOAPStructureMember);
        this._membersByName.put(sOAPStructureMember.getName(), sOAPStructureMember);
    }

    public SOAPStructureMember getMemberByName(String string) {
        if (this._membersByName.size() != this._members.size()) {
            this.initializeMembersByName();
        }
        return (SOAPStructureMember)this._membersByName.get(string);
    }

    public Iterator getMembers() {
        return this._members.iterator();
    }

    public int getMembersCount() {
        return this._members.size();
    }

    public List getMembersList() {
        return this._members;
    }

    public void setMembersList(List list) {
        this._members = list;
        this.initializeMembersByName();
    }

    private void initializeMembersByName() {
        this._membersByName = new HashMap();
        if (this._members != null) {
            Iterator iterator = this._members.iterator();
            while (iterator.hasNext()) {
                SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)iterator.next();
                if (sOAPStructureMember.getName() != null && this._membersByName.containsKey(sOAPStructureMember.getName())) {
                    throw new ModelException("model.uniqueness");
                }
                this._membersByName.put(sOAPStructureMember.getName(), sOAPStructureMember);
            }
        }
    }

    public void addSubtype(SOAPStructureType sOAPStructureType) {
        if (this._subtypes == null) {
            this._subtypes = new HashSet();
        }
        this._subtypes.add(sOAPStructureType);
        sOAPStructureType.setParentType(this);
    }

    public Iterator getSubtypes() {
        if (this._subtypes != null) {
            return this._subtypes.iterator();
        }
        return null;
    }

    public Set getSubtypesSet() {
        return this._subtypes;
    }

    public void setSubtypesSet(Set set) {
        this._subtypes = set;
    }

    public void setParentType(SOAPStructureType sOAPStructureType) {
        if (this._parentType != null && sOAPStructureType != null && !this._parentType.equals(sOAPStructureType)) {
            throw new ModelException("model.parent.type.already.set", new Object[]{this.getName().toString(), this._parentType.getName().toString(), sOAPStructureType.getName().toString()});
        }
        this._parentType = sOAPStructureType;
    }

    public SOAPStructureType getParentType() {
        return this._parentType;
    }
}

