/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.local;

import com.sun.xml.rpc.client.ClientTransport;
import com.sun.xml.rpc.client.ClientTransportException;
import com.sun.xml.rpc.soap.message.Handler;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.OutputStream;

public class LocalClientTransport
implements ClientTransport {
    private Handler _handler;
    private OutputStream _logStream;

    public LocalClientTransport(Handler handler) {
        this._handler = handler;
    }

    public LocalClientTransport(Handler handler, OutputStream outputStream) {
        this._handler = handler;
        this._logStream = outputStream;
    }

    public void invoke(String string, SOAPMessageContext sOAPMessageContext) {
        try {
            String string2;
            if (this._logStream != null) {
                string2 = "\n******************\nRequest\n";
                this._logStream.write(string2.getBytes());
                sOAPMessageContext.getMessage().writeTo(this._logStream);
            }
            this._handler.handle(sOAPMessageContext);
            sOAPMessageContext.setFailure(false);
            if (this._logStream != null) {
                string2 = "\nResponse\n";
                this._logStream.write(string2.getBytes());
                sOAPMessageContext.getMessage().writeTo(this._logStream);
                string2 = "\n******************\n\n";
                this._logStream.write(string2.getBytes());
            }
        }
        catch (Exception exception) {
            if (exception instanceof Localizable) {
                throw new ClientTransportException("local.client.failed", (Localizable)((Object)exception));
            }
            throw new ClientTransportException("local.client.failed", new LocalizableExceptionAdapter(exception));
        }
    }

    public void invokeOneWay(String string, SOAPMessageContext sOAPMessageContext) {
        try {
            if (this._logStream != null) {
                String string2 = "\n******************\nRequest\n";
                this._logStream.write(string2.getBytes());
                sOAPMessageContext.getMessage().writeTo(this._logStream);
            }
            this._handler.handle(sOAPMessageContext);
            sOAPMessageContext.setFailure(false);
        }
        catch (Exception exception) {
            if (exception instanceof Localizable) {
                throw new ClientTransportException("local.client.failed", (Localizable)((Object)exception));
            }
            throw new ClientTransportException("local.client.failed", new LocalizableExceptionAdapter(exception));
        }
    }
}

