/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.namespace;

import java.io.Serializable;

public class QName
implements Serializable {
    private String namespaceURI;
    private String localPart;

    public QName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Local part not allowed to be null");
        }
        this.namespaceURI = "";
        this.localPart = string;
    }

    public QName(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Local part not allowed to be null");
        }
        if (string == null) {
            string = "";
        }
        this.namespaceURI = string;
        this.localPart = string2;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String toString() {
        if (this.namespaceURI.equals("")) {
            return this.localPart;
        }
        return "{" + this.namespaceURI + "}" + this.localPart;
    }

    public static QName valueOf(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("invalid QName literal");
        }
        if (string.charAt(0) == '{') {
            int n = string.indexOf(125);
            if (n == -1) {
                throw new IllegalArgumentException("invalid QName literal");
            }
            if (n == string.length() - 1) {
                throw new IllegalArgumentException("invalid QName literal");
            }
            return new QName(string.substring(1, n), string.substring(n + 1));
        }
        return new QName(string);
    }

    public final int hashCode() {
        return this.namespaceURI.hashCode() ^ this.localPart.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof QName)) {
            return false;
        }
        QName qName = (QName)object;
        return this.namespaceURI.equals(qName.namespaceURI) && this.localPart.equals(qName.localPart);
    }
}

