/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.parser;

import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.NullEntityResolver;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.Binding;
import com.sun.xml.rpc.wsdl.document.BindingFault;
import com.sun.xml.rpc.wsdl.document.BindingInput;
import com.sun.xml.rpc.wsdl.document.BindingOperation;
import com.sun.xml.rpc.wsdl.document.BindingOutput;
import com.sun.xml.rpc.wsdl.document.Definitions;
import com.sun.xml.rpc.wsdl.document.Documentation;
import com.sun.xml.rpc.wsdl.document.Fault;
import com.sun.xml.rpc.wsdl.document.Import;
import com.sun.xml.rpc.wsdl.document.Input;
import com.sun.xml.rpc.wsdl.document.Message;
import com.sun.xml.rpc.wsdl.document.MessagePart;
import com.sun.xml.rpc.wsdl.document.Operation;
import com.sun.xml.rpc.wsdl.document.OperationStyle;
import com.sun.xml.rpc.wsdl.document.Output;
import com.sun.xml.rpc.wsdl.document.Port;
import com.sun.xml.rpc.wsdl.document.PortType;
import com.sun.xml.rpc.wsdl.document.Service;
import com.sun.xml.rpc.wsdl.document.Types;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.WSDLDocument;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.framework.Entity;
import com.sun.xml.rpc.wsdl.framework.Extensible;
import com.sun.xml.rpc.wsdl.framework.GlobalEntity;
import com.sun.xml.rpc.wsdl.framework.ParseException;
import com.sun.xml.rpc.wsdl.framework.ParserContext;
import com.sun.xml.rpc.wsdl.framework.ParserListener;
import com.sun.xml.rpc.wsdl.parser.ExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.HTTPExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.MIMEExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.SOAPExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.SchemaExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.SchemaParser;
import com.sun.xml.rpc.wsdl.parser.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSDLParser {
    private boolean _followImports;
    private String _targetNamespaceURI;
    private Map _extensionHandlers = new HashMap();
    private ArrayList _listeners;

    public WSDLParser() {
        this.register(new SOAPExtensionHandler());
        this.register(new HTTPExtensionHandler());
        this.register(new MIMEExtensionHandler());
        this.register(new SchemaExtensionHandler());
    }

    public void register(ExtensionHandler extensionHandler) {
        this._extensionHandlers.put(extensionHandler.getNamespaceURI(), extensionHandler);
        extensionHandler.setExtensionHandlers(this._extensionHandlers);
    }

    public void unregister(ExtensionHandler extensionHandler) {
        this._extensionHandlers.put(extensionHandler.getNamespaceURI(), null);
        extensionHandler.setExtensionHandlers(null);
    }

    public void unregister(String string) {
        this._extensionHandlers.put(string, null);
    }

    public boolean getFollowImports() {
        return this._followImports;
    }

    public void setFollowImports(boolean bl) {
        this._followImports = bl;
    }

    public void addParserListener(ParserListener parserListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(parserListener);
    }

    public void removeParserListener(ParserListener parserListener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(parserListener);
    }

    public WSDLDocument parse(InputSource inputSource) {
        WSDLDocument wSDLDocument = new WSDLDocument();
        wSDLDocument.setSystemId(inputSource.getSystemId());
        ParserContext parserContext = new ParserContext(wSDLDocument, this._listeners);
        parserContext.setFollowImports(this._followImports);
        wSDLDocument.setDefinitions(this.parseDefinitions(parserContext, inputSource, null));
        return wSDLDocument;
    }

    protected Definitions parseDefinitions(ParserContext parserContext, InputSource inputSource, String string) {
        Definitions definitions = this.parseDefinitionsNoImport(parserContext, inputSource, string);
        this.processImports(parserContext, inputSource, definitions);
        return definitions;
    }

    protected void processImports(ParserContext parserContext, InputSource inputSource, Definitions definitions) {
        Iterator iterator = definitions.imports();
        while (iterator.hasNext()) {
            Import import_ = (Import)iterator.next();
            String string = import_.getLocation();
            if (string == null || parserContext.getDocument().isImportedDocument(string)) continue;
            parserContext.getDocument().addImportedDocument(string);
            String string2 = inputSource.getSystemId() == null ? (parserContext.getDocument().getSystemId() == null ? string : Util.processSystemIdWithBase(parserContext.getDocument().getSystemId(), string)) : Util.processSystemIdWithBase(inputSource.getSystemId(), string);
            try {
                parserContext.getDocument().addImportedEntity(this.parseDefinitions(parserContext, new InputSource(string2), import_.getNamespace()));
            }
            catch (ParseException parseException) {
                if (parseException.getKey().equals("parsing.incorrectRootElement")) {
                    try {
                        SchemaParser schemaParser = new SchemaParser();
                        parserContext.getDocument().addImportedEntity(schemaParser.parseSchema(parserContext, new InputSource(string2), import_.getNamespace()));
                        continue;
                    }
                    catch (ParseException parseException2) {
                        if (parseException2.getKey().equals("parsing.incorrectRootElement")) {
                            Util.fail("parsing.unknownImportedDocumentType", string);
                            continue;
                        }
                        throw parseException2;
                    }
                }
                throw parseException;
            }
        }
    }

    protected Definitions parseDefinitionsNoImport(ParserContext parserContext, InputSource inputSource, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException sAXParseException) throws SAXParseException {
                    throw sAXParseException;
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
                    throw sAXParseException;
                }

                public void warning(SAXParseException sAXParseException) throws SAXParseException {
                }
            });
            documentBuilder.setEntityResolver(new NullEntityResolver());
            try {
                Document document = documentBuilder.parse(inputSource);
                return this.parseDefinitionsNoImport(parserContext, document, string);
            }
            catch (IOException iOException) {
                if (inputSource.getSystemId() != null) {
                    throw new ParseException("parsing.ioExceptionWithSystemId", inputSource.getSystemId(), new LocalizableExceptionAdapter(iOException));
                }
                throw new ParseException("parsing.ioException", new LocalizableExceptionAdapter(iOException));
            }
            catch (SAXException sAXException) {
                if (inputSource.getSystemId() != null) {
                    throw new ParseException("parsing.saxExceptionWithSystemId", inputSource.getSystemId(), new LocalizableExceptionAdapter(sAXException));
                }
                throw new ParseException("parsing.saxException", new LocalizableExceptionAdapter(sAXException));
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ParseException("parsing.parserConfigException", new LocalizableExceptionAdapter(parserConfigurationException));
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ParseException("parsing.factoryConfigException", new LocalizableExceptionAdapter(factoryConfigurationError));
        }
    }

    protected Definitions parseDefinitionsNoImport(ParserContext parserContext, Document document, String string) {
        this._targetNamespaceURI = null;
        Element element = document.getDocumentElement();
        Util.verifyTagNSRootElement(element, WSDLConstants.QNAME_DEFINITIONS);
        return this.parseDefinitionsNoImport(parserContext, element, string);
    }

    protected Definitions parseDefinitionsNoImport(ParserContext parserContext, Element element, String string) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        Definitions definitions = new Definitions(parserContext.getDocument());
        String string2 = XmlUtil.getAttributeOrNull(element, "name");
        definitions.setName(string2);
        this._targetNamespaceURI = XmlUtil.getAttributeOrNull(element, "targetNamespace");
        definitions.setTargetNamespaceURI(this._targetNamespaceURI);
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = XmlUtil.getAllChildren(element);
        while (iterator.hasNext()) {
            GlobalEntity globalEntity;
            Element element2 = Util.nextElement(iterator);
            if (element2 == null) break;
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                definitions.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_TYPES)) {
                if (bl2) {
                    Util.fail("parsing.onlyOneTypesAllowed", "definitions");
                }
                definitions.setTypes(this.parseTypes(parserContext, definitions, element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_MESSAGE)) {
                globalEntity = this.parseMessage(parserContext, definitions, element2);
                definitions.add((Message)globalEntity);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_PORT_TYPE)) {
                globalEntity = this.parsePortType(parserContext, definitions, element2);
                definitions.add((PortType)globalEntity);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_BINDING)) {
                globalEntity = this.parseBinding(parserContext, definitions, element2);
                definitions.add((Binding)globalEntity);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_SERVICE)) {
                globalEntity = this.parseService(parserContext, definitions, element2);
                definitions.add((Service)globalEntity);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_IMPORT)) {
                definitions.add(this.parseImport(parserContext, definitions, element2));
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(parserContext, definitions, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_DEFINITIONS, definitions);
        return definitions;
    }

    protected Message parseMessage(ParserContext parserContext, Definitions definitions, Element element) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        Message message = new Message(definitions);
        String string = Util.getRequiredAttribute(element, "name");
        message.setName(string);
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren(element);
        while (iterator.hasNext()) {
            Element element2 = Util.nextElement(iterator);
            if (element2 == null) break;
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                message.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_PART)) {
                MessagePart messagePart = this.parseMessagePart(parserContext, element2);
                message.add(messagePart);
                continue;
            }
            Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_MESSAGE, message);
        return message;
    }

    protected MessagePart parseMessagePart(ParserContext parserContext, Element element) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        MessagePart messagePart = new MessagePart();
        String string = Util.getRequiredAttribute(element, "name");
        messagePart.setName(string);
        String string2 = XmlUtil.getAttributeOrNull(element, "element");
        String string3 = XmlUtil.getAttributeOrNull(element, "type");
        if (string2 != null) {
            if (string3 != null) {
                Util.fail("parsing.onlyOneOfElementOrTypeRequired", string);
            }
            messagePart.setDescriptor(parserContext.translateQualifiedName(string2));
            messagePart.setDescriptorKind(SchemaKinds.XSD_ELEMENT);
        } else if (string3 != null) {
            messagePart.setDescriptor(parserContext.translateQualifiedName(string3));
            messagePart.setDescriptorKind(SchemaKinds.XSD_TYPE);
        } else {
            Util.fail("parsing.elementOrTypeRequired", string);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_PART, messagePart);
        return messagePart;
    }

    protected PortType parsePortType(ParserContext parserContext, Definitions definitions, Element element) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        PortType portType = new PortType(definitions);
        String string = Util.getRequiredAttribute(element, "name");
        portType.setName(string);
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren(element);
        while (iterator.hasNext()) {
            Element element2 = Util.nextElement(iterator);
            if (element2 == null) break;
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                portType.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_OPERATION)) {
                Operation operation = this.parsePortTypeOperation(parserContext, element2);
                portType.add(operation);
                continue;
            }
            Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_PORT_TYPE, portType);
        return portType;
    }

    protected Operation parsePortTypeOperation(ParserContext parserContext, Element element) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        Operation operation = new Operation();
        String string = Util.getRequiredAttribute(element, "name");
        operation.setName(string);
        String string2 = XmlUtil.getAttributeOrNull(element, "parameterOrder");
        operation.setParameterOrder(string2);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Iterator iterator = XmlUtil.getAllChildren(element);
        while (iterator.hasNext()) {
            Element element2;
            Iterator iterator2;
            boolean bl6;
            String string3;
            String string4;
            Entity entity;
            Element element3 = Util.nextElement(iterator);
            if (element3 == null) break;
            if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                operation.setDocumentation(this.getDocumentationFor(element3));
                continue;
            }
            if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_INPUT)) {
                if (bl2) {
                    Util.fail("parsing.tooManyElements", new Object[]{"input", "operation", string});
                }
                parserContext.push();
                parserContext.registerNamespaces(element3);
                entity = new Input();
                string4 = Util.getRequiredAttribute(element3, "message");
                ((Input)entity).setMessage(parserContext.translateQualifiedName(string4));
                string3 = XmlUtil.getAttributeOrNull(element3, "name");
                ((Input)entity).setName(string3);
                operation.setInput((Input)entity);
                bl2 = true;
                if (bl3) {
                    bl5 = false;
                }
                bl6 = false;
                iterator2 = XmlUtil.getAllChildren(element3);
                while (iterator2.hasNext()) {
                    element2 = Util.nextElement(iterator2);
                    if (element2 == null) break;
                    if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                        }
                        bl6 = true;
                        ((Input)entity).setDocumentation(this.getDocumentationFor(element2));
                        continue;
                    }
                    Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
                }
                parserContext.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_OUTPUT)) {
                if (bl3) {
                    Util.fail("parsing.tooManyElements", new Object[]{"output", "operation", string});
                }
                parserContext.push();
                parserContext.registerNamespaces(element3);
                entity = new Output();
                string4 = Util.getRequiredAttribute(element3, "message");
                ((Output)entity).setMessage(parserContext.translateQualifiedName(string4));
                string3 = XmlUtil.getAttributeOrNull(element3, "name");
                ((Output)entity).setName(string3);
                operation.setOutput((Output)entity);
                bl3 = true;
                if (bl2) {
                    bl5 = true;
                }
                bl6 = false;
                iterator2 = XmlUtil.getAllChildren(element3);
                while (iterator2.hasNext()) {
                    element2 = Util.nextElement(iterator2);
                    if (element2 == null) break;
                    if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                        }
                        bl6 = true;
                        ((Output)entity).setDocumentation(this.getDocumentationFor(element2));
                        continue;
                    }
                    Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
                }
                parserContext.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_FAULT)) {
                parserContext.push();
                parserContext.registerNamespaces(element3);
                entity = new Fault();
                string4 = Util.getRequiredAttribute(element3, "message");
                ((Fault)entity).setMessage(parserContext.translateQualifiedName(string4));
                string3 = XmlUtil.getAttributeOrNull(element3, "name");
                ((Fault)entity).setName(string3);
                operation.addFault((Fault)entity);
                bl4 = true;
                bl6 = false;
                iterator2 = XmlUtil.getAllChildren(element3);
                while (iterator2.hasNext()) {
                    element2 = Util.nextElement(iterator2);
                    if (element2 == null) break;
                    if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                        }
                        bl6 = true;
                        ((Fault)entity).setDocumentation(this.getDocumentationFor(element2));
                        continue;
                    }
                    Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
                }
                parserContext.pop();
                continue;
            }
            Util.fail("parsing.invalidElement", element3.getTagName(), element3.getNamespaceURI());
        }
        if (bl2 && !bl3 && !bl4) {
            operation.setStyle(OperationStyle.ONE_WAY);
        } else if (bl2 && bl3 && bl5) {
            operation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (bl2 && bl3 && !bl5) {
            operation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (bl3 && !bl2 && !bl4) {
            operation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            Util.fail("parsing.invalidOperationStyle", string);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, operation);
        return operation;
    }

    protected Binding parseBinding(ParserContext parserContext, Definitions definitions, Element element) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        Binding binding = new Binding(definitions);
        String string = Util.getRequiredAttribute(element, "name");
        binding.setName(string);
        String string2 = Util.getRequiredAttribute(element, "type");
        binding.setPortType(parserContext.translateQualifiedName(string2));
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren(element);
        while (iterator.hasNext()) {
            Element element2 = Util.nextElement(iterator);
            if (element2 == null) break;
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                binding.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_OPERATION)) {
                BindingOperation bindingOperation = this.parseBindingOperation(parserContext, element2);
                binding.add(bindingOperation);
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(parserContext, binding, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_BINDING, binding);
        return binding;
    }

    protected BindingOperation parseBindingOperation(ParserContext parserContext, Element element) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        BindingOperation bindingOperation = new BindingOperation();
        String string = Util.getRequiredAttribute(element, "name");
        bindingOperation.setName(string);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Iterator iterator = XmlUtil.getAllChildren(element);
        while (iterator.hasNext()) {
            Element element2;
            Iterator iterator2;
            boolean bl6;
            String string2;
            Entity entity;
            Element element3 = Util.nextElement(iterator);
            if (element3 == null) break;
            if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                bindingOperation.setDocumentation(this.getDocumentationFor(element3));
                continue;
            }
            if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_INPUT)) {
                if (bl2) {
                    Util.fail("parsing.tooManyElements", new Object[]{"input", "operation", string});
                }
                parserContext.push();
                parserContext.registerNamespaces(element3);
                entity = new BindingInput();
                string2 = XmlUtil.getAttributeOrNull(element3, "name");
                ((BindingInput)entity).setName(string2);
                bindingOperation.setInput((BindingInput)entity);
                bl2 = true;
                if (bl3) {
                    bl5 = false;
                }
                bl6 = false;
                iterator2 = XmlUtil.getAllChildren(element3);
                while (iterator2.hasNext()) {
                    element2 = Util.nextElement(iterator2);
                    if (element2 == null) break;
                    if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                        }
                        bl6 = true;
                        ((BindingInput)entity).setDocumentation(this.getDocumentationFor(element2));
                        continue;
                    }
                    this.checkNotWsdlElement(element2);
                    if (this.handleExtension(parserContext, (Extensible)((Object)entity), element2)) continue;
                    this.checkNotWsdlRequired(element2);
                }
                parserContext.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_OUTPUT)) {
                if (bl3) {
                    Util.fail("parsing.tooManyElements", new Object[]{"output", "operation", string});
                }
                parserContext.push();
                parserContext.registerNamespaces(element3);
                entity = new BindingOutput();
                string2 = XmlUtil.getAttributeOrNull(element3, "name");
                ((BindingOutput)entity).setName(string2);
                bindingOperation.setOutput((BindingOutput)entity);
                bl3 = true;
                if (bl2) {
                    bl5 = true;
                }
                bl6 = false;
                iterator2 = XmlUtil.getAllChildren(element3);
                while (iterator2.hasNext()) {
                    element2 = Util.nextElement(iterator2);
                    if (element2 == null) break;
                    if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                        }
                        bl6 = true;
                        ((BindingOutput)entity).setDocumentation(this.getDocumentationFor(element2));
                        continue;
                    }
                    this.checkNotWsdlElement(element2);
                    if (this.handleExtension(parserContext, (Extensible)((Object)entity), element2)) continue;
                    this.checkNotWsdlRequired(element2);
                }
                parserContext.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_FAULT)) {
                parserContext.push();
                parserContext.registerNamespaces(element3);
                entity = new BindingFault();
                string2 = Util.getRequiredAttribute(element3, "name");
                ((BindingFault)entity).setName(string2);
                bindingOperation.addFault((BindingFault)entity);
                bl4 = true;
                bl6 = false;
                iterator2 = XmlUtil.getAllChildren(element3);
                while (iterator2.hasNext()) {
                    element2 = Util.nextElement(iterator2);
                    if (element2 == null) break;
                    if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                        }
                        bl6 = true;
                        ((BindingFault)entity).setDocumentation(this.getDocumentationFor(element2));
                        continue;
                    }
                    this.checkNotWsdlElement(element2);
                    if (this.handleExtension(parserContext, (Extensible)((Object)entity), element2)) continue;
                    this.checkNotWsdlRequired(element2);
                }
                parserContext.pop();
                continue;
            }
            this.checkNotWsdlElement(element3);
            if (this.handleExtension(parserContext, bindingOperation, element3)) continue;
            this.checkNotWsdlRequired(element3);
        }
        if (bl2 && !bl3 && !bl4) {
            bindingOperation.setStyle(OperationStyle.ONE_WAY);
        } else if (bl2 && bl3 && bl5) {
            bindingOperation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (bl2 && bl3 && !bl5) {
            bindingOperation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (bl3 && !bl2 && !bl4) {
            bindingOperation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            Util.fail("parsing.invalidOperationStyle", string);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, bindingOperation);
        return bindingOperation;
    }

    protected Import parseImport(ParserContext parserContext, Definitions definitions, Element element) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        Import import_ = new Import();
        String string = Util.getRequiredAttribute(element, "namespace");
        import_.setNamespace(string);
        String string2 = Util.getRequiredAttribute(element, "location");
        import_.setLocation(string2);
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren(element);
        while (iterator.hasNext()) {
            Element element2 = Util.nextElement(iterator);
            if (element2 == null) break;
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                import_.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_IMPORT, import_);
        return import_;
    }

    protected Service parseService(ParserContext parserContext, Definitions definitions, Element element) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        Service service = new Service(definitions);
        String string = Util.getRequiredAttribute(element, "name");
        service.setName(string);
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren(element);
        while (iterator.hasNext()) {
            Element element2 = Util.nextElement(iterator);
            if (element2 == null) break;
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                service.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_PORT)) {
                Port port = this.parsePort(parserContext, definitions, element2);
                service.add(port);
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(parserContext, service, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_SERVICE, service);
        return service;
    }

    protected Port parsePort(ParserContext parserContext, Definitions definitions, Element element) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        Port port = new Port(definitions);
        String string = Util.getRequiredAttribute(element, "name");
        port.setName(string);
        String string2 = Util.getRequiredAttribute(element, "binding");
        port.setBinding(parserContext.translateQualifiedName(string2));
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren(element);
        while (iterator.hasNext()) {
            Element element2 = Util.nextElement(iterator);
            if (element2 == null) break;
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                port.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(parserContext, port, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_PORT, port);
        return port;
    }

    protected Types parseTypes(ParserContext parserContext, Definitions definitions, Element element) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        Types types = new Types();
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren(element);
        while (iterator.hasNext()) {
            Element element2 = Util.nextElement(iterator);
            if (element2 == null) break;
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                types.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(parserContext, types, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_TYPES, types);
        return types;
    }

    protected boolean handleExtension(ParserContext parserContext, Extensible extensible, Element element) {
        ExtensionHandler extensionHandler = (ExtensionHandler)this._extensionHandlers.get(element.getNamespaceURI());
        if (extensionHandler == null) {
            parserContext.fireIgnoringExtension(new QName(element.getNamespaceURI(), element.getLocalName()), ((Entity)((Object)extensible)).getElementName());
            return false;
        }
        return extensionHandler.doHandleExtension(parserContext, extensible, element);
    }

    protected void checkNotWsdlElement(Element element) {
        if (element.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            Util.fail("parsing.invalidWsdlElement", element.getTagName());
        }
    }

    protected void checkNotWsdlRequired(Element element) {
        String string = XmlUtil.getAttributeNSOrNull(element, "required", "http://schemas.xmlsoap.org/wsdl/");
        if (string != null && string.equals("true")) {
            Util.fail("parsing.requiredExtensibilityElement", element.getTagName(), element.getNamespaceURI());
        }
    }

    protected Documentation getDocumentationFor(Element element) {
        String string = XmlUtil.getTextForNode(element);
        if (string == null) {
            return null;
        }
        return new Documentation(string);
    }
}

