/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.parser;

import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.soap.SOAPAddress;
import com.sun.xml.rpc.wsdl.document.soap.SOAPBinding;
import com.sun.xml.rpc.wsdl.document.soap.SOAPBody;
import com.sun.xml.rpc.wsdl.document.soap.SOAPConstants;
import com.sun.xml.rpc.wsdl.document.soap.SOAPFault;
import com.sun.xml.rpc.wsdl.document.soap.SOAPHeader;
import com.sun.xml.rpc.wsdl.document.soap.SOAPHeaderFault;
import com.sun.xml.rpc.wsdl.document.soap.SOAPOperation;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import com.sun.xml.rpc.wsdl.document.soap.SOAPUse;
import com.sun.xml.rpc.wsdl.framework.Extensible;
import com.sun.xml.rpc.wsdl.framework.Extension;
import com.sun.xml.rpc.wsdl.framework.ParserContext;
import com.sun.xml.rpc.wsdl.framework.WriterContext;
import com.sun.xml.rpc.wsdl.parser.ExtensionHandlerBase;
import com.sun.xml.rpc.wsdl.parser.Util;
import java.io.IOException;
import java.util.Iterator;
import org.w3c.dom.Element;

public class SOAPExtensionHandler
extends ExtensionHandlerBase {
    public String getNamespaceURI() {
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    protected boolean handleDefinitionsExtension(ParserContext parserContext, Extensible extensible, Element element) {
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleTypesExtension(ParserContext parserContext, Extensible extensible, Element element) {
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleBindingExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, SOAPConstants.QNAME_BINDING)) {
            parserContext.push();
            parserContext.registerNamespaces(element);
            SOAPBinding sOAPBinding = new SOAPBinding();
            String string = Util.getRequiredAttribute(element, "transport");
            sOAPBinding.setTransport(string);
            String string2 = XmlUtil.getAttributeOrNull(element, "style");
            if (string2 != null) {
                if (string2.equals("rpc")) {
                    sOAPBinding.setStyle(SOAPStyle.RPC);
                } else if (string2.equals("document")) {
                    sOAPBinding.setStyle(SOAPStyle.DOCUMENT);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "style", string2);
                }
            }
            extensible.addExtension(sOAPBinding);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(SOAPConstants.QNAME_BINDING, sOAPBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleOperationExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, SOAPConstants.QNAME_OPERATION)) {
            String string;
            parserContext.push();
            parserContext.registerNamespaces(element);
            SOAPOperation sOAPOperation = new SOAPOperation();
            String string2 = XmlUtil.getAttributeOrNull(element, "soapAction");
            if (string2 != null) {
                sOAPOperation.setSOAPAction(string2);
            }
            if ((string = XmlUtil.getAttributeOrNull(element, "style")) != null) {
                if (string.equals("rpc")) {
                    sOAPOperation.setStyle(SOAPStyle.RPC);
                } else if (string.equals("document")) {
                    sOAPOperation.setStyle(SOAPStyle.DOCUMENT);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "style", string);
                }
            }
            extensible.addExtension(sOAPOperation);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(SOAPConstants.QNAME_OPERATION, sOAPOperation);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleInputExtension(ParserContext parserContext, Extensible extensible, Element element) {
        return this.handleInputOutputExtension(parserContext, extensible, element);
    }

    protected boolean handleOutputExtension(ParserContext parserContext, Extensible extensible, Element element) {
        return this.handleInputOutputExtension(parserContext, extensible, element);
    }

    protected boolean handleMIMEPartExtension(ParserContext parserContext, Extensible extensible, Element element) {
        return this.handleInputOutputExtension(parserContext, extensible, element);
    }

    protected boolean handleInputOutputExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, SOAPConstants.QNAME_BODY)) {
            String string;
            String string2;
            String string3;
            parserContext.push();
            parserContext.registerNamespaces(element);
            SOAPBody sOAPBody = new SOAPBody();
            String string4 = XmlUtil.getAttributeOrNull(element, "use");
            if (string4 != null) {
                if (string4.equals("literal")) {
                    sOAPBody.setUse(SOAPUse.LITERAL);
                } else if (string4.equals("encoded")) {
                    sOAPBody.setUse(SOAPUse.ENCODED);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "use", string4);
                }
            }
            if ((string3 = XmlUtil.getAttributeOrNull(element, "namespace")) != null) {
                sOAPBody.setNamespace(string3);
            }
            if ((string2 = XmlUtil.getAttributeOrNull(element, "encodingStyle")) != null) {
                sOAPBody.setEncodingStyle(string2);
            }
            if ((string = XmlUtil.getAttributeOrNull(element, "parts")) != null) {
                sOAPBody.setNamespace(string);
            }
            extensible.addExtension(sOAPBody);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(SOAPConstants.QNAME_BODY, sOAPBody);
            return true;
        }
        if (XmlUtil.matchesTagNS(element, SOAPConstants.QNAME_HEADER)) {
            String string;
            String string5;
            String string6;
            String string7;
            parserContext.push();
            parserContext.registerNamespaces(element);
            SOAPHeader sOAPHeader = new SOAPHeader();
            String string8 = XmlUtil.getAttributeOrNull(element, "use");
            if (string8 != null) {
                if (string8.equals("literal")) {
                    sOAPHeader.setUse(SOAPUse.LITERAL);
                } else if (string8.equals("encoded")) {
                    sOAPHeader.setUse(SOAPUse.ENCODED);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "use", string8);
                }
            }
            if ((string7 = XmlUtil.getAttributeOrNull(element, "namespace")) != null) {
                sOAPHeader.setNamespace(string7);
            }
            if ((string6 = XmlUtil.getAttributeOrNull(element, "encodingStyle")) != null) {
                sOAPHeader.setEncodingStyle(string6);
            }
            if ((string5 = XmlUtil.getAttributeOrNull(element, "part")) != null) {
                sOAPHeader.setPart(string5);
            }
            if ((string = XmlUtil.getAttributeOrNull(element, "message")) != null) {
                sOAPHeader.setMessage(parserContext.translateQualifiedName(string));
            }
            Iterator iterator = XmlUtil.getAllChildren(element);
            while (iterator.hasNext()) {
                Element element2 = Util.nextElement(iterator);
                if (element2 == null) break;
                if (XmlUtil.matchesTagNS(element2, SOAPConstants.QNAME_HEADERFAULT)) {
                    String string9;
                    String string10;
                    String string11;
                    String string12;
                    parserContext.push();
                    parserContext.registerNamespaces(element);
                    SOAPHeaderFault sOAPHeaderFault = new SOAPHeaderFault();
                    String string13 = XmlUtil.getAttributeOrNull(element, "use");
                    if (string13 != null) {
                        if (string13.equals("literal")) {
                            sOAPHeaderFault.setUse(SOAPUse.LITERAL);
                        } else if (string8.equals("encoded")) {
                            sOAPHeaderFault.setUse(SOAPUse.ENCODED);
                        } else {
                            Util.fail("parsing.invalidAttributeValue", "use", string13);
                        }
                    }
                    if ((string12 = XmlUtil.getAttributeOrNull(element, "namespace")) != null) {
                        sOAPHeaderFault.setNamespace(string12);
                    }
                    if ((string11 = XmlUtil.getAttributeOrNull(element, "encodingStyle")) != null) {
                        sOAPHeaderFault.setEncodingStyle(string11);
                    }
                    if ((string10 = XmlUtil.getAttributeOrNull(element, "part")) != null) {
                        sOAPHeaderFault.setPart(string10);
                    }
                    if ((string9 = XmlUtil.getAttributeOrNull(element, "message")) != null) {
                        sOAPHeaderFault.setMessage(parserContext.translateQualifiedName(string9));
                    }
                    sOAPHeader.add(sOAPHeaderFault);
                    parserContext.pop();
                    continue;
                }
                Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
            }
            extensible.addExtension(sOAPHeader);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(SOAPConstants.QNAME_HEADER, sOAPHeader);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleFaultExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, SOAPConstants.QNAME_FAULT)) {
            String string;
            String string2;
            parserContext.push();
            parserContext.registerNamespaces(element);
            SOAPFault sOAPFault = new SOAPFault();
            String string3 = XmlUtil.getAttributeOrNull(element, "use");
            if (string3 != null) {
                if (string3.equals("literal")) {
                    sOAPFault.setUse(SOAPUse.LITERAL);
                } else if (string3.equals("encoded")) {
                    sOAPFault.setUse(SOAPUse.ENCODED);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "use", string3);
                }
            }
            if ((string2 = XmlUtil.getAttributeOrNull(element, "namespace")) != null) {
                sOAPFault.setNamespace(string2);
            }
            if ((string = XmlUtil.getAttributeOrNull(element, "encodingStyle")) != null) {
                sOAPFault.setEncodingStyle(string);
            }
            extensible.addExtension(sOAPFault);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(SOAPConstants.QNAME_FAULT, sOAPFault);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleServiceExtension(ParserContext parserContext, Extensible extensible, Element element) {
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handlePortExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, SOAPConstants.QNAME_ADDRESS)) {
            parserContext.push();
            parserContext.registerNamespaces(element);
            SOAPAddress sOAPAddress = new SOAPAddress();
            String string = Util.getRequiredAttribute(element, "location");
            sOAPAddress.setLocation(string);
            extensible.addExtension(sOAPAddress);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(SOAPConstants.QNAME_ADDRESS, sOAPAddress);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    public void doHandleExtension(WriterContext writerContext, Extension extension) throws IOException {
        if (extension instanceof SOAPAddress) {
            SOAPAddress sOAPAddress = (SOAPAddress)extension;
            writerContext.writeStartTag(sOAPAddress.getElementName());
            writerContext.writeAttribute("location", sOAPAddress.getLocation());
            writerContext.writeEndTag(sOAPAddress.getElementName());
        } else if (extension instanceof SOAPBinding) {
            SOAPBinding sOAPBinding = (SOAPBinding)extension;
            writerContext.writeStartTag(sOAPBinding.getElementName());
            writerContext.writeAttribute("transport", sOAPBinding.getTransport());
            String string = sOAPBinding.getStyle() == null ? null : (sOAPBinding.getStyle() == SOAPStyle.DOCUMENT ? "document" : "rpc");
            writerContext.writeAttribute("style", string);
            writerContext.writeEndTag(sOAPBinding.getElementName());
        } else if (extension instanceof SOAPBody) {
            SOAPBody sOAPBody = (SOAPBody)extension;
            writerContext.writeStartTag(sOAPBody.getElementName());
            writerContext.writeAttribute("encodingStyle", sOAPBody.getEncodingStyle());
            writerContext.writeAttribute("parts", sOAPBody.getParts());
            String string = sOAPBody.getUse() == null ? null : (sOAPBody.getUse() == SOAPUse.LITERAL ? "literal" : "encoded");
            writerContext.writeAttribute("use", string);
            writerContext.writeAttribute("namespace", sOAPBody.getNamespace());
            writerContext.writeEndTag(sOAPBody.getElementName());
        } else if (extension instanceof SOAPFault) {
            SOAPFault sOAPFault = (SOAPFault)extension;
            writerContext.writeStartTag(sOAPFault.getElementName());
            writerContext.writeAttribute("encodingStyle", sOAPFault.getEncodingStyle());
            String string = sOAPFault.getUse() == null ? null : (sOAPFault.getUse() == SOAPUse.LITERAL ? "literal" : "encoded");
            writerContext.writeAttribute("use", string);
            writerContext.writeAttribute("namespace", sOAPFault.getNamespace());
            writerContext.writeEndTag(sOAPFault.getElementName());
        } else if (extension instanceof SOAPHeader) {
            SOAPHeader sOAPHeader = (SOAPHeader)extension;
            writerContext.writeStartTag(sOAPHeader.getElementName());
            writerContext.writeAttribute("message", sOAPHeader.getMessage());
            writerContext.writeAttribute("part", sOAPHeader.getPart());
            writerContext.writeAttribute("encodingStyle", sOAPHeader.getEncodingStyle());
            String string = sOAPHeader.getUse() == null ? null : (sOAPHeader.getUse() == SOAPUse.LITERAL ? "literal" : "encoded");
            writerContext.writeAttribute("use", string);
            writerContext.writeAttribute("namespace", sOAPHeader.getNamespace());
            writerContext.writeEndTag(sOAPHeader.getElementName());
        } else if (extension instanceof SOAPHeaderFault) {
            SOAPHeaderFault sOAPHeaderFault = (SOAPHeaderFault)extension;
            writerContext.writeStartTag(sOAPHeaderFault.getElementName());
            writerContext.writeAttribute("message", sOAPHeaderFault.getMessage());
            writerContext.writeAttribute("part", sOAPHeaderFault.getPart());
            writerContext.writeAttribute("encodingStyle", sOAPHeaderFault.getEncodingStyle());
            String string = sOAPHeaderFault.getUse() == null ? null : (sOAPHeaderFault.getUse() == SOAPUse.LITERAL ? "literal" : "encoded");
            writerContext.writeAttribute("use", string);
            writerContext.writeAttribute("namespace", sOAPHeaderFault.getNamespace());
            writerContext.writeEndTag(sOAPHeaderFault.getElementName());
        } else if (extension instanceof SOAPOperation) {
            SOAPOperation sOAPOperation = (SOAPOperation)extension;
            writerContext.writeStartTag(sOAPOperation.getElementName());
            writerContext.writeAttribute("soapAction", sOAPOperation.getSOAPAction());
            String string = sOAPOperation.getStyle() == null ? null : (sOAPOperation.isDocument() ? "document" : "rpc");
            writerContext.writeAttribute("style", string);
            writerContext.writeEndTag(sOAPOperation.getElementName());
        } else {
            throw new IllegalArgumentException();
        }
    }
}

