/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.framework;

import com.sun.xml.rpc.sp.NamespaceSupport;
import com.sun.xml.rpc.util.xml.PrettyPrintingXmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class WriterContext {
    private PrettyPrintingXmlWriter _writer;
    private NamespaceSupport _nsSupport;
    private String _targetNamespaceURI;
    private int _newPrefixCount;
    private List _pendingNamespaceDeclarations;

    public WriterContext(OutputStream outputStream) throws IOException {
        this._writer = new PrettyPrintingXmlWriter(outputStream);
        this._nsSupport = new NamespaceSupport();
        this._newPrefixCount = 2;
    }

    public void flush() throws IOException {
        this._writer.flush();
    }

    public void close() throws IOException {
        this._writer.close();
    }

    public void push() {
        if (this._pendingNamespaceDeclarations != null) {
            throw new IllegalStateException("prefix declarations are pending");
        }
        this._nsSupport.pushContext();
    }

    public void pop() {
        this._nsSupport.popContext();
        this._pendingNamespaceDeclarations = null;
    }

    public String getNamespaceURI(String string) {
        return this._nsSupport.getURI(string);
    }

    public Iterator getPrefixes() {
        return this._nsSupport.getPrefixes();
    }

    public String getDefaultNamespaceURI() {
        return this.getNamespaceURI("");
    }

    public void declarePrefix(String string, String string2) {
        this._nsSupport.declarePrefix(string, string2);
        if (this._pendingNamespaceDeclarations == null) {
            this._pendingNamespaceDeclarations = new ArrayList();
        }
        this._pendingNamespaceDeclarations.add(new String[]{string, string2});
    }

    public String getPrefixFor(String string) {
        if (this.getDefaultNamespaceURI().equals(string)) {
            return "";
        }
        return this._nsSupport.getPrefix(string);
    }

    public String findNewPrefix(String string) {
        return string + Integer.toString(this._newPrefixCount++);
    }

    public String getTargetNamespaceURI() {
        return this._targetNamespaceURI;
    }

    public void setTargetNamespaceURI(String string) {
        this._targetNamespaceURI = string;
    }

    public void writeStartTag(QName qName) throws IOException {
        this._writer.start(this.getQNameString(qName));
    }

    public void writeEndTag(QName qName) throws IOException {
        this._writer.end(this.getQNameString(qName));
    }

    public void writeAttribute(String string, String string2) throws IOException {
        if (string2 != null) {
            this._writer.attribute(string, string2);
        }
    }

    public void writeAttribute(String string, QName qName) throws IOException {
        if (qName != null) {
            this._writer.attribute(string, this.getQNameString(qName));
        }
    }

    public void writeAttribute(String string, boolean bl) throws IOException {
        this.writeAttribute(string, bl ? "true" : "false");
    }

    public void writeAttribute(String string, Boolean bl) throws IOException {
        if (bl != null) {
            this.writeAttribute(string, (boolean)bl);
        }
    }

    public void writeAttribute(String string, int n) throws IOException {
        this.writeAttribute(string, Integer.toString(n));
    }

    public void writeAttribute(String string, Object object, Map map) throws IOException {
        String string2 = (String)map.get(object);
        this.writeAttribute(string, string2);
    }

    public void writeNamespaceDeclaration(String string, String string2) throws IOException {
        this._writer.attribute(this.getNamespaceDeclarationAttributeName(string), string2);
    }

    public void writeAllPendingNamespaceDeclarations() throws IOException {
        if (this._pendingNamespaceDeclarations != null) {
            Iterator iterator = this._pendingNamespaceDeclarations.iterator();
            while (iterator.hasNext()) {
                String[] stringArray = (String[])iterator.next();
                this.writeNamespaceDeclaration(stringArray[0], stringArray[1]);
            }
        }
        this._pendingNamespaceDeclarations = null;
    }

    private String getNamespaceDeclarationAttributeName(String string) {
        if (string.equals("")) {
            return "xmlns";
        }
        return "xmlns:" + string;
    }

    public void writeTag(QName qName, String string) throws IOException {
        this._writer.leaf(this.getQNameString(qName), string);
    }

    public String getQNameString(QName qName) {
        String string = this.getPrefixFor(qName.getNamespaceURI());
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("")) {
            return qName.getLocalPart();
        }
        return string + ":" + qName.getLocalPart();
    }

    public String getQNameStringWithTargetNamespaceCheck(QName qName) {
        if (qName.getNamespaceURI().equals(this._targetNamespaceURI)) {
            return qName.getLocalPart();
        }
        return this.getQNameString(qName);
    }
}

