/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.document;

import com.sun.xml.rpc.wsdl.document.Binding;
import com.sun.xml.rpc.wsdl.document.Documentation;
import com.sun.xml.rpc.wsdl.document.Import;
import com.sun.xml.rpc.wsdl.document.Message;
import com.sun.xml.rpc.wsdl.document.PortType;
import com.sun.xml.rpc.wsdl.document.Service;
import com.sun.xml.rpc.wsdl.document.Types;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.WSDLDocumentVisitor;
import com.sun.xml.rpc.wsdl.framework.AbstractDocument;
import com.sun.xml.rpc.wsdl.framework.Defining;
import com.sun.xml.rpc.wsdl.framework.DuplicateEntityException;
import com.sun.xml.rpc.wsdl.framework.Entity;
import com.sun.xml.rpc.wsdl.framework.EntityAction;
import com.sun.xml.rpc.wsdl.framework.ExtensibilityHelper;
import com.sun.xml.rpc.wsdl.framework.Extensible;
import com.sun.xml.rpc.wsdl.framework.Extension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;

public class Definitions
extends Entity
implements Defining,
Extensible {
    private AbstractDocument _document;
    private ExtensibilityHelper _helper;
    private Documentation _documentation;
    private String _name;
    private String _targetNsURI;
    private Types _types;
    private List _messages;
    private List _portTypes;
    private List _bindings;
    private List _services;
    private List _imports;
    private Set _importedNamespaces;

    public Definitions(AbstractDocument abstractDocument) {
        this._document = abstractDocument;
        this._bindings = new ArrayList();
        this._imports = new ArrayList();
        this._messages = new ArrayList();
        this._portTypes = new ArrayList();
        this._services = new ArrayList();
        this._importedNamespaces = new HashSet();
        this._helper = new ExtensibilityHelper();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getTargetNamespaceURI() {
        return this._targetNsURI;
    }

    public void setTargetNamespaceURI(String string) {
        this._targetNsURI = string;
    }

    public void setTypes(Types types) {
        this._types = types;
    }

    public Types getTypes() {
        return this._types;
    }

    public void add(Message message) {
        this._document.define(message);
        this._messages.add(message);
    }

    public void add(PortType portType) {
        this._document.define(portType);
        this._portTypes.add(portType);
    }

    public void add(Binding binding) {
        this._document.define(binding);
        this._bindings.add(binding);
    }

    public void add(Service service) {
        this._document.define(service);
        this._services.add(service);
    }

    public void add(Import import_) {
        if (this._importedNamespaces.contains(import_.getNamespace())) {
            throw new DuplicateEntityException(import_, import_.getNamespace());
        }
        this._imports.add(import_);
    }

    public Iterator imports() {
        return this._imports.iterator();
    }

    public Iterator messages() {
        return this._messages.iterator();
    }

    public Iterator portTypes() {
        return this._portTypes.iterator();
    }

    public Iterator bindings() {
        return this._bindings.iterator();
    }

    public Iterator services() {
        return this._services.iterator();
    }

    public QName getElementName() {
        return WSDLConstants.QNAME_DEFINITIONS;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation documentation) {
        this._documentation = documentation;
    }

    public void addExtension(Extension extension) {
        this._helper.addExtension(extension);
    }

    public Iterator extensions() {
        return this._helper.extensions();
    }

    public void withAllSubEntitiesDo(EntityAction entityAction) {
        if (this._types != null) {
            entityAction.perform(this._types);
        }
        Iterator iterator = this._messages.iterator();
        while (iterator.hasNext()) {
            entityAction.perform((Entity)iterator.next());
        }
        Iterator iterator2 = this._portTypes.iterator();
        while (iterator2.hasNext()) {
            entityAction.perform((Entity)iterator2.next());
        }
        Iterator iterator3 = this._bindings.iterator();
        while (iterator3.hasNext()) {
            entityAction.perform((Entity)iterator3.next());
        }
        Iterator iterator4 = this._services.iterator();
        while (iterator4.hasNext()) {
            entityAction.perform((Entity)iterator4.next());
        }
        Iterator iterator5 = this._imports.iterator();
        while (iterator5.hasNext()) {
            entityAction.perform((Entity)iterator5.next());
        }
        this._helper.withAllSubEntitiesDo(entityAction);
    }

    public void accept(WSDLDocumentVisitor wSDLDocumentVisitor) throws Exception {
        wSDLDocumentVisitor.preVisit(this);
        Iterator iterator = this._imports.iterator();
        while (iterator.hasNext()) {
            ((Import)iterator.next()).accept(wSDLDocumentVisitor);
        }
        if (this._types != null) {
            this._types.accept(wSDLDocumentVisitor);
        }
        Iterator iterator2 = this._messages.iterator();
        while (iterator2.hasNext()) {
            ((Message)iterator2.next()).accept(wSDLDocumentVisitor);
        }
        Iterator iterator3 = this._portTypes.iterator();
        while (iterator3.hasNext()) {
            ((PortType)iterator3.next()).accept(wSDLDocumentVisitor);
        }
        Iterator iterator4 = this._bindings.iterator();
        while (iterator4.hasNext()) {
            ((Binding)iterator4.next()).accept(wSDLDocumentVisitor);
        }
        Iterator iterator5 = this._services.iterator();
        while (iterator5.hasNext()) {
            ((Service)iterator5.next()).accept(wSDLDocumentVisitor);
        }
        this._helper.accept(wSDLDocumentVisitor);
        wSDLDocumentVisitor.postVisit(this);
    }

    public void validateThis() {
    }
}

