/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.wsdlp;

import com.sun.xml.rpc.util.Debug;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.localization.Localizer;
import com.sun.xml.rpc.util.localization.Resources;
import com.sun.xml.rpc.wsdl.document.WSDLDocument;
import com.sun.xml.rpc.wsdl.document.schema.SchemaDocument;
import com.sun.xml.rpc.wsdl.framework.Entity;
import com.sun.xml.rpc.wsdl.framework.ParseException;
import com.sun.xml.rpc.wsdl.framework.ParserListener;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import com.sun.xml.rpc.wsdl.parser.SOAPEntityReferenceValidator;
import com.sun.xml.rpc.wsdl.parser.SchemaParser;
import com.sun.xml.rpc.wsdl.parser.SchemaWriter;
import com.sun.xml.rpc.wsdl.parser.WSDLParser;
import com.sun.xml.rpc.wsdl.parser.WSDLWriter;
import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import javax.xml.namespace.QName;
import org.xml.sax.InputSource;

public class Main {
    private boolean _succeeded;
    private Localizer _localizer;
    private Resources _resources = new Resources("com.sun.xml.rpc.resources.wsdlp");
    private String _sourceFilename;
    private boolean _shouldValidate;
    private boolean _beVerbose;
    private boolean _echo;
    private boolean _parseSchema;

    public static void main(String[] stringArray) {
        try {
            Main main = new Main();
            main.run(stringArray);
            System.exit(main.succeeded() ? 0 : 1);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("wsdlp: resources not available");
            System.exit(2);
        }
    }

    public Main() throws MissingResourceException {
        this._localizer = new Localizer();
    }

    public boolean succeeded() {
        return this._succeeded;
    }

    public void run(String[] stringArray) {
        block16: {
            this._succeeded = false;
            if (!this.processArgs(stringArray)) {
                return;
            }
            try {
                if (this._parseSchema) {
                    SchemaParser schemaParser = new SchemaParser();
                    if (this._shouldValidate) {
                        schemaParser.setFollowImports(true);
                    }
                    InputSource inputSource = new InputSource(new File(this._sourceFilename).toURL().toString());
                    SchemaDocument schemaDocument = schemaParser.parse(inputSource);
                    schemaDocument.validateLocally();
                    if (this._shouldValidate) {
                        schemaDocument.validate(new SOAPEntityReferenceValidator());
                    }
                    if (this._echo) {
                        SchemaWriter schemaWriter = new SchemaWriter();
                        schemaWriter.write(schemaDocument, System.out);
                    }
                } else {
                    WSDLParser wSDLParser = new WSDLParser();
                    if (this._beVerbose) {
                        wSDLParser.addParserListener(new ParserListener(){

                            public void ignoringExtension(QName qName, QName qName2) {
                                System.err.println(Main.this._resources.getString("message.ignoring", new String[]{qName.getLocalPart(), qName.getNamespaceURI()}));
                            }

                            public void doneParsingEntity(QName qName, Entity entity) {
                                System.err.println(Main.this._resources.getString("message.processed", new String[]{qName.getLocalPart(), qName.getNamespaceURI()}));
                            }
                        });
                    }
                    if (this._shouldValidate) {
                        wSDLParser.setFollowImports(true);
                    }
                    InputSource inputSource = new InputSource(new File(this._sourceFilename).toURL().toString());
                    WSDLDocument wSDLDocument = wSDLParser.parse(inputSource);
                    wSDLDocument.validateLocally();
                    if (this._shouldValidate) {
                        wSDLDocument.validate(new SOAPEntityReferenceValidator());
                    }
                    if (this._echo) {
                        WSDLWriter wSDLWriter = new WSDLWriter();
                        wSDLWriter.write(wSDLDocument, System.out);
                    }
                }
                this._succeeded = true;
            }
            catch (ParseException parseException) {
                System.err.println(this._resources.getString("error.parsing", this._localizer.localize(parseException)));
            }
            catch (ValidationException validationException) {
                System.err.println(this._resources.getString("error.validation", this._localizer.localize(validationException)));
            }
            catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
                System.err.println(this._resources.getString("error.generic", this._localizer.localize(jAXRPCExceptionBase)));
            }
            catch (IOException iOException) {
                System.err.println(this._resources.getString("error.io", iOException.toString()));
            }
            catch (Exception exception) {
                System.err.println(this._resources.getString("error.generic", exception.toString()));
                if (!Debug.enabled()) break block16;
                exception.printStackTrace();
            }
        }
    }

    private boolean processArgs(String[] stringArray) {
        if (stringArray.length == 0) {
            this.help();
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            ++n;
            if (string.startsWith("-")) {
                if (string.equals("-help")) {
                    this.help();
                    this._succeeded = true;
                    return false;
                }
                if (string.equals("-echo")) {
                    this._echo = true;
                    continue;
                }
                if (string.equals("-schema")) {
                    this._parseSchema = true;
                    continue;
                }
                if (string.equals("-validate")) {
                    this._shouldValidate = true;
                    continue;
                }
                if (string.equals("-v") || string.equals("-verbose")) {
                    this._beVerbose = true;
                    continue;
                }
                if (string.equals("-version")) {
                    System.err.println(this._resources.getString("message.version"));
                    this._succeeded = true;
                    return false;
                }
                this.usageError("error.invalidOption", string);
                return false;
            }
            if (this._sourceFilename != null) {
                this.usageError("error.multipleFilenames", null);
                return false;
            }
            this._sourceFilename = string;
        }
        if (this._sourceFilename == null) {
            this.usageError("error.missingFilename", null);
            return false;
        }
        return true;
    }

    private void help() {
        System.err.println(this._resources.getString("message.header"));
        System.err.println(this._resources.getString("message.usage"));
    }

    private void printError(String string) {
        System.err.println(this._resources.getString("message.name") + ": " + string);
    }

    private void usageError(String string, String string2) {
        this.printError(this._resources.getString(string, string2));
    }
}

